/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhost.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhost.transcoder.TranscoderEncodeConfig;
import com.wowza.wms.rest.vhost.transcoder.TranscoderOverlayDecodeConfig;
import com.wowza.wms.rest.vhost.transcoder.TranscoderStreamNameGroupConfig;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Template")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/transcoder/templates/{templateName}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="{templateName}.xml")
public class TranscoderTemplateConfig
extends ConfigBase
implements Comparable<TranscoderTemplateConfig> {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    public String templateName;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Transcode/Description/text()")
    public String description;
    @JsonProperty(value="implementation")
    @XStreamAlias(value="Implementation")
    @WMSXMLVariable(xpath="/Root/Transcode/Decode/Video/Implementation/text()")
    public String implementation;
    @JsonProperty(value="deinterlace")
    @XStreamAlias(value="Deinterlace")
    @WMSXMLVariable(xpath="/Root/Transcode/Decode/Video/Deinterlace/text()")
    public boolean deinterlace;
    @JsonProperty(value="encodes")
    @XStreamAlias(value="Encodes")
    @WMSXMLList(xpath="/Root/Transcode/Encodes", keyxpath="/Encode/Name", keyName="encodeName")
    protected List<TranscoderEncodeConfig> encodes;
    @JsonProperty(value="streamNameGroups")
    @XStreamAlias(value="StreamNameGroups")
    @WMSXMLList(xpath="/Root/Transcode/StreamNameGroups", keyxpath="/StreamNameGroup/Name", keyName="groupName")
    protected List<TranscoderStreamNameGroupConfig> streamNameGroups;
    @JsonProperty(value="overlays")
    @XStreamAlias(value="Overlays")
    @WMSXMLList(xpath="/Root/Transcode/Decode/Video/Overlays", keyxpath="/Overlay/Name", keyName="overlayName")
    protected List<TranscoderOverlayDecodeConfig> decodeOverlays;

    public TranscoderTemplateConfig() {
    }

    public TranscoderTemplateConfig(String string, String string2) {
        this.vhostName = string;
        this.templateName = string2;
        this.addToStringKeyMap(Severity.valueOf(768 / 157, "rmit|"), string);
        this.addToStringKeyMap(Utils.lastIndexOf("tdoshdrbFhgn", -32 - -64), string2);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("}of|ao{u_s~q", 9 * 33));
        this.addToStringKeyMapFromRequest(Severity.valueOf(-33 + 79, "xg\u007fbf"));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String string) {
        this.implementation = string;
    }

    public boolean isDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(boolean bl) {
        this.deinterlace = bl;
    }

    public List<TranscoderOverlayDecodeConfig> getDecodeOverlays() {
        return this.decodeOverlays;
    }

    public void setDecodeOverlays(List<TranscoderOverlayDecodeConfig> list) {
        this.decodeOverlays = list;
    }

    public List<TranscoderStreamNameGroupConfig> getStreamNameGroups() {
        return this.streamNameGroups;
    }

    public void setStreamNameGroups(List<TranscoderStreamNameGroupConfig> list) {
        this.streamNameGroups = list;
    }

    public List<TranscoderEncodeConfig> getEncodes() {
        return this.encodes;
    }

    public void setEncodes(List<TranscoderEncodeConfig> list) {
        this.encodes = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.lastIndexOf("ortoi", -39 - -64));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Utils.lastIndexOf("u/.<0,cnffv*rbeyfjxh}", 89 + 33);
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse saveNewObject() throws ConfigBase.ConfigBaseException {
        String string = this.getBaseDir();
        File file = new File(string);
        if (file.exists()) {
            return super.saveNewObject();
        }
        file.mkdirs();
        return super.saveNewObject();
    }

    @Override
    public boolean loadObject() {
        this.templateName = this.stringKeyMap.get(Severity.valueOf(49 - 40, "}of|ao{u_s~q"));
        return super.loadObject();
    }

    public static TranscoderTemplateConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(28 - 25, "uljus"), string);
        hashMap.put(Severity.valueOf(125 + 90, "#=4*7=);\u0011!,'"), string2);
        String string3 = TranscoderTemplateConfig.getUrl(hashMap, TranscoderTemplateConfig.class);
        return (TranscoderTemplateConfig)TranscoderTemplateConfig.getObjectFromREST(string3, TranscoderTemplateConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(TranscoderTemplateConfig transcoderTemplateConfig) {
        return this.templateName.compareTo(transcoderTemplateConfig.templateName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse copyAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        try {
            String string2 = URLDecoder.decode(string, Utils.lastIndexOf("QQ@*0", 762 / 189));
            String string3 = this.getBaseDir() + "/" + this.templateName + Severity.valueOf(83 + -77, "(\u007fee");
            String string4 = this.getBaseDir() + "/" + string2 + Severity.valueOf(1077 / 221, "*}kk");
            File file2 = new File(string3);
            File file = new File(string4);
            if (file.exists()) {
                wMSResponse.message = Severity.valueOf(1016 / 209, "P`kwdh~n,") + string2 + Utils.lastIndexOf("-ocbtswm5soqjnh", 39 * 43);
            }
            if (!file2.exists()) {
                wMSResponse.message = Severity.valueOf(17 + 113, "Vfiujf|l*") + this.templateName + Utils.lastIndexOf("*och}/~~f3qm\u007fdlj", -21 + 31);
            } else {
                TranscoderTemplateConfig.copyDirectory(file2, file);
                wMSResponse.success = true;
                wMSResponse.message = Utils.lastIndexOf("Jzmqnbp`&/", -42 - 56) + string2 + Severity.valueOf(54 - 44, "#+o\u007fkndtv3g`ut}ji}iqrf");
                TranscoderTemplateConfig transcoderTemplateConfig = this.getNewTemplate(string2);
                transcoderTemplateConfig.setDescription("");
                transcoderTemplateConfig.addToSaveFieldList(Utils.lastIndexOf("..?.<& %;<:", 52 + 22));
                try {
                    transcoderTemplateConfig.saveObject();
                }
                catch (ConfigBase.ConfigBaseException configBaseException) {
                    ConfigBase.log.warn((Object)Severity.valueOf(894 / 160, "@tug{*xm{gaw1Fau{etw}\u007fi<I{rpmcwa"), (Throwable)configBaseException);
                }
            }
        }
        catch (IOException iOException) {
            wMSResponse.message = iOException.getMessage();
            ConfigBase.log.warn((Object)Utils.lastIndexOf("\u001a23-1d&)71 $,l\u0019<.>\"1<00$w\f<7+0<*:", -21 - 12), (Throwable)iOException);
        }
        catch (SecurityException securityException) {
            wMSResponse.message = securityException.getMessage();
            ConfigBase.log.warn((Object)Severity.valueOf(62 + 89, "Rjkui<~qoyhld$Qtffzidhh|/Dt\u007fcxtbr"), (Throwable)securityException);
        }
        if (wMSResponse.isSuccess()) {
            ConfigBase.log.info((Object)(Severity.valueOf(13 + 18, "MERV#EUO=(Je{u-Z}q\u007fap{qse8M\u007fvlq\u007fk%{b") + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.error((Object)(Severity.valueOf(2 + 75, "\u001f\u000b\u001c\u0004q\u0013\u0003\u001dov\u00147)#{\b/?13\"-'!7f\u0013-$:'-9+up") + wMSResponse.message));
        return wMSResponse;
    }

    protected TranscoderTemplateConfig getNewTemplate(String string) {
        return new TranscoderTemplateConfig(this.vhostName, string);
    }
}

