/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.server.Server;
import com.wowza.wms.server.ServerTuningHandler;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="ServerConfig")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/tune", restVerbs="GET,PUT", xmlFilename="VHost.xml")
public class VHostTuneConfig
extends ConfigBase {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String name;
    @JsonProperty(value="netConnectionsProcessorCount")
    @XStreamAlias(value="NetConnectionsProcessorCount")
    @WMSXMLVariable(xpath="/Root/VHost/NetConnections/ProcessorCount/text()")
    protected String netConnectionsProcessorCount;
    @JsonProperty(value="netConnectionsProcessorCountAutoValue")
    @XStreamAlias(value="NetConnectionsProcessorCountAutoValue")
    protected String netConnectionsProcessorCountAutoValue;
    @JsonProperty(value="mediaCasterProcessorCount")
    @XStreamAlias(value="MediaCasterProcessorCount")
    @WMSXMLVariable(xpath="/Root/VHost/MediaCasters/ProcessorCount/text()")
    protected String mediaCasterProcessorCount;
    @JsonProperty(value="mediaCasterProcessorCountAutoValue")
    @XStreamAlias(value="MediaCasterProcessorCountAutoValue")
    protected String mediaCasterProcessorCountAutoValue;
    @JsonProperty(value="idleWorkerCount")
    @XStreamAlias(value="IdleWorkerCount")
    @WMSXMLVariable(xpath="/Root/VHost/IdleWorkers/WorkerCount/text()")
    protected String idleWorkerCount;
    @JsonProperty(value="idleWorkerCountAutoValue")
    @XStreamAlias(value="IdleWorkerCountAutoValue")
    protected String idleWorkerCountAutoValue;
    @JsonProperty(value="unicastIncomingProcessorCount")
    @XStreamAlias(value="UnicastIncomingProcessorCount")
    @WMSXMLVariable(xpath="/Root/VHost/RTP/UnicastIncoming/ProcessorCount/text()")
    protected String unicastIncomingProcessorCount;
    @JsonProperty(value="unicastIncomingProcessorCountAutoValue")
    @XStreamAlias(value="UnicastIncomingProcessorCountAutoValue")
    protected String unicastIncomingProcessorCountAutoValue;
    @JsonProperty(value="unicastOutgoingProcessorCount")
    @XStreamAlias(value="UnicastOutgoingProcessorCount")
    @WMSXMLVariable(xpath="/Root/VHost/RTP/UnicastOutgoing/ProcessorCount/text()")
    protected String unicastOutgoingProcessorCount;
    @JsonProperty(value="unicastOutgoingProcessorCountAutoValue")
    @XStreamAlias(value="UnicastOutgoingProcessorCountAutoValue")
    protected String unicastOutgoingProcessorCountAutoValue;
    @JsonProperty(value="multicastIncomingProcessorCount")
    @XStreamAlias(value="MulticastIncomingProcessorCount")
    @WMSXMLVariable(xpath="/Root/VHost/RTP/MulticastIncoming/ProcessorCount/text()")
    protected String multicastIncomingProcessorCount;
    @JsonProperty(value="multicastIncomingProcessorCountAutoValue")
    @XStreamAlias(value="MulticastIncomingProcessorCountAutoValue")
    protected String multicastIncomingProcessorCountAutoValue;
    @JsonProperty(value="multicastOutgoingProcessorCount")
    @XStreamAlias(value="MulticastOutgoingProcessorCount")
    @WMSXMLVariable(xpath="/Root/VHost/RTP/MulticastOutgoing/ProcessorCount/text()")
    protected String multicastOutgoingProcessorCount;
    @JsonProperty(value="multicastOutgoingProcessorCountAutoValue")
    @XStreamAlias(value="MulticastOutgoingProcessorCountAutoValue")
    protected String multicastOutgoingProcessorCountAutoValue;
    @JsonProperty(value="clientIdleFrequency")
    @XStreamAlias(value="ClientIdleFrequency")
    @WMSXMLVariable(xpath="/Root/VHost/Client/IdleFrequency/text()")
    protected int clientIdleFrequency;
    @JsonProperty(value="rtpIdleFrequency")
    @XStreamAlias(value="RTPIdleFrequency")
    @WMSXMLVariable(xpath="/Root/VHost/RTP/IdleFrequency/text()")
    protected int rtpIdleFrequency;
    @JsonProperty(value="handlerThreadPoolSize")
    @XStreamAlias(value="HandlerThreadPoolSize")
    @WMSXMLVariable(xpath="/Root/VHost/HandlerThreadPool/PoolSize/text()")
    protected int handlerThreadPoolSize;
    @JsonProperty(value="transportThreadPoolSize")
    @XStreamAlias(value="TransportThreadPoolSize")
    @WMSXMLVariable(xpath="/Root/VHost/TransportThreadPool/PoolSize/text()")
    protected int transportThreadPoolSize;

    public VHostTuneConfig() {
    }

    public VHostTuneConfig(String string) {
        this.name = string;
        this.addToStringKeyMap(Severity.valueOf(85 + 118, "=$\"=;"), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf(" ?7*.", 56 + 62));
    }

    public String getNetConnectionsProcessorCount() {
        return this.netConnectionsProcessorCount;
    }

    public void setNetConnectionsProcessorCount(String string) {
        this.netConnectionsProcessorCount = string;
    }

    public String getNetConnectionsProcessorCountAutoValue() {
        return this.netConnectionsProcessorCountAutoValue;
    }

    public void setNetConnectionsProcessorCountAutoValue(String string) {
        this.netConnectionsProcessorCountAutoValue = string;
    }

    public String getMediaCasterProcessorCount() {
        return this.mediaCasterProcessorCount;
    }

    public void setMediaCasterProcessorCount(String string) {
        this.mediaCasterProcessorCount = string;
    }

    public String getMediaCasterProcessorCountAutoValue() {
        return this.mediaCasterProcessorCountAutoValue;
    }

    public void setMediaCasterProcessorCountAutoValue(String string) {
        this.mediaCasterProcessorCountAutoValue = string;
    }

    public String getIdleWorkerCount() {
        return this.idleWorkerCount;
    }

    public void setIdleWorkerCount(String string) {
        this.idleWorkerCount = string;
    }

    public String getIdleWorkerCountAutoValue() {
        return this.idleWorkerCountAutoValue;
    }

    public void setIdleWorkerCountAutoValue(String string) {
        this.idleWorkerCountAutoValue = string;
    }

    public String getUnicastIncomingProcessorCount() {
        return this.unicastIncomingProcessorCount;
    }

    public void setUnicastIncomingProcessorCount(String string) {
        this.unicastIncomingProcessorCount = string;
    }

    public String getUnicastIncomingProcessorCountAutoValue() {
        return this.unicastIncomingProcessorCountAutoValue;
    }

    public void setUnicastIncomingProcessorCountAutoValue(String string) {
        this.unicastIncomingProcessorCountAutoValue = string;
    }

    public String getUnicastOutgoingProcessorCount() {
        return this.unicastOutgoingProcessorCount;
    }

    public void setUnicastOutgoingProcessorCount(String string) {
        this.unicastOutgoingProcessorCount = string;
    }

    public String getUnicastOutgoingProcessorCountAutoValue() {
        return this.unicastOutgoingProcessorCountAutoValue;
    }

    public void setUnicastOutgoingProcessorCountAutoValue(String string) {
        this.unicastOutgoingProcessorCountAutoValue = string;
    }

    public String getMulticastIncomingProcessorCount() {
        return this.multicastIncomingProcessorCount;
    }

    public void setMulticastIncomingProcessorCount(String string) {
        this.multicastIncomingProcessorCount = string;
    }

    public String getMulticastIncomingProcessorCountAutoValue() {
        return this.multicastIncomingProcessorCountAutoValue;
    }

    public void setMulticastIncomingProcessorCountAutoValue(String string) {
        this.multicastIncomingProcessorCountAutoValue = string;
    }

    public String getMulticastOutgoingProcessorCount() {
        return this.multicastOutgoingProcessorCount;
    }

    public void setMulticastOutgoingProcessorCount(String string) {
        this.multicastOutgoingProcessorCount = string;
    }

    public String getMulticastOutgoingProcessorCountAutoValue() {
        return this.multicastOutgoingProcessorCountAutoValue;
    }

    public void setMulticastOutgoingProcessorCountAutoValue(String string) {
        this.multicastOutgoingProcessorCountAutoValue = string;
    }

    public int getClientIdleFrequency() {
        return this.clientIdleFrequency;
    }

    public void setClientIdleFrequency(int n) {
        this.clientIdleFrequency = n;
    }

    public int getRtpIdleFrequency() {
        return this.rtpIdleFrequency;
    }

    public void setRtpIdleFrequency(int n) {
        this.rtpIdleFrequency = n;
    }

    public int getHandlerThreadPoolSize() {
        return this.handlerThreadPoolSize;
    }

    public void setHandlerThreadPoolSize(int n) {
        this.handlerThreadPoolSize = n;
    }

    public int getTransportThreadPoolSize() {
        return this.transportThreadPoolSize;
    }

    public void setTransportThreadPoolSize(int n) {
        this.transportThreadPoolSize = n;
    }

    @Override
    public String getFilename() {
        String string = this.getStringVariable(Severity.valueOf(70 + -57, "{f`ce"));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Utils.lastIndexOf("z586?u", -31 - -20) + this.getXMLFilename();
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        try {
            Class.forName(Severity.valueOf(17 - -49, "!,)k1(?3+e; =a#4 %1'x\u0004=+,>.\t+1)/%\u000b%+\"+-;"));
            ServerTuningHandler serverTuningHandler = Server.getInstance().getTuningHandler();
            this.netConnectionsProcessorCountAutoValue = serverTuningHandler.getSuggestedNetConnectionProcessorCount() + "";
            this.mediaCasterProcessorCountAutoValue = serverTuningHandler.getSuggestedMediaCasterProcessorCount() + "";
            this.idleWorkerCountAutoValue = serverTuningHandler.getSuggestedIdleWorkerCount() + "";
            this.unicastIncomingProcessorCountAutoValue = serverTuningHandler.getSuggestedRTPIncomingCount() + "";
            this.unicastOutgoingProcessorCountAutoValue = serverTuningHandler.getSuggestedRTPOutgoingCount() + "";
            this.multicastIncomingProcessorCountAutoValue = serverTuningHandler.getSuggestedRTPIncomingCount() + "";
            this.multicastOutgoingProcessorCountAutoValue = serverTuningHandler.getSuggestedRTPOutgoingCount() + "";
            return super.loadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.loadObject();
        }
    }

    public static VHostTuneConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (VHostTuneConfig)VHostTuneConfig.getObjectFromREST(VHostTuneConfig.getUrl(Severity.valueOf(-31 - 37, "juql4"), string, VHostTuneConfig.class), VHostTuneConfig.class, wMSClientSecurity);
    }
}

