/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.util;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.JSON;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerSanJoseUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String SESSIONIDPLACHOLDER = "{session-id}";
    public static final String BITRATEPLACHOLDER = "{bitrate}";
    public static final String KBITRATEPLACHOLDER = "{kbitrate}";
    public static final String BOOTSTRAPIDPLACEHOLDER = "{bootstrapId}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYHEXSTRPLACHOLDER = "{query-hex}";
    public static final String PLAYLISTPLACHOLDER = "playlist_b{bitrate}_w{session-id}.abst{query}";
    public static final String PLAYSTARTPLACHOLDER = "{playStart}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDuration}";
    public static final String PLAYSEEKPLACHOLDER = "{playSeek}";
    public static final String NGRPPLACHOLDER = "{ngrp}";
    public static final String RANDOMPLACHOLDER = "{randomId}";
    public static final String MEDIAPLACHOLDER = "media{randomId}_b{bitrate}_w{session-id}{query-hex}.abst/";
    public static final String VODMEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}{query-hex}{playStart}{playDuration}{playSeek}{ngrp}.abst/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseEncInfo sanJoseEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingSanJoseBlock> arrayList;
        List<LiveStreamingSanJoseBlock> list;
        Cipher cipher;
        if (sanJoseEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info(Base64.lastIndexOf((int)(-6 - 10), (String)"\u001c8$6\u0007!$294\n:?6;+i{gqWdhMgzo%ja{|xAsp\u007fpbd\"9{\u007fx_qjnb{@evrkmZohy\u007fg{iA`|b|rrj#:") + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(sanJoseEncInfo.getEncKeyBytes(), Base64.lastIndexOf((int)(43 + -17), (String)"[^O"));
            long l = liveStreamPacketizerSanJoseChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(Base64.lastIndexOf((int)(936 / 192), (String)"E@U(KKI$\\FM\\'Aswp|xp"), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerSanJoseChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingSanJoseBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error(Base64.lastIndexOf((int)(15 * 31), (String)"\u001d;%1\u0006\"%=87\u000b=>5:4(8&6\u0016')\u0002&9.\u00199'##\u007f7=7'/',\u001a2.26d\u007fADQ.57>'mgiyu}zf\u007f\u007f2"), (Throwable)exception);
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerSanJoseChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = list.get(n);
            n4 += liveStreamingSanJoseBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen()) : cipher.update(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingSanJoseBlock liveStreamingSanJoseBlock2 = new LiveStreamingSanJoseBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingSanJoseBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SanJoseEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.lastIndexOf((int)(12 + 110), (String)"t09$"));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(JSON.regionMatches((String)"53.", (int)(49 - -47)));
            if (string3 != null || (string3 = (String)object.get(Base64.lastIndexOf((int)(31 * 33), (String)"*rh"))) != null || (string3 = (String)object.get(JSON.regionMatches((String)">+/%36***53:,+&%#)b14!bfm{\"*5", (int)(43 * 23)))) != null || (string3 = (String)object.get(Base64.lastIndexOf((int)(23 * 25), (String)"|51'10,((;=8.- '!7|36'ddou,(2"))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(JSON.regionMatches((String)"mbq", (int)(229 / 38)))) != null || (string2 = (String)object.get(Base64.lastIndexOf((int)(21 - 37), (String)"3$\"6&!?97*.)9<36nf/bav750$anu"))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() != 32) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.lastIndexOf((int)(45 + 55), (String)"\b,0\"\u001b=8.- \u001e.3:7'=/3%\u001b,*>.)71o/kmmq<'Cls+`h`hdy2zzvyej|yo2=Sjsu\"aa%71(ks\u007fi~.'##2p|tdv{m\u007fio4>s//%c\u001f") + file + JSON.regionMatches((String)"[=(", (int)(52 + -14)) + string2.length());
                } else {
                    byArray = BufferUtils.decodeHexString((String)string2);
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new SanJoseEncInfo(string2, byArray, string3);
    }
}

