/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xstream;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.xstream.XstreamRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XstreamConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    protected <T> XstreamRepresentation<T> create(MediaType mediaType, T source) {
        return new XstreamRepresentation<T>(mediaType, source);
    }

    protected <T> XstreamRepresentation<T> create(Representation source, Class<T> target) {
        XstreamRepresentation<T> representation = new XstreamRepresentation<T>(source, target);
        return representation;
    }

    @Override
    public List<Class<?>> getObjectClasses(Variant source) {
        List<Class<?>> result = null;
        if (VARIANT_JSON.isCompatible(source) || VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, XstreamRepresentation.class);
        }
        return result;
    }

    @Override
    public List<VariantInfo> getVariants(Class<?> source) {
        List<VariantInfo> result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    @Override
    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        result = source instanceof XstreamRepresentation ? 1.0f : (target == null ? 0.5f : (VARIANT_JSON.isCompatible(target) ? 0.8f : (VARIANT_APPLICATION_ALL_XML.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target) ? 0.8f : 0.5f)));
        return result;
    }

    @Override
    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (target != null) {
            if (source instanceof XstreamRepresentation) {
                result = 1.0f;
            } else if (XstreamRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (VARIANT_JSON.isCompatible(source)) {
                result = 0.8f;
            } else if (VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
                result = 0.8f;
            }
        } else {
            result = 0.5f;
        }
        return result;
    }

    @Override
    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        XstreamRepresentation<T> result = null;
        XstreamRepresentation<T> xstreamSource = null;
        if (source instanceof XstreamRepresentation) {
            xstreamSource = (XstreamRepresentation<T>)source;
            if (target != null) {
                xstreamSource.getXstream().processAnnotations(target);
            }
        } else if (VARIANT_JSON.isCompatible(source)) {
            xstreamSource = this.create(source, target);
        } else if (VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            xstreamSource = this.create(source, target);
        }
        if (xstreamSource != null) {
            result = target != null && XstreamRepresentation.class.isAssignableFrom(target) ? xstreamSource : (XstreamRepresentation<T>)xstreamSource.getObject();
        }
        return (T)result;
    }

    @Override
    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        XstreamRepresentation<Object> result = null;
        if (source instanceof XstreamRepresentation) {
            result = (XstreamRepresentation<Object>)source;
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.TEXT_XML);
            }
            if (VARIANT_JSON.isCompatible(target)) {
                XstreamRepresentation<Object> xstreamRepresentation;
                result = xstreamRepresentation = this.create(target.getMediaType(), source);
            } else if (VARIANT_APPLICATION_ALL_XML.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target)) {
                result = this.create(target.getMediaType(), source);
            }
        }
        return result;
    }

    @Override
    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        this.updatePreferences(preferences, MediaType.APPLICATION_ALL_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
    }
}

