#!/bin/bash

OS=$1
INST_DIR=$2

if [ "$OS" = "linux" ]
then
	find $INST_DIR -type f | grep -v wms-server.jar | xargs -I {} chmod --reference $INST_DIR/lib/wms-server.jar "{}"
	find $INST_DIR -type f | grep -v wms-server.jar | xargs -I {} chown --reference $INST_DIR/lib/wms-server.jar "{}"
else
	MODE=`stat -f "%p" "$INST_DIR/lib/wms-server.jar"`
	OWNER=`stat -f "%u:%g" "$INST_DIR/lib/wms-server.jar"`
	find $INST_DIR -type f | grep -v wms-server.jar | xargs -I {} chmod $MODE "{}"
	find $INST_DIR -type f | grep -v wms-server.jar | xargs -I {} chown $OWNER "{}"
fi
