/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool;

import com.wowza.updatetool.FileUtil;
import com.wowza.updatetool.Messages;
import com.wowza.updatetool.ZipUtils;
import com.wowza.updatetool.manifest.UpdateManifestEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BackupCreator {
    private static final Logger LOG = Logger.getLogger(BackupCreator.class);
    public static final String BACKUPFILE_EXTENSION = ".zip";
    private final List<UpdateManifestEntry> filesToBackup = new ArrayList<UpdateManifestEntry>();
    private File backupDir;
    private final String installHome;
    private final String outputDir;
    private String outputName;

    public BackupCreator(List<UpdateManifestEntry> filesToBackup, String installHome, String outputName) {
        this.filesToBackup.addAll(filesToBackup);
        this.installHome = installHome;
        this.outputName = outputName;
        this.outputDir = installHome + "/" + "updates" + "/" + "backup" + "/";
    }

    public boolean backup() {
        boolean success = false;
        try {
            File backupFile = new File(this.outputDir + "/" + this.outputName + BACKUPFILE_EXTENSION);
            if (backupFile.exists()) {
                int attempt = 0;
                while ((backupFile = new File(this.outputDir + "/" + this.outputName + "-" + ++attempt + BACKUPFILE_EXTENSION)).exists()) {
                }
                this.outputName = this.outputName + "-" + attempt;
            }
            this.outputName = this.outputName + BACKUPFILE_EXTENSION;
            LOG.debug("Attempting to create temporary backup directory");
            success = this.createBackupDirectory();
            LOG.debug("Created temporary backup directory " + this.backupDir);
            if (success && !(success = this.copyFilesToBackupDirectory(this.backupDir.getAbsolutePath()))) {
                LOG.error(Messages.get("backupCreator.errorCopyingToBackupDir"));
            }
            LOG.debug("Zipping backup directory");
            if (success && !(success = this.zipBackupDirectory(this.backupDir.getAbsolutePath(), this.outputDir, this.outputName))) {
                LOG.error(Messages.get("backupCreator.errorCreatingZipArchive"));
            }
            if (success && !this.deleteBackupDirectory()) {
                LOG.warn(String.format(Messages.get("backupCreator.errorDeletingTempBackupDir"), this.backupDir));
            }
            if (success) {
                LOG.info(String.format(Messages.get("backupCreator.success"), backupFile.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            LOG.error(Messages.get("update.backupFailed"), e);
        }
        return success;
    }

    private boolean createBackupDirectory() throws IOException {
        boolean result = true;
        try {
            this.backupDir = File.createTempFile("temp", Long.toString(System.nanoTime()));
            result = this.backupDir.delete();
            if (result && !(result &= this.backupDir.mkdir())) {
                result = false;
            }
        }
        catch (Exception e) {
            LOG.debug(Messages.get("update.backupFailed"), e);
        }
        return result;
    }

    private boolean copyFilesToBackupDirectory(String backupDir) throws IOException {
        boolean success = true;
        try {
            for (UpdateManifestEntry entry : this.filesToBackup) {
                File srcFile = new File(this.installHome + "/" + entry.getDestination());
                if (!srcFile.exists()) {
                    if (!entry.getRequired().booleanValue()) continue;
                    LOG.debug(String.format(Messages.get("backupCreator.missingSourceFile"), entry.getDestination()));
                    continue;
                }
                File dstFile = new File(backupDir + "/" + entry.getDestination());
                File dstDir = new File(dstFile.getParent());
                if (!dstDir.exists()) {
                    success &= dstDir.mkdirs();
                }
                if (success &= FileUtil.copyFile(srcFile, dstFile)) {
                    LOG.debug("Copied " + srcFile + " from " + this.installHome + " to backup directory");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.error(Messages.get("update.backupFailed"), e);
            success = false;
        }
        return success;
    }

    private boolean zipBackupDirectory(String sourceDir, String outDir, String outputName) throws IOException {
        boolean result = false;
        try {
            result = ZipUtils.zipDirectory(sourceDir, outDir, outputName, false);
        }
        catch (Exception e) {
            LOG.error(String.format(Messages.get("backupCreator.cannotZipFiles"), sourceDir, outDir + "/" + outputName));
        }
        return result;
    }

    private boolean deleteBackupDirectory() throws IOException {
        return BackupCreator.deleteDirectory(this.backupDir);
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    BackupCreator.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public String getBackupFileName() {
        return this.outputDir + this.outputName;
    }
}

