/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class);

    public static boolean copyFile(File fromFile, File toFile) throws IOException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(fromFile);
            outStream = new FileOutputStream(toFile);
        }
        catch (Exception e) {
            LOG.error("Error copying " + fromFile + " to " + toFile, e);
            return false;
        }
        try {
            long c;
            FileChannel inChannel = inStream.getChannel();
            FileChannel outChannel = outStream.getChannel();
            long s = inChannel.size();
            for (long n = 0L; n < s; n += c) {
                c = outChannel.transferFrom(inChannel, n, s - n);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            FileUtil.closeQuietly(inStream);
            FileUtil.closeQuietly(outStream);
        }
    }

    public static void closeQuietly(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

