/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool;

import com.wowza.updatetool.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipUtils {
    private static final Logger LOG = Logger.getLogger(ZipUtils.class);

    public static boolean zipDirectory(String srcDir, String destDir, String zipFileName) {
        return ZipUtils.zipDirectory(srcDir, destDir, zipFileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipDirectory(String srcDir, String destDir, String zipFileName, boolean includeParentDirInName) {
        boolean retVal = false;
        List<String> zipFileList = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        FileInputStream in = null;
        try {
            int start;
            File srcFile = new File(srcDir);
            if (!srcFile.exists() || !srcFile.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            String rootDir = null;
            String temp = srcDir.replaceAll("\\\\", "/");
            if (includeParentDirInName && (start = temp.lastIndexOf("/")) >= 0 && start < temp.length()) {
                rootDir = temp.substring(start + 1, temp.length());
            }
            if ((zipFileList = ZipUtils.buildZipLIst(srcFile, rootDir)) != null && zipFileList.size() > 0) {
                File test = new File(destDir);
                if (!test.exists()) {
                    test.mkdirs();
                }
                fos = new FileOutputStream(destDir + "/" + zipFileName);
                zos = new ZipOutputStream(fos);
                byte[] buff = new byte[1024];
                rootDir = rootDir == null ? temp : temp.substring(0, temp.lastIndexOf("/"));
                for (String file : zipFileList) {
                    int len;
                    LOG.debug("Adding file " + file);
                    ZipEntry ze = new ZipEntry(file);
                    zos.putNextEntry(ze);
                    in = new FileInputStream(rootDir + "/" + file);
                    while ((len = in.read(buff)) > 0) {
                        zos.write(buff, 0, len);
                    }
                    in.close();
                    in = null;
                }
                retVal = true;
            }
        }
        catch (Exception e) {
            LOG.error(String.format(Messages.get("zipUtils.error"), srcDir, destDir + "/" + zipFileName), e);
        }
        finally {
            try {
                if (zos != null) {
                    zos.closeEntry();
                    zos.close();
                }
            }
            catch (Exception e2) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e2) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {}
        }
        return retVal;
    }

    private static List<String> buildZipLIst(File srcDir, String rootDir) {
        ArrayList<String> fileList = new ArrayList<String>();
        String[] files = srcDir.list();
        if (files != null) {
            for (String file : files) {
                File temp = new File(srcDir.getAbsoluteFile() + "/" + file);
                if (temp.isFile()) {
                    String name = (rootDir == null ? "" : rootDir + "/") + temp.getName();
                    fileList.add(name);
                    continue;
                }
                fileList.addAll(ZipUtils.buildZipLIst(temp, (rootDir == null ? "" : rootDir + "/") + temp.getName()));
            }
        }
        return fileList;
    }
}

