/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.Registry;

public class JndiJmx
extends BaseModelMBean
implements NotificationListener {
    protected Context componentContext;
    protected Context descriptorContext;
    protected Context configContext;
    MBeanServer mserver;
    Hashtable attributes = new Hashtable();
    Hashtable instances = new Hashtable();

    public JndiJmx() throws MBeanException {
        super(JndiJmx.class.getName());
    }

    public void setComponentContext(Context context) {
        this.componentContext = context;
    }

    public void setDescriptorContext(Context context) {
        this.descriptorContext = context;
    }

    public void setConfigContext(Context context) {
        this.configContext = context;
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        Object object2;
        Object object3;
        Object object4;
        Notification notification2;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(JndiJmx.class);
        if (notification instanceof MBeanServerNotification) {
            notification2 = (MBeanServerNotification)notification;
            object4 = ((MBeanServerNotification)notification2).getMBeanName();
            if ("jmx.mbean.created".equalsIgnoreCase(notification.getType())) {
                try {
                    object3 = this.mserver.getObjectInstance((ObjectName)object4);
                    if (wMSLogger.isDebugEnabled()) {
                        wMSLogger.debug("MBean created " + object4 + " " + object3);
                    }
                    if (object3 instanceof NotificationBroadcaster) {
                        object2 = (NotificationBroadcaster)object3;
                        object2.addNotificationListener(this, null, null);
                        if (wMSLogger.isDebugEnabled()) {
                            wMSLogger.debug("Add attribute change listener");
                        }
                    }
                    this.instances.put(((ObjectName)object4).toString(), object3);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    wMSLogger.error("Instance not found for the created object", (Throwable)instanceNotFoundException);
                }
            }
            if ("jmx.mbean.deleted".equalsIgnoreCase(notification.getType())) {
                this.instances.remove(((ObjectName)object4).toString());
            }
        }
        if (notification instanceof AttributeChangeNotification) {
            notification2 = (AttributeChangeNotification)notification;
            object4 = ((AttributeChangeNotification)notification2).getAttributeName();
            object3 = ((AttributeChangeNotification)notification2).getNewValue();
            object2 = notification2.getSource();
            Object var8_9 = null;
            Hashtable<Object, Notification> hashtable = (Hashtable<Object, Notification>)this.attributes.get(object2);
            if (hashtable == null) {
                hashtable = new Hashtable<Object, Notification>();
                this.attributes.put(object2, hashtable);
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("First attribute for " + object2);
                }
            }
            hashtable.put(object4, notification2);
            wMSLogger.debug("Attribute change notification " + (String)object4 + " " + object3 + " " + object2);
        }
    }

    public String dumpStatus() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.instances.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.instances.get(string);
            Hashtable hashtable = (Hashtable)this.attributes.get(v);
            stringBuffer.append("<mbean class=\"").append(string).append("\">");
            stringBuffer.append("\n");
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)hashtable.get(string2);
                stringBuffer.append("  <attribute name=\"").append(string2).append("\" ");
                stringBuffer.append("value=\"").append(attributeChangeNotification.getNewValue()).append("\">");
                stringBuffer.append("\n");
            }
            stringBuffer.append("</mbean>");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void replay() throws Exception {
    }

    public void init() throws Exception {
        MBeanServer mBeanServer = Registry.getRegistry().getMBeanServer();
        ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        mBeanServer.addNotificationListener(objectName, this, null, null);
    }
}

