/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacache.impl;

import com.wowza.io.HTTPByteReaderS3;
import com.wowza.util.Base64;
import com.wowza.util.HTTPUtils;
import com.wowza.util.JSON;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacache.impl.IMediaCacheHTTPByteReader;
import com.wowza.wms.mediacache.impl.MediaCacheHTTPByteReaderResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class MediaCacheHTTPByteReader
implements IMediaCacheHTTPByteReader {
    public static final String S3DOMAINNAME = "s3.amazonaws.com";
    public static final int MAXHEADERSIZE = 4096;
    public static final int BUFFERINCSIZE = 1024;
    public static final int TIMEOUT = 6000;
    public static final int SENDBUFFERSIZE = 8000;
    public static final int RECEIVEBUFFERSIZE = 65000;
    public static final String CRLF = "\r\n";
    protected String host = null;
    protected int port = 80;
    protected String reqPath = null;
    protected String proxyHost = null;
    protected int proxyPort = 80;
    protected FastDateFormat dateFormat = null;
    protected Socket socket = null;
    protected StringBuffer msgBuf = new StringBuffer();
    protected int maxRetries = 3;
    protected int maxUsesBeforeReconnect = 12;
    protected int uses = 0;
    protected int readTimeout = 6000;
    protected int connectionTimeout = 6000;
    protected List<String> debugInfo = null;
    protected String debugPrefix = null;
    protected boolean requestFullURL = false;
    protected String[] parseDateFormats = null;
    protected int sendBufferSize = 8000;
    protected int receiveBufferSize = 65000;
    protected String userAgent = null;
    protected WMSProperties properties = new WMSProperties();
    protected String awsSecretAccessKey = null;
    protected String awsAccessKeyId = null;
    protected SecretKeySpec signingKey = null;
    protected Mac mac = null;
    protected String bucketName = null;
    protected boolean debugHTTPRequests = false;
    protected boolean sendHTTPKeepAlive = true;
    protected boolean sendHTTPProxyKeepAlive = true;
    protected boolean bucketNameInDomain = true;
    protected boolean closeConnectOnBadStatus = false;
    protected boolean closeConnectOnBadContentLength = false;
    protected boolean logSocketWarning = true;
    protected String userHeadersStr = null;
    protected Map<String, String> userHeaders = new HashMap<String, String>();

    public MediaCacheHTTPByteReader() {
        this.dateFormat = FastDateFormat.getInstance((String)JSON.replace((String)"P:7|}:VQP>f98;c\f\r|*%s98l745", (int)(61 - 8)), (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
        this.parseDateFormats = new String[1];
        this.parseDateFormats[0] = Base64.subSequence((int)(506 / 119), (String)"A)&cl)GFA-wvih2[\\/{z\"ji;fgd");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() {
        Object object;
        WMSProperties wMSProperties = this.properties;
        this.debugHTTPRequests = wMSProperties.getPropertyBoolean(JSON.replace((String)"ace}nB_X]\\jadw``f", (int)(237 / 41)), this.debugHTTPRequests);
        this.sendHTTPKeepAlive = wMSProperties.getPropertyBoolean(Base64.subSequence((int)(99 + -48), (String)"`q{r_LMJPyxn^,(4&"), this.sendHTTPKeepAlive);
        this.sendHTTPProxyKeepAlive = wMSProperties.getPropertyBoolean(Base64.subSequence((int)(75 + 62), (String)"zoehEZ[@A`|ll]r}i[wuk{"), this.sendHTTPProxyKeepAlive);
        this.closeConnectOnBadStatus = wMSProperties.getPropertyBoolean(JSON.replace((String)"ekgzoHcc`jse]}VtrDlxnno", (int)(1636 / 244)), this.closeConnectOnBadStatus);
        this.closeConnectOnBadContentLength = wMSProperties.getPropertyBoolean(Base64.subSequence((int)(39 - -25), (String)"#--0!\u0006))&,)?\u0003#\f.4\u0012== 08#\u0014<4<(5"), this.closeConnectOnBadContentLength);
        this.userHeadersStr = wMSProperties.getPropertyStr(JSON.replace((String)"r{lxCXY^Gupvvff", (int)(45 * 35)), this.userHeadersStr);
        this.userHeaders.clear();
        if (this.userHeadersStr != null && (object = HTTPUtils.expandHTTPHeadersStr((String)this.userHeadersStr)) != null) {
            this.userHeaders.putAll((Map<String, String>)object);
        }
        this.awsSecretAccessKey = wMSProperties.getPropertyStr(JSON.replace((String)"|ilSdaqaqGdklyxGhw", (int)(-50 + 79)), null);
        if (this.awsSecretAccessKey != null && this.awsSecretAccessKey.length() <= 0) {
            this.awsSecretAccessKey = null;
        }
        this.awsAccessKeyId = wMSProperties.getPropertyStr(Base64.subSequence((int)(64 + -42), (String)"w`kXyxynmTexKg"), null);
        if (this.awsAccessKeyId != null && this.awsAccessKeyId.length() <= 0) {
            this.awsAccessKeyId = null;
        }
        if (this.awsAccessKeyId == null || this.awsSecretAccessKey == null) {
            this.awsSecretAccessKey = null;
            this.awsAccessKeyId = null;
        }
        if (this.awsAccessKeyId == null) return;
        object = this.host;
        String string = this.host.toLowerCase();
        int n = string.indexOf(Base64.subSequence((int)(-25 - 2), (String)"k5tf('*6\" .'\"|0;8"));
        if (n >= 0) {
            this.bucketName = ((String)object).substring(0, n);
            this.bucketNameInDomain = true;
        }
        try {
            this.initAuth();
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPByteReaderS3.class).info(Base64.subSequence((int)(40 - 4), (String)"LQRWJp~n^hokucA :{s`Qwio}s}zza") + exception.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void a(StringBuffer stringBuffer) {
        if (this.userHeaders.size() > 0) {
            for (String string : this.userHeaders.keySet()) {
                stringBuffer.append(string + JSON.replace((String)"?&", (int)(1055 / 201)) + this.userHeaders.get(string) + Base64.subSequence((int)(-33 - -1), (String)"MK"));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String a() {
        block15: {
            block12: {
                block14: {
                    block13: {
                        block11: {
                            block10: {
                                var1_1 = "";
                                if (this.userHeaders.size() <= 0) lbl-1000:
                                // 3 sources

                                {
                                    return var1_1;
                                }
                                var2_2 = new TreeMap<String, String>();
                                var3_3 = this.userHeaders.keySet().iterator();
                                if (true) ** GOTO lbl22
lbl8:
                                // 1 sources

                                while (true) {
                                    var4_4 = var3_3.next();
                                    var5_5 = (String)var2_2.get(var4_4);
                                    v0 = new StringBuilder().append(var1_1).append(var4_4);
                                    if (var5_5 != null) break block10;
                                    break block11;
                                    break;
                                }
lbl14:
                                // 1 sources

                                while (true) {
                                    var5_5 = var5_5.trim();
                                    break block12;
                                    break;
                                }
                                block3: while (true) {
                                    var4_4 = var3_3.next();
                                    var5_5 = this.userHeaders.get(var4_4);
                                    var4_4 = var4_4.toLowerCase(Locale.ENGLISH);
                                    if (var4_4.startsWith(JSON.replace((String)"}+fes'", (int)(354 / 67)))) break block13;
lbl22:
                                    // 3 sources

                                    while (true) {
                                        if (var3_3.hasNext()) {
                                            continue block3;
                                        }
                                        break block14;
                                        break;
                                    }
                                    break;
                                }
                            }
                            v1 = ":" + var5_5;
                            break block15;
                        }
                        v1 = "";
                        break block15;
lbl32:
                        // 2 sources

                        while (true) {
                            if (!var3_3.hasNext()) ** GOTO lbl-1000
                            ** continue;
                            break;
                        }
lbl35:
                        // 1 sources

                        while (true) {
                            var3_3 = var2_2.keySet().iterator();
                            ** GOTO lbl32
                            break;
                        }
                    }
                    if (var5_5 != null) {
                        ** continue;
                    }
                    break block12;
                }
                if (var2_2.size() > 0) ** break;
                ** while (true)
                ** while (true)
            }
            var2_2.put(var4_4, var5_5);
            ** while (true)
        }
        var1_1 = v0.append(v1).append("\n").toString();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getHeadCommandS3(String string) {
        String string2;
        String string3 = Base64.subSequence((int)(63 * 9), (String)"_]X^");
        String string4 = this.httpDate();
        String string5 = "";
        String string6 = null;
        if (this.mac != null) {
            string2 = string3 + Base64.subSequence((int)(906 / 207), (String)"\u000e\u000f\f") + string4 + "\n" + this.a() + (this.bucketName == null ? "" : "/" + this.bucketName) + string;
            MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
            String string7 = mediaCacheHTTPByteReader.signRequest(mediaCacheHTTPByteReader.awsSecretAccessKey, string2);
            string6 = JSON.replace((String)"Eprog{cqmyg`~+2RCF6", (int)(702 / 175)) + this.awsAccessKeyId + ":" + string7;
        }
        string2 = string;
        this.msgBuf.setLength(0);
        this.msgBuf.append(string3 + " " + string2 + Base64.subSequence((int)(-54 - 63), (String)"+DYZ_? <\"") + Base64.subSequence((int)(47 - -42), (String)"TP"));
        this.msgBuf.append(Base64.subSequence((int)(30 - -8), (String)"Bf|l0+") + string4 + JSON.replace((String)"\b\f", (int)(45 * 57)));
        this.msgBuf.append(JSON.replace((String)"^xkm ;", (int)(-56 - 50)) + this.host + Base64.subSequence((int)(462 / 81), (String)"\b\f"));
        this.msgBuf.append(Base64.subSequence((int)(31 * 37), (String)"\u001833*:nu/W}uc=(") + string5 + JSON.replace((String)"\u0000\u0004", (int)(108 + -63)));
        if (this.sendHTTPKeepAlive) {
            this.msgBuf.append(Base64.subSequence((int)(512 / 75), (String)"Ehfgohxdaa*1yvqe;vtpl~\u0011\u0017"));
        }
        if (this.sendHTTPProxyKeepAlive) {
            this.msgBuf.append(JSON.replace((String)"Jiseg2Cnlmafrngg0+ghk\u007f=p~zbp\u001b\u001d", (int)(119 + -93)));
        }
        MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
        mediaCacheHTTPByteReader.a(mediaCacheHTTPByteReader.msgBuf);
        if (string6 != null) {
            this.msgBuf.append(string6 + JSON.replace((String)"_Y", (int)(93 + -11)));
        }
        this.msgBuf.append(JSON.replace((String)"\u0000\u0004", (int)(1 + 44)));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getGetCommandS3(String string, long l, int n) {
        String string2;
        String string3 = JSON.replace((String)"HUE", (int)(-62 - 51));
        String string4 = this.httpDate();
        String string5 = "";
        String string6 = null;
        if (this.mac != null) {
            string2 = string3 + Base64.subSequence((int)(777 / 162), (String)"\u000e\u000f\f") + string4 + "\n" + this.a() + (this.bucketName == null ? "" : "/" + this.bucketName) + string;
            MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
            String string7 = mediaCacheHTTPByteReader.signRequest(mediaCacheHTTPByteReader.awsSecretAccessKey, string2);
            string6 = JSON.replace((String)"Tccpvhrf|jv//xc\u0005\u0012\u0015g", (int)(63 * 11)) + this.awsAccessKeyId + ":" + string7;
        }
        string2 = string;
        long l2 = l;
        long l3 = l + (long)n - 1L;
        this.msgBuf.setLength(0);
        this.msgBuf.append(string3 + " " + string2 + Base64.subSequence((int)(35 + 15), (String)"2[@AF8)7+") + Base64.subSequence((int)(29 * 15), (String)"\u001e\u001e"));
        this.msgBuf.append(Base64.subSequence((int)(51 * 49), (String)"\u0007%1#}h") + string4 + JSON.replace((String)"\u001d\u001b", (int)(80 + -64)));
        this.msgBuf.append(JSON.replace((String)"\u001d9$,cz", (int)(3 * 39)) + this.host + Base64.subSequence((int)(21 - 20), (String)"\f\b"));
        this.msgBuf.append(JSON.replace((String)"Fii|ld\u007f!Yw\u007fu+2", (int)(61 * 9)) + string5 + JSON.replace((String)"\u001e\u001e", (int)(6 + 13)));
        this.msgBuf.append(JSON.replace((String)"\f>.&'yd'?3-:w", (int)(62 - -32)) + l2 + "-" + l3 + JSON.replace((String)"\t\u000f", (int)(349 / 71)));
        if (this.sendHTTPKeepAlive) {
            this.msgBuf.append(Base64.subSequence((int)(22 - 10), (String)"Ob`aurfz{{,7s|\u007fk1|rvvd\u000f\t"));
        }
        if (this.sendHTTPProxyKeepAlive) {
            this.msgBuf.append(JSON.replace((String)"Nmoy{.Gjhimj~bcc4/{twc9tz~n|\u0017\u0011", (int)(60 - 30)));
        }
        MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
        mediaCacheHTTPByteReader.a(mediaCacheHTTPByteReader.msgBuf);
        if (string6 != null) {
            this.msgBuf.append(string6 + Base64.subSequence((int)(302 / 99), (String)"\u000e\u000e"));
        }
        this.msgBuf.append(Base64.subSequence((int)(33 * 11), (String)"FF"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initAuth() {
        this.signingKey = new SecretKeySpec(this.awsSecretAccessKey.getBytes(), JSON.replace((String)"Sq|}LH@3", (int)(21 + 6)));
        try {
            this.mac = Mac.getInstance(Base64.subSequence((int)(55 * 47), (String)"Qwz\u007fNV^1"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(Base64.subSequence((int)(45 * 27), (String)"\\/4.'d+)3h/#%(m='1`r2829%1-26"), noSuchAlgorithmException);
        }
        try {
            this.mac.init(this.signingKey);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(JSON.replace((String)"Ytiqz?nnv#mkosahfbvh.{xt2^UV6vt~uiuivr", (int)(12 - -14)), invalidKeyException);
        }
    }

    public void addProperties(WMSProperties wMSProperties) {
        this.properties.putAll((Map)wMSProperties);
    }

    @Override
    public void setDestinationAddress(String string, int n) {
        this.host = string;
        this.port = n;
    }

    @Override
    public void setProxyAddress(String string, int n) {
        this.proxyHost = string;
        this.proxyPort = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {}
        this.socket = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        if (this.socket != null) {
            this.close();
        }
        try {
            this.socket = new Socket();
            this.socket.setKeepAlive(true);
            this.socket.setSendBufferSize(this.sendBufferSize);
            this.socket.setReceiveBufferSize(this.receiveBufferSize);
            this.socket.setSoTimeout(this.readTimeout);
            this.socket.connect(new InetSocketAddress(this.proxyHost, this.proxyPort), this.connectionTimeout);
            this.logSocketWarning = true;
            return;
        }
        catch (Exception exception) {
            this.close();
            return;
        }
    }

    protected void reconnect() {
        this.connect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.socket == null) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseHeader(SendResult var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block29: {
            block24: {
                block27: {
                    block28: {
                        block23: {
                            try {
                                block26: {
                                    block25: {
                                        block22: {
                                            block21: {
                                                var6_6 = 0;
                                                block10: while (var6_6 < var4_4) {
                                                    if (var2_2[var6_6 + var3_3] != 13 || var6_6 + 3 >= var4_4 || var2_2[var6_6 + var3_3] != 13) {
                                                        while (true) {
                                                            ++var6_6;
                                                            continue block10;
                                                            break;
                                                        }
                                                    }
                                                    break block21;
                                                }
                                                return;
                                            }
                                            if (var2_2[var6_6 + var3_3 + 1] != 10 || var2_2[var6_6 + var3_3 + 2] != 13 || var2_2[var6_6 + var3_3 + 3] != 10) ** continue;
                                            var1_1.gotHeader = true;
                                            var1_1.headerLength = var6_6 + 4;
                                            var7_8 = new String(var2_2, var3_3, (int)var1_1.headerLength);
                                            while ((var8_9 = var7_8.substring(0, 1)).equals("\n") || var8_9.equals("\r")) {
                                                if ((var7_8 = var7_8.substring(1)).length() != 0) continue;
                                                break;
                                            }
                                            var7_8 = var7_8.replace(Base64.subSequence((int)(60 - 20), (String)"\u0005\u0003"), "\n").replace("\r", "\n");
                                            var8_9 = var7_8.split("\n");
                                            var1_1.headerStr = var7_8;
                                            var9_10 = 0;
                                            block13: while (var9_10 < var8_9.length) {
                                                if (var8_9[var9_10].length() == 0) lbl-1000:
                                                // 12 sources

                                                {
                                                    while (true) {
                                                        ++var9_10;
                                                        continue block13;
                                                        break;
                                                    }
                                                }
                                                break block22;
                                            }
                                            return;
                                        }
                                        if (this.debugInfo != null) {
                                            var10_13 = this.debugPrefix + var8_9[var9_10];
                                            this.debugInfo.add(var10_13);
                                        }
                                        if (var9_10 != 0) break block25;
                                        var10_12 = var8_9[var9_10].split(" ");
                                        if (var10_12.length <= 1) ** GOTO lbl-1000
                                        break block26;
                                    }
                                    var10_11 = var8_9[var9_10].indexOf(":");
                                    if (var10_11 >= 0) break block23;
                                    ** GOTO lbl-1000
                                }
                                try {}
                                catch (Exception var11_15) {}
                                break block24;
                                ** GOTO lbl-1000
                            }
                            catch (Exception var6_7) {
                                WMSLoggerFactory.getLogger(null).error(Base64.subSequence((int)(-11 - 47), (String)"\u000b\", +\b-.&*\u0018\u0005\u0006\u0003\u0016,\"2\n<;?9/p/!31&\f '#-;\u0011") + this.getConextPath() + JSON.replace((String)"X&", (int)(59 * 31)), (Throwable)var6_7);
                                return;
                            }
lbl50:
                            // 1 sources

                            while (true) {
                                var12_16 = var12_16.substring(JSON.replace((String)"ks\u007fi~.", (int)(65 + -56)).length());
                                while (true) {
                                    var13_17 = var12_16.split(Base64.subSequence((int)(99 + -57), (String)"Q$Q"));
                                    var14_20 = var13_17[0].split(Base64.subSequence((int)(411 / 83), (String)"_(["));
                                    var1_1.contentRangeStart = Long.parseLong(var14_20[0]);
                                    var1_1.contentRangeStop = Long.parseLong(var14_20[1]);
                                    var1_1.contentRangeFound = true;
                                    break;
                                }
                                break;
                            }
lbl60:
                            // 1 sources

                            while (true) {
                                if (!var11_14.equalsIgnoreCase(Base64.subSequence((int)(11 - 7), (String)"Gjhsmg~&^l`hu"))) ** GOTO lbl-1000
                                if (!(var12_16 = var12_16.trim()).startsWith(JSON.replace((String)"}yugp$", (int)(56 + 103)))) ** continue;
                                ** continue;
                                break;
                            }
                        }
                        var11_14 = var8_9[var9_10].substring(0, var10_11).trim();
                        var12_16 = var8_9[var9_10].substring(var10_11 + 1).trim();
                        if (!var11_14.equalsIgnoreCase(Base64.subSequence((int)(31 * 31), (String)"\u0002--0 (3e\u0005/%+9&"))) break block27;
                        try {}
                        catch (Exception var13_18) {}
                        break block28;
                        ** GOTO lbl-1000
                    }
                    var1_1.contentLength = Long.parseLong(var12_16);
                }
                ** while (!var11_14.equalsIgnoreCase((String)JSON.replace((String)"W}nj2\r.&*\",##", (int)(47 * 53))))
lbl-1000:
                // 1 sources

                try {}
                catch (Exception var13_19) {
                }
                break block29;
                catch (Exception var15_21) {}
                ** GOTO lbl-1000
            }
            var1_1.status = Integer.parseInt(var10_12[1]);
        }
        var1_1.lastModified = DateUtils.parseDate((String)var12_16, (String[])this.parseDateFormats);
        ** while (true)
    }

    @Override
    public MediaCacheHTTPByteReaderResult read(String string, long l, int n) {
        this.reqPath = string;
        return this.readDirect(string, l, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getRequestPath(String string, String string2, int n) {
        if (!this.requestFullURL) return string;
        return Base64.subSequence((int)(31 * 49), (String)"'$%\"i{z") + string2 + (this.port != 80 ? ":" + this.port : "") + (string.startsWith("/") ? string : "/" + string);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getConextPath() {
        String string;
        String string2 = "";
        if (this.reqPath != null) {
            string2 = this.reqPath;
        }
        StringBuilder stringBuilder = new StringBuilder().append(Base64.subSequence((int)(988 / 211), (String)"lqrw2&%")).append(this.host).append(":").append(this.port);
        if (!string2.startsWith("/")) {
            string = "/" + string2;
            return stringBuilder.append(string).toString();
        }
        string = string2;
        return stringBuilder.append(string).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getHeaderHost() {
        String string;
        StringBuilder stringBuilder;
        block2: {
            block1: {
                stringBuilder = new StringBuilder().append(this.host);
                if (this.port != 80) break block1;
                break block2;
            }
            string = ":" + this.port;
            return stringBuilder.append(string).toString();
        }
        string = "";
        return stringBuilder.append(string).toString();
    }

    protected String httpDate() {
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)JSON.replace((String)"FA@*'lm*FA@.vihk3\\],zu#ih<", (int)(818 / 207)), (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);
        return fastDateFormat.format(new Date()) + Base64.subSequence((int)(251 / 64), (String)"DIQ");
    }

    public String signRequest(String string, String string2) {
        return Base64.encodeBytes((byte[])this.mac.doFinal(string2.getBytes()));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getHeadCommand(String string) {
        if (this.awsAccessKeyId != null) {
            this.getHeadCommandS3(string);
        } else {
            this.msgBuf.setLength(0);
            this.msgBuf.append(JSON.replace((String)"CILJ/", (int)(19 * 9)) + this.getRequestPath(string, this.host, this.port) + JSON.replace((String)"/XEFC;$8&", (int)(-2 - -49)) + Base64.subSequence((int)(113 + -76), (String)"\b\f"));
            this.msgBuf.append(Base64.subSequence((int)(11 - 63), (String)"\u0004\"=;jq") + this.getHeaderHost() + Base64.subSequence((int)(50 - -3), (String)"\u0018\u001c"));
            if (this.userAgent != null) {
                this.msgBuf.append(Base64.subSequence((int)(1087 / 244), (String)"Qvcu%Hmnby4/") + this.userAgent + JSON.replace((String)"\t\u000f", (int)(872 / 202)));
            }
            if (this.sendHTTPKeepAlive) {
                this.msgBuf.append(Base64.subSequence((int)(-65 - 45), (String)"Q|z{stlpuu&=uzeq/bhlpb\u0005\u0003"));
            }
            if (this.sendHTTPProxyKeepAlive) {
                this.msgBuf.append(JSON.replace((String)"Edx``7Xsspzcuklj?&lmlz&magyu\u001c\u0018", (int)(37 * 49)));
            }
            MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
            mediaCacheHTTPByteReader.a(mediaCacheHTTPByteReader.msgBuf);
            this.msgBuf.append(Base64.subSequence((int)(209 / 54), (String)"\u000e\u000e"));
        }
        if (!this.debugHTTPRequests) return;
        WMSLoggerFactory.getLogger(null).info(Base64.subSequence((int)(-89 + 114), (String)"T\u007f\u007fu|]~cigKPQVEq}oYiljjb?uv`]sv|Zuvq|p{\u001b") + this.getConextPath() + Base64.subSequence((int)(82 + -11), (String)"\u001ari") + string + "\n" + this.msgBuf.toString());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MediaCacheHTTPByteReaderResult head(String var1_1) {
        var2_2 = null;
        this.reqPath = var1_1;
        var3_3 = System.nanoTime();
        this.getHeadCommand(var1_1);
        var5_4 = this.msgBuf.toString().getBytes();
        var6_5 = 0;
        if (true) ** GOTO lbl40
        do {
            block11: {
                block14: {
                    block9: {
                        block10: {
                            block8: {
                                block13: {
                                    block7: {
                                        block12: {
                                            if ((var7_6 = this.sendRequest(var5_4, true)) == null) break block12;
                                            break block13;
                                            while (true) {
                                                v0 = 0L;
                                                break block7;
                                                break;
                                            }
lbl14:
                                            // 1 sources

                                            while (true) {
                                                this.uses = 0;
                                                this.close();
                                                break block8;
                                                break;
                                            }
lbl18:
                                            // 1 sources

                                            while (!this.isOpen()) {
                                                break block9;
                                            }
                                            continue;
                                        }
lbl22:
                                        // 2 sources

                                        while (true) {
                                            ++var6_5;
                                            break block10;
                                            break;
                                        }
                                    }
lbl26:
                                    // 2 sources

                                    while (true) {
                                        var2_2.lastModified = v0;
                                        var2_2.tries = var6_5;
                                        var2_2.elapseTime = (System.nanoTime() - var3_3) / 1000000L;
                                        break block11;
                                        break;
                                    }
                                }
                                var2_2 = new MediaCacheHTTPByteReaderResult();
                                var2_2.status = var7_6.status;
                                var2_2.contentLength = var7_6.contentLength;
                                if (var7_6.lastModified == null) ** continue;
                                break block14;
                            }
                            return var2_2;
                        }
                        if (var6_5 >= this.maxRetries) break block11;
                        ** GOTO lbl18
                    }
                    this.reconnect();
                    continue;
                }
                v0 = var7_6.lastModified.getTime();
                ** continue;
            }
            ++this.uses;
            if (this.uses < this.maxUsesBeforeReconnect) ** continue;
            ** continue;
        } while (this.isOpen());
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getGetCommand(String string, long l, int n) {
        if (this.awsAccessKeyId != null) {
            this.getGetCommandS3(string, l, n);
        } else {
            long l2 = l;
            long l3 = l + (long)n - 1L;
            this.msgBuf.setLength(0);
            this.msgBuf.append(Base64.subSequence((int)(35 * 49), (String)"TQA6") + this.getRequestPath(string, this.host, this.port) + JSON.replace((String)"$MRSX&;%=", (int)(965 / 226)) + JSON.replace((String)"\u0019\u001f", (int)(51 - 31)));
            this.msgBuf.append(Base64.subSequence((int)(15 * 21), (String)"Ssnj%`") + this.getHeaderHost() + JSON.replace((String)"\u0015\u0013", (int)(61 - 5)));
            if (this.userAgent != null) {
                this.msgBuf.append(JSON.replace((String)"\u0018=*\"|\u001341;\"mx", (int)(53 * 57)) + this.userAgent + JSON.replace((String)"\b\f", (int)(945 / 180)));
            }
            this.msgBuf.append(Base64.subSequence((int)(1004 / 237), (String)"Vdh`m3*iuyk|-") + l2 + "-" + l3 + Base64.subSequence((int)(10 + 80), (String)"WQ"));
            if (this.sendHTTPKeepAlive) {
                this.msgBuf.append(Base64.subSequence((int)(58 + 85), (String)"L\u007f\u007f|vwa\u007fxv#:pyxn2amkua\b\f"));
            }
            if (this.sendHTTPProxyKeepAlive) {
                this.msgBuf.append(JSON.replace((String)"O2.::i\u0006))&,)?%\" up:76$x7;1/?VV", (int)(39 * 41)));
            }
            MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
            mediaCacheHTTPByteReader.a(mediaCacheHTTPByteReader.msgBuf);
            this.msgBuf.append(JSON.replace((String)"\t\u000f", (int)(-58 - 34)));
        }
        if (!this.debugHTTPRequests) return;
        WMSLoggerFactory.getLogger(null).info(JSON.replace((String)"I`bniJkhdhF[DAPj`pDry}\u007fi2z{kGdv@khkffmQ", (int)(726 / 170)) + this.getConextPath() + JSON.replace((String)"I/6", (int)(7 + 45)) + string + "\n" + this.msgBuf.toString());
    }

    /*
     * Unable to fully structure code
     */
    public MediaCacheHTTPByteReaderResult readDirect(String var1_1, long var2_2, int var4_3) {
        block19: {
            block23: {
                block22: {
                    block18: {
                        block21: {
                            block16: {
                                block12: {
                                    block17: {
                                        block13: {
                                            var5_4 = null;
                                            var6_5 = System.nanoTime();
                                            this.reqPath = var1_1;
                                            var8_6 = var2_2;
                                            var10_7 = var2_2 + (long)var4_3 - 1L;
                                            this.getGetCommand(var1_1, var2_2, var4_3);
                                            var12_8 = this.msgBuf.toString().getBytes();
                                            var13_9 = 0;
                                            break block16;
lbl10:
                                            // 3 sources

                                            while (true) {
                                                if (var5_4 == null) ** GOTO lbl19
                                                break block12;
                                                break;
                                            }
lbl13:
                                            // 2 sources

                                            while (true) {
                                                block15: {
                                                    block14: {
                                                        block20: {
                                                            if (this.isOpen()) break block13;
                                                            break block20;
lbl16:
                                                            // 1 sources

                                                            while (true) {
                                                                if (var14_10.buffer != null) break block14;
                                                                break block15;
                                                                break;
                                                            }
                                                        }
                                                        ++var13_9;
                                                        break block16;
                                                    }
                                                    if (var14_10.status < 200) break block15;
                                                    break block17;
                                                    while (true) {
                                                        this.uses = 0;
                                                        this.close();
                                                        ** GOTO lbl63
                                                        break;
                                                    }
lbl29:
                                                    // 1 sources

                                                    while (true) {
                                                        WMSLoggerFactory.getLogger(null).info(Base64.subSequence((int)(217 / 68), (String)"NaaofKhiciEZ[@SkgqGsv||h5nx\u007f{Dhpfgq]") + this.getConextPath() + JSON.replace((String)"E#:|srz%", (int)(-11 - -35)) + var15_11 + JSON.replace((String)"g8(>#v", (int)(31 * 57)) + var1_1 + JSON.replace((String)"!qweqst2", (int)(50 + -17)) + var14_10.status + JSON.replace((String)"1q\u007fq{,", (int)(47 * 31)) + var14_10.contentLength + "=" + var4_3 + Base64.subSequence((int)(9 * 63), (String)"7jxt|yF") + var14_10.contentRangeFound + JSON.replace((String)"\bl", (int)(42 - -43)) + var14_10.contentRangeStart + "=" + var8_6 + "-" + var14_10.contentRangeStop + "=" + var10_7 + "\n" + var14_10.headerStr);
                                                        ** GOTO lbl10
                                                        break;
                                                    }
                                                }
lbl33:
                                                // 7 sources

                                                while (true) {
                                                    if (var14_10 == null) ** GOTO lbl10
                                                    break block18;
                                                    break;
                                                }
                                                break;
                                            }
lbl36:
                                            // 2 sources

                                            while (true) {
                                                var15_11 = true;
                                                var5_4 = new MediaCacheHTTPByteReaderResult();
                                                var5_4.buffer = var14_10.buffer;
                                                var5_4.contentLength = var14_10.contentLength;
                                                var5_4.headerLength = var14_10.headerLength;
                                                var5_4.status = var14_10.status;
                                                var5_4.tries = var13_9;
                                                var5_4.roffset = var16_12;
                                                var5_4.rlen = var18_13;
                                                var5_4.elapseTime = (System.nanoTime() - var6_5) / 1000000L;
                                                ** GOTO lbl33
                                                break;
                                            }
lbl48:
                                            // 1 sources

                                            while (true) {
                                                WMSLoggerFactory.getLogger(null).debug(Base64.subSequence((int)(87 + -78), (String)"kko^l`huBf|d/6") + var14_10.contentRangeStop + "/" + var10_7);
                                                ** GOTO lbl33
                                                break;
                                            }
                                        }
                                        var14_10 = this.sendRequest(var12_8, var4_3, false);
                                        var15_11 = false;
                                        ** while (var14_10 != null)
lbl55:
                                        // 1 sources

                                        ** GOTO lbl33
                                    }
                                    if (var14_10.status < 300) break block21;
                                    ** GOTO lbl33
                                }
lbl60:
                                // 2 sources

                                while (true) {
                                    ++this.uses;
                                    if (this.uses >= this.maxUsesBeforeReconnect) ** continue;
lbl63:
                                    // 2 sources

                                    return var5_4;
                                }
                            }
                            ** while (var13_9 >= this.maxRetries)
lbl66:
                            // 1 sources

                            break block22;
                            while (true) {
                                if (var14_10.contentRangeStop == var10_7) ** GOTO lbl36
                                ** continue;
                                break;
                            }
                        }
                        if (var14_10.contentLength == (long)var4_3) break block23;
                        ** GOTO lbl33
                    }
                    if (this.debugHTTPRequests) ** break;
                    ** while (true)
                    ** while (true)
lbl77:
                    // 1 sources

                    while (true) {
                        this.reconnect();
                        ** GOTO lbl13
                        break;
                    }
                }
                this.debugPrefix = Base64.subSequence((int)(-40 - 63), (String)"k\u007fzxYwmebvX") + var13_9 + Base64.subSequence((int)(33 * 13), (String)"P4/");
                if (!this.isOpen()) ** break;
                ** while (true)
                ** while (true)
lbl85:
                // 1 sources

                while (true) {
                    var16_12 = var14_10.contentRangeStart;
                    var18_13 = var14_10.contentRangeStop - var14_10.contentRangeStart + 1L;
                    if (var14_10.contentRangeStart == var8_6) ** continue;
                    break block19;
                    break;
                }
            }
            var16_12 = 0L;
            var18_13 = 0L;
            if (var14_10.contentRangeFound) ** break;
            ** while (true)
            ** while (true)
        }
        WMSLoggerFactory.getLogger(null).debug(JSON.replace((String)"aeaTffnoXxl|{*1", (int)(709 / 226)) + var14_10.contentRangeStart + "/" + var8_6);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dumpDebug() {
        if (this.debugInfo == null) {
            return;
        }
        Iterator<String> iterator = this.debugInfo.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            System.out.println(string);
        }
    }

    public SendResult sendRequest(byte[] byArray, boolean bl) {
        return this.sendRequest(byArray, 0, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SendResult sendRequest(byte[] byArray, int n, boolean bl) {
        SendResult sendResult;
        block12: {
            boolean bl2;
            int n2;
            if (this.socket == null) {
                return null;
            }
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                outputStream = this.socket.getOutputStream();
                inputStream = this.socket.getInputStream();
            }
            catch (Exception exception) {
                return null;
            }
            if (outputStream == null) return null;
            if (inputStream == null) {
                return null;
            }
            sendResult = new SendResult();
            sendResult.buffer = new byte[n + 4096];
            try {
                outputStream.write(byArray);
                n2 = 0;
                bl2 = true;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error(Base64.subSequence((int)(1098 / 195), (String)"HccahIjoekGDEBQmasE}x~~n3mznePfupct|R") + this.getConextPath() + JSON.replace((String)"X&", (int)(23 + 14)), (Throwable)exception);
                sendResult = null;
                break block12;
            }
            do {
                int n3;
                int n4;
                if ((n4 = sendResult.buffer.length - n2) <= 0) {
                    byte[] byArray2 = new byte[sendResult.buffer.length + 1024];
                    System.arraycopy(sendResult.buffer, 0, byArray2, 0, sendResult.buffer.length);
                    sendResult.buffer = byArray2;
                    n4 = sendResult.buffer.length - n2;
                }
                if ((n3 = inputStream.read(sendResult.buffer, n2, n4)) == -1) {
                    sendResult = null;
                    break;
                }
                n2 += n3;
                if (!sendResult.gotHeader) {
                    SendResult sendResult2 = sendResult;
                    this.parseHeader(sendResult2, sendResult2.buffer, 0, n2, bl);
                }
                if (!sendResult.gotHeader || !bl2) continue;
                bl2 = false;
                if (bl || sendResult.status < 200 || sendResult.status >= 300 || sendResult.contentLength <= (long)n) continue;
                if (this.logSocketWarning) {
                    WMSLoggerFactory.getLogger(null).warn(Base64.subSequence((int)(121 + 86), (String)"\u000255;2\u001745?=\u0011\u000e\u000f\f\u001f'+%\u0013'\"  4i;,$/\u001e(?:5\"&\b") + this.getConextPath() + JSON.replace((String)"M+2Zzcw{q}:SHIN?bxvf$wgiol*yi|{jce2P{{brvm7Wysyk({b", (int)(31 + 113)) + sendResult.contentLength + Base64.subSequence((int)(55 * 37), (String)"sju") + n);
                    this.logSocketWarning = false;
                }
                if (!this.closeConnectOnBadContentLength) continue;
                sendResult = null;
                break;
            } while (!sendResult.gotHeader || (long)n2 < sendResult.size() && !bl);
        }
        if (sendResult != null) {
            if (sendResult.keepAlive) return sendResult;
            this.close();
            return sendResult;
        }
        this.close();
        return sendResult;
    }

    public int getMaxUsesBeforeReconnect() {
        return this.maxUsesBeforeReconnect;
    }

    public void setMaxUsesBeforeReconnect(int n) {
        this.maxUsesBeforeReconnect = n;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public boolean isRequestFullURL() {
        return this.requestFullURL;
    }

    @Override
    public void setRequestFullURL(boolean bl) {
        this.requestFullURL = bl;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String string) {
        this.awsSecretAccessKey = string;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String string) {
        this.awsAccessKeyId = string;
    }

    class SendResult {
        public long contentLength = 0L;
        public long headerLength = 0L;
        public long contentRead = 0L;
        public Date lastModified = null;
        public int status = 500;
        public boolean gotHeader = false;
        public boolean gotMessage = false;
        public byte[] buffer = null;
        public boolean keepAlive = true;
        public boolean contentRangeFound = false;
        public long contentRangeStart = 0L;
        public long contentRangeStop = 0L;
        public String headerStr = "";

        SendResult() {
        }

        public long size() {
            return this.contentLength + this.headerLength;
        }
    }
}

