/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacache.model;

import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.JSON;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacache.model.IMediaCacheItem;
import com.wowza.wms.mediacache.model.IMediaCacheReader;
import com.wowza.wms.mediacache.model.IMediaCacheSource;
import com.wowza.wms.mediacache.model.MediaCache;
import com.wowza.wms.mediacache.model.MediaCachePerformanceCounter;
import com.wowza.wms.mediacache.model.MediaCacheReaderBase;
import java.io.File;
import java.io.RandomAccessFile;

public class MediaCacheReaderLocal
extends MediaCacheReaderBase
implements IMediaCacheReader {
    protected RandomAccessFile filePtr = null;
    protected File file = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open() {
        try {
            if (this.filePtr != null) {
                this.close();
            }
            IMediaCacheItem iMediaCacheItem = this.getMediaCacheItem();
            String string = iMediaCacheItem.getLocalPath();
            this.file = new File(string);
            if (!this.file.exists()) return;
            this.filePtr = new WowzaRandomAccessFile(this.file, "r");
            MediaCache.openFileCount.incrementAndGet();
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error(JSON.replace((String)"\u0006))'.\u001301;1\u000736<<(\u00173>?3.nrfj%", (int)(-49 - -28)), (Throwable)exception);
            this.file = null;
            this.filePtr = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            if (this.filePtr != null) {
                this.filePtr.close();
                MediaCache.openFileCount.decrementAndGet();
            }
            this.filePtr = null;
            this.file = null;
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error(JSON.replace((String)"\u00183318\u0019:?5;\r% &&6\t)$)%d( \"=*p", (int)(31 * 11)), (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long length() {
        if (this.file == null) {
            return 0L;
        }
        long l = this.file.length();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long lastModified() {
        if (this.file == null) {
            return 0L;
        }
        long l = this.file.lastModified();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.filePtr == null) {
            return n3;
        }
        IMediaCacheSource iMediaCacheSource = this.mediaCacheItem.getMediaCacheSource();
        MediaCache mediaCache = iMediaCacheSource.getMediaCache();
        MediaCachePerformanceCounter mediaCachePerformanceCounter = mediaCache.getPerformanceCount();
        MediaCachePerformanceCounter mediaCachePerformanceCounter2 = this.mediaCacheItem.getMediaCacheSource().getPerformanceCount();
        int n4 = 0;
        int n5 = n2;
        try {
            int n6;
            this.filePtr.seek(this.pos);
            while ((n6 = this.filePtr.read(byArray, n + n4, n5)) >= 0) {
                n4 += n6;
                if ((n5 -= n6) > 0) continue;
            }
        }
        catch (Exception exception) {}
        this.pos += (long)n4;
        n3 = n4;
        mediaCachePerformanceCounter.incReadCache(n3);
        mediaCachePerformanceCounter2.incReadCache(n3);
        return n3;
    }
}

