/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.WMSTimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSUtils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSCondition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSLock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class WMSCondVar
implements WMSCondition,
Serializable {
    protected final ExclusiveLock lock;

    WMSCondVar(ExclusiveLock exclusiveLock) {
        this.lock = exclusiveLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptibly() {
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        boolean bl = Thread.interrupted();
        try {
            WMSCondVar wMSCondVar = this;
            synchronized (wMSCondVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            WMSCondVar wMSCondVar = this;
            synchronized (wMSCondVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long l, WMSTimeUnit wMSTimeUnit) throws InterruptedException {
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long l2 = wMSTimeUnit.toNanos(l);
        boolean bl = false;
        try {
            WMSCondVar wMSCondVar = this;
            synchronized (wMSCondVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    if (l2 > 0L) {
                        long l3 = WMSUtils.nanoTime();
                        WMSTimeUnit.NANOSECONDS.timedWait(this, l2);
                        bl = WMSUtils.nanoTime() - l3 < l2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitUntil(Date date) throws InterruptedException {
        if (date == null) {
            throw new NullPointerException();
        }
        int n = this.lock.getHoldCount();
        if (n == 0) {
            throw new IllegalMonitorStateException();
        }
        long l = date.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean bl = false;
        try {
            WMSCondVar wMSCondVar = this;
            synchronized (wMSCondVar) {
                for (int i = n; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    long l2 = System.currentTimeMillis();
                    long l3 = l - l2;
                    if (l3 > 0L) {
                        this.wait(l3);
                        bl = System.currentTimeMillis() - l2 < l3;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            for (int i = n; i > 0; --i) {
                this.lock.lock();
            }
        }
        return bl;
    }

    @Override
    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    @Override
    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends WMSLock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

