/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.support.ByteBufferHexDumper;

public abstract class ByteBuffer
implements Comparable {
    private static ByteBufferAllocator allocator = new SimpleByteBufferAllocator();
    private static boolean useDirectBuffers = true;

    public static ByteBufferAllocator getAllocator() {
        return allocator;
    }

    public static void setAllocator(ByteBufferAllocator byteBufferAllocator) {
        if (byteBufferAllocator == null) {
            throw new NullPointerException("allocator");
        }
        ByteBufferAllocator byteBufferAllocator2 = allocator;
        allocator = byteBufferAllocator;
        if (null != byteBufferAllocator2) {
            byteBufferAllocator2.dispose();
        }
    }

    public static boolean isUseDirectBuffers() {
        return useDirectBuffers;
    }

    public static void setUseDirectBuffers(boolean bl) {
        useDirectBuffers = bl;
    }

    public static ByteBuffer allocate(int n) {
        if (useDirectBuffers) {
            try {
                return ByteBuffer.allocate(n, true);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return ByteBuffer.allocate(n, false);
    }

    public static ByteBuffer allocate(int n, boolean bl) {
        return allocator.allocate(n, bl);
    }

    public static ByteBuffer wrap(java.nio.ByteBuffer byteBuffer) {
        return allocator.wrap(byteBuffer);
    }

    public static ByteBuffer wrap(byte[] byArray) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byArray));
    }

    public static ByteBuffer wrap(byte[] byArray, int n, int n2) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byArray, n, n2));
    }

    protected ByteBuffer() {
    }

    public abstract void acquire();

    public abstract void release();

    public abstract java.nio.ByteBuffer buf();

    public abstract Object getExtra();

    public abstract void setExtra(Object var1);

    public abstract boolean isDirect();

    public abstract boolean isReadOnly();

    public abstract int capacity();

    public abstract ByteBuffer capacity(int var1);

    public abstract boolean isAutoExpand();

    public abstract ByteBuffer setAutoExpand(boolean var1);

    public ByteBuffer expand(int n) {
        return this.expand(this.position(), n);
    }

    public abstract ByteBuffer expand(int var1, int var2);

    public abstract boolean isPooled();

    public abstract void setPooled(boolean var1);

    public abstract int position();

    public abstract ByteBuffer position(int var1);

    public abstract int limit();

    public abstract ByteBuffer limit(int var1);

    public abstract ByteBuffer mark();

    public abstract int markValue();

    public abstract ByteBuffer reset();

    public abstract ByteBuffer clear();

    public ByteBuffer sweep() {
        this.clear();
        return this.fillAndReset(this.remaining());
    }

    public ByteBuffer sweep(byte by) {
        this.clear();
        return this.fillAndReset(by, this.remaining());
    }

    public abstract ByteBuffer flip();

    public abstract ByteBuffer rewind();

    public int remaining() {
        return this.limit() - this.position();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract byte get();

    public short getUnsigned() {
        return (short)(this.get() & 0xFF);
    }

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public short getUnsigned(int n) {
        return (short)(this.get(n) & 0xFF);
    }

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer get(byte[] var1, int var2, int var3);

    public ByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public abstract ByteBuffer put(java.nio.ByteBuffer var1);

    public ByteBuffer put(ByteBuffer byteBuffer) {
        return this.put(byteBuffer.buf());
    }

    public abstract ByteBuffer put(byte[] var1, int var2, int var3);

    public ByteBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public abstract ByteBuffer compact();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDirect()) {
            stringBuffer.append("DirectBuffer");
        } else {
            stringBuffer.append("HeapBuffer");
        }
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append(": ");
        stringBuffer.append(this.getHexDump());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        if (this.remaining() != byteBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = byteBuffer.limit() - 1;
        while (n2 >= n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = byteBuffer.get(n3))) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(Object object) {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        int n = this.position() + Math.min(this.remaining(), byteBuffer.remaining());
        int n2 = this.position();
        int n3 = byteBuffer.position();
        while (n2 < n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = byteBuffer.get(n3))) {
                if (by2 < by) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - byteBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract ByteBuffer order(ByteOrder var1);

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public int getUnsignedShort(int n) {
        return this.getShort(n) & 0xFFFF;
    }

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public long getUnsignedInt(int n) {
        return (long)this.getInt(n) & 0xFFFFFFFFL;
    }

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();

    public InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int available() {
                return ByteBuffer.this.remaining();
            }

            @Override
            public synchronized void mark(int n) {
                ByteBuffer.this.mark();
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public int read() {
                if (ByteBuffer.this.hasRemaining()) {
                    return ByteBuffer.this.get() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) {
                int n3 = ByteBuffer.this.remaining();
                if (n3 > 0) {
                    int n4 = Math.min(n3, n2);
                    ByteBuffer.this.get(byArray, n, n4);
                    return n4;
                }
                return -1;
            }

            @Override
            public synchronized void reset() {
                ByteBuffer.this.reset();
            }

            @Override
            public long skip(long l) {
                int n = l > Integer.MAX_VALUE ? ByteBuffer.this.remaining() : Math.min(ByteBuffer.this.remaining(), (int)l);
                ByteBuffer.this.skip(n);
                return n;
            }
        };
    }

    public OutputStream asOutputStream() {
        return new OutputStream(){

            @Override
            public void write(byte[] byArray, int n, int n2) {
                ByteBuffer.this.put(byArray, n, n2);
            }

            @Override
            public void write(int n) {
                ByteBuffer.this.put((byte)n);
            }
        };
    }

    public String getHexDump() {
        return ByteBufferHexDumper.getHexdump(this);
    }

    public String getString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        CoderResult coderResult;
        int n;
        if (!this.hasRemaining()) {
            return "";
        }
        boolean bl = charsetDecoder.charset().name().startsWith("UTF-16");
        int n2 = this.position();
        int n3 = this.limit();
        if (!bl) {
            while (this.hasRemaining() && this.get() != 0) {
            }
            n = this.position();
            if (n == n3 && this.get(n - 1) != 0) {
                this.limit(n);
            } else {
                this.limit(n - 1);
            }
        } else {
            while (this.remaining() >= 2 && (this.get() != 0 || this.get() != 0)) {
            }
            n = this.position();
            if (n == n3 || n == n3 - 1) {
                this.limit(n);
            } else {
                this.limit(n - 2);
            }
        }
        this.position(n2);
        if (!this.hasRemaining()) {
            this.limit(n3);
            this.position(n);
            return "";
        }
        charsetDecoder.reset();
        int n4 = (int)((float)this.remaining() * charsetDecoder.averageCharsPerByte()) + 1;
        CharBuffer charBuffer = CharBuffer.allocate(n4);
        while (!(coderResult = this.hasRemaining() ? charsetDecoder.decode(this.buf(), charBuffer, true) : charsetDecoder.flush(charBuffer)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(charBuffer.capacity() + n4);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        this.limit(n3);
        this.position(n);
        return charBuffer.flip().toString();
    }

    public String getString(int n, CharsetDecoder charsetDecoder) throws CharacterCodingException {
        CoderResult coderResult;
        int n2;
        int n3;
        ByteBuffer.checkFieldSize(n);
        if (n == 0) {
            return "";
        }
        if (!this.hasRemaining()) {
            return "";
        }
        boolean bl = charsetDecoder.charset().name().startsWith("UTF-16");
        if (bl && (n & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int n4 = this.position();
        int n5 = this.limit();
        if (n5 < (n3 = this.position() + n)) {
            throw new BufferUnderflowException();
        }
        if (!bl) {
            for (n2 = 0; n2 < n && this.get() != 0; ++n2) {
            }
            if (n2 == n) {
                this.limit(n3);
            } else {
                this.limit(this.position() - 1);
            }
        } else {
            for (n2 = 0; n2 < n && (this.get() != 0 || this.get() != 0); n2 += 2) {
            }
            if (n2 == n) {
                this.limit(n3);
            } else {
                this.limit(this.position() - 2);
            }
        }
        this.position(n4);
        if (!this.hasRemaining()) {
            this.limit(n5);
            this.position(n3);
            return "";
        }
        charsetDecoder.reset();
        int n6 = (int)((float)this.remaining() * charsetDecoder.averageCharsPerByte()) + 1;
        CharBuffer charBuffer = CharBuffer.allocate(n6);
        while (!(coderResult = this.hasRemaining() ? charsetDecoder.decode(this.buf(), charBuffer, true) : charsetDecoder.flush(charBuffer)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(charBuffer.capacity() + n6);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        this.limit(n5);
        this.position(n3);
        return charBuffer.flip().toString();
    }

    public ByteBuffer putString(CharSequence charSequence, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        CoderResult coderResult;
        if (charSequence.length() == 0) {
            return this;
        }
        CharBuffer charBuffer = CharBuffer.wrap(charSequence);
        charsetEncoder.reset();
        int n = 0;
        block4: while (!(coderResult = charBuffer.hasRemaining() ? charsetEncoder.encode(charBuffer, this.buf(), true) : charsetEncoder.flush(this.buf())).isUnderflow()) {
            if (coderResult.isOverflow()) {
                if (this.isAutoExpand()) {
                    switch (n) {
                        case 0: {
                            this.autoExpand((int)Math.ceil((float)charBuffer.remaining() * charsetEncoder.averageBytesPerChar()));
                            ++n;
                            continue block4;
                        }
                        case 1: {
                            this.autoExpand((int)Math.ceil((float)charBuffer.remaining() * charsetEncoder.maxBytesPerChar()));
                            ++n;
                            continue block4;
                        }
                    }
                    throw new RuntimeException("Expanded by " + (int)Math.ceil((float)charBuffer.remaining() * charsetEncoder.maxBytesPerChar()) + " but that wasn't enough for '" + charSequence + "'");
                }
            } else {
                n = 0;
            }
            coderResult.throwException();
        }
        return this;
    }

    public ByteBuffer putString(CharSequence charSequence, int n, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        CoderResult coderResult;
        int n2;
        ByteBuffer.checkFieldSize(n);
        if (n == 0) {
            return this;
        }
        this.autoExpand(n);
        boolean bl = charsetEncoder.charset().name().startsWith("UTF-16");
        if (bl && (n & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int n3 = this.limit();
        if (n3 < (n2 = this.position() + n)) {
            throw new BufferOverflowException();
        }
        if (charSequence.length() == 0) {
            if (!bl) {
                this.put((byte)0);
            } else {
                this.put((byte)0);
                this.put((byte)0);
            }
            this.position(n2);
            return this;
        }
        CharBuffer charBuffer = CharBuffer.wrap(charSequence);
        this.limit(n2);
        charsetEncoder.reset();
        while (!(coderResult = charBuffer.hasRemaining() ? charsetEncoder.encode(charBuffer, this.buf(), true) : charsetEncoder.flush(this.buf())).isUnderflow() && !coderResult.isOverflow()) {
            coderResult.throwException();
        }
        this.limit(n3);
        if (this.position() < n2) {
            if (!bl) {
                this.put((byte)0);
            } else {
                this.put((byte)0);
                this.put((byte)0);
            }
        }
        this.position(n2);
        return this;
    }

    public String getPrefixedString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.getPrefixedString(2, charsetDecoder);
    }

    public String getPrefixedString(int n, CharsetDecoder charsetDecoder) throws CharacterCodingException {
        CoderResult coderResult;
        int n2;
        if (!this.prefixedDataAvailable(n)) {
            throw new BufferUnderflowException();
        }
        int n3 = 0;
        switch (n) {
            case 1: {
                n3 = this.getUnsigned();
                break;
            }
            case 2: {
                n3 = this.getUnsignedShort();
                break;
            }
            case 4: {
                n3 = this.getInt();
            }
        }
        if (n3 == 0) {
            return "";
        }
        boolean bl = charsetDecoder.charset().name().startsWith("UTF-16");
        if (bl && (n3 & 1) != 0) {
            throw new BufferDataException("fieldSize is not even for a UTF-16 string.");
        }
        int n4 = this.limit();
        if (n4 < (n2 = this.position() + n3)) {
            throw new BufferUnderflowException();
        }
        this.limit(n2);
        charsetDecoder.reset();
        int n5 = (int)((float)this.remaining() * charsetDecoder.averageCharsPerByte()) + 1;
        CharBuffer charBuffer = CharBuffer.allocate(n5);
        while (!(coderResult = this.hasRemaining() ? charsetDecoder.decode(this.buf(), charBuffer, true) : charsetDecoder.flush(charBuffer)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(charBuffer.capacity() + n5);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        this.limit(n4);
        this.position(n2);
        return charBuffer.flip().toString();
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        return this.putPrefixedString(charSequence, 2, 0, charsetEncoder);
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        return this.putPrefixedString(charSequence, n, 0, charsetEncoder);
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, int n2, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        return this.putPrefixedString(charSequence, n, n2, (byte)0, charsetEncoder);
    }

    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, int n2, byte by, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        int n3;
        int n4;
        switch (n) {
            case 1: {
                n4 = 255;
                break;
            }
            case 2: {
                n4 = 65535;
                break;
            }
            case 4: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("prefixLength: " + n);
            }
        }
        if (charSequence.length() > n4) {
            throw new IllegalArgumentException("The specified string is too long.");
        }
        if (charSequence.length() == 0) {
            switch (n) {
                case 1: {
                    this.put((byte)0);
                    break;
                }
                case 2: {
                    this.putShort((short)0);
                    break;
                }
                case 4: {
                    this.putInt(0);
                }
            }
            return this;
        }
        switch (n2) {
            case 0: 
            case 1: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("padding: " + n2);
            }
        }
        CharBuffer charBuffer = CharBuffer.wrap(charSequence);
        int n5 = (int)((float)charBuffer.remaining() * charsetEncoder.averageBytesPerChar()) + 1;
        this.skip(n);
        int n6 = this.position();
        charsetEncoder.reset();
        while (true) {
            CoderResult coderResult = charBuffer.hasRemaining() ? charsetEncoder.encode(charBuffer, this.buf(), true) : charsetEncoder.flush(this.buf());
            if (this.position() - n6 > n4) {
                throw new IllegalArgumentException("The specified string is too long.");
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow() && this.isAutoExpand()) {
                this.autoExpand(n5);
                continue;
            }
            coderResult.throwException();
        }
        this.fill(by, n2 - (this.position() - n6 & n3));
        int n7 = this.position() - n6;
        switch (n) {
            case 1: {
                this.put(n6 - 1, (byte)n7);
                break;
            }
            case 2: {
                this.putShort(n6 - 2, (short)n7);
                break;
            }
            case 4: {
                this.putInt(n6 - 4, n7);
            }
        }
        return this;
    }

    public Object getObject() throws ClassNotFoundException {
        return this.getObject(Thread.currentThread().getContextClassLoader());
    }

    public Object getObject(final ClassLoader classLoader) throws ClassNotFoundException {
        if (!this.prefixedDataAvailable(4)) {
            throw new BufferUnderflowException();
        }
        int n = this.getInt();
        if (n <= 4) {
            throw new BufferDataException("Object length should be greater than 4: " + n);
        }
        int n2 = this.limit();
        this.limit(this.position() + n);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this.asInputStream()){

                @Override
                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    String string = this.readUTF();
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    return ObjectStreamClass.lookup(clazz);
                }
            };
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            throw new BufferDataException(iOException);
        }
        finally {
            this.limit(n2);
        }
    }

    public ByteBuffer putObject(Object object) {
        int n = this.position();
        this.skip(4);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.asOutputStream()){

                @Override
                protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
                    this.writeUTF(objectStreamClass.getName());
                }
            };
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new BufferDataException(iOException);
        }
        int n2 = this.position();
        this.position(n);
        this.putInt(n2 - n - 4);
        this.position(n2);
        return this;
    }

    public boolean prefixedDataAvailable(int n) {
        return this.prefixedDataAvailable(n, Integer.MAX_VALUE);
    }

    public boolean prefixedDataAvailable(int n, int n2) {
        int n3;
        if (this.remaining() < n) {
            return false;
        }
        switch (n) {
            case 1: {
                n3 = this.getUnsigned(this.position());
                break;
            }
            case 2: {
                n3 = this.getUnsignedShort(this.position());
                break;
            }
            case 4: {
                n3 = this.getInt(this.position());
                break;
            }
            default: {
                throw new IllegalArgumentException("prefixLength: " + n);
            }
        }
        if (n3 < 0 || n3 > n2) {
            throw new BufferDataException("dataLength: " + n3);
        }
        return this.remaining() - n >= n3;
    }

    public ByteBuffer skip(int n) {
        this.autoExpand(n);
        return this.position(this.position() + n);
    }

    public ByteBuffer fill(byte by, int n) {
        this.autoExpand(n);
        int n2 = n >>> 3;
        int n3 = n & 7;
        if (n2 > 0) {
            int s = by | by << 8 | by << 16 | by << 24;
            long l = s;
            l <<= 32;
            l |= (long)s;
            for (int i = n2; i > 0; --i) {
                this.putLong(l);
            }
        }
        n2 = n3 >>> 2;
        n3 &= 3;
        if (n2 > 0) {
            int n4 = by | by << 8 | by << 16 | by << 24;
            this.putInt(n4);
        }
        n2 = n3 >> 1;
        n3 &= 1;
        if (n2 > 0) {
            short s = (short)(by | by << 8);
            this.putShort(s);
        }
        if (n3 > 0) {
            this.put(by);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer fillAndReset(byte by, int n) {
        this.autoExpand(n);
        int n2 = this.position();
        try {
            this.fill(by, n);
        }
        finally {
            this.position(n2);
        }
        return this;
    }

    public ByteBuffer fill(int n) {
        this.autoExpand(n);
        int n2 = n >>> 3;
        int n3 = n & 7;
        for (int i = n2; i > 0; --i) {
            this.putLong(0L);
        }
        n2 = n3 >>> 2;
        n3 &= 3;
        if (n2 > 0) {
            this.putInt(0);
        }
        n2 = n3 >> 1;
        n3 &= 1;
        if (n2 > 0) {
            this.putShort((short)0);
        }
        if (n3 > 0) {
            this.put((byte)0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer fillAndReset(int n) {
        this.autoExpand(n);
        int n2 = this.position();
        try {
            this.fill(n);
        }
        finally {
            this.position(n2);
        }
        return this;
    }

    protected ByteBuffer autoExpand(int n) {
        if (this.isAutoExpand()) {
            this.expand(n);
        }
        return this;
    }

    protected ByteBuffer autoExpand(int n, int n2) {
        if (this.isAutoExpand()) {
            this.expand(n, n2);
        }
        return this;
    }

    private static void checkFieldSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("fieldSize cannot be negative: " + n);
        }
    }
}

