/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.common.ByteBuffer;

public class ByteBufferProxy
extends ByteBuffer {
    protected ByteBuffer buf;
    protected Object extra = null;

    protected ByteBufferProxy(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("buf");
        }
        this.buf = byteBuffer;
    }

    @Override
    public void acquire() {
        this.buf.acquire();
    }

    @Override
    public void release() {
        this.buf.release();
    }

    @Override
    public boolean isDirect() {
        return this.buf.isDirect();
    }

    @Override
    public java.nio.ByteBuffer buf() {
        return this.buf.buf();
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public Object getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(Object object) {
        this.extra = object;
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public ByteBuffer position(int n) {
        this.buf.position(n);
        return this;
    }

    @Override
    public int limit() {
        return this.buf.limit();
    }

    @Override
    public ByteBuffer limit(int n) {
        this.buf.limit(n);
        return this;
    }

    @Override
    public ByteBuffer mark() {
        this.buf.mark();
        return this;
    }

    @Override
    public ByteBuffer reset() {
        this.buf.reset();
        return this;
    }

    @Override
    public ByteBuffer clear() {
        this.buf.clear();
        return this;
    }

    @Override
    public ByteBuffer sweep() {
        this.buf.sweep();
        return this;
    }

    @Override
    public ByteBuffer sweep(byte by) {
        this.buf.sweep(by);
        return this;
    }

    @Override
    public ByteBuffer flip() {
        this.buf.flip();
        return this;
    }

    @Override
    public ByteBuffer rewind() {
        this.buf.rewind();
        return this;
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    @Override
    public byte get() {
        return this.buf.get();
    }

    @Override
    public short getUnsigned() {
        return this.buf.getUnsigned();
    }

    @Override
    public ByteBuffer put(byte by) {
        this.buf.put(by);
        return this;
    }

    @Override
    public byte get(int n) {
        return this.buf.get(n);
    }

    @Override
    public short getUnsigned(int n) {
        return this.buf.getUnsigned(n);
    }

    @Override
    public ByteBuffer put(int n, byte by) {
        this.buf.put(n, by);
        return this;
    }

    @Override
    public ByteBuffer get(byte[] byArray, int n, int n2) {
        this.buf.get(byArray, n, n2);
        return this;
    }

    @Override
    public ByteBuffer get(byte[] byArray) {
        this.buf.get(byArray);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer byteBuffer) {
        this.buf.put(byteBuffer);
        return this;
    }

    @Override
    public ByteBuffer put(java.nio.ByteBuffer byteBuffer) {
        this.buf.put(byteBuffer);
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray, int n, int n2) {
        this.buf.put(byArray, n, n2);
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray) {
        this.buf.put(byArray);
        return this;
    }

    @Override
    public ByteBuffer compact() {
        this.buf.compact();
        return this;
    }

    @Override
    public String toString() {
        return this.buf.toString();
    }

    @Override
    public int hashCode() {
        return this.buf.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.buf.equals(object);
    }

    @Override
    public int compareTo(Object object) {
        return this.buf.compareTo(object);
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public ByteBuffer order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
        return this;
    }

    @Override
    public char getChar() {
        return this.buf.getChar();
    }

    @Override
    public ByteBuffer putChar(char c) {
        this.buf.putChar(c);
        return this;
    }

    @Override
    public char getChar(int n) {
        return this.buf.getChar(n);
    }

    @Override
    public ByteBuffer putChar(int n, char c) {
        this.buf.putChar(n, c);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        return this.buf.asCharBuffer();
    }

    @Override
    public short getShort() {
        return this.buf.getShort();
    }

    @Override
    public int getUnsignedShort() {
        return this.buf.getUnsignedShort();
    }

    @Override
    public ByteBuffer putShort(short s) {
        this.buf.putShort(s);
        return this;
    }

    @Override
    public short getShort(int n) {
        return this.buf.getShort(n);
    }

    @Override
    public int getUnsignedShort(int n) {
        return this.buf.getUnsignedShort(n);
    }

    @Override
    public ByteBuffer putShort(int n, short s) {
        this.buf.putShort(n, s);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return this.buf.asShortBuffer();
    }

    @Override
    public int getInt() {
        return this.buf.getInt();
    }

    @Override
    public long getUnsignedInt() {
        return this.buf.getUnsignedInt();
    }

    @Override
    public ByteBuffer putInt(int n) {
        this.buf.putInt(n);
        return this;
    }

    @Override
    public int getInt(int n) {
        return this.buf.getInt(n);
    }

    @Override
    public long getUnsignedInt(int n) {
        return this.buf.getUnsignedInt(n);
    }

    @Override
    public ByteBuffer putInt(int n, int n2) {
        this.buf.putInt(n, n2);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        return this.buf.asIntBuffer();
    }

    @Override
    public long getLong() {
        return this.buf.getLong();
    }

    @Override
    public ByteBuffer putLong(long l) {
        this.buf.putLong(l);
        return this;
    }

    @Override
    public long getLong(int n) {
        return this.buf.getLong(n);
    }

    @Override
    public ByteBuffer putLong(int n, long l) {
        this.buf.putLong(n, l);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        return this.buf.asLongBuffer();
    }

    @Override
    public float getFloat() {
        return this.buf.getFloat();
    }

    @Override
    public ByteBuffer putFloat(float f) {
        this.buf.putFloat(f);
        return this;
    }

    @Override
    public float getFloat(int n) {
        return this.buf.getFloat(n);
    }

    @Override
    public ByteBuffer putFloat(int n, float f) {
        this.buf.putFloat(n, f);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return this.buf.asFloatBuffer();
    }

    @Override
    public double getDouble() {
        return this.buf.getDouble();
    }

    @Override
    public ByteBuffer putDouble(double d) {
        this.buf.putDouble(d);
        return this;
    }

    @Override
    public double getDouble(int n) {
        return this.buf.getDouble(n);
    }

    @Override
    public ByteBuffer putDouble(int n, double d) {
        this.buf.putDouble(n, d);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        return this.buf.asDoubleBuffer();
    }

    @Override
    public String getHexDump() {
        return this.buf.getHexDump();
    }

    @Override
    public String getString(int n, CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getString(n, charsetDecoder);
    }

    @Override
    public String getString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getString(charsetDecoder);
    }

    @Override
    public String getPrefixedString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getPrefixedString(charsetDecoder);
    }

    @Override
    public String getPrefixedString(int n, CharsetDecoder charsetDecoder) throws CharacterCodingException {
        return this.buf.getPrefixedString(n, charsetDecoder);
    }

    @Override
    public ByteBuffer putString(CharSequence charSequence, int n, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putString(charSequence, n, charsetEncoder);
        return this;
    }

    @Override
    public ByteBuffer putString(CharSequence charSequence, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putString(charSequence, charsetEncoder);
        return this;
    }

    @Override
    public ByteBuffer putPrefixedString(CharSequence charSequence, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, charsetEncoder);
        return this;
    }

    @Override
    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, n, charsetEncoder);
        return this;
    }

    @Override
    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, int n2, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, n, n2, charsetEncoder);
        return this;
    }

    @Override
    public ByteBuffer putPrefixedString(CharSequence charSequence, int n, int n2, byte by, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        this.buf.putPrefixedString(charSequence, n, n2, by, charsetEncoder);
        return this;
    }

    @Override
    public ByteBuffer skip(int n) {
        this.buf.skip(n);
        return this;
    }

    @Override
    public ByteBuffer fill(byte by, int n) {
        this.buf.fill(by, n);
        return this;
    }

    @Override
    public ByteBuffer fillAndReset(byte by, int n) {
        this.buf.fillAndReset(by, n);
        return this;
    }

    @Override
    public ByteBuffer fill(int n) {
        this.buf.fill(n);
        return this;
    }

    @Override
    public ByteBuffer fillAndReset(int n) {
        this.buf.fillAndReset(n);
        return this;
    }

    @Override
    public boolean isAutoExpand() {
        return this.buf.isAutoExpand();
    }

    @Override
    public ByteBuffer setAutoExpand(boolean bl) {
        this.buf.setAutoExpand(bl);
        return this;
    }

    @Override
    public ByteBuffer expand(int n, int n2) {
        this.buf.expand(n, n2);
        return this;
    }

    @Override
    public ByteBuffer expand(int n) {
        this.buf.expand(n);
        return this;
    }

    @Override
    public boolean isPooled() {
        return this.buf.isPooled();
    }

    @Override
    public void setPooled(boolean bl) {
        this.buf.setPooled(bl);
    }

    @Override
    public Object getObject() throws ClassNotFoundException {
        return this.buf.getObject();
    }

    @Override
    public Object getObject(ClassLoader classLoader) throws ClassNotFoundException {
        return this.buf.getObject(classLoader);
    }

    @Override
    public ByteBuffer putObject(Object object) {
        this.buf.putObject(object);
        return this;
    }

    @Override
    public InputStream asInputStream() {
        return this.buf.asInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return this.buf.asOutputStream();
    }

    @Override
    public ByteBuffer duplicate() {
        return this.buf.duplicate();
    }

    @Override
    public ByteBuffer slice() {
        return this.buf.slice();
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return this.buf.asReadOnlyBuffer();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    @Override
    public ByteBuffer capacity(int n) {
        this.buf.capacity(n);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    @Override
    public int markValue() {
        return this.buf.markValue();
    }
}

