/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.mina.common.ByteBuffer;

public abstract class BaseByteBuffer
extends ByteBuffer {
    private boolean autoExpand;
    private int mark = -1;

    protected BaseByteBuffer() {
    }

    @Override
    public boolean isDirect() {
        return this.buf().isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.buf().isReadOnly();
    }

    @Override
    public int capacity() {
        return this.buf().capacity();
    }

    @Override
    public ByteBuffer capacity(int n) {
        if (n > this.capacity()) {
            int n2 = this.position();
            int n3 = this.limit();
            ByteOrder byteOrder = this.order();
            this.capacity0(n);
            this.buf().limit(n3);
            if (this.mark >= 0) {
                this.buf().position(this.mark);
                this.buf().mark();
            }
            this.buf().position(n2);
            this.buf().order(byteOrder);
        }
        return this;
    }

    protected abstract void capacity0(int var1);

    @Override
    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    @Override
    public ByteBuffer setAutoExpand(boolean bl) {
        this.autoExpand = bl;
        return this;
    }

    @Override
    public ByteBuffer expand(int n, int n2) {
        int n3 = n + n2;
        if (n3 > this.capacity()) {
            this.capacity(n3);
        }
        if (n3 > this.limit()) {
            this.buf().limit(n3);
        }
        return this;
    }

    @Override
    public int position() {
        return this.buf().position();
    }

    @Override
    public ByteBuffer position(int n) {
        this.autoExpand(n, 0);
        this.buf().position(n);
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.buf().limit();
    }

    @Override
    public ByteBuffer limit(int n) {
        this.autoExpand(n, 0);
        this.buf().limit(n);
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public ByteBuffer mark() {
        this.buf().mark();
        this.mark = this.position();
        return this;
    }

    @Override
    public int markValue() {
        return this.mark;
    }

    @Override
    public ByteBuffer reset() {
        this.buf().reset();
        return this;
    }

    @Override
    public ByteBuffer clear() {
        this.buf().clear();
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer flip() {
        this.buf().flip();
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer rewind() {
        this.buf().rewind();
        this.mark = -1;
        return this;
    }

    @Override
    public byte get() {
        return this.buf().get();
    }

    @Override
    public ByteBuffer put(byte by) {
        this.autoExpand(1);
        this.buf().put(by);
        return this;
    }

    @Override
    public byte get(int n) {
        return this.buf().get(n);
    }

    @Override
    public ByteBuffer put(int n, byte by) {
        this.autoExpand(n, 1);
        this.buf().put(n, by);
        return this;
    }

    @Override
    public ByteBuffer get(byte[] byArray, int n, int n2) {
        this.buf().get(byArray, n, n2);
        return this;
    }

    @Override
    public ByteBuffer put(java.nio.ByteBuffer byteBuffer) {
        this.autoExpand(byteBuffer.remaining());
        this.buf().put(byteBuffer);
        return this;
    }

    @Override
    public ByteBuffer put(byte[] byArray, int n, int n2) {
        this.autoExpand(n2);
        this.buf().put(byArray, n, n2);
        return this;
    }

    @Override
    public ByteBuffer compact() {
        this.buf().compact();
        this.mark = -1;
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.buf().order();
    }

    @Override
    public ByteBuffer order(ByteOrder byteOrder) {
        this.buf().order(byteOrder);
        return this;
    }

    @Override
    public char getChar() {
        return this.buf().getChar();
    }

    @Override
    public ByteBuffer putChar(char c) {
        this.autoExpand(2);
        this.buf().putChar(c);
        return this;
    }

    @Override
    public char getChar(int n) {
        return this.buf().getChar(n);
    }

    @Override
    public ByteBuffer putChar(int n, char c) {
        this.autoExpand(n, 2);
        this.buf().putChar(n, c);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        return this.buf().asCharBuffer();
    }

    @Override
    public short getShort() {
        return this.buf().getShort();
    }

    @Override
    public ByteBuffer putShort(short s) {
        this.autoExpand(2);
        this.buf().putShort(s);
        return this;
    }

    @Override
    public short getShort(int n) {
        return this.buf().getShort(n);
    }

    @Override
    public ByteBuffer putShort(int n, short s) {
        this.autoExpand(n, 2);
        this.buf().putShort(n, s);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return this.buf().asShortBuffer();
    }

    @Override
    public int getInt() {
        return this.buf().getInt();
    }

    @Override
    public ByteBuffer putInt(int n) {
        this.autoExpand(4);
        this.buf().putInt(n);
        return this;
    }

    @Override
    public int getInt(int n) {
        return this.buf().getInt(n);
    }

    @Override
    public ByteBuffer putInt(int n, int n2) {
        this.autoExpand(n, 4);
        this.buf().putInt(n, n2);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        return this.buf().asIntBuffer();
    }

    @Override
    public long getLong() {
        return this.buf().getLong();
    }

    @Override
    public ByteBuffer putLong(long l) {
        this.autoExpand(8);
        this.buf().putLong(l);
        return this;
    }

    @Override
    public long getLong(int n) {
        return this.buf().getLong(n);
    }

    @Override
    public ByteBuffer putLong(int n, long l) {
        this.autoExpand(n, 8);
        this.buf().putLong(n, l);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        return this.buf().asLongBuffer();
    }

    @Override
    public float getFloat() {
        return this.buf().getFloat();
    }

    @Override
    public ByteBuffer putFloat(float f) {
        this.autoExpand(4);
        this.buf().putFloat(f);
        return this;
    }

    @Override
    public float getFloat(int n) {
        return this.buf().getFloat(n);
    }

    @Override
    public ByteBuffer putFloat(int n, float f) {
        this.autoExpand(n, 4);
        this.buf().putFloat(n, f);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return this.buf().asFloatBuffer();
    }

    @Override
    public double getDouble() {
        return this.buf().getDouble();
    }

    @Override
    public ByteBuffer putDouble(double d) {
        this.autoExpand(8);
        this.buf().putDouble(d);
        return this;
    }

    @Override
    public double getDouble(int n) {
        return this.buf().getDouble(n);
    }

    @Override
    public ByteBuffer putDouble(int n, double d) {
        this.autoExpand(n, 8);
        this.buf().putDouble(n, d);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        return this.buf().asDoubleBuffer();
    }
}

