/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.multiton;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.multiton.SingleSessionIoHandler;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerFactory;

public class SingleSessionIoHandlerDelegate
implements IoHandler {
    public static final String HANDLER = SingleSessionIoHandlerDelegate.class.getName() + ".handler";
    private final SingleSessionIoHandlerFactory factory;

    public SingleSessionIoHandlerDelegate(SingleSessionIoHandlerFactory singleSessionIoHandlerFactory) {
        if (singleSessionIoHandlerFactory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = singleSessionIoHandlerFactory;
    }

    @Override
    public void sessionCreated(IoSession ioSession) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = this.factory.getHandler(ioSession);
        ioSession.setAttribute(HANDLER, singleSessionIoHandler);
        singleSessionIoHandler.sessionCreated();
    }

    @Override
    public void sessionOpened(IoSession ioSession) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.sessionOpened();
    }

    @Override
    public void sessionClosed(IoSession ioSession) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.sessionClosed();
    }

    @Override
    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.sessionIdle(idleStatus);
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.exceptionCaught(throwable);
    }

    @Override
    public void messageReceived(IoSession ioSession, Object object) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.messageReceived(object);
    }

    @Override
    public void messageSent(IoSession ioSession, Object object) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.messageSent(object);
    }
}

