/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import com.wowza.wms.logging.WMSLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.mina.util.Queue;

public class SocketAcceptor
extends BaseIoAcceptor {
    private static volatile int nextId = 0;
    private final Executor executor;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketAcceptor-" + this.id;
    private SocketAcceptorConfig defaultConfig = new SocketAcceptorConfig();
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private WMSLogger log = null;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;

    public SocketAcceptor() {
        this(1, new NewThreadExecutor());
    }

    public SocketAcceptor(int n) {
        this(n, new NewThreadExecutor());
    }

    public SocketAcceptor(int n, Executor executor) {
        if (n < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.executor = executor;
        this.processorCount = n;
        this.ioProcessors = new SocketIoProcessor[n];
        if (this.log != null) {
            this.log.info("SocketAcceptor: " + n);
        }
        for (int i = 0; i < n; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketAcceptorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) throws IOException {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + socketAddress.getClass());
        }
        if (((InetSocketAddress)socketAddress).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        RegistrationRequest registrationRequest = new RegistrationRequest(socketAddress, ioHandler, ioServiceConfig);
        Object object = this.registerQueue;
        synchronized (object) {
            this.registerQueue.push(registrationRequest);
        }
        this.startupWorker();
        this.selector.wakeup();
        object = registrationRequest;
        synchronized (object) {
            while (!registrationRequest.done) {
                try {
                    registrationRequest.wait();
                }
                catch (InterruptedException interruptedException) {
                    ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                }
            }
        }
        if (registrationRequest.exception != null) {
            throw registrationRequest.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startupWorker() throws IOException {
        if (this.log != null) {
            this.log.info("SocketAcceptor.startupWorker: startupWorker");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest cancellationRequest = new CancellationRequest(socketAddress);
        try {
            this.startupWorker();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Address not bound: " + socketAddress);
        }
        Object object = this.cancelQueue;
        synchronized (object) {
            this.cancelQueue.push(cancellationRequest);
        }
        this.selector.wakeup();
        object = cancellationRequest;
        synchronized (object) {
            while (!cancellationRequest.done) {
                try {
                    cancellationRequest.wait();
                }
                catch (InterruptedException interruptedException) {
                    ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                }
            }
        }
        if (cancellationRequest.exception != null) {
            cancellationRequest.exception.fillInStackTrace();
            throw cancellationRequest.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest cancellationRequest = new CancellationRequest(socketAddress);
        cancellationRequest.isSuspend = true;
        try {
            this.startupWorker();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Address not bound: " + socketAddress);
        }
        Object object = this.cancelQueue;
        synchronized (object) {
            this.cancelQueue.push(cancellationRequest);
        }
        this.selector.wakeup();
        object = cancellationRequest;
        synchronized (object) {
            while (!cancellationRequest.done) {
                try {
                    cancellationRequest.wait();
                }
                catch (InterruptedException interruptedException) {
                    ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                }
            }
        }
        if (cancellationRequest.exception != null) {
            cancellationRequest.exception.fillInStackTrace();
            throw cancellationRequest.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        ArrayList arrayList;
        Object object = this.channels;
        synchronized (object) {
            arrayList = new ArrayList(this.channels.keySet());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.unbind((SocketAddress)object.next());
        }
    }

    private SocketIoProcessor nextProcessor() {
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketAcceptorConfig socketAcceptorConfig) {
        if (socketAcceptorConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = socketAcceptorConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            Object object;
            RegistrationRequest registrationRequest;
            Object object2 = this.registerQueue;
            synchronized (object2) {
                registrationRequest = (RegistrationRequest)this.registerQueue.pop();
            }
            if (registrationRequest == null) return;
            object2 = null;
            try {
                object2 = ServerSocketChannel.open();
                ((AbstractSelectableChannel)object2).configureBlocking(false);
                object = registrationRequest.config instanceof SocketAcceptorConfig ? (SocketAcceptorConfig)registrationRequest.config : (SocketAcceptorConfig)this.getDefaultConfig();
                ((ServerSocketChannel)object2).socket().setReuseAddress(((SocketAcceptorConfig)object).isReuseAddress());
                int n = ((SocketSessionConfig)((SocketAcceptorConfig)object).getSessionConfig()).getReceiveBufferSize();
                if (n > 0) {
                    ((ServerSocketChannel)object2).socket().setReceiveBufferSize(n);
                }
                ((ServerSocketChannel)object2).socket().bind(registrationRequest.address, ((SocketAcceptorConfig)object).getBacklog());
                ((AbstractSelectableChannel)object2).register(this.selector, 16, registrationRequest);
                Map map = this.channels;
                synchronized (map) {
                    this.channels.put(registrationRequest.address, object2);
                }
                this.getListeners().fireServiceActivated(this, registrationRequest.address, registrationRequest.handler, registrationRequest.config);
                continue;
            }
            catch (IOException iOException) {
                registrationRequest.exception = iOException;
                continue;
            }
            finally {
                object = registrationRequest;
                synchronized (object) {
                    registrationRequest.done = true;
                    registrationRequest.notifyAll();
                }
                if (object2 == null || registrationRequest.exception == null) continue;
                try {
                    ((AbstractInterruptibleChannel)object2).close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            CancellationRequest cancellationRequest;
            Object object = this.cancelQueue;
            synchronized (object) {
                cancellationRequest = (CancellationRequest)this.cancelQueue.pop();
            }
            if (cancellationRequest == null) return;
            Object object2 = this.channels;
            synchronized (object2) {
                object = (ServerSocketChannel)this.channels.remove(cancellationRequest.address);
            }
            try {
                if (object == null) {
                    cancellationRequest.exception = new IllegalArgumentException("Address not bound: " + cancellationRequest.address);
                    continue;
                }
                object2 = ((AbstractSelectableChannel)object).keyFor(this.selector);
                cancellationRequest.registrationRequest = (RegistrationRequest)((SelectionKey)object2).attachment();
                ((SelectionKey)object2).cancel();
                this.selector.wakeup();
                ((AbstractInterruptibleChannel)object).close();
                continue;
            }
            catch (IOException iOException) {
                ExceptionMonitor.getInstance().exceptionCaught(iOException);
                continue;
            }
            finally {
                object2 = cancellationRequest;
                synchronized (object2) {
                    cancellationRequest.done = true;
                    cancellationRequest.notifyAll();
                }
                if (cancellationRequest.isSuspend || cancellationRequest.exception != null) continue;
                this.getListeners().fireServiceDeactivated(this, cancellationRequest.address, cancellationRequest.registrationRequest.handler, cancellationRequest.registrationRequest.config);
                continue;
            }
            break;
        }
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RegistrationRequest registrationRequest;
        private RuntimeException exception;
        private boolean isSuspend = false;

        private CancellationRequest(SocketAddress socketAddress) {
            this.address = socketAddress;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private IOException exception;
        private boolean done;

        private RegistrationRequest(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
            this.address = socketAddress;
            this.handler = ioHandler;
            this.config = ioServiceConfig;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = Thread.currentThread().getPriority();
            Thread.currentThread().setName(SocketAcceptor.this.threadName);
            Thread.currentThread().setPriority(10);
            while (true) {
                try {
                    do {
                        int n2 = SocketAcceptor.this.selector.select();
                        if (SocketAcceptor.this.log != null) {
                            SocketAcceptor.this.log.info("SocketAcceptor.Worker.run: Worker: " + n2);
                        }
                        SocketAcceptor.this.registerNew();
                        SocketAcceptor.this.cancelKeys();
                        if (n2 <= 0) continue;
                        this.processSessions(SocketAcceptor.this.selector.selectedKeys());
                    } while (!SocketAcceptor.this.selector.keys().isEmpty());
                    Object object = SocketAcceptor.this.lock;
                    synchronized (object) {
                        if (SocketAcceptor.this.selector.keys().isEmpty() && SocketAcceptor.this.registerQueue.isEmpty() && SocketAcceptor.this.cancelQueue.isEmpty()) {
                            SocketAcceptor.this.worker = null;
                            try {
                                SocketAcceptor.this.selector.close();
                            }
                            catch (IOException iOException) {
                                ExceptionMonitor.getInstance().exceptionCaught(iOException);
                            }
                            finally {
                                SocketAcceptor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException iOException) {
                    if (SocketAcceptor.this.log != null) {
                        SocketAcceptor.this.log.info("SocketAcceptor.Worker.run: exception: " + iOException.toString());
                    }
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                    }
                    continue;
                }
                break;
            }
            Thread.currentThread().setPriority(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSessions(Set set) throws IOException {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ServerSocketChannel serverSocketChannel;
                SocketChannel socketChannel;
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                iterator.remove();
                if (!selectionKey.isAcceptable() || (socketChannel = (serverSocketChannel = (ServerSocketChannel)selectionKey.channel()).accept()) == null) continue;
                boolean bl = false;
                try {
                    if (SocketAcceptor.this.log != null) {
                        SocketAcceptor.this.log.info("SocketAcceptor.Worker.newSession");
                    }
                    RegistrationRequest registrationRequest = (RegistrationRequest)selectionKey.attachment();
                    if (SocketAcceptor.this.log != null) {
                        SocketAcceptor.this.log.info("SocketAcceptor.Worker.newSession: req.address: " + registrationRequest.address);
                    }
                    SocketSessionImpl socketSessionImpl = new SocketSessionImpl(SocketAcceptor.this, SocketAcceptor.this.nextProcessor(), SocketAcceptor.this.getListeners(), registrationRequest.config, socketChannel, registrationRequest.handler, registrationRequest.address);
                    SocketAcceptor.this.getFilterChainBuilder().buildFilterChain(socketSessionImpl.getFilterChain());
                    registrationRequest.config.getFilterChainBuilder().buildFilterChain(socketSessionImpl.getFilterChain());
                    registrationRequest.config.getThreadModel().buildFilterChain(socketSessionImpl.getFilterChain());
                    socketSessionImpl.getIoProcessor().addNew(socketSessionImpl);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (SocketAcceptor.this.log != null) {
                        SocketAcceptor.this.log.info("SocketAcceptor.Worker.newSession: processSessions: error" + throwable);
                    }
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                }
                finally {
                    if (SocketAcceptor.this.log != null) {
                        SocketAcceptor.this.log.info("SocketAcceptor.Worker.newSession: success: " + bl);
                    }
                    if (bl) continue;
                    socketChannel.close();
                }
            }
        }
    }
}

