/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import com.wowza.wms.logging.WMSLogger;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.WriteTimeoutException;
import org.apache.mina.transport.socket.nio.FastMinaMessage;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.Queue;

public class SocketIoProcessor {
    public static final int IDLEGENTIME = 500;
    private final Object lock = new Object();
    private final String threadName;
    private final Executor executor;
    private Selector selector;
    private final Queue newSessions = new Queue();
    private final Queue removingSessions = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue trafficControllingSessions = new Queue();
    private Worker worker;
    private long lastIdleCheckTime = System.currentTimeMillis();
    private WMSLogger log = null;

    SocketIoProcessor(String string, Executor executor) {
        this.threadName = string;
        this.executor = executor;
        if (this.log != null) {
            this.log.info("SocketIoProcessor.newInstance: " + this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNew(SocketSessionImpl socketSessionImpl) throws IOException {
        Queue queue = this.newSessions;
        synchronized (queue) {
            this.newSessions.push(socketSessionImpl);
        }
        if (this.log != null) {
            this.log.info("SocketIoProcessor.addNew: " + this.newSessions.size());
        }
        this.startupWorker();
    }

    void remove(SocketSessionImpl socketSessionImpl) throws IOException {
        this.scheduleRemove(socketSessionImpl);
        this.startupWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.log != null) {
                this.log.info("SocketIoProcessor.startupWorker: " + this.worker);
            }
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker));
            }
            this.selector.wakeup();
        }
    }

    void flush(SocketSessionImpl socketSessionImpl) {
        this.scheduleFlush(socketSessionImpl);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    void updateTrafficMask(SocketSessionImpl socketSessionImpl) {
        this.scheduleTrafficControl(socketSessionImpl);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRemove(SocketSessionImpl socketSessionImpl) {
        Queue queue = this.removingSessions;
        synchronized (queue) {
            this.removingSessions.push(socketSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(SocketSessionImpl socketSessionImpl) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(socketSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(SocketSessionImpl socketSessionImpl) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(socketSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddNew() {
        if (this.newSessions.isEmpty()) {
            return;
        }
        while (true) {
            boolean bl;
            SocketSessionImpl socketSessionImpl;
            Object object = this.newSessions;
            synchronized (object) {
                socketSessionImpl = (SocketSessionImpl)this.newSessions.pop();
            }
            if (socketSessionImpl == null) break;
            object = socketSessionImpl.getChannel();
            try {
                ((AbstractSelectableChannel)object).configureBlocking(false);
                socketSessionImpl.setSelectionKey(((AbstractSelectableChannel)object).register(this.selector, 1, socketSessionImpl));
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
                socketSessionImpl.getFilterChain().fireExceptionCaught(socketSessionImpl, iOException);
            }
            if (!bl) continue;
            socketSessionImpl.getServiceListeners().fireSessionCreated(socketSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doRemove() {
        if (this.removingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Object object = this.removingSessions;
            // MONITORENTER : object
            SocketSessionImpl socketSessionImpl = (SocketSessionImpl)this.removingSessions.pop();
            // MONITOREXIT : object
            if (socketSessionImpl == null) {
                return;
            }
            object = socketSessionImpl.getChannel();
            SelectionKey selectionKey = socketSessionImpl.getSelectionKey();
            if (selectionKey == null) {
                this.scheduleRemove(socketSessionImpl);
                return;
            }
            if (!selectionKey.isValid()) continue;
            try {
                selectionKey.cancel();
                ((AbstractInterruptibleChannel)object).close();
                continue;
            }
            catch (IOException iOException) {
                socketSessionImpl.getFilterChain().fireExceptionCaught(socketSessionImpl, iOException);
                continue;
            }
            finally {
                this.releaseWriteBuffers(socketSessionImpl);
                socketSessionImpl.getServiceListeners().fireSessionDestroyed(socketSessionImpl);
                continue;
            }
            break;
        }
    }

    private void process(Set set) {
        for (SelectionKey selectionKey : set) {
            SocketSessionImpl socketSessionImpl = (SocketSessionImpl)selectionKey.attachment();
            if (selectionKey.isReadable() && socketSessionImpl.getTrafficMask().isReadable()) {
                this.read(socketSessionImpl);
            }
            if (!selectionKey.isWritable() || !socketSessionImpl.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(socketSessionImpl);
        }
        set.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(SocketSessionImpl socketSessionImpl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(socketSessionImpl.getReadBufferSize(), false);
        SocketChannel socketChannel = socketSessionImpl.getChannel();
        try {
            int n;
            byteBuffer.clear();
            int n2 = 0;
            try {
                while ((n = socketChannel.read(byteBuffer.buf())) > 0) {
                    n2 += n;
                }
            }
            finally {
                byteBuffer.flip();
            }
            socketSessionImpl.increaseReadBytes(n2);
            if (n2 > 0) {
                socketSessionImpl.getFilterChain().fireMessageReceived(socketSessionImpl, byteBuffer);
                byteBuffer = null;
            }
            if (n < 0) {
                this.scheduleRemove(socketSessionImpl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                this.scheduleRemove(socketSessionImpl);
            }
            socketSessionImpl.getFilterChain().fireExceptionCaught(socketSessionImpl, throwable);
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.release();
            }
        }
    }

    private void notifyIdleness() {
    }

    private void notifyIdleness(SocketSessionImpl socketSessionImpl, long l) {
        this.notifyIdleness0(socketSessionImpl, l, socketSessionImpl.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(socketSessionImpl.getLastIoTime(), socketSessionImpl.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyWriteTimeout(socketSessionImpl, l, socketSessionImpl.getWriteTimeoutInMillis(), socketSessionImpl.getLastWriteTime());
    }

    private void notifyIdleness0(SocketSessionImpl socketSessionImpl, long l, long l2, IdleStatus idleStatus, long l3) {
        if (l2 > 0L && l3 != 0L && l - l3 >= l2 && socketSessionImpl.getInQueue() == 0) {
            socketSessionImpl.increaseIdleCount(idleStatus);
            socketSessionImpl.getFilterChain().fireSessionIdle(socketSessionImpl, idleStatus);
        }
    }

    private void notifyWriteTimeout(SocketSessionImpl socketSessionImpl, long l, long l2, long l3) {
        SelectionKey selectionKey = socketSessionImpl.getSelectionKey();
        if (l2 > 0L && l - l3 >= l2 && selectionKey != null && selectionKey.isValid() && (selectionKey.interestOps() & 4) != 0) {
            socketSessionImpl.getFilterChain().fireExceptionCaught(socketSessionImpl, new WriteTimeoutException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            SocketSessionImpl socketSessionImpl;
            Object object = this.flushingSessions;
            synchronized (object) {
                socketSessionImpl = (SocketSessionImpl)this.flushingSessions.pop();
            }
            if (socketSessionImpl == null) break;
            if (!socketSessionImpl.isConnected()) {
                this.releaseWriteBuffers(socketSessionImpl);
                continue;
            }
            object = socketSessionImpl.getSelectionKey();
            if (object == null) {
                this.scheduleFlush(socketSessionImpl);
                break;
            }
            if (!((SelectionKey)object).isValid()) continue;
            try {
                this.doFlush(socketSessionImpl);
            }
            catch (IOException iOException) {
                this.scheduleRemove(socketSessionImpl);
                socketSessionImpl.getFilterChain().fireExceptionCaught(socketSessionImpl, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWriteBuffers(SocketSessionImpl socketSessionImpl) {
        IoFilter.WriteRequest writeRequest;
        Queue queue = socketSessionImpl.getWriteRequestQueue();
        while ((writeRequest = (IoFilter.WriteRequest)queue.pop()) != null) {
            try {
                ((ByteBuffer)writeRequest.getMessage()).release();
            }
            catch (IllegalStateException illegalStateException) {
                socketSessionImpl.getFilterChain().fireExceptionCaught(socketSessionImpl, illegalStateException);
            }
            finally {
                writeRequest.getFuture().setWritten(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(SocketSessionImpl socketSessionImpl) throws IOException {
        SelectionKey selectionKey = socketSessionImpl.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        SocketChannel socketChannel = socketSessionImpl.getChannel();
        Queue queue = socketSessionImpl.getWriteRequestQueue();
        while (true) {
            IoFilter.WriteRequest writeRequest;
            Object object = queue;
            synchronized (object) {
                writeRequest = (IoFilter.WriteRequest)queue.first();
            }
            if (writeRequest == null) break;
            object = (ByteBuffer)writeRequest.getMessage();
            Object object2 = ((ByteBuffer)object).getExtra();
            if (object2 != null) {
                FastMinaMessage fastMinaMessage = (FastMinaMessage)object2;
                List list = fastMinaMessage.bufferList;
                int n = 0;
                while (list.size() > 0) {
                    object = (ByteBuffer)list.get(0);
                    int n2 = ((ByteBuffer)object).remaining();
                    if (n2 == 0) {
                        ((ByteBuffer)object).release();
                        list.remove(0);
                        continue;
                    }
                    int n3 = socketChannel.write(((ByteBuffer)object).buf());
                    if (n3 > 0) {
                        n += n3;
                        n2 -= n3;
                        fastMinaMessage.incSent(n3);
                    }
                    if (n2 > 0) break;
                    if (n2 > 0) continue;
                    ((ByteBuffer)object).release();
                    list.remove(0);
                }
                if (n > 0) {
                    socketSessionImpl.increaseWrittenBytes(n);
                    socketSessionImpl.notifyWriteWriteRequest(writeRequest, n);
                }
                if (list.size() == 0) {
                    Queue queue2 = queue;
                    synchronized (queue2) {
                        queue.pop();
                    }
                    socketSessionImpl.increaseWrittenWriteRequests();
                    socketSessionImpl.getFilterChain().fireMessageSent(socketSessionImpl, writeRequest);
                    socketSessionImpl.notifyCompleteWriteRequest(writeRequest);
                    continue;
                }
                selectionKey.interestOps(selectionKey.interestOps() | 4);
                break;
            }
            if (((ByteBuffer)object).remaining() == 0) {
                Queue queue3 = queue;
                synchronized (queue3) {
                    queue.pop();
                }
                socketSessionImpl.increaseWrittenWriteRequests();
                ((ByteBuffer)object).reset();
                socketSessionImpl.getFilterChain().fireMessageSent(socketSessionImpl, writeRequest);
                continue;
            }
            int n = socketChannel.write(((ByteBuffer)object).buf());
            if (n > 0) {
                socketSessionImpl.increaseWrittenBytes(n);
                socketSessionImpl.notifyWriteWriteRequest(writeRequest, n);
            }
            if (((ByteBuffer)object).hasRemaining()) {
                selectionKey.interestOps(selectionKey.interestOps() | 4);
                break;
            }
            socketSessionImpl.notifyCompleteWriteRequest(writeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue queue;
            SocketSessionImpl socketSessionImpl;
            Object object = this.trafficControllingSessions;
            synchronized (object) {
                socketSessionImpl = (SocketSessionImpl)this.trafficControllingSessions.pop();
            }
            if (socketSessionImpl == null) break;
            object = socketSessionImpl.getSelectionKey();
            if (object == null) {
                this.scheduleTrafficControl(socketSessionImpl);
                break;
            }
            if (!((SelectionKey)object).isValid()) continue;
            int n = 1;
            Queue queue2 = queue = socketSessionImpl.getWriteRequestQueue();
            synchronized (queue2) {
                if (!queue.isEmpty()) {
                    n |= 4;
                }
            }
            int n2 = socketSessionImpl.getTrafficMask().getInterestOps();
            ((SelectionKey)object).interestOps(n & n2);
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SocketIoProcessor.this.log != null) {
                SocketIoProcessor.this.log.info("SocketIoProcessor.Worker.run: " + SocketIoProcessor.this.threadName);
            }
            int n = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            Thread.currentThread().setName(SocketIoProcessor.this.threadName);
            while (true) {
                try {
                    do {
                        int n2 = SocketIoProcessor.this.selector.select(500L);
                        SocketIoProcessor.this.doAddNew();
                        SocketIoProcessor.this.doUpdateTrafficMask();
                        if (n2 > 0) {
                            SocketIoProcessor.this.process(SocketIoProcessor.this.selector.selectedKeys());
                        }
                        SocketIoProcessor.this.doFlush();
                        SocketIoProcessor.this.doRemove();
                        SocketIoProcessor.this.notifyIdleness();
                    } while (!SocketIoProcessor.this.selector.keys().isEmpty());
                    Object object = SocketIoProcessor.this.lock;
                    synchronized (object) {
                        if (SocketIoProcessor.this.selector.keys().isEmpty() && SocketIoProcessor.this.newSessions.isEmpty()) {
                            SocketIoProcessor.this.worker = null;
                            try {
                                SocketIoProcessor.this.selector.close();
                            }
                            catch (IOException iOException) {
                                ExceptionMonitor.getInstance().exceptionCaught(iOException);
                            }
                            finally {
                                SocketIoProcessor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                    }
                    continue;
                }
                break;
            }
            Thread.currentThread().setPriority(n);
        }
    }
}

