/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.flv;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.IRandomAccessWriter;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.flv.FLVStreamPosition;
import com.wowza.wms.mediareader.flv.MediaReaderFLVNodeData;
import com.wowza.wms.protocol.wowz.WOWZHeader;
import com.wowza.wms.protocol.wowz.WOWZSession;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaIndexItem;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaIndexCacheSingleton;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.MediaStreamIndex;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Level;

public class MediaReaderFLV
implements IMediaReader {
    protected static final int HEADER_TYPE = 0;
    protected static final int HEADER_SIZE = 1;
    protected static final int HEADER_TC = 2;
    protected static final int SEEK_KEYFRAMEMAX = 10000;
    protected IRandomAccessReader fileStream = null;
    protected ScheduledRandomAccessReaderWrapper fileReader = null;
    protected List metaData = null;
    protected int metaDataSize = 0;
    protected MediaReaderFLVNodeData nodeData = null;
    protected byte[] chunkHeaderBuffer = null;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean errorReported = false;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = Base64.subSequence((int)(-19 - -16), (String)";2)");
    protected String mediaReaderExt = JSON.replace((String)"$/2", (int)(102 + -36));
    protected MediaReaderItem mediaReaderItem = null;
    protected long saveLastVideoPos = 0L;
    protected long saveLastAudioPos = 0L;
    protected long saveLastBroadcastPos = 0L;
    protected int saveLastVideoSize = 0;
    protected int saveLastAudioSize = 0;
    protected int saveLastBroadcastSize = 0;
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = "";
    protected long duration = -1L;
    protected SortedMap<Long, Long> seekMap = new TreeMap<Long, Long>();
    protected SortedMap<Long, Long> keyframeMap = new TreeMap<Long, Long>();
    protected int seekBufferSize = 24576;
    protected long seekLargestFrame = 512000L;
    protected IRandomAccessWriter directWriter = null;
    protected long firstPacketLoc = 13L;
    protected byte firstPacketType = (byte)8;
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected String randomAccessReaderClass = JSON.replace((String)"gjk)\u007ff}qm#g`>U{aqvbEyw~tq\\}|erqQadbbz", (int)(413 / 102));
    protected IApplicationInstance appInstance = null;
    protected boolean bufferSeekIO = false;
    protected byte[] videoCodecConfig = null;
    protected byte[] audioCodecConfig = null;
    protected int seekKeyFrameSearchWindow = 10000;

    public MediaReaderFLV() {
        this.chunkHeaderBuffer = new byte[13];
        this.chunkHeaderValues = new int[5];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MediaReaderFLVNodeData getNodeData() {
        if (this.nodeData != null) {
            return this.nodeData;
        }
        this.nodeData = new MediaReaderFLVNodeData();
        return this.nodeData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderType = string.toLowerCase();
        this.mediaReaderExt = string;
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.fileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
        this.fileReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.fileStream, this.readAheadSize, this.readAheadTrigger);
        this.directWriter = this.fileReader;
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            block6: {
                block7: {
                    if (this.fileStream.isOpen()) {
                        this.close();
                    }
                    bl = false;
                    try {
                        this.fileStream.open();
                        this.fileReader.open();
                        this.errorReported = false;
                        this.saveLastVideoPos = 0L;
                        this.saveLastAudioPos = 0L;
                        this.saveLastBroadcastPos = 0L;
                        this.duration = -1L;
                        this.firstPacketLoc = 13L;
                        this.firstPacketType = (byte)8;
                        bl = true;
                        break block6;
                    }
                    catch (Exception exception) {
                        if (this.errorReported) break block7;
                    }
                    WMSLoggerFactory.getLogger(MediaReaderFLV.class).log(Level.WARN, Base64.subSequence((int)(1344 / 254), (String)"jvbf3*") + exception.toString(), null, Base64.subSequence((int)(1 + 81), (String)"!6&#3%"), "comment", 404, string2);
                }
                this.errorReported = true;
            }
            if (this.fileReader == null) return;
            MediaReaderFLV mediaReaderFLV = this;
            this.appInstance.notifyMediaReaderOpen((IMediaReader)mediaReaderFLV, mediaReaderFLV.stream);
            MediaReaderFLV mediaReaderFLV2 = this;
            boolean bl2 = mediaReaderFLV2.readMetadata((IRandomAccessReader)mediaReaderFLV2.fileReader);
            MediaReaderFLV mediaReaderFLV3 = this;
            mediaReaderFLV3.readCodecConfig((IRandomAccessReader)mediaReaderFLV3.fileReader);
            MediaReaderFLV mediaReaderFLV4 = this;
            this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)mediaReaderFLV4, mediaReaderFLV4.stream);
            if (!bl) return;
            if (bl2) return;
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).warn(Base64.subSequence((int)(146 / 40), (String)"NaaofZlkoi\u007fHCF?}cq{,7U|nzx|j~ `rsadtt(}e+nh.mqu(3") + (this.stream != null ? this.stream.getName() : JSON.replace((String)"rfbdd{c", (int)(83 + 84))));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() {
        Object object = this.lock;
        // MONITORENTER : object
        try {
            if (this.fileReader != null) {
                this.fileReader.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(31 * 3), (String)">203$b"), (Throwable)exception);
        }
        try {
            if (this.fileStream != null) {
                this.fileStream.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(49 * 35), (String)"pxzer8"), (Throwable)exception);
        }
        this.seekMap.clear();
        this.keyframeMap.clear();
        this.metaData = null;
        this.metaDataSize = 0;
        this.saveLastVideoPos = 0L;
        this.saveLastAudioPos = 0L;
        this.saveLastBroadcastPos = 0L;
        this.duration = -1L;
        this.firstPacketLoc = 13L;
        this.firstPacketType = (byte)8;
        // MONITOREXIT : object
        MediaReaderFLV mediaReaderFLV = this;
        this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderFLV, mediaReaderFLV.stream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.seekBufferSize = wMSProperties.getPropertyInt(JSON.replace((String)"ad\u007fYnifLzvwwaG|lr", (int)(17 * 55)), this.seekBufferSize);
        this.readAheadSize = wMSProperties.getPropertyInt(Base64.subSequence((int)(58 - -55), (String)"7>%\u0006073\u00191?:8\u000e7%e"), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(Base64.subSequence((int)(45 - -62), (String)"- ;\u001c*15\u0013;142\u0003*0=<9/"), this.readAheadTrigger);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(JSON.replace((String)"tffmefMnmjcb@vuqse[u{ho", (int)(1081 / 164)), this.randomAccessReaderClass);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(Base64.subSequence((int)(-14 + 78), (String)"\"4$%!7\u0015\"-\"\u0003\u0004"), this.bufferSeekIO);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(JSON.replace((String)"kbyRdtuqgEr}rST", (int)(127 + 46)), this.bufferSeekIO);
        this.seekKeyFrameSearchWindow = wMSProperties.getPropertyInt(JSON.replace((String)"-:%*\t&=\u00034&%,\u0019.-?-'\u00078<7;\"", (int)(110 + -16)), this.seekKeyFrameSearchWindow);
        if (!WMSLoggerFactory.getLogger(MediaReaderFLV.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug(Base64.subSequence((int)(8 + 31), (String)"Jmmcj^hokucT_B;p{nK\u007fzx\\vz!%\u0011*> |g") + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug(JSON.replace((String)"Kbl`kYiljjbW^E:szaJ|{\u007f]u{~dUpjcbcu2)", (int)(1567 / 229)) + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug(JSON.replace((String)"Buu{rFpws}k\\WJ3xs6\u0012'&/\u00073!.,8\u0018%7+up", (int)(87 + -40)) + this.seekBufferSize);
        WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug(JSON.replace((String)"\r$&*%\u0017#&,,8\r\u0000\u001b`=1?6<9\u001454=*)\t9<::2\u0002.\"76|g", (int)(61 + 3)) + this.randomAccessReaderClass);
        WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug(Base64.subSequence((int)(566 / 168), (String)"NaaofZlkoi\u007fHCF?pfrsseK|\u007fpUR$?") + this.bufferSeekIO);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    public boolean isOpen() {
        if (this.fileStream == null) {
            return false;
        }
        return this.fileStream.isOpen();
    }

    protected void indexFileExpand(MediaReaderFLVNodeData mediaReaderFLVNodeData, IRandomAccessReader iRandomAccessReader, long l) {
        this.indexFile(mediaReaderFLVNodeData, iRandomAccessReader, (int)(l / 1000L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void indexFile(MediaReaderFLVNodeData mediaReaderFLVNodeData, IRandomAccessReader iRandomAccessReader, int n) {
        MediaStreamIndex mediaStreamIndex = mediaReaderFLVNodeData.getMediaStreamIndex();
        if (mediaStreamIndex.isHitEnd()) {
            return;
        }
        if (n != -1) {
            if (mediaStreamIndex.getLength() > n) return;
        }
        try {
            int n2;
            if (n != -1) {
                n2 = n + 1;
                mediaStreamIndex.indexFileIncSize(n2);
            } else {
                n2 = mediaStreamIndex.getLength();
                mediaStreamIndex.indexFileIncSize(n2 += 500);
            }
            long l = 13L;
            int n3 = 0;
            if (mediaStreamIndex.getLength() > 0) {
                n3 = mediaStreamIndex.getLength() - 1;
                l = mediaStreamIndex.get(n3);
                ++n3;
            }
            iRandomAccessReader.seek(l);
            long l2 = iRandomAccessReader.length();
            byte[] byArray = new byte[8];
            boolean bl = false;
            long l3 = l;
            long l4 = 0L;
            while (true) {
                long l5 = l3;
                l3 = l;
                int n4 = iRandomAccessReader.read(byArray, 0, 7);
                if (n4 != 7) {
                    bl = true;
                    break;
                }
                l4 = l3;
                l += (long)n4;
                int n5 = byArray[0] & 0xFF;
                int n6 = byArray[1] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[2] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[3] & 0xFF;
                int n7 = byArray[4] & 0xFF;
                n7 <<= 8;
                n7 |= byArray[5] & 0xFF;
                n7 <<= 8;
                n7 |= byArray[6] & 0xFF;
                if (n6 > 0 && (n5 == 8 || n5 == 9)) {
                    while (n7 > n3 * 1000) {
                        mediaStreamIndex.indexFileSet(n3, l5);
                        ++n3;
                    }
                }
                if ((l += (long)(n6 + 8)) >= l2) {
                    bl = true;
                    break;
                }
                if (n != -1 && n3 > n) break;
                iRandomAccessReader.seek(l);
            }
            if (bl) {
                if (l4 > 0L) {
                    MediaStreamIndex mediaStreamIndex2 = mediaStreamIndex;
                    mediaStreamIndex2.indexFileSet(mediaStreamIndex2.getLength(), l4);
                }
                mediaStreamIndex.setHitEnd(true);
            }
            mediaStreamIndex.indexFileShrink();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendVideoTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, long l) {
        int n2 = 0;
        if (this.videoCodecConfig == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = this.videoCodecConfig.length;
        nArray[2] = n;
        nArray[0] = 9;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, this.videoCodecConfig);
        n2 += n4;
        lArray[2] = lArray[2] + (long)n4;
        lArray[3] = lArray[3] + 1L;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, long l) {
        int n2 = 0;
        if (this.audioCodecConfig == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = this.audioCodecConfig.length;
        nArray[2] = n;
        nArray[0] = 8;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, this.audioCodecConfig);
        n2 += n4;
        lArray[0] = lArray[0] + (long)n4;
        lArray[1] = lArray[1] + 1L;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readCodecConfig(IRandomAccessReader var1_1) {
        block29: {
            break block29;
lbl1:
            // 1 sources

            while (true) {
                var1_1.seek(var2_2);
                throw var11_3;
            }
lbl4:
            // 4 sources

            while (true) {
                var1_1.seek(var2_2);
                return;
            }
        }
        var2_2 = var1_1.getFilePointer();
        try {
            block30: {
                break block30;
lbl11:
                // 1 sources

                while (true) {
                    ++var5_6;
                    ** GOTO lbl83
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    if (var8_9[4] == 0) {
                        this.audioCodecConfig = new byte[var8_9[1]];
                        var1_1.read(this.audioCodecConfig, 0, this.audioCodecConfig.length);
                        var9_10 = true;
                    }
                    ** GOTO lbl59
                    break;
                }
            }
            var4_4 = 0;
            var5_6 = 0;
            var6_7 = 0;
            var7_8 = new byte[13];
            var8_9 = new int[5];
            this.videoCodecConfig = null;
            this.audioCodecConfig = null;
            block12: while (true) {
                block27: {
                    block28: {
                        block26: {
                            block31: {
                                block25: {
                                    var9_10 = false;
                                    this.readChunkHeader(var1_1, var7_8, var8_9);
                                    if (var8_9[0] == 127) ** GOTO lbl4
                                    if (var8_9[1] < 2) ** GOTO lbl59
                                    break block31;
lbl35:
                                    // 1 sources

                                    while (true) {
                                        var10_11 = FLVUtils.getAudioCodec((int)var8_9[3]);
                                        if (var10_11 != 10) ** GOTO lbl59
                                        break block25;
                                        break;
                                    }
lbl39:
                                    // 1 sources

                                    while (true) {
                                        ++var6_7;
                                        ** GOTO lbl83
                                        break;
                                    }
lbl42:
                                    // 1 sources

                                    while (true) {
                                        var10_11 = FLVUtils.getVideoCodec((int)var8_9[3]);
                                        if (var10_11 != 7) ** GOTO lbl59
                                        break block26;
                                        break;
                                    }
                                    while (true) {
                                        this.videoCodecConfig = new byte[var8_9[1]];
                                        var1_1.read(this.videoCodecConfig, 0, this.videoCodecConfig.length);
                                        var9_10 = true;
                                        ** GOTO lbl59
                                        break;
                                    }
lbl52:
                                    // 2 sources

                                    while (true) {
                                        if (var6_7 > 0) ** GOTO lbl4
                                        break block27;
                                        break;
                                    }
lbl55:
                                    // 1 sources

                                    while (true) {
                                        --var5_6;
                                        while (true) {
                                            if (var8_9[4] == 0) ** continue;
lbl59:
                                            // 8 sources

                                            while (true) {
                                                this.skipPacket(var8_9, var9_10, true, 1);
                                                if (var4_4 >= 10) ** GOTO lbl4
                                                break block28;
                                                break;
                                            }
                                            break;
                                        }
                                        break;
                                    }
lbl64:
                                    // 2 sources

                                    while (true) {
                                        if (var8_9[0] != 9) ** GOTO lbl59
                                        ** continue;
                                        break;
                                    }
                                }
                                if (var8_9[1] >= 2) ** break;
                                ** continue;
                                ** continue;
                            }
                            ++var4_4;
                            switch (var8_9[0]) {
                                case 9: {
                                    ** continue;
                                }
                                case 8: {
                                    ** continue;
                                }
                                default: {
                                    if (var8_9[0] != 8) ** continue;
                                }
                            }
lbl80:
                            // 1 sources

                            while (true) {
                                if (this.videoCodecConfig == null) continue block12;
                                ** GOTO lbl52
                                break;
                            }
lbl83:
                            // 2 sources

                            if (var8_9[0] != 8) ** GOTO lbl64
                            ** continue;
                        }
                        if (var8_9[4] == 1) ** continue;
                        ** continue;
                    }
                    if (var5_6 <= 0) ** break;
                    ** continue;
                    ** continue;
                }
                if (this.audioCodecConfig != null) break;
            }
            ** continue;
        }
        catch (Exception var4_5) {
            try {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(JSON.replace((String)"NaaofZlkoi\u007fHCF?`vuqUx||yXssxvg!", (int)(373 / 104)), (Throwable)var4_5);
                ** continue;
            }
            catch (Throwable var11_3) {
                ** continue;
            }
        }
lbl96:
        // 1 sources

        while (true) {
            var1_1.seek(var2_2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readMetadata(IRandomAccessReader var1_1) {
        block32: {
            block25: {
                block31: {
                    block24: {
                        block26: {
                            this.firstPacketLoc = 13L;
                            this.firstPacketType = (byte)8;
                            var2_2 = true;
                            if (var1_1 == null) return var2_2;
                            try {}
                            catch (Exception var3_3) {
                                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(JSON.replace((String)"Jmmcj^hokucT_B;dry}W~h|z~t`\"", (int)(19 * 61)), (Throwable)var3_3);
                                return var2_2;
                            }
                            var1_1.setDirecton(1);
                            var1_1.seek(13L);
                            this.metaData = null;
                            this.metaDataSize = 0;
                            var3_4 = new byte[13];
                            var4_5 = new int[5];
                            var5_6 = false;
                            var6_7 = false;
                            var7_8 = var1_1.getFilePointer();
                            this.readChunkHeader(var1_1, var3_4, var4_5);
                            if (var4_5[0] == 18 || var4_5[0] == 15) break block32;
                            var1_1.seek(var7_8);
                            var2_2 = false;
lbl23:
                            // 12 sources

                            while (true) {
                                if (var5_6) break block24;
                                var7_8 = var1_1.getFilePointer();
                                var9_11 = var1_1.length();
                                if (var9_11 <= 17L) break block25;
                                var1_1.seek(var9_11 - 4L);
                                var11_14 /* !! */  = new byte[4];
                                var1_1.read(var11_14 /* !! */ , 0, 4);
                                var12_16 = BufferUtils.byteArrayToInt((byte[])var11_14 /* !! */ , (int)0, (int)4);
                                if (var12_16 <= 0 || (long)var12_16 >= var9_11 - 13L) break block25;
                                var1_1.seek(var9_11 - (long)(var12_16 + 4));
                                var1_1.read(var11_14 /* !! */ , 0, 1);
                                var1_1.read(var11_14 /* !! */ , 0, 3);
                                var13_17 = BufferUtils.byteArrayToInt((byte[])var11_14 /* !! */ , (int)0, (int)3);
                                if (var13_17 + 11L == (long)var12_16) {
                                    var15_21 = var1_1.getFilePointer();
                                    var1_1.seek(var9_11 - (long)(var12_16 + 4));
                                    var17_22 = (int)var13_17 + 11 + 4;
                                    var18_24 = new byte[var17_22];
                                    var1_1.read(var18_24, 0, var17_22);
                                    var1_1.seek(var15_21);
                                    var1_1.read(var11_14 /* !! */ , 0, 3);
                                    var15_21 = BufferUtils.byteArrayToInt((byte[])var11_14 /* !! */ , (int)0, (int)3);
                                    this.duration = var15_21 & 0xFFFFFFFFL;
                                    var5_6 = true;
                                }
                                break block25;
                                {
                                    catch (Throwable var23_32) {
                                        var1_1.seek(var7_8);
                                        throw var23_32;
                                    }
                                    catch (Exception var9_12) {}
                                    {
                                        WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(-46 - -17), (String)"\u000e!!/&\u001a,+/)?\b\u0003\u0006\u007f 651\u001b2,8>:(<d\u007fgdvGqwgsafd+"), (Throwable)var9_12);
                                        break block26;
                                    }
                                }
                                break;
                            }
lbl61:
                            // 2 sources

                            while (true) {
                                this.metaData.add(ByteBuffer.wrap(var9_10));
                                this.metaDataSize += 11 + var4_5[1] + 4;
                                if (var5_6) ** GOTO lbl23
                                ** try [egrp 2[TRYBLOCK] [2 : 435->885)] { 
lbl67:
                                // 1 sources

                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        var1_1.seek(var7_8);
                        break block24;
lbl-1000:
                        // 1 sources

                        {
                            block27: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block33: {
                                                var10_25 = 0;
                                                if (var4_5[0] != 15 || var9_10.length <= 0) break block29;
                                                break block33;
lbl74:
                                                // 1 sources

                                                while (true) {
                                                    if (var18_23 >= var16_28) ** GOTO lbl23
                                                    var19_29 = Math.round(var15_20.getDouble(var18_23) * 1000.0);
                                                    var21_30 = var14_27.getLong(var18_23);
                                                    this.keyframeMap.put(new Long(var19_29), new Long(var21_30));
                                                    this.seekMap.put(new Long(var19_29), new Long(var21_30));
                                                    ++var18_23;
                                                    continue;
                                                    break;
                                                }
lbl84:
                                                // 1 sources

                                                while (true) {
                                                    var13_19 = var12_15.getDouble(Base64.subSequence((int)(56 + -54), (String)"fvvdrngg"));
                                                    this.duration = Math.round(var13_19 * 1000.0);
                                                    var5_6 = true;
                                                    break block27;
                                                    break;
                                                }
lbl89:
                                                // 1 sources

                                                while (true) {
                                                    if (!var13_18.containsKey(Base64.subSequence((int)(50 - -28), (String)":&=4!"))) ** GOTO lbl23
                                                    var14_27 = (AMFDataArray)var13_18.get(Base64.subSequence((int)(109 + 37), (String)"tzxpfxkpnrssm"));
                                                    var15_20 = (AMFDataArray)var13_18.get(Base64.subSequence((int)(92 + -84), (String)"|`gn\u007f"));
                                                    if (var14_27 == null) ** GOTO lbl23
                                                    break block28;
                                                    break;
                                                }
lbl95:
                                                // 1 sources

                                                while (true) {
                                                    var10_25 = 1;
                                                    break block29;
                                                    break;
                                                }
lbl98:
                                                // 1 sources

                                                while (true) {
                                                    var16_28 = var14_27.size();
                                                    if (var16_28 != (var17_22 = var15_20.size())) ** GOTO lbl23
                                                    break block30;
                                                    break;
                                                }
lbl102:
                                                // 1 sources

                                                while (true) {
                                                    if (!var13_18.containsKey(JSON.replace((String)"cokmyexeyg`~b", (int)(602 / 111)))) ** GOTO lbl23
                                                    ** continue;
                                                    break;
                                                }
lbl105:
                                                // 1 sources

                                                while (true) {
                                                    var12_15 = (AMFDataMixedArray)var11_14 /* !! */ .get(1);
                                                    if (var12_15.containsKey(JSON.replace((String)"asui}cdb", (int)(1020 / 197)))) {
                                                        ** continue;
                                                    }
                                                    break block27;
                                                    break;
                                                }
                                            }
                                            if (var9_10[0] == 0) {
                                                ** continue;
                                            }
                                            break block29;
                                        }
                                        if (var15_20 == null) ** GOTO lbl23
                                        ** continue;
                                        while (true) {
                                            var2_2 = false;
                                            ** GOTO lbl23
                                            break;
                                        }
                                    }
                                    if ((var11_14 /* !! */  = (byte[])new AMFDataList(var9_10, var10_25, var9_10.length - var10_25)).size() <= 1) ** continue;
                                    if (var11_14 /* !! */ .get(1).getType() != 8) ** GOTO lbl23
                                    ** continue;
                                }
                                var18_23 = 0;
                                ** continue;
                            }
                            if (!var12_15.containsKey(Base64.subSequence((int)(19 * 29), (String)"lmplym`k|")) || (var13_18 = (AMFDataObj)var12_15.get(JSON.replace((String)"ha|`uidox", (int)(404 / 109)))) == null) ** GOTO lbl23
                            ** continue;
                        }
                    }
lbl131:
                    // 2 sources

                    while (true) {
                        if (var6_7) {
                            var7_8 = var1_1.getFilePointer();
                            this.readChunkHeader(var1_1, var3_4, var4_5);
                            var1_1.seek(var7_8);
                            if (var4_5[0] == 127) return var2_2;
                            this.firstPacketLoc = var7_8;
                            this.firstPacketType = (byte)var4_5[0];
                            return var2_2;
                        }
                        break block31;
                        break;
                    }
lbl141:
                    // 1 sources

                    catch (Exception var10_26) {
                        WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(20 - -46), (String)"\u000f& ,'\u0015-(..>\u000b\u0002\u0019~#720\u00183#9=;/=g~8%5\u000666$2.''j"), (Throwable)var10_26);
                        ** continue;
                    }
                }
                if (var5_6 == false) return var2_2;
                var7_9 = new AMFDataList();
                var8_31 = new AMFDataMixedArray();
                var8_31.put(JSON.replace((String)"i{}qe{|z", (int)(86 + 87)), (AMFData)new AMFDataItem((double)this.duration / 1000.0));
                var7_9.add((AMFData)new AMFDataItem(JSON.replace((String)"%%\u0001(:.\u00140&2", (int)(-18 - 36))));
                var7_9.add((AMFData)var8_31);
                var9_13 = var7_9.serialize();
                if (var9_13 == null) return var2_2;
                if (this.metaData == null) {
                    this.metaData = new ArrayList<E>();
                }
                this.metaData.add(ByteBuffer.wrap(var9_13));
                return var2_2;
            }
            var1_1.seek(var7_8);
            ** while (true)
        }
        var6_7 = true;
        var9_10 = new byte[var4_5[1]];
        var1_1.read(var9_10, 0, var9_10.length);
        v0 = var1_1;
        v0.seek(v0.getFilePointer() + 4L);
        if (this.metaData != null) ** GOTO lbl61
        this.metaData = new ArrayList<E>();
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getMetadata() {
        Object object = this.lock;
        synchronized (object) {
            return this.metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rewind() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.fileReader == null) return;
                this.fileReader.seek(this.firstPacketLoc);
                this.fileReader.setDirecton(1);
                this.saveLastVideoPos = 0L;
                this.saveLastAudioPos = 0L;
                this.saveLastBroadcastPos = 0L;
                return;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(116 / 35), (String)"NaaofZlkoi\u007fHCF?`vc|xs\"9MVOMr~ymkppWcfllx1,\u007fkxy\u007fv3"), (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long readInt(IRandomAccessReader iRandomAccessReader) {
        long l = 0L;
        byte[] byArray = new byte[4];
        int n = iRandomAccessReader.read(byArray, 0, 4);
        if (n != 4) {
            return l;
        }
        l |= (long)(byArray[0] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[3] & 0xFF);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean skipPacket(int[] nArray, boolean bl, boolean bl2, int n) {
        boolean bl3 = true;
        try {
            int n2;
            if (n > 0) {
                n2 = 4;
                if (!bl) {
                    n2 += nArray[1];
                }
                if (!bl2) {
                    n2 += 11;
                }
            } else {
                int n3 = 4;
                if (bl) {
                    n3 += nArray[1];
                }
                if (bl2) {
                    n3 += 11;
                }
                ScheduledRandomAccessReaderWrapper scheduledRandomAccessReaderWrapper = this.fileReader;
                scheduledRandomAccessReaderWrapper.seek(scheduledRandomAccessReaderWrapper.getFilePointer() - (long)n3);
                MediaReaderFLV mediaReaderFLV = this;
                long l = mediaReaderFLV.readInt((IRandomAccessReader)mediaReaderFLV.fileReader);
                if (l <= 0L) return false;
                ScheduledRandomAccessReaderWrapper scheduledRandomAccessReaderWrapper2 = this.fileReader;
                scheduledRandomAccessReaderWrapper2.seek(scheduledRandomAccessReaderWrapper2.getFilePointer() - (l + 4L));
                return bl3;
            }
            ScheduledRandomAccessReaderWrapper scheduledRandomAccessReaderWrapper = this.fileReader;
            scheduledRandomAccessReaderWrapper.seek(scheduledRandomAccessReaderWrapper.getFilePointer() + (long)n2);
            return bl3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(45 * 49), (String)"P{{i`PfeacuNE\\%\u007ffg\u007f@pqxqa6"), (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readPacketHeader(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray) {
        try {
            int n = iRandomAccessReader.read(byArray, 0, 7);
            if (n < 7) {
                return false;
            }
        }
        catch (Exception exception) {
            return true;
        }
        {
            nArray[0] = byArray[0] & 0xFF;
            nArray[1] = byArray[1] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[2] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[3] & 0xFF;
            nArray[2] = byArray[7] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[4] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[5] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[6] & 0xFF;
            return true;
        }
    }

    protected PlaylistSeekResult seekExact(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        return this.seekExactDown(iRandomAccessReader, l, byArray, nArray, l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlaylistSeekResult seekExactUpOrDown(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l3 = iRandomAccessReader.getFilePointer();
            this.readPacketHeader(iRandomAccessReader, byArray, nArray);
            long l4 = (long)nArray[2] & 0xFFFFFFFFL;
            iRandomAccessReader.seek(l3);
            if (l4 > l) return this.seekExactUp(iRandomAccessReader, l, byArray, nArray, l2);
            return this.seekExactDown(iRandomAccessReader, l, byArray, nArray, l2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(37 + 13), (String)"_vp|wE}x~~n[RIn2'&/\u0000>&+=\u001f;\u0003?\n '?r"), (Throwable)exception);
            return playlistSeekResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlaylistSeekResult seekExactUp(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        long l3;
        long l4;
        PlaylistSeekResult playlistSeekResult;
        block5: {
            long l5;
            playlistSeekResult = null;
            try {
                l4 = l5 = iRandomAccessReader.getFilePointer();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(799 / 195), (String)"I`bni[ojhh|I\\G<`qp}R`xyoIm>"), (Throwable)exception);
                return playlistSeekResult;
            }
            while (true) {
                long l6;
                l3 = l4;
                l4 = l5;
                if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                    return playlistSeekResult;
                }
                if (nArray[1] > 0 && (nArray[0] == 8 || nArray[0] == 9) && ((l6 = (long)nArray[2] & 0xFFFFFFFFL) <= l || (l5 += 7L) - 7L + 4L < 13L)) break block5;
                if ((l5 -= 11L) < 13L) {
                    return playlistSeekResult;
                }
                iRandomAccessReader.seek(l5);
                l6 = this.readInt(iRandomAccessReader);
                if (l6 <= 0L) return playlistSeekResult;
                if ((l5 -= l6) < 13L) break;
                iRandomAccessReader.seek(l5);
            }
            return playlistSeekResult;
        }
        iRandomAccessReader.seek(l3);
        playlistSeekResult = new PlaylistSeekResult(0L);
        playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l4), (long)nArray[2], nArray[0], 0);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlaylistSeekResult seekExactDown(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        long l3;
        long l4;
        long l5;
        PlaylistSeekResult playlistSeekResult = null;
        try {
            l4 = l5 = iRandomAccessReader.getFilePointer();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(834 / 181), (String)"I`bni[ojhh|I\\G<`qp}R`xyoXriq "), (Throwable)exception);
            return playlistSeekResult;
        }
        while (true) {
            long l6;
            l3 = l4;
            l4 = l5;
            if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                return playlistSeekResult;
            }
            int n = 8;
            if (nArray[1] > 0 && (nArray[0] == 8 || nArray[0] == 9) && ((l6 = (long)nArray[2] & 0xFFFFFFFFL) >= l || (l5 += 7L) + (long)nArray[1] + (long)n >= l2)) break;
            if ((l5 += (long)(nArray[1] + n)) >= l2) {
                return playlistSeekResult;
            }
            iRandomAccessReader.seek(l5);
        }
        iRandomAccessReader.seek(l3);
        playlistSeekResult = new PlaylistSeekResult(0L);
        playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l4), (long)nArray[2], nArray[0], 0);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlaylistSeekResult seekKeyDown(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray, long l) {
        long l2;
        long l3;
        long l4;
        PlaylistSeekResult playlistSeekResult = null;
        try {
            l3 = l4 = iRandomAccessReader.getFilePointer();
            l2 = -1L;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(-6 - -21), (String)"Buu{rFpws}k\\WJ3mzejIf}Aipf)"), (Throwable)exception);
            return playlistSeekResult;
        }
        while (true) {
            long l5 = l3;
            l3 = l4;
            if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                return playlistSeekResult;
            }
            l4 += 7L;
            int n = 8;
            if (nArray[1] > 0 && (nArray[0] == 8 || nArray[0] == 9)) {
                if (nArray[0] == 9) {
                    iRandomAccessReader.seek(l4 + 4L);
                    iRandomAccessReader.read(byArray, 0, 2);
                    if (FLVUtils.isVideoKeyFrame((byte[])byArray)) break;
                }
                if (l2 == -1L) {
                    l2 = nArray[2];
                }
                if ((long)nArray[2] > l2 + (long)this.seekKeyFrameSearchWindow) {
                    iRandomAccessReader.seek(l3);
                    return playlistSeekResult;
                }
            }
            if ((l4 += (long)(nArray[1] + n)) >= l) {
                return playlistSeekResult;
            }
            iRandomAccessReader.seek(l4);
        }
        iRandomAccessReader.seek(l3);
        playlistSeekResult = new PlaylistSeekResult(0L);
        long l6 = (long)nArray[2] & 0xFFFFFFFFL;
        playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l3), l6, nArray[0], 1);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlaylistSeekResult seekKeyUp(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray, long l) {
        long l2;
        PlaylistSeekResult playlistSeekResult;
        block9: {
            long l3;
            long l4;
            long l5;
            playlistSeekResult = null;
            try {
                l2 = l5 = iRandomAccessReader.getFilePointer();
                l4 = -1L;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(JSON.replace((String)"\\ww}tDry}\u007fiZQH1sdghO`\u007fRx)", (int)(46 - 29)), (Throwable)exception);
                return playlistSeekResult;
            }
            while (true) {
                long l6 = l2;
                l2 = l5;
                if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                    return playlistSeekResult;
                }
                l5 += 7L;
                if (nArray[1] > 0 && (nArray[0] == 8 || nArray[0] == 9)) {
                    if (nArray[0] == 9) {
                        iRandomAccessReader.seek(l5 + 4L);
                        iRandomAccessReader.read(byArray, 0, 2);
                        if (FLVUtils.isVideoKeyFrame((byte[])byArray)) break;
                    }
                    if (l4 == -1L) {
                        l4 = nArray[2];
                    }
                    if (l4 > (long)this.seekKeyFrameSearchWindow && (l3 = (long)nArray[2] & 0xFFFFFFFFL) < l4 - (long)this.seekKeyFrameSearchWindow) break block9;
                }
                if ((l5 -= 11L) < 13L) {
                    return playlistSeekResult;
                }
                iRandomAccessReader.seek(l5);
                l3 = this.readInt(iRandomAccessReader);
                if (l3 <= 0L) return playlistSeekResult;
                if ((l5 -= l3) < 13L) return playlistSeekResult;
                iRandomAccessReader.seek(l5);
            }
            iRandomAccessReader.seek(l2);
            playlistSeekResult = new PlaylistSeekResult(0L);
            l3 = (long)nArray[2] & 0xFFFFFFFFL;
            playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l2), l3, nArray[0], 1);
            return playlistSeekResult;
        }
        iRandomAccessReader.seek(l2);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlaylistSeekResult seekGoodUp(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray, long l) {
        long l2;
        long l3;
        PlaylistSeekResult playlistSeekResult = null;
        try {
            l2 = l3 = iRandomAccessReader.getFilePointer();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(JSON.replace((String)"I`bni[ojhh|I\\G<`qp}Pwv~Nl=", (int)(516 / 120)), (Throwable)exception);
            return playlistSeekResult;
        }
        while (true) {
            long l4;
            long l5 = l2;
            l2 = l3;
            if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                return playlistSeekResult;
            }
            l3 += 7L;
            if (nArray[1] > 0 && (nArray[0] == 9 || nArray[0] == 8)) {
                iRandomAccessReader.seek(l2);
                playlistSeekResult = new PlaylistSeekResult(0L);
                l4 = (long)nArray[2] & 0xFFFFFFFFL;
                playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l2), l4, nArray[0], 0);
                return playlistSeekResult;
            }
            if ((l3 -= 11L) < 13L) {
                return playlistSeekResult;
            }
            iRandomAccessReader.seek(l3);
            l4 = this.readInt(iRandomAccessReader);
            if (l4 <= 0L) return playlistSeekResult;
            if ((l3 -= l4) < 13L) break;
            iRandomAccessReader.seek(l3);
        }
        return playlistSeekResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long resultsToFilePos(PlaylistSeekResult playlistSeekResult) {
        if (playlistSeekResult.getStreamPos() == null) {
            return -1L;
        }
        long l = ((FLVStreamPosition)playlistSeekResult.getStreamPos()).getFilePos();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PlaylistSeekResult seek(long var1_1, int var3_2) {
        block44: {
            if (!this.fileStream.exists()) {
                return null;
            }
            var4_3 = null;
            var5_4 = null;
            var6_9 = null;
            if (var1_1 <= 0L) {
                var4_3 = new PlaylistSeekResult(0L);
                var4_3.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(this.firstPacketLoc), 0L, (int)this.firstPacketType, 0);
                return var4_3;
            }
            var7_7 = System.currentTimeMillis();
            ** try [egrp 2[TRYBLOCK] [6 : 126->1911)] { 
lbl13:
            // 1 sources

            {
                block45: {
                    block62: {
                        block60: {
                            block61: {
                                block59: {
                                    block56: {
                                        block57: {
                                            block58: {
                                                block46: {
                                                    block48: {
                                                        block54: {
                                                            block55: {
                                                                block51: {
                                                                    block52: {
                                                                        block53: {
                                                                            block50: {
                                                                                block49: {
                                                                                    block47: {
                                                                                        if (this.bufferSeekIO) {
                                                                                            var5_4 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                                                                            var6_9 = new ScheduledRandomAccessReaderWrapper(this.stream, var5_4, this.readAheadSize, this.readAheadTrigger);
                                                                                            var5_4.open();
                                                                                            var6_9.open();
                                                                                        } else {
                                                                                            var6_9 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                                                                            var6_9.open();
                                                                                        }
                                                                                        var9_10 = new byte[13];
                                                                                        var10_12 = new int[5];
                                                                                        var11_13 = var6_9.length();
                                                                                        var13_14 = -1L;
                                                                                        var15_15 = -1L;
                                                                                        if (this.keyframeMap.size() <= 0) break block46;
                                                                                        var17_16 = new Long(var1_1);
                                                                                        var18_21 = 0L;
                                                                                        if (var3_2 != 1) break block47;
                                                                                        var20_25 = this.keyframeMap.headMap((Long)var17_16);
                                                                                        if (!var20_25.isEmpty()) {
                                                                                            var18_21 = var20_25.lastKey();
                                                                                            v0 = var20_25;
                                                                                            var13_14 = (Long)v0.get(v0.lastKey());
                                                                                        }
                                                                                        break block48;
                                                                                    }
                                                                                    if (var3_2 != 3) break block49;
                                                                                    var20_24 = -1L;
                                                                                    var22_30 = 0L;
                                                                                    var24_31 = -1L;
                                                                                    var26_32 = 0L;
                                                                                    var28_36 = this.keyframeMap.headMap((Long)var17_16);
                                                                                    if (!var28_36.isEmpty()) {
                                                                                        var20_24 = var28_36.lastKey();
                                                                                        v1 = var28_36;
                                                                                        var22_30 = (Long)v1.get(v1.lastKey());
                                                                                    }
                                                                                    break block50;
                                                                                }
                                                                                var20_26 = this.keyframeMap.tailMap((Long)var17_16);
                                                                                if (var20_26.isEmpty()) break block48;
                                                                                break block51;
                                                                            }
                                                                            var29_34 = this.keyframeMap.tailMap((Long)var17_16);
                                                                            if (!var29_34.isEmpty()) {
                                                                                var24_31 = var29_34.firstKey();
                                                                                v2 = var29_34;
                                                                                var26_32 = (Long)v2.get(v2.firstKey());
                                                                            }
                                                                            if (var20_24 >= 0L && var24_31 >= 0L) break block52;
                                                                            if (var20_24 < 0L) break block53;
                                                                            var18_21 = var20_24;
                                                                            var13_14 = var22_30;
                                                                            break block48;
                                                                        }
                                                                        if (var24_31 < 0L) break block48;
                                                                        break block54;
                                                                    }
                                                                    var30_38 = Math.abs(var20_24 - var1_1);
                                                                    var32_39 = Math.abs(var24_31 - var1_1);
                                                                    if (var32_39 > var30_38) break block55;
                                                                    var18_21 = var24_31;
                                                                    var13_14 = var26_32;
                                                                    break block48;
                                                                }
                                                                var18_21 = var20_26.firstKey();
                                                                v3 = var20_26;
                                                                var13_14 = (Long)v3.get(v3.firstKey());
                                                                break block48;
                                                            }
                                                            var18_21 = var20_24;
                                                            var13_14 = var22_30;
                                                            break block48;
                                                        }
                                                        var18_21 = var24_31;
                                                        var13_14 = var26_32;
                                                    }
                                                    if (var13_14 >= 0L) {
                                                        if (var3_2 != 2 && var3_2 != 1 && var3_2 != 3) {
                                                            var6_9.seek(var13_14);
                                                            var4_3 = this.seekExactUpOrDown(var6_9, var1_1, var9_10, var10_12, var11_13);
                                                        } else {
                                                            var15_15 = var13_14;
                                                            var4_3 = new PlaylistSeekResult(0L);
                                                            var20_23 = new FLVStreamPosition(var13_14);
                                                            var4_3.setResults((IMediaReaderStreamPosition)var20_23, var18_21, 9, 1);
                                                            var4_3.setVideoStreamPos((IMediaReaderStreamPosition)var20_23);
                                                            var4_3.setResultVideoTimecode(var18_21);
                                                            var21_27 = var13_14;
                                                            var6_9.seek(var13_14);
                                                            var23_28 = this.seekExactUpOrDown(var6_9, var1_1, var9_10, var10_12, var11_13);
                                                            var6_9.seek(var21_27);
                                                            if (var23_28 != null) {
                                                                var15_15 = this.resultsToFilePos(var23_28);
                                                                var4_3.setResultTimecode(var23_28.getResultTimecode());
                                                            }
                                                        }
                                                    }
                                                }
                                                if ((var13_14 == -1L || var4_3 == null) && this.duration > 0L && (var13_14 = this.findClosestPacket(var6_9, var1_1, this.duration, this.seekMap, this.metaDataSize, (byte[])(var17_16 = (Object)new byte[this.seekBufferSize]), var9_10, var10_12)) >= 0L) {
                                                    var6_9.seek(var13_14);
                                                    var4_3 = this.seekExactUpOrDown(var6_9, var1_1, var9_10, var10_12, var11_13);
                                                }
                                                if (var13_14 == -1L || var4_3 == null) {
                                                    // MONITORENTER : this.getNodeData()
                                                    if (!this.nodeData.isHitEnd()) {
                                                        var18_22 = this.nodeData.getExtent();
                                                        v4 = this;
                                                        v4.indexFileExpand(v4.nodeData, var6_9, var1_1);
                                                        if (var18_22 != this.nodeData.getExtent()) {
                                                            MediaIndexCacheSingleton.getInstance().addPending(this.mediaReaderType, (IRandomAccessReader)this.fileReader, (IMediaIndexItem)this.nodeData);
                                                        }
                                                    }
                                                    var13_14 = this.nodeData.getMediaStreamIndex().indexFileGet(var1_1);
                                                    this.nodeData.touch();
                                                    // MONITOREXIT : var17_16
                                                    if (var13_14 == -1L) break block44;
                                                    var6_9.seek(var13_14);
                                                    var4_3 = this.seekExact(var6_9, var1_1, var9_10, var10_12, var11_13);
                                                }
                                                if (var15_15 != -1L) break block56;
                                                switch (var3_2) {
                                                    case 2: {
                                                        if (var4_3 != null) {
                                                            var15_15 = this.resultsToFilePos(var4_3);
                                                            var17_16 = this.seekKeyDown(var6_9, var9_10, var10_12, var11_13);
                                                            if (var17_16 != null) {
                                                                var4_3.setVideoStreamPos(var17_16.getStreamPos());
                                                                var4_3.setResultVideoTimecode(var17_16.getResultTimecode());
                                                            }
                                                        }
                                                        break block56;
                                                    }
                                                    case 4: {
                                                        if (var4_3 != null) {
                                                            ** break;
                                                        }
                                                        break block56;
                                                    }
                                                    case 3: {
                                                        if (var4_3 == null) break;
                                                        var15_15 = this.resultsToFilePos(var4_3);
                                                        var17_18 = var6_9.getFilePointer();
                                                        var19_33 = this.seekKeyUp(var6_9, var9_10, var10_12, var11_13);
                                                        var6_9.seek(var17_18);
                                                        var20_23 = this.seekKeyDown(var6_9, var9_10, var10_12, var11_13);
                                                        if (var19_33 == null) ** GOTO lbl158
                                                        ** GOTO lbl153
                                                    }
                                                    catch (Throwable var34_37) {
                                                        // MONITOREXIT : var17_16
                                                        throw var34_37;
                                                    }
lbl153:
                                                    // 1 sources

                                                    if (var20_23 == null) ** GOTO lbl158
                                                    var21_27 = Math.abs(var19_33.getResultTimecode() - var1_1);
                                                    var23_29 = Math.abs(var20_23.getResultTimecode() - var1_1);
                                                    if (var23_29 > var21_27) ** GOTO lbl161
                                                    break block57;
lbl158:
                                                    // 2 sources

                                                    if (var19_33 != null) ** GOTO lbl164
                                                    if (var20_23 == null) break block56;
                                                    ** GOTO lbl167
lbl161:
                                                    // 1 sources

                                                    var4_3.setVideoStreamPos(var19_33.getStreamPos());
                                                    var4_3.setResultVideoTimecode(var19_33.getResultTimecode());
                                                    break block56;
lbl164:
                                                    // 1 sources

                                                    var4_3.setVideoStreamPos(var19_33.getStreamPos());
                                                    var4_3.setResultVideoTimecode(var19_33.getResultTimecode());
                                                    break;
lbl167:
                                                    // 1 sources

                                                    var4_3.setVideoStreamPos(var20_23.getStreamPos());
                                                    var4_3.setResultVideoTimecode(var20_23.getResultTimecode());
                                                    break;
lbl170:
                                                    // 1 sources

                                                    var15_15 = this.resultsToFilePos(var4_3);
                                                    break;
                                                    case 1: {
                                                        if (var4_3 != null) break block58;
                                                    }
                                                }
                                                break block56;
                                            }
                                            var15_15 = this.resultsToFilePos(var4_3);
                                            var17_16 = this.seekKeyUp(var6_9, var9_10, var10_12, var11_13);
                                            if (var17_16 != null) {
                                                var4_3.setVideoStreamPos(var17_16.getStreamPos());
                                                var4_3.setResultVideoTimecode(var17_16.getResultTimecode());
                                            }
                                            break block56;
                                        }
                                        var4_3.setVideoStreamPos(var20_23.getStreamPos());
                                        var4_3.setResultVideoTimecode(var20_23.getResultTimecode());
                                    }
                                    if (var4_3 != null) break block45;
                                    var17_19 = this.getNodeData();
                                    // MONITORENTER : var17_19
                                    if (!this.nodeData.isHitEnd()) {
                                        v5 = this;
                                        v5.indexFileExpand(v5.nodeData, var6_9, -1L);
                                        MediaIndexCacheSingleton.getInstance().addPending(this.mediaReaderType, (IRandomAccessReader)this.fileReader, (IMediaIndexItem)this.nodeData);
                                    }
                                    var13_14 = this.nodeData.getMediaStreamIndex().indexFileLast();
                                    this.nodeData.touch();
                                    // MONITOREXIT : var17_19
                                    if (var13_14 == -1L) break block45;
                                    var6_9.seek(var13_14);
                                    if (var3_2 != 4) break block59;
                                    break block60;
                                }
                                var4_3 = this.seekKeyUp(var6_9, var9_10, var10_12, var11_13);
                                if (var4_3 != null) break block61;
                                var4_3 = this.seekGoodUp(var6_9, var9_10, var10_12, var11_13);
                                if (var4_3 == null) break block45;
                                break block62;
                            }
                            var15_15 = this.resultsToFilePos(var4_3);
                            break block45;
                        }
                        var4_3 = this.seekGoodUp(var6_9, var9_10, var10_12, var11_13);
                        if (var4_3 != null) {
                            var15_15 = this.resultsToFilePos(var4_3);
                        }
                        break block45;
                    }
                    var15_15 = this.resultsToFilePos(var4_3);
                }
                if (var4_3 != null) {
                    var17_20 = new FLVStreamPosition(var15_15 != -1L ? var15_15 : var6_9.getFilePointer());
                    var4_3.setStreamPos((IMediaReaderStreamPosition)var17_20);
                    var4_3.setSearchTimecode(var1_1);
                }
                var6_9.close();
                var6_9 = null;
            }
lbl228:
            // 1 sources

            catch (Exception var9_11) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(372 / 56), (String)"Kbl`kYiljjbW^E:fsrs9"), (Throwable)var9_11);
            }
        }
        try {
            if (var6_9 != null) {
                var6_9.close();
            }
        }
        catch (Exception var7_6) {}
        var6_9 = null;
        try {
            if (var5_4 != null) {
                var5_4.close();
            }
        }
        catch (Exception var7_5) {}
        var5_4 = null;
        return var4_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMediaReaderStreamPosition getStreamPosition() {
        FLVStreamPosition fLVStreamPosition = new FLVStreamPosition();
        try {
            if (this.fileReader == null) return fLVStreamPosition;
            fLVStreamPosition.setFilePos(this.fileReader.getFilePointer());
            return fLVStreamPosition;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(125 + 85), (String)"\u001f60<7\u0005=8>>.\u001b\u0012\tn&'7\u0002,*\"\u0018&#%8(<o"), (Throwable)exception);
            return fLVStreamPosition;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        try {
            if (this.fileReader != null) {
                this.fileReader.seek(((FLVStreamPosition)iMediaReaderStreamPosition).getFilePos());
            }
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(75 + 56), (String)"NaaofZlkoi\u007fHCF?uv`S\u007f{}Iurri{m "), (Throwable)exception);
            return;
        }
    }

    public void startPlayback() {
    }

    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        return this.writeGeneratedKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (fastPlaySettings == null) {
            return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
        }
        return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.chunkWorkBuffer = new byte[n];
    }

    /*
     * Unable to fully structure code
     */
    public int rewriteLastPacket(int var1_1, long var2_2, boolean var4_3, IMediaStream var5_4, OutputStream var6_5, AMFObj var7_6, PlaylistCursor var8_7, long[] var9_8, FastPlaySettings var10_9) {
        block8: {
            var11_10 = 0;
            var12_11 = var8_7.getWriteControl().getChunkSize();
            this.checkWorkBuffer(var12_11);
            break block8;
lbl5:
            // 1 sources

            while (true) {
                this.fileReader.seek(this.saveLastAudioPos);
                this.chunkHeaderValues[0] = var1_1;
                this.chunkHeaderValues[1] = this.saveLastBroadcastSize;
                this.chunkHeaderValues[2] = (int)(var2_2 & 0xFFFFFFFFL);
                v0 = this;
                var13_12 = v0.directOutput((IRandomAccessReader)v0.fileReader, this.chunkHeaderValues, var4_3, var5_4.getSrc(), var6_5, var7_6, this.chunkWorkBuffer, var12_11);
                var11_10 += var13_12;
                var9_8[4] = var9_8[4] + (long)var13_12;
                var9_8[5] = var9_8[5] + 1L;
                ** GOTO lbl-1000
                break;
            }
        }
        switch (var1_1) {
            case 8: {
                if (this.saveLastAudioPos != 0L) break;
                ** GOTO lbl-1000
            }
            while (true) {
                this.fileReader.seek(this.saveLastVideoPos);
                this.chunkHeaderValues[0] = var1_1;
                this.chunkHeaderValues[1] = this.saveLastVideoSize;
                this.chunkHeaderValues[2] = (int)(var2_2 & 0xFFFFFFFFL);
                v1 = this;
                var13_13 = v1.directOutput((IRandomAccessReader)v1.fileReader, this.chunkHeaderValues, var4_3, var5_4.getSrc(), var6_5, var7_6, this.chunkWorkBuffer, var12_11);
                var11_10 += var13_13;
                var9_8[2] = var9_8[2] + (long)var13_13;
                var9_8[3] = var9_8[3] + 1L;
                ** GOTO lbl-1000
                break;
            }
            case 9: {
                if (this.saveLastVideoPos != 0L) ** continue;
                ** GOTO lbl-1000
            }
        }
        this.fileReader.seek(this.saveLastAudioPos);
        this.chunkHeaderValues[0] = var1_1;
        this.chunkHeaderValues[1] = this.saveLastAudioSize;
        this.chunkHeaderValues[2] = (int)(var2_2 & 0xFFFFFFFFL);
        v2 = this;
        var13_14 = v2.directOutput((IRandomAccessReader)v2.fileReader, this.chunkHeaderValues, var4_3, var5_4.getSrc(), var6_5, var7_6, this.chunkWorkBuffer, var12_11);
        var11_10 += var13_14;
        var9_8[0] = var9_8[0] + (long)var13_14;
        var9_8[1] = var9_8[1] + 1L;
lbl-1000:
        // 6 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                return var11_10;
            }
            ** case 15:
            ** case 18:
        }
lbl47:
        // 1 sources

        ** while (this.saveLastBroadcastPos != 0L)
lbl48:
        // 1 sources

        ** GOTO lbl-1000
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) < 0) return false;
        return true;
    }

    public int writeEnhancedCmd(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, int n2, int n3) {
        int n4 = 0;
        int n5 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n5);
        byte[] byArray = new byte[]{(byte)(n3 & 0xF | 0x50), (byte)(0xFF & n2)};
        int[] nArray = new int[5];
        nArray[1] = byArray.length;
        nArray[2] = n;
        nArray[0] = 9;
        int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n5, byArray);
        lArray[2] = lArray[2] + (long)n6;
        lArray[3] = lArray[3] + 1L;
        return n4 += n6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int writeEnhancedCmd(IMediaStream iMediaStream, OutputStream outputStream, int n, int n2) {
        int n3 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) {
            return 0;
        }
        try {
            int n4 = iMediaStream.getSrc();
            int n5 = 1;
            byte[] byArray = new byte[]{(byte)(n2 & 0xF | 0x50), (byte)(0xFF & n)};
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createEnhancedSeekMessage(byArray, n4, n5);
            return n3 += responseFunction.write(outputStream, ((Client)iClient).getSendChunkSize());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(JSON.replace((String)"Jmmcj^hokucT_B;sypxtxyy]rd!", (int)(33 * 39)), (Throwable)exception);
            return n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int writeChunkSizeCmd(OutputStream outputStream, int n) {
        int n2 = 0;
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 4, 1, 0, 0, 0, 0, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n)};
        try {
            outputStream.write(byArray);
            n2 += byArray.length;
            return n2;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(63 * 55), (String)"Dooel\\jquwaRY@9oksoy^vjnjQj~`Ejl3*n~\u007fa}0bw}p|xp8zrnrv>l);'c"), (Throwable)exception);
            return n2;
        }
    }

    /*
     * Exception decompiling
     */
    protected int writeGeneratedKeyFrame(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [1 : 143->166)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 164->1419)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int writeGeneratedKeyFrameFastPlay(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected int writePacketsFastPlay(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        var12_12 = 0;
        var13_13 = var10_10.getMultiplier();
        var15_14 = var10_10.getDirection();
        var16_15 = Math.round(1000.0 / (double)var10_10.getFps());
        var18_16 = var10_10.getStartTC();
        this.fileReader.setDirecton(var15_14);
        if (var15_14 < 0) {
            var6_6.setVideoCanDFrame(false);
            var6_6.setVideoCanPFrame(false);
        }
        var20_17 = var6_6.getWriteControl().getChunkSize();
        this.checkWorkBuffer(var20_17);
        var21_18 = 0L;
        var23_19 = false;
        var24_20 = false;
        var25_21 = false;
        var26_22 = var7_7.getMaxTC();
        var28_23 = 0;
        while (true) {
            block28: {
                block29: {
                    block34: {
                        block31: {
                            block30: {
                                block33: {
                                    block32: {
                                        block26: {
                                            var29_24 = this.lock;
                                            // MONITORENTER : var29_24
                                            {
                                                if (!var6_6.isBreakLoop()) break block26;
                                                // MONITOREXIT : var29_24
                                                break;
                                            }
                                        }
                                        var30_25 = this.fileReader.getFilePointer();
                                        v0 = this;
                                        v0.readChunkHeader((IRandomAccessReader)v0.fileReader, this.chunkHeaderBuffer, this.chunkHeaderValues);
                                        if (this.chunkHeaderValues[0] == 127) {
                                            var8_8.setHitEnd(true);
                                            // MONITOREXIT : var29_24
                                            break;
                                        }
                                        var32_26 = false;
                                        if ((long)this.chunkHeaderValues[1] > this.seekLargestFrame) {
                                            this.seekLargestFrame = this.chunkHeaderValues[1];
                                        }
                                        var33_27 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                                        switch (this.chunkHeaderValues[0]) {
                                            default: {
                                                break block28;
                                            }
                                            case 15: 
                                            case 18: {
                                                var40_35 = true;
                                                var41_36 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                                                if ((var41_36 += var6_6.getStartTCOffset()) >= 0L) ** GOTO lbl54
                                                break block28;
                                            }
                                            case 9: {
                                                var35_28 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                                                if (!var6_6.isWaitForKeyFrame()) ** GOTO lbl61
                                                if (FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) ** GOTO lbl60
                                                break block28;
                                            }
lbl54:
                                            // 1 sources

                                            this.chunkHeaderValues[2] = (int)(var6_6.calcTCAdj(var41_36) & 0xFFFFFFFFL);
                                            this.saveLastBroadcastPos = this.fileReader.getFilePointer();
                                            this.saveLastBroadcastSize = this.chunkHeaderValues[1];
                                            if (!var11_11) break block29;
                                            this.chunkHeaderValues[2] = 0;
                                            break block29;
lbl60:
                                            // 1 sources

                                            var6_6.setWaitForKeyFrame(false);
lbl61:
                                            // 2 sources

                                            var36_29 = true;
                                            var37_30 = var6_6.isSendAbsVideoTC();
                                            var38_31 = var6_6.isSendAbsVideoTC();
                                            if (!var37_30) ** GOTO lbl68
                                            var39_34 = var6_6.getForceVideoTC();
                                            if (var39_34 < 0L) ** GOTO lbl73
                                            ** GOTO lbl77
lbl68:
                                            // 1 sources

                                            var39_34 = var6_6.getLastVideoFastTC() - var18_16;
                                            var41_36 = Math.round((double)Math.abs(var18_16 - var33_27) / var13_13);
                                            var43_37 = var41_36 - var39_34;
                                            if (!(var13_13 <= 1.0) && var43_37 <= var16_15 - 3L) ** GOTO lbl75
                                            ** GOTO lbl81
lbl73:
                                            // 1 sources

                                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                            ** GOTO lbl79
lbl75:
                                            // 1 sources

                                            v1 = false;
                                            ** GOTO lbl82
lbl77:
                                            // 1 sources

                                            this.chunkHeaderValues[2] = (int)(var39_34 + var6_6.getStartTCOffset());
                                            var33_27 = var39_34;
lbl79:
                                            // 2 sources

                                            if (this.chunkHeaderValues[2] >= 0) break block30;
                                            break block28;
lbl81:
                                            // 1 sources

                                            v1 = true;
lbl82:
                                            // 2 sources

                                            if ((var36_29 = v1) && var35_28 == 2 && !var6_6.isVideoCanPFrame() || var35_28 == 3 && !var6_6.isVideoCanDFrame()) {
                                                var36_29 = false;
                                            }
                                            if (var36_29) {
                                                this.chunkHeaderValues[2] = (int)(var43_37 & 0xFFFFFFFFL);
                                                var6_6.incLastVideoFastTC(var43_37);
                                            }
                                            break block31;
                                            case 8: 
                                        }
                                        var39_33 = var6_6.isSendAbsAudioTC();
                                        if (!var6_6.isSendAbsAudioTC()) break block32;
                                        this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                        if (this.chunkHeaderValues[2] >= 0) break block33;
                                        break block28;
                                    }
                                    this.chunkHeaderValues[2] = (int)(var33_27 - var6_6.getLastAudioTC() & 0xFFFFFFFFL);
                                    break block28;
                                }
                                var6_6.setSendAbsAudioTC(false);
                                break block28;
                            }
                            var6_6.setForceVideoTC(-1L);
                            var6_6.setSendAbsVideoTC(false);
                            var6_6.setLastVideoFastTC(var33_27);
                        }
                        if (var36_29) break block34;
                        if (var15_14 > 0) {
                            var6_6.setVideoCanPFrame(false);
                            if (FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) {
                                var6_6.setVideoCanDFrame(false);
                            }
                        }
                        break block28;
                    }
                    var6_6.setLastVideoTC(var33_27);
                    var6_6.incVideoPacketCount();
                    var21_18 = var33_27;
                    this.saveLastVideoPos = this.fileReader.getFilePointer();
                    this.saveLastVideoSize = this.chunkHeaderValues[1];
                    if (var11_11) {
                        this.chunkHeaderValues[2] = 0;
                    }
                    if ((long)var28_23 != var6_6.getVideoSampleDesc()) {
                        v2 = this;
                        var39_32 = v2.sendVideoTrakData(v2.chunkHeaderValues[2], var38_31, var1_1, var2_2, var4_4, var6_6, var7_7, var8_8, var9_9, var11_11, var28_23);
                        if (var39_32 > 0) {
                            var38_31 = false;
                            this.chunkHeaderValues[2] = 0;
                        }
                        var6_6.setVideoSampleDesc((long)var28_23);
                    }
                    v3 = this;
                    var39_32 = v3.directOutput((IRandomAccessReader)v3.fileReader, this.chunkHeaderValues, var38_31, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var20_17);
                    var12_12 += var39_32;
                    var23_19 = true;
                    var24_20 = true;
                    var32_26 = true;
                    var9_9[2] = var9_9[2] + (long)var39_32;
                    var9_9[3] = var9_9[3] + 1L;
                    var8_8.incVideoPackets();
                    if (var38_31) {
                        var39_32 = this.rewriteLastPacket(9, 0L, false, var1_1, var2_2, var4_4, var6_6, var9_9, var10_10);
                        var12_12 += var39_32;
                        var8_8.incVideoPackets();
                    }
                    if (var15_14 > 0) {
                        var6_6.setVideoCanPFrame(true);
                        if (FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) {
                            var6_6.setVideoCanDFrame(true);
                        }
                    }
                    break block28;
                }
                v4 = this;
                var43_38 = v4.directOutput((IRandomAccessReader)v4.fileReader, this.chunkHeaderValues, var40_35, var1_1.getSrc(), var2_2, var5_5, this.chunkWorkBuffer, var20_17);
                var12_12 += var43_38;
                var6_6.setLastBroadcastTC(var33_27);
                var6_6.incDataPacketCount();
                var21_18 = var33_27;
                var9_9[4] = var9_9[4] + (long)var43_38;
                var9_9[5] = var9_9[5] + 1L;
                var32_26 = true;
            }
            var8_8.setLastTC(var33_27);
            v5 = this;
            var35_28 = (int)v5.skipPacket(v5.chunkHeaderValues, var32_26, true, var15_14);
            if (var35_28 == 0) {
                var8_8.setHitEnd(true);
                // MONITOREXIT : var29_24
                break;
            }
            if (var23_19) {
                if (var26_22 == 0L) break;
                if (var6_6.calcTCAdj(var33_27) >= var26_22) break;
            }
            // MONITOREXIT : var29_24
        }
        // MONITOREXIT : var29_24
        var8_8.setTotalSize(var12_12);
        return var12_12;
    }

    /*
     * Unable to fully structure code
     */
    protected long findClosestPacket(IRandomAccessReader var1_1, long var2_2, long var4_3, SortedMap<Long, Long> var6_4, int var7_5, byte[] var8_6, byte[] var9_7, int[] var10_8) {
        block46: {
            block41: {
                block48: {
                    block31: {
                        block29: {
                            block42: {
                                block33: {
                                    block38: {
                                        block47: {
                                            block37: {
                                                block35: {
                                                    block43: {
                                                        block36: {
                                                            block45: {
                                                                block27: {
                                                                    block28: {
                                                                        block39: {
                                                                            block30: {
                                                                                block26: {
                                                                                    block34: {
                                                                                        block32: {
                                                                                            block44: {
                                                                                                block40: {
                                                                                                    var11_9 = -1L;
                                                                                                    var13_10 = var1_1.length();
                                                                                                    var17_12 = var13_10 - (var15_11 = (long)(13 + var7_5));
                                                                                                    if (var17_12 >= 0x300000L) break block40;
                                                                                                    break block41;
lbl6:
                                                                                                    // 1 sources

                                                                                                    while (true) {
                                                                                                        v0 = true;
                                                                                                        break block26;
                                                                                                        break;
                                                                                                    }
lbl9:
                                                                                                    // 1 sources

                                                                                                    while (true) {
                                                                                                        v0 = false;
                                                                                                        break block26;
                                                                                                        break;
                                                                                                    }
lbl12:
                                                                                                    // 1 sources

                                                                                                    while (var8_6[var37_24] == 9) lbl-1000:
                                                                                                    // 4 sources

                                                                                                    {
                                                                                                        while (true) {
                                                                                                            var39_26 = 0;
                                                                                                            var39_26 = var8_6[var37_24 + 1] & 255;
                                                                                                            var39_26 <<= 8;
                                                                                                            var39_26 |= var8_6[var37_24 + 2] & 255;
                                                                                                            var39_26 <<= 8;
                                                                                                            if ((var39_26 |= var8_6[var37_24 + 3] & 255) < 0) break block27;
                                                                                                            break block28;
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    break block42;
lbl22:
                                                                                                    // 2 sources

                                                                                                    while (true) {
                                                                                                        var38_25 = 14;
                                                                                                        break block29;
                                                                                                        break;
                                                                                                    }
lbl25:
                                                                                                    // 1 sources

                                                                                                    while (true) {
                                                                                                        var25_17 = var29_19.firstKey();
                                                                                                        v1 = var29_19;
                                                                                                        var27_18 = (Long)v1.get(v1.firstKey());
                                                                                                        break block30;
                                                                                                        break;
                                                                                                    }
lbl30:
                                                                                                    // 1 sources

                                                                                                    while (true) {
                                                                                                        var1_1.seek(var44_30 + (long)var10_8[1]);
                                                                                                        var1_1.read(var9_7, 0, 4);
                                                                                                        var46_32 = 0;
                                                                                                        var46_32 = var9_7[0] & 255;
                                                                                                        var46_32 <<= 8;
                                                                                                        var46_32 |= var9_7[1] & 255;
                                                                                                        var46_32 <<= 8;
                                                                                                        var46_32 |= var9_7[2] & 255;
                                                                                                        var46_32 <<= 8;
                                                                                                        if (var10_8[1] + 11 != (var46_32 |= var9_7[3] & 255)) break block31;
                                                                                                        break block32;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                if (var4_3 > 0L) break block43;
                                                                                                break block44;
lbl46:
                                                                                                // 1 sources

                                                                                                while (true) {
                                                                                                    if (var8_6[var37_24] != 15) break block27;
                                                                                                    ** GOTO lbl-1000
lbl49:
                                                                                                    // 1 sources

                                                                                                    while ((var35_23 += (long)(var8_6.length - var38_25)) + (long)var8_6.length > var13_10) lbl-1000:
                                                                                                    // 2 sources

                                                                                                    {
                                                                                                        return var11_9;
                                                                                                    }
                                                                                                    break block29;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            return -1L;
lbl55:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                var43_29 = v2;
                                                                                                break block33;
                                                                                                break;
                                                                                            }
lbl58:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                var19_13 = new Long(var2_2);
                                                                                                var20_14 = 0L;
                                                                                                var22_15 = var15_11;
                                                                                                var24_16 = var6_4.headMap(var19_13);
                                                                                                if (var24_16.isEmpty()) break block34;
                                                                                                break block35;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        v2 = true;
                                                                                        ** GOTO lbl55
lbl68:
                                                                                        // 1 sources

                                                                                        while (true) {
                                                                                            var44_30 = var1_1.getFilePointer();
                                                                                            if (var44_30 + (long)var10_8[1] + 4L <= var13_10) {
                                                                                                ** continue;
                                                                                            }
                                                                                            break block33;
                                                                                            break;
                                                                                        }
                                                                                    }
lbl74:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var25_17 = var4_3;
                                                                                        var27_18 = var13_10;
                                                                                        var29_19 = var6_4.tailMap(var19_13);
                                                                                        if (var29_19.isEmpty()) break block30;
                                                                                        ** continue;
                                                                                        break;
                                                                                    }
lbl80:
                                                                                    // 1 sources

                                                                                    while (true) {
                                                                                        var40_27 = var35_23 + (long)var37_24 + 11L + (long)var39_26;
                                                                                        if (var40_27 + 4L > var13_10) break block27;
                                                                                        break block36;
                                                                                        break;
                                                                                    }
lbl84:
                                                                                    // 1 sources

                                                                                    while (true) {
                                                                                        var2_2 = 0L;
                                                                                        break block37;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                var30_20 = v0;
                                                                                var31_21 = (double)(var2_2 - var20_14) / (double)(var25_17 - var20_14);
                                                                                var33_22 = (double)var2_2 / (double)var4_3;
                                                                                var35_23 = var22_15 + Math.round((double)(var27_18 - var22_15) * var31_21);
                                                                                if (var35_23 + this.seekLargestFrame <= var13_10) ** GOTO lbl22
                                                                                break block45;
lbl94:
                                                                                // 2 sources

                                                                                while (var10_8[0] != 127) {
                                                                                    ** continue;
lbl96:
                                                                                    // 1 sources

                                                                                    ** GOTO lbl68
                                                                                }
                                                                                break block33;
lbl98:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    if (var37_24 >= var8_6.length - var38_25) break block38;
                                                                                    break block39;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            ** while (var25_17 - var20_14 <= 1000L)
lbl103:
                                                                            // 1 sources

                                                                            ** while (true)
                                                                        }
                                                                        if (var8_6[var37_24] == 8) ** GOTO lbl-1000
                                                                        ** GOTO lbl12
                                                                    }
                                                                    ** while ((long)var39_26 <= this.seekLargestFrame)
                                                                }
lbl110:
                                                                // 3 sources

                                                                while (true) {
                                                                    ++var37_24;
                                                                    ** GOTO lbl98
                                                                    break;
                                                                }
lbl113:
                                                                // 1 sources

                                                                while (true) {
                                                                    var6_4.put(new Long(var44_30), new Long(var11_9));
                                                                    break block38;
                                                                    break;
                                                                }
                                                            }
                                                            var35_23 = var13_10 - this.seekLargestFrame;
                                                            ** while (true)
                                                        }
                                                        var1_1.seek(var40_27);
                                                        var1_1.read(var9_7, 0, 4);
                                                        var42_28 = 0;
                                                        var42_28 = var9_7[0] & 255;
                                                        var42_28 <<= 8;
                                                        var42_28 |= var9_7[1] & 255;
                                                        var42_28 <<= 8;
                                                        var42_28 |= var9_7[2] & 255;
                                                        var42_28 <<= 8;
                                                        if ((var42_28 |= var9_7[3] & 255) != var39_26 + 11) ** GOTO lbl110
                                                        break block46;
                                                    }
                                                    if (var2_2 < 0L) {
                                                        ** continue;
                                                    }
                                                    break block37;
                                                }
                                                var20_14 = var24_16.lastKey();
                                                v3 = var24_16;
                                                var22_15 = (Long)v3.get(v3.lastKey());
                                                ** while (true)
                                            }
                                            if (var2_2 <= var4_3) ** GOTO lbl58
                                            break block47;
lbl145:
                                            // 1 sources

                                            while (true) {
                                                this.readChunkHeader(var1_1, var9_7, var10_8);
                                                ** GOTO lbl94
                                                break;
                                            }
                                        }
                                        var2_2 = var4_3;
                                        ** while (true)
                                    }
lbl152:
                                    // 3 sources

                                    while (var11_9 != -1L) {
                                        ** continue;
lbl154:
                                        // 1 sources

                                        ** GOTO lbl-1000
                                    }
                                    ** GOTO lbl49
lbl156:
                                    // 1 sources

                                    while (true) {
                                        MediaReaderFLV.readPrevChunkHeader(var1_1, var9_7, var10_8);
                                        ** GOTO lbl94
                                        break;
                                    }
                                }
                                if (var43_29) ** break;
                                ** while (true)
                                break block48;
lbl163:
                                // 1 sources

                                while (!var6_4.containsKey(var46_31 = new Long(var44_30))) {
                                    ** continue;
lbl165:
                                    // 1 sources

                                    ** GOTO lbl113
                                }
                                ** GOTO lbl152
                            }
                            if (var8_6[var37_24] != 18) ** break;
                            ** while (true)
                            ** while (true)
                        }
                        var1_1.seek(var35_23);
                        var1_1.read(var8_6, 0, var8_6.length);
                        var37_24 = 0;
                        ** while (true)
                    }
                    v2 = false;
                    ** while (true)
                }
                var11_9 = var35_23 + (long)var37_24;
                var44_30 = 0L;
                var44_30 |= (long)(var8_6[var37_24 + 7] & 255);
                var44_30 <<= 8;
                var44_30 |= (long)(var8_6[var37_24 + 4] & 255);
                var44_30 <<= 8;
                var44_30 |= (long)(var8_6[var37_24 + 5] & 255);
                var44_30 <<= 8;
                var44_30 |= (long)(var8_6[var37_24 + 6] & 255);
                if (!var30_20) ** GOTO lbl152
                ** GOTO lbl163
            }
            return -1L;
        }
        var40_27 = var35_23 + (long)var37_24;
        var43_29 = false;
        var1_1.seek(var40_27 + (long)var42_28 + 4L);
        ** while (!(var33_22 < 0.5))
lbl199:
        // 1 sources

        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readChunkHeader(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray) {
        nArray[0] = 127;
        if (iRandomAccessReader == null) {
            return;
        }
        long l = 0L;
        try {
            l = iRandomAccessReader.getFilePointer();
            int n = 13;
            int n2 = iRandomAccessReader.read(byArray, 0, n);
            if (n2 == n) {
                nArray[0] = byArray[0] & 0xFF;
                nArray[1] = byArray[1] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[2] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[3] & 0xFF;
                nArray[2] = byArray[7] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[4] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[5] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[6] & 0xFF;
                nArray[3] = byArray[11];
                nArray[4] = byArray[12];
            }
            iRandomAccessReader.seek(l + 11L);
            return;
        }
        catch (Exception exception) {
            nArray[0] = 127;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readPrevChunkHeader(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray) {
        nArray[0] = 127;
        if (iRandomAccessReader == null) {
            return;
        }
        try {
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            iRandomAccessReader2.seek(iRandomAccessReader2.getFilePointer() - 4L);
            iRandomAccessReader.read(byArray, 0, 4);
            int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4, (boolean)false);
            if (n <= 0) return;
            IRandomAccessReader iRandomAccessReader3 = iRandomAccessReader;
            iRandomAccessReader3.seek(iRandomAccessReader3.getFilePointer() - (long)(n + 4));
            iRandomAccessReader.read(byArray, 0, 13);
            nArray[0] = byArray[0] & 0xFF;
            nArray[1] = byArray[1] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[2] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[3] & 0xFF;
            nArray[2] = byArray[7] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[4] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[5] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[6] & 0xFF;
            nArray[3] = byArray[11] & 0xFF;
            nArray[4] = byArray[12] & 0xFF;
            IRandomAccessReader iRandomAccessReader4 = iRandomAccessReader;
            iRandomAccessReader4.seek(iRandomAccessReader4.getFilePointer() - 2L);
            return;
        }
        catch (Exception exception) {
            nArray[0] = 127;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket createPacket(IRandomAccessReader iRandomAccessReader, int[] nArray) {
        int n = nArray[1];
        int n2 = nArray[0];
        AMFPacket aMFPacket = new AMFPacket(n2, 0, n);
        try {
            byte[] byArray = aMFPacket.getData();
            int n3 = iRandomAccessReader.read(byArray, 0, n);
            if (n3 == byArray.length) return aMFPacket;
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(99 + 48), (String)"^qq\u007fvJ|{\u007fyoXSV/aqadrbXhi`iy4/`c}qxp{7j|{\u007fusy?)/260e .$,pk") + n3 + ":" + n);
            return aMFPacket;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(30 + -2), (String)"QxzvaSgb``tAD_$h~ho{uAsp\u007fpb7"), (Throwable)exception);
            return aMFPacket;
        }
    }

    /*
     * Exception decompiling
     */
    protected int directOutput(IRandomAccessReader var1_1, int[] var2_2, boolean var3_3, int var4_4, OutputStream var5_5, AMFObj var6_6, byte[] var7_7, int var8_8) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 943->1030)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutputBuf(int[] nArray, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        try {
            int n4;
            int n5;
            int n6;
            boolean bl2;
            boolean bl3;
            int n7;
            int n8;
            int n9;
            long l;
            block22: {
                block21: {
                    WOWZSession wOWZSession;
                    block19: {
                        block20: {
                            block18: {
                                l = (long)nArray[2] & 0xFFFFFFFFL;
                                n9 = nArray[1];
                                n8 = nArray[0];
                                int n10 = IFasterByteArrayOutputStream.getProtocol((OutputStream)outputStream);
                                n7 = aMFObj.getId();
                                boolean bl4 = aMFObj.isNew();
                                bl3 = bl4 | bl;
                                bl2 = false;
                                aMFObj.setNew(false);
                                if (n10 != 4) break block18;
                                wOWZSession = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)outputStream);
                                WOWZHeader wOWZHeader = new WOWZHeader();
                                wOWZHeader.cid = n7;
                                wOWZHeader.timecode = l;
                                wOWZHeader.isTimecodeAbs = bl3;
                                wOWZHeader.size = n9;
                                wOWZHeader.type = n8;
                                wOWZHeader.src = n;
                                wOWZHeader.updateFlags();
                                aMFObj.setSize(n9);
                                aMFObj.setType(n8);
                                aMFObj.setTimecode(l);
                                aMFObj.setLastSentAbsTimecode(bl4);
                                aMFObj.setSrc(n);
                                n3 += wOWZSession.sendStart(outputStream);
                                n3 += wOWZSession.writeHeader(outputStream, wOWZHeader);
                                if (n9 <= 0) break block19;
                                break block20;
                            }
                            n6 = 0;
                            byArray[0] = (byte)(0xFF & n7);
                            if (l < 0xFFFFFFL) break block21;
                            byArray[1] = -1;
                            byArray[2] = -1;
                            byArray[3] = -1;
                            bl2 = true;
                            break block22;
                        }
                        outputStream.write(byArray2, 0, n9);
                        n3 += n9;
                    }
                    return n3 += wOWZSession.sendStop(outputStream);
                }
                byArray[1] = (byte)(0xFFL & l >> 16);
                byArray[2] = (byte)(0xFFL & l >> 8);
                byArray[3] = (byte)(0xFFL & l);
            }
            byArray[4] = (byte)(0xFF & n9 >> 16);
            byArray[5] = (byte)(0xFF & n9 >> 8);
            byArray[6] = (byte)(0xFF & n9);
            byArray[7] = (byte)n8;
            n6 += 8;
            aMFObj.setSize(n9);
            aMFObj.setType(n8);
            aMFObj.setTimecode(l);
            if (bl3 || aMFObj.getSrc() != n) {
                byArray[8] = (byte)(0xFF & n);
                byArray[9] = (byte)(0xFF & n >> 8);
                byArray[10] = (byte)(0xFF & n >> 16);
                byArray[11] = (byte)(0xFF & n >> 24);
                n6 += 4;
                aMFObj.setSrc(n);
            }
            if (n7 >= 64) {
                n5 = n7 - 64;
                n4 = n5 > 255 ? 3 : 2;
                byte[] byArray3 = new byte[n4];
                if (n6 < 12) {
                    byArray3[0] = (byte)(64 + (n4 - 2));
                }
                byArray3[1] = (byte)(0xFF & n5);
                if (n4 == 3) {
                    byArray3[2] = (byte)(0xFF & n5 >> 8);
                }
                outputStream.write(byArray3, 0, n4);
                outputStream.write(byArray, 1, n6 - 1);
                n3 += n6 + 1;
            } else {
                if (n6 < 12) {
                    byArray[0] = (byte)(byArray[0] | 0x40);
                }
                outputStream.write(byArray, 0, n6);
                n3 += n6;
            }
            if (bl2) {
                byArray[0] = (byte)(0xFFL & l >> 24);
                byArray[1] = (byte)(0xFFL & l >> 16);
                byArray[2] = (byte)(0xFFL & l >> 8);
                byArray[3] = (byte)(0xFFL & l);
                outputStream.write(byArray, 0, 4);
                n3 = 4;
            }
            if (n9 <= 0) return n3;
            n5 = n9;
            n4 = 0;
            int n11 = 0;
            do {
                if (n4 > 0) {
                    if (n7 < 64) {
                        byArray[0] = (byte)(0xFF & n7 | 0xC0);
                        outputStream.write(byArray, 0, 1);
                        ++n3;
                    } else {
                        int n12 = n7 - 64;
                        int n13 = n12 <= 255 ? 2 : 3;
                        byArray[0] = (byte)(192 + (n13 - 2));
                        byArray[1] = (byte)(0xFF & n12);
                        if (n13 == 3) {
                            byArray[2] = (byte)(0xFF & n12 >> 8);
                        }
                        outputStream.write(byArray, 0, n13);
                        n3 += n13;
                    }
                    if (bl2) {
                        byArray[0] = (byte)(0xFFL & l >> 24);
                        byArray[1] = (byte)(0xFFL & l >> 16);
                        byArray[2] = (byte)(0xFFL & l >> 8);
                        byArray[3] = (byte)(0xFFL & l);
                        outputStream.write(byArray, 0, 4);
                        n3 = 4;
                    }
                }
                if ((n11 = n2) > n5 - n4) {
                    n11 = n5 - n4;
                }
                try {
                    outputStream.write(byArray2, n4, n11);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(JSON.replace((String)"HccahXnmik}V]D=p|dr{mUnhmkkBtd9$uthjeof,\u007fkntx|t4|xgmm:}uq{?", (int)(49 * 21)), (Throwable)exception);
                }
                n3 += n11;
            } while ((n4 += n11) != n5);
            return n3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error(Base64.subSequence((int)(23 - -49), (String)"\u0005,.\"-\u001f+.44 \u0015\u0018\u0003x31+?8(\u0012++046\u00011#f"), (Throwable)exception);
            return n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        if (this.duration == -1L) {
            IRandomAccessReader iRandomAccessReader = null;
            try {
                iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                iRandomAccessReader.open();
                this.readMetadata(iRandomAccessReader);
            }
            catch (Exception exception) {}
            if (iRandomAccessReader != null) {
                try {
                    iRandomAccessReader.close();
                }
                catch (Exception exception) {}
            }
            iRandomAccessReader = null;
        }
        if (this.duration == -1L) return 0L;
        long l = this.duration;
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.fileReader == null) return 0L;
        long l = this.fileReader.length();
        return l;
    }

    public String getPath() {
        return this.fileReader.getPath();
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public MediaReaderItem getMediaReaderItem() {
        return this.mediaReaderItem;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(List<AMFPacket> var1_1, PlaylistCursor var2_2, PlaylistWriteControl var3_3, PlaylistReaderWriteResults var4_4, long[] var5_5, FastPlaySettings var6_6) {
        var7_7 = 0;
        var8_8 = false;
        var9_9 = 0;
        var10_10 = var3_3.getMaxTC();
        var12_11 = 0;
        this.fileReader.setDirecton(1);
        if (true) ** GOTO lbl141
        do {
            block26: {
                block25: {
                    block27: {
                        block28: {
                            var14_14 = this.fileReader.getFilePointer();
                            v0 = this;
                            v0.readChunkHeader((IRandomAccessReader)v0.fileReader, this.chunkHeaderBuffer, this.chunkHeaderValues);
                            if (this.chunkHeaderValues[0] == 127) {
                                var4_4.setHitEnd(true);
                                // MONITOREXIT : var13_13
                                break;
                            }
                            var16_15 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                            if (var10_10 > 0L && var16_15 > var10_10) {
                                this.fileReader.seek(var14_14);
                                // MONITOREXIT : var13_13
                                break;
                            }
                            if ((long)this.chunkHeaderValues[1] > this.seekLargestFrame) {
                                this.seekLargestFrame = this.chunkHeaderValues[1];
                            }
                            var18_16 = false;
                            switch (this.chunkHeaderValues[0]) {
                                case 9: {
                                    if (!this.stream.isReceiveVideo()) break block27;
                                    if (var2_2.isWaitForKeyFrame()) {
                                        ** break;
                                    }
                                    ** GOTO lbl49
                                }
                                case 15: 
                                case 18: {
                                    var2_2.setLastBroadcastTC(var16_15);
                                    var2_2.incDataPacketCount();
                                    this.saveLastBroadcastPos = this.fileReader.getFilePointer();
                                    this.saveLastBroadcastSize = this.chunkHeaderValues[1];
                                    v1 = this;
                                    var19_20 = v1.createPacket((IRandomAccessReader)v1.fileReader, this.chunkHeaderValues);
                                    var19_20.setAbsTimecode(var16_15);
                                    var1_1.add(var19_20);
                                    var20_24 = var19_20.getSize();
                                    var7_7 += var20_24;
                                    var5_5[4] = var5_5[4] + (long)var20_24;
                                    var5_5[5] = var5_5[5] + 1L;
                                    var18_16 = true;
                                    break;
                                }
lbl47:
                                // 1 sources

                                if (!FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) break block27;
                                var2_2.setWaitForKeyFrame(false);
lbl49:
                                // 2 sources

                                if (!(var19_17 = var3_3.testVideoFrame(this.chunkHeaderValues[3]))) {
                                    if (!var19_17) {
                                        var5_5[6] = var5_5[6] + (long)this.chunkHeaderValues[1];
                                        var5_5[7] = var5_5[7] + 1L;
                                    }
                                    break block27;
                                } else {
                                    var2_2.setLastVideoTC(var16_15);
                                    var2_2.incVideoPacketCount();
                                    this.saveLastVideoPos = this.fileReader.getFilePointer();
                                    this.saveLastVideoSize = this.chunkHeaderValues[1];
                                    if ((long)var12_11 != var2_2.getVideoSampleDesc()) {
                                        var20_25 = var2_2.compareAndSetVideoCodecConfig(this.videoCodecConfig);
                                        if (!var20_25 && this.audioCodecConfig != null && this.videoCodecConfig != null) {
                                            var21_27 = new AMFPacket(9, 0, this.videoCodecConfig.length);
                                            var21_27.addData(this.videoCodecConfig, 0, this.videoCodecConfig.length);
                                            var21_27.setAbsTimecode(var16_15);
                                            var1_1.add(var21_27);
                                            var22_28 = var21_27.getSize();
                                            var7_7 += var22_28;
                                            var4_4.incVideoPackets();
                                            var5_5[2] = var5_5[2] + (long)var22_28;
                                            var5_5[3] = var5_5[3] + 1L;
                                        }
                                        var2_2.setVideoSampleDesc((long)var12_11);
                                    }
                                    v2 = this;
                                    var20_21 = v2.createPacket((IRandomAccessReader)v2.fileReader, this.chunkHeaderValues);
                                    var20_21.setAbsTimecode(var16_15);
                                    var1_1.add(var20_21);
                                    var21_26 = var20_21.getSize();
                                    var7_7 += var21_26;
                                    var18_16 = true;
                                    var4_4.incVideoPackets();
                                    var8_8 = true;
                                    var5_5[2] = var5_5[2] + (long)var21_26;
                                    var5_5[3] = var5_5[3] + 1L;
                                }
                                break block27;
                                case 8: {
                                    if (this.stream.isReceiveAudio()) break block28;
                                }
                            }
                            break block27;
                        }
                        if (!var3_3.isSkipAudio() && !var3_3.isAudioFilter()) {
                            var2_2.setLastAudioTC(var16_15);
                            var2_2.incAudioPacketCount();
                            var2_2.setLastAudioWasZero(this.chunkHeaderValues[1] == 0);
                            this.saveLastAudioPos = this.fileReader.getFilePointer();
                            this.saveLastAudioSize = this.chunkHeaderValues[1];
                            if ((long)var12_11 != var2_2.getAudioSampleDesc()) {
                                var19_18 = var2_2.compareAndSetAudioCodecConfig(this.audioCodecConfig);
                                if (!var19_18 && this.audioCodecConfig != null) {
                                    var20_22 = new AMFPacket(8, 0, this.audioCodecConfig.length);
                                    var20_22.addData(this.audioCodecConfig, 0, this.audioCodecConfig.length);
                                    var20_22.setAbsTimecode(var16_15);
                                    var1_1.add(var20_22);
                                    var21_26 = var20_22.getSize();
                                    var7_7 += var21_26;
                                    var4_4.incAudioPackets();
                                    var5_5[0] = var5_5[0] + (long)var21_26;
                                    var5_5[1] = var5_5[1] + 1L;
                                }
                                var2_2.setAudioSampleDesc((long)var12_11);
                            }
                            v3 = this;
                            var19_19 = v3.createPacket((IRandomAccessReader)v3.fileReader, this.chunkHeaderValues);
                            var19_19.setAbsTimecode(var16_15);
                            var1_1.add(var19_19);
                            var20_23 = var19_19.getSize();
                            var7_7 += var20_23;
                            var18_16 = true;
                            var4_4.incAudioPackets();
                            var5_5[0] = var5_5[0] + (long)var20_23;
                            var5_5[1] = var5_5[1] + 1L;
                        }
                    }
                    var4_4.setLastTC(var16_15);
                    ++var9_9;
                    v4 = this;
                    v4.skipPacket(v4.chunkHeaderValues, var18_16, true, 1);
                    if (var10_10 == 0L) break block25;
                    if (var16_15 <= var10_10) break block26;
                    // MONITOREXIT : var13_13
                    break;
                }
                if (var8_8 || var9_9 > 20) {
                    // MONITOREXIT : var13_13
                    break;
                }
            }
            // MONITOREXIT : var13_13
lbl141:
            // 2 sources

            // MONITORENTER : this.lock
        } while (!var2_2.isBreakLoop());
        // MONITOREXIT : var13_13
        var4_4.setTotalSize(var7_7);
        return var7_7;
    }
}

