/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.util.Base64;
import com.wowza.util.JSON;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStreamDestination;
import com.wowza.wms.transcoder.model.TranscoderStreamDestinationAudio;
import com.wowza.wms.transcoder.model.TranscoderStreamDestinationVideo;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroups;
import com.wowza.wms.transcoder.model.TranscoderStreamSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TranscoderStream {
    public static final String STREAMNAME_PLACEHOLDERNAME = "SourceStreamName";
    public static final String AUDIOBITRATE_PLACEHOLDERNAME = "SourceAudioBitrate";
    public static final String VIDEOBITRATE_PLACEHOLDERNAME = "SourceVideoBitrate";
    public static final String STREAMNAME_PLACEHOLDER = "${SourceStreamName}";
    public static final String AUDIOBITRATE_PLACEHOLDER = "${SourceAudioBitrate}";
    public static final String VIDEOBITRATE_PLACEHOLDER = "${SourceVideoBitrate}";
    public static final int TRANSCODING_PASSTHROUGH = -1;
    public static final int TRANSCODING_DISABLE = -2;
    public static final int ENCODING_IMPLEMENTATION_DEFAULT = 0;
    public static final int DECODING_IMPLEMENTATION_DEFAULT = 0;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_DEFAULT = 0;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC = 1;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_NVIDIACUDA = 2;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_OPENCL = 3;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC2 = 4;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_NVIDIACUDA2 = 5;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_NVENC = 6;
    public static final int ENCODING_VIDEO_IMPLEMENTATION_H264_X264 = 7;
    public static final int DECODING_VIDEO_IMPLEMENTATION_DEFAULT = 0;
    public static final int DECODING_VIDEO_IMPLEMENTATION_H264_QUICKSYNC = 1;
    public static final int ENCODING_AUDIO_IMPLEMENTATION_DEFAULT = 0;
    public static final int DECODING_AUDIO_IMPLEMENTATION_DEFAULT = 0;
    public static final int FRAMESIZE_FITMODE_LETTERBOX = 1;
    public static final int FRAMESIZE_FITMODE_FITWIDTH = 2;
    public static final int FRAMESIZE_FITMODE_FITHEIGHT = 3;
    public static final int FRAMESIZE_FITMODE_CROP = 4;
    public static final int FRAMESIZE_FITMODE_STRETCH = 5;
    public static final int FRAMESIZE_FITMODE_MATCHSOURCE = 6;
    public static final int FOURCC_YV12 = 842094169;
    public static final int FOURCC_I420 = 808596553;
    public static final int FOURCC_NV12 = 842094158;
    public static final int FOURCC_ARGB = 1111970369;
    public static final int FOURCC_BGRA = 1095911234;
    public static final int FOURCC_VUYA = 1096373590;
    public static final long SCALER_MODE_NEIGHBOUR = 0L;
    public static final long SCALER_MODE_BILINEAR = 2L;
    public static final long SCALER_MODE_POLYPHASE8 = 3L;
    public static final long SCALER_MODE_BEST = 1L;
    public static final long SCALER_MODE_INTERLACED = 256L;
    public static final long SCALER_MODE_HOR_PIN_BEG = 4096L;
    public static final long SCALER_MODE_HOR_PIN_END = 8192L;
    public static final long SCALER_MODE_VERT_PIN_BEG = 16384L;
    public static final long SCALER_MODE_VERT_PIN_END = 32768L;
    public static final long SCALER_MODE_INP_ITU601 = 0x1000000L;
    public static final long SCALER_MODE_INP_ITU709 = 0x2000000L;
    public static final long SCALER_MODE_OUT_ITU601 = 0x10000000L;
    public static final long SCALER_MODE_OUT_ITU709 = 0x20000000L;
    public static final long SCALER_MODE_BICUBIC = 0x100000L;
    public static final long SCALER_MODE_B_SPLINE = 0L;
    public static final long SCALER_MODE_NOTCH = 0x200000L;
    public static final long SCALER_MODE_CATMULL_ROM = 0x400000L;
    public static final long SCALER_MODE_MITCHELL = 0x600000L;
    private TranscoderStreamSource a = new TranscoderStreamSource();
    private Map<String, TranscoderStreamDestination> b = new HashMap<String, TranscoderStreamDestination>();
    private TranscoderStreamNameGroups c = new TranscoderStreamNameGroups();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        int n = liveStreamTranscoder.getTranscoderType();
        if (n != 1) {
            return;
        }
        this.c.init(liveStreamTranscoder, transcoderStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        if (this.b.size() > 0) return false;
        return true;
    }

    public void close(LiveStreamTranscoder liveStreamTranscoder) {
    }

    public void shutdown(LiveStreamTranscoder liveStreamTranscoder) {
        this.c.shutdown(liveStreamTranscoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfPassThroughAudioEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationAudio transcoderStreamDestinationAudio = transcoderStreamDestination.getAudio();
                if (transcoderStreamDestinationAudio == null || !transcoderStreamDestinationAudio.isPassThrough()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfTrueAudioEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationAudio transcoderStreamDestinationAudio = transcoderStreamDestination.getAudio();
                if (transcoderStreamDestinationAudio == null || transcoderStreamDestinationAudio.isPassThrough() || transcoderStreamDestinationAudio.isDisable()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfPassThroughVideoEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationVideo transcoderStreamDestinationVideo = transcoderStreamDestination.getVideo();
                if (transcoderStreamDestinationVideo == null || !transcoderStreamDestinationVideo.isPassThrough()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountOfTrueVideoEncodes() {
        int n = 0;
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            Iterator<TranscoderStreamDestination> iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                TranscoderStreamDestination transcoderStreamDestination = iterator.next();
                TranscoderStreamDestinationVideo transcoderStreamDestinationVideo = transcoderStreamDestination.getVideo();
                if (transcoderStreamDestinationVideo == null || transcoderStreamDestinationVideo.isPassThrough() || transcoderStreamDestinationVideo.isDisable()) continue;
                ++n;
            }
            return n;
        }
    }

    public TranscoderStreamSource getSource() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putDestination(String string, TranscoderStreamDestination transcoderStreamDestination) {
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            this.b.put(string, transcoderStreamDestination);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamDestination getDestination(String string) {
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            return this.b.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamDestination removeDestination(String string) {
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            return this.b.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getDestinationNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            hashSet.addAll(this.b.keySet());
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TranscoderStreamDestination> getDestinations() {
        ArrayList<TranscoderStreamDestination> arrayList = new ArrayList<TranscoderStreamDestination>();
        Map<String, TranscoderStreamDestination> map = this.b;
        synchronized (map) {
            arrayList.addAll(this.b.values());
            return arrayList;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Base64.subSequence((int)(63 + 61), (String)"'\t,>nral`lh`[}xnm`4/"));
        stringBuffer.append(Base64.subSequence((int)(211 / 40), (String)"virzjo6.") + this.a.toString() + Base64.subSequence((int)(189 / 33), (String)"'*'"));
        stringBuffer.append(JSON.replace((String)"3=*.22<*6oo?", (int)(84 + 35)));
        List<TranscoderStreamDestination> list = this.getDestinations();
        Iterator<TranscoderStreamDestination> iterator = list.iterator();
        int n = 0;
        boolean bl = true;
        while (true) {
            TranscoderStreamDestination transcoderStreamDestination;
            if (!bl || (bl = false) || !true) {
                stringBuffer.append(transcoderStreamDestination.toString());
                ++n;
            }
            if (!iterator.hasNext()) {
                stringBuffer.append("}");
                return stringBuffer.toString();
            }
            transcoderStreamDestination = iterator.next();
            if (n <= 0) continue;
            stringBuffer.append(JSON.replace((String)"/$", (int)(25 * 27)));
        }
    }

    public TranscoderStreamNameGroups getNameGroups() {
        return this.c;
    }
}

