/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.util.Base64;
import com.wowza.util.JSON;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.transcoder.model.ITranscoderWorker;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderSession;
import com.wowza.wms.transcoder.model.TranscoderSessionNative;
import com.wowza.wms.vhost.ThreadPool;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class TranscoderWorkerBase
implements Runnable,
ITranscoderWorker {
    protected boolean isRunning = false;
    protected Object lock = new Object();
    protected ExecutorService threadPool = null;
    protected ThreadPool threadPoolVHost = null;
    protected int maxCycleCount = 20;
    protected LiveStreamTranscoder liveStreamTranscoder = null;
    protected TranscoderSession transcodingSession = null;
    protected TranscoderSessionNative nativeSession = null;
    protected long nativeObj = 0L;
    protected boolean active = true;
    protected long frameCount = 0L;
    protected String contextStr = Base64.subSequence((int)(35 * 25), (String)"\u001f>, <3>66&\u00029%3<(\u0019=.;");
    protected boolean useVHostThreadPool = false;

    @Override
    public String getContextStr() {
        return this.contextStr;
    }

    protected abstract boolean isWorkWaiting();

    /*
     * Enabled aggressive block sorting
     */
    public void init(LiveStreamTranscoder liveStreamTranscoder) {
        this.liveStreamTranscoder = liveStreamTranscoder;
        this.useVHostThreadPool = liveStreamTranscoder.getProperties().getPropertyBoolean(Base64.subSequence((int)(93 + 80), (String)"x}jFY}``A~e}x~Ksrr"), this.useVHostThreadPool);
        if (this.useVHostThreadPool) {
            this.threadPoolVHost = liveStreamTranscoder.getAppInstance().getVHost().getHandlerThreadPool();
            WMSLoggerFactory.getLogger(TranscoderWorkerBase.class).info(JSON.replace((String)"Qtffzidhh|X\u007fcyvfWwd}7suuiE", (int)(3 * 55)) + liveStreamTranscoder.getContextStr() + Base64.subSequence((int)(934 / 168), (String)"X&R{`dl,[F`ce2g|gsv|9jtsq0"));
        }
        this.transcodingSession = liveStreamTranscoder.getTranscodingSession();
        this.nativeSession = this.transcodingSession.getNativeSession();
        this.nativeObj = this.transcodingSession.getNativeObj();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doNativeLogging() {
        if (this.transcodingSession == null) {
            return;
        }
        this.transcodingSession.doNativeLogging();
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runIfNeeded() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) return;
            if (!this.isWorkWaiting()) return;
            this.isRunning = true;
            if (this.threadPoolVHost != null) {
                this.threadPoolVHost.execute((Runnable)this);
            } else {
                if (this.threadPool == null) {
                    this.threadPool = Executors.newSingleThreadExecutor();
                }
                this.threadPool.submit(this);
            }
            return;
        }
    }

    public int getMaxCycleCount() {
        return this.maxCycleCount;
    }

    public void setMaxCycleCount(int n) {
        this.maxCycleCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActive(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.active = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deactivate() {
        Object object = this.lock;
        synchronized (object) {
            this.active = false;
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.threadPool == null) return;
                this.threadPool.shutdown();
                return;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(TranscoderWorkerBase.class).info(JSON.replace((String)"\u001c;+%?.!+5#\u0005<&>3%\u001a8)>r9;,43-:\u001f1.5-(.;#\"\"\u0012", (int)(17 + 55)));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long incFrameCount() {
        Object object = this.lock;
        synchronized (object) {
            long l = this.frameCount;
            this.frameCount = l + 1L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getFrameCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.frameCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFrameCount(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.frameCount = l;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEncoderInUse() {
        Object object = this.lock;
        synchronized (object) {
            if (this.frameCount <= 0L) return false;
            return true;
        }
    }
}

