/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto;

import java.security.GeneralSecurityException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.util.Base64;
import org.restlet.ext.crypto.internal.CryptoUtils;
import org.restlet.security.ChallengeAuthenticator;

public class CookieAuthenticator
extends ChallengeAuthenticator {
    private volatile String cookieName = "Credentials";
    private volatile String encryptAlgorithm = "AES";
    private volatile byte[] encryptSecretKey;
    private volatile String identifierFormName = "login";
    private volatile boolean interceptingLogin = true;
    private volatile boolean interceptingLogout = true;
    private volatile String loginFormPath;
    private volatile String loginPath = "/login";
    private volatile String logoutPath = "/logout";
    private volatile int maxCookieAge;
    private volatile String redirectQueryName;
    private volatile String secretFormName = "password";

    public CookieAuthenticator(Context context, boolean optional, String realm, byte[] encryptSecretKey) {
        super(context, optional, ChallengeScheme.HTTP_COOKIE, realm);
        this.encryptSecretKey = encryptSecretKey;
        this.maxCookieAge = -1;
        this.redirectQueryName = "targetUri";
    }

    public CookieAuthenticator(Context context, String realm, byte[] encryptSecretKey) {
        this(context, false, realm, encryptSecretKey);
    }

    protected void attemptRedirect(Request request, Response response) {
        String targetUri = request.getResourceRef().getQueryAsForm().getFirstValue(this.getRedirectQueryName());
        if (targetUri != null) {
            response.redirectSeeOther(Reference.decode(targetUri));
        }
    }

    protected boolean authenticate(Request request, Response response) {
        Cookie credentialsCookie = request.getCookies().getFirst(this.getCookieName());
        if (credentialsCookie != null) {
            request.setChallengeResponse(this.parseCredentials(credentialsCookie.getValue()));
        }
        return super.authenticate(request, response);
    }

    protected int authenticated(Request request, Response response) {
        try {
            CookieSetting credentialsCookie = this.getCredentialsCookie(request, response);
            credentialsCookie.setValue(this.formatCredentials(request.getChallengeResponse()));
            credentialsCookie.setMaxAge(this.getMaxCookieAge());
        }
        catch (GeneralSecurityException e) {
            this.getLogger().log(Level.SEVERE, "Could not format credentials cookie", e);
        }
        return super.authenticated(request, response);
    }

    protected int beforeHandle(Request request, Response response) {
        if (this.isLoggingIn(request, response)) {
            this.login(request, response);
        } else if (this.isLoggingOut(request, response)) {
            return this.logout(request, response);
        }
        return super.beforeHandle(request, response);
    }

    public void challenge(Response response, boolean stale) {
        if (this.getLoginFormPath() == null) {
            super.challenge(response, stale);
        } else {
            Reference ref = response.getRequest().getResourceRef();
            String redirectQueryName = this.getRedirectQueryName();
            String redirectQueryValue = ref.getQueryAsForm().getFirstValue(redirectQueryName, "");
            if ("".equals(redirectQueryValue)) {
                redirectQueryValue = new Reference(this.getLoginFormPath()).addQueryParameter(redirectQueryName, ref.toString()).toString();
            }
            response.redirectSeeOther(redirectQueryValue);
        }
    }

    protected String formatCredentials(ChallengeResponse challenge) throws GeneralSecurityException {
        StringBuffer sb = new StringBuffer();
        StringBuffer isb = new StringBuffer();
        String timeIssued = Long.toString(System.currentTimeMillis());
        int i = timeIssued.length();
        sb.append(timeIssued);
        isb.append(i);
        String identifier = challenge.getIdentifier();
        sb.append('/');
        sb.append(identifier);
        isb.append(',').append(i += identifier.length() + 1);
        sb.append('/');
        sb.append(challenge.getSecret());
        sb.append('/');
        sb.append(isb);
        return Base64.encode(CryptoUtils.encrypt(this.getEncryptAlgorithm(), this.getEncryptSecretKey(), sb.toString()), false);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    protected CookieSetting getCredentialsCookie(Request request, Response response) {
        CookieSetting credentialsCookie = response.getCookieSettings().getFirst(this.getCookieName());
        if (credentialsCookie == null) {
            credentialsCookie = new CookieSetting(this.getCookieName(), null);
            credentialsCookie.setAccessRestricted(true);
            if (request.getRootRef() != null) {
                String p = request.getRootRef().getPath();
                credentialsCookie.setPath(p == null ? "/" : p);
            }
            response.getCookieSettings().add(credentialsCookie);
        }
        return credentialsCookie;
    }

    public String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    public byte[] getEncryptSecretKey() {
        return this.encryptSecretKey;
    }

    public String getIdentifierFormName() {
        return this.identifierFormName;
    }

    public String getLoginFormPath() {
        return this.loginFormPath;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public int getMaxCookieAge() {
        return this.maxCookieAge;
    }

    public String getRedirectQueryName() {
        return this.redirectQueryName;
    }

    public String getSecretFormName() {
        return this.secretFormName;
    }

    public boolean isInterceptingLogin() {
        return this.interceptingLogin;
    }

    public boolean isInterceptingLogout() {
        return this.interceptingLogout;
    }

    protected boolean isLoggingIn(Request request, Response response) {
        return this.isInterceptingLogin() && this.getLoginPath().equals(request.getResourceRef().getRemainingPart(false, false)) && Method.POST.equals(request.getMethod());
    }

    protected boolean isLoggingOut(Request request, Response response) {
        return this.isInterceptingLogout() && this.getLogoutPath().equals(request.getResourceRef().getRemainingPart(false, false)) && (Method.GET.equals(request.getMethod()) || Method.POST.equals(request.getMethod()));
    }

    protected void login(Request request, Response response) {
        Form form = new Form(request.getEntity());
        Parameter identifier = (Parameter)form.getFirst(this.getIdentifierFormName());
        Parameter secret = (Parameter)form.getFirst(this.getSecretFormName());
        ChallengeResponse cr = new ChallengeResponse(this.getScheme(), identifier != null ? identifier.getValue() : null, secret != null ? secret.getValue() : null);
        request.setChallengeResponse(cr);
        this.attemptRedirect(request, response);
    }

    protected int logout(Request request, Response response) {
        request.setChallengeResponse(null);
        CookieSetting credentialsCookie = this.getCredentialsCookie(request, response);
        credentialsCookie.setMaxAge(0);
        this.attemptRedirect(request, response);
        return 2;
    }

    protected ChallengeResponse parseCredentials(String cookieValue) {
        byte[] encrypted = Base64.decode(cookieValue);
        if (encrypted == null) {
            this.getLogger().warning("Cannot decode cookie credentials : " + cookieValue);
        }
        try {
            String decrypted = CryptoUtils.decrypt(this.getEncryptAlgorithm(), this.getEncryptSecretKey(), encrypted);
            int lastSlash = decrypted.lastIndexOf(47);
            String[] indexes = decrypted.substring(lastSlash + 1).split(",");
            int identifierIndex = Integer.parseInt(indexes[0]);
            int secretIndex = Integer.parseInt(indexes[1]);
            ChallengeResponse cr = new ChallengeResponse(this.getScheme());
            cr.setRawValue(cookieValue);
            cr.setTimeIssued(Long.parseLong(decrypted.substring(0, identifierIndex)));
            cr.setIdentifier(decrypted.substring(identifierIndex + 1, secretIndex));
            cr.setSecret(decrypted.substring(secretIndex + 1, lastSlash));
            return cr;
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Unable to decrypt cookie credentials", e);
            return null;
        }
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setEncryptAlgorithm(String secretAlgorithm) {
        this.encryptAlgorithm = secretAlgorithm;
    }

    public void setEncryptSecretKey(byte[] secretKey) {
        this.encryptSecretKey = secretKey;
    }

    public void setIdentifierFormName(String loginInputName) {
        this.identifierFormName = loginInputName;
    }

    public void setInterceptingLogin(boolean intercepting) {
        this.interceptingLogin = intercepting;
    }

    public void setInterceptingLogout(boolean intercepting) {
        this.interceptingLogout = intercepting;
    }

    public void setLoginFormPath(String loginFormPath) {
        this.loginFormPath = loginFormPath;
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public void setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
    }

    public void setMaxCookieAge(int timeout) {
        this.maxCookieAge = timeout;
    }

    public void setRedirectQueryName(String redirectQueryName) {
        this.redirectQueryName = redirectQueryName;
    }

    public void setSecretFormName(String passwordInputName) {
        this.secretFormName = passwordInputName;
    }
}

