/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.security.LocalVerifier;
import org.restlet.security.SecretVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestVerifier<T extends SecretVerifier>
extends SecretVerifier {
    private String algorithm;
    private String wrappedAlgorithm;
    private T wrappedVerifier;

    public DigestVerifier(String algorithm, T wrappedVerifier, String wrappedAlgorithm) {
        this.algorithm = algorithm;
        this.wrappedAlgorithm = wrappedAlgorithm;
        this.wrappedVerifier = wrappedVerifier;
    }

    protected char[] digest(String identifier, char[] secret, String algorithm) {
        return DigestUtils.digest(secret, algorithm);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getWrappedAlgorithm() {
        return this.wrappedAlgorithm;
    }

    public char[] getWrappedSecret(String identifier) {
        char[] result = null;
        if (this.getWrappedVerifier() instanceof LocalVerifier) {
            LocalVerifier localVerifier = (LocalVerifier)this.getWrappedVerifier();
            result = localVerifier.getLocalSecret(identifier);
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The wrapped verifier must be a LocalVerifier to allow digesting of wrapped secrets.");
        }
        return result;
    }

    public char[] getWrappedSecretDigest(String identifier) {
        char[] result = null;
        if (this.getWrappedAlgorithm() == null) {
            result = this.digest(identifier, this.getWrappedSecret(identifier), this.getAlgorithm());
        } else if (this.getAlgorithm().equals(this.getWrappedAlgorithm())) {
            result = this.getWrappedSecret(identifier);
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The digest algorithms can't be different.");
        }
        return result;
    }

    public T getWrappedVerifier() {
        return this.wrappedVerifier;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setWrappedAlgorithm(String wrappedAlgorithm) {
        this.wrappedAlgorithm = wrappedAlgorithm;
    }

    public void setWrappedVerifier(T wrappedVerifier) {
        this.wrappedVerifier = wrappedVerifier;
    }

    @Override
    public int verify(String identifier, char[] secret) {
        int result = -1;
        char[] secretDigest = secret;
        if (this.getAlgorithm() == null) {
            if (this.getWrappedAlgorithm() != null) {
                secretDigest = this.digest(identifier, secret, this.getWrappedAlgorithm());
            }
            result = ((SecretVerifier)this.getWrappedVerifier()).verify(identifier, secretDigest);
        } else if (this.getWrappedAlgorithm() == null) {
            result = DigestVerifier.compare(secretDigest, this.getWrappedSecretDigest(identifier)) ? 4 : -1;
        } else if (this.getAlgorithm().equals(this.getWrappedAlgorithm())) {
            result = ((SecretVerifier)this.getWrappedVerifier()).verify(identifier, secretDigest);
        } else {
            result = 3;
            Context.getCurrentLogger().log(Level.WARNING, "The input and output algorithms can't be different.");
        }
        return result;
    }
}

