/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.util;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.JSON;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerSanJoseUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String SESSIONIDPLACHOLDER = "{session-id}";
    public static final String BITRATEPLACHOLDER = "{bitrate}";
    public static final String KBITRATEPLACHOLDER = "{kbitrate}";
    public static final String BOOTSTRAPIDPLACEHOLDER = "{bootstrapId}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYHEXSTRPLACHOLDER = "{query-hex}";
    public static final String SECURETOKENPLACEHOLDER = "{secureToken}";
    public static final String PLAYLISTPLACHOLDER = "playlist_b{bitrate}_w{session-id}{secureToken}.abst{query}";
    public static final String PLAYSTARTPLACHOLDER = "{playStart}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDuration}";
    public static final String PLAYSEEKPLACHOLDER = "{playSeek}";
    public static final String NGRPPLACHOLDER = "{ngrp}";
    public static final String RANDOMPLACHOLDER = "{randomId}";
    public static final String MEDIAPLACHOLDER = "media{randomId}_b{bitrate}_w{session-id}{query-hex}{secureToken}.abst/";
    public static final String VODMEDIAPLACHOLDER = "media_b{bitrate}_w{session-id}{query-hex}{playStart}{playDuration}{playSeek}{ngrp}{secureToken}.abst/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk, SanJoseEncInfo sanJoseEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingSanJoseBlock> arrayList;
        List<LiveStreamingSanJoseBlock> list;
        Cipher cipher;
        if (sanJoseEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info(JSON.replace((String)"\u00117)%\u001261!$+\u0017)*!.8$4*\"\u00023=\u001e:%2v?6./5\u000e>cjgww?&flmHdycmvSpagxpEr{lhrhdNmowkgaw<'", (int)(31 * 3)) + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(sanJoseEncInfo.getEncKeyBytes(), Base64.subSequence((int)(11 + 50), (String)"\\[L"));
            long l = liveStreamPacketizerSanJoseChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(JSON.replace((String)"E@U(KKI$\\FM\\'Aswp|xp", (int)(1211 / 247)), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerSanJoseChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingSanJoseBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error(JSON.replace((String)"IoqmZ~yilc_qryv`|lrjJ{uVrmzUukow+cik{s{xNfz~z(3UPE:)+\";ys}m916*++f", (int)(1316 / 224)), (Throwable)exception);
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerSanJoseChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = list.get(n);
            n4 += liveStreamingSanJoseBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen()) : cipher.update(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingSanJoseBlock liveStreamingSanJoseBlock2 = new LiveStreamingSanJoseBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingSanJoseBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SanJoseEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + JSON.replace((String)"1+$;", (int)(-51 - 14)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(Base64.subSequence((int)(26 - 6), (String)"agz"));
            if (string3 != null || (string3 = (String)object.get(Base64.subSequence((int)(30 + 107), (String)"|xb"))) != null || (string3 = (String)object.get(JSON.replace((String)">+/%36***53:,+&%#)b14!bfm{\"*5", (int)(13 * 17)))) != null || (string3 = (String)object.get(Base64.subSequence((int)(-45 - 3), (String)"3$\"6&!?97*.)9<36.&o\"!6wupd?9%"))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.subSequence((int)(94 + 79), (String)"fkv"))) != null || (string2 = (String)object.get(Base64.subSequence((int)(19 * 19), (String)"*?;)?:&>>!'&07:17=v=8-n29/ha|"))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() != 32) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.subSequence((int)(55 * 63), (String)"Ec}i^z}up\u007fCuv}rlp`~n^koesvjjj(nf`~1,Fkv0}w}sa~7qwytno{|4ob\u000e162g*,jzzm,6$4!s|fdw;1;)=>*:22kc(*( h\u0012") + file + JSON.replace((String)"Y?&", (int)(870 / 204)) + string2.length());
                } else {
                    byArray = BufferUtils.decodeHexString((String)string2);
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new SanJoseEncInfo(string2, byArray, string3);
    }
}

