/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer;

import com.wowza.util.Base64;
import com.wowza.util.JSON;

public class CupertinoStreamingRendition {
    public static final int RENDITION_AUDIOONLY = 1;
    public static final int RENDITION_VIDEOONLY = 2;
    public static final int RENDITION_KEYFRAMEONLY = 4;
    public static final int RENDITION_AUDIOVIDEO = 3;
    public int rendition = 3;

    public CupertinoStreamingRendition() {
    }

    public CupertinoStreamingRendition(int n) {
        this.rendition = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CupertinoStreamingRendition(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.rendition = 1;
            return;
        }
        if (bl2) {
            this.rendition = 2;
            return;
        }
        if (!bl3) {
            this.rendition = 3;
            return;
        }
        this.rendition = 4;
    }

    public static CupertinoStreamingRendition createAudioVideoRendition() {
        return new CupertinoStreamingRendition(3);
    }

    public static CupertinoStreamingRendition createAudioOnlyRendition() {
        return new CupertinoStreamingRendition(1);
    }

    public static CupertinoStreamingRendition createVideoOnlyRendition() {
        return new CupertinoStreamingRendition(2);
    }

    public static CupertinoStreamingRendition createKeyFrameOnlyRendition() {
        return new CupertinoStreamingRendition(4);
    }

    public int getRendition() {
        return this.rendition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAudioOnly() {
        if (this.rendition != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVideoOnly() {
        if (this.rendition != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isKeyFrameOnly() {
        if (this.rendition != 4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAudioVideo() {
        if (this.rendition != 3) return false;
        return true;
    }

    public String toString() {
        switch (this.rendition) {
            case 4: {
                return JSON.replace((String)"NC^N[KFIB@CI", (int)(382 / 68));
            }
            case 2: {
                return JSON.replace((String)"RLBBGFDGU", (int)(1060 / 251));
            }
            default: {
                return Base64.subSequence((int)(49 * 59), (String)"\u001e\u0002\u0006\u0000\u0000\u0007\u001f");
            }
            case 1: {
                return Base64.subSequence((int)(21 * 27), (String)"VM]STSSRF");
            }
            case 3: 
        }
        return JSON.replace((String)"EPBNG_COIB", (int)(337 / 70));
    }
}

