/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.codecconfig;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.h265.H265CodecConfigInfo;
import com.wowza.wms.media.h265.H265Utils;
import com.wowza.wms.mediawriter.h264.codecconfig.QTWriterTrackCodecConfigVideo;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterUtils;
import com.wowza.wms.stream.IMediaStream;
import java.util.Arrays;

public class QTWriterCodecConfigH264
extends QTWriterTrackCodecConfigVideo {
    private byte[] a = null;
    private byte[] b = null;
    private H264CodecConfigInfo c = null;
    private H265CodecConfigInfo d = null;

    private final H264CodecConfigInfo a() {
        return this.c;
    }

    private final H265CodecConfigInfo b() {
        return this.d;
    }

    public byte[] getH264CodecConfig() {
        return this.a;
    }

    public byte[] getH265CodecConfig() {
        return this.b;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setH264CodecConfig(byte[] byArray) {
        this.a = byArray;
        this.c = byArray != null ? H264Utils.decodeAVCC((byte[])byArray) : null;
        if (this.c == null) return;
        QTWriterCodecConfigH264 qTWriterCodecConfigH264 = this;
        qTWriterCodecConfigH264.setVideoWidth(qTWriterCodecConfigH264.c.width);
        QTWriterCodecConfigH264 qTWriterCodecConfigH2642 = this;
        qTWriterCodecConfigH2642.setVideoHeight(qTWriterCodecConfigH2642.c.height);
        WMSLoggerFactory.getLogger(QTWriterCodecConfigH264.class).debug(Base64.subSequence((int)(30 - 42), (String)"\u0005\u0001\u0001%1-?)\u0014ohkCnffgFiin`m%\u007fhzG\"'&P{qst[vt}uz$?") + this.c.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setH265CodecConfig(byte[] byArray) {
        this.b = byArray;
        this.d = byArray != null ? H265Utils.decodeHVCC((byte[])byArray) : null;
        if (this.d == null) return;
        QTWriterCodecConfigH264 qTWriterCodecConfigH264 = this;
        qTWriterCodecConfigH264.setVideoWidth(qTWriterCodecConfigH264.d.getFrameWidth());
        QTWriterCodecConfigH264 qTWriterCodecConfigH2642 = this;
        qTWriterCodecConfigH2642.setVideoHeight(qTWriterCodecConfigH2642.d.getFrameHeight());
        WMSLoggerFactory.getLogger(QTWriterCodecConfigH264.class).debug(Base64.subSequence((int)(-24 - -18), (String)"\u000b\u000f\u000b/7+esJ121EhlliHcchfw?av`]$!,Zu\u007fy~]pngkd>%") + this.d.toString());
    }

    public int getH264CodecConfigLength() {
        if (this.a == null) {
            return 0;
        }
        return this.a.length;
    }

    public int getH265CodecConfigLength() {
        if (this.b == null) {
            return 0;
        }
        return this.b.length;
    }

    public static void extractH264CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l) {
        QTWriterCodecConfigH264.extractH264CodecInfoFromStream(iMediaStream, qTWriterContextTrack, l, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractH264CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l, AMFPacket aMFPacket) {
        try {
            int n = 5;
            AMFPacket aMFPacket2 = aMFPacket != null ? aMFPacket : iMediaStream.getVideoCodecConfigPacket(l);
            if (aMFPacket2 == null) {
                return;
            }
            if (aMFPacket2.getSize() < 5) {
                return;
            }
            byte[] byArray = aMFPacket2.getData();
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            QTWriterCodecConfigH264 qTWriterCodecConfigH264 = new QTWriterCodecConfigH264();
            qTWriterCodecConfigH264.setH264CodecConfig(byArray2);
            qTWriterContextTrack.addCodecConfig(qTWriterCodecConfigH264, true);
            qTWriterContextTrack.setSampleType(0);
            H264CodecConfigInfo h264CodecConfigInfo = qTWriterCodecConfigH264.a();
            if (h264CodecConfigInfo == null) return;
            WMSLoggerFactory.getLogger(QTWriterUtils.class).debug(JSON.replace((String)"\u001a\u0018\u001a<&$4 \u0006 <:$by\u0012ijid\u007f", (int)(37 - -38)) + h264CodecConfigInfo.toString());
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(Base64.subSequence((int)(-25 - 35), (String)"\u0015\u0011\u00115!=/9\u0004\u007fx{\u0013>667\u001699>0=u9%*-!\"6\u000bvsr\u0004'-/(\u0005#( \u0016#=>\u0007!$294\u0001") + qTWriterContextTrack.getContext().getOutPath() + Base64.subSequence((int)(914 / 187), (String)"Y%"), (Throwable)exception);
            return;
        }
    }

    public static void extractH265CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l) {
        QTWriterCodecConfigH264.extractH265CodecInfoFromStream(iMediaStream, qTWriterContextTrack, l, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractH265CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l, AMFPacket aMFPacket) {
        try {
            int n = 5;
            AMFPacket aMFPacket2 = aMFPacket != null ? aMFPacket : iMediaStream.getVideoCodecConfigPacket(l);
            if (aMFPacket2 == null) {
                return;
            }
            if (aMFPacket2.getSize() >= 5) {
                byte[] byArray = aMFPacket2.getData();
                byte[] byArray2 = new byte[byArray.length - n];
                System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                QTWriterCodecConfigH264 qTWriterCodecConfigH264 = new QTWriterCodecConfigH264();
                qTWriterCodecConfigH264.setH265CodecConfig(byArray2);
                qTWriterContextTrack.addCodecConfig(qTWriterCodecConfigH264, true);
                qTWriterContextTrack.setSampleType(6);
                H265CodecConfigInfo h265CodecConfigInfo = qTWriterCodecConfigH264.b();
                if (h265CodecConfigInfo == null) return;
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug(Base64.subSequence((int)(59 * 61), (String)"^DF`z`pdBlpvh&=V-658#") + h265CodecConfigInfo.toString());
                return;
            }
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(Base64.subSequence((int)(7 * 45), (String)"JHJlv4$0\u000bvsr\u0004'-/(\u000f\" )96|6,!$6;-\u0012iji\u001d0$$!\n*#)\u0001:&'\u00188?+.=\n") + qTWriterContextTrack.getContext().getOutPath() + JSON.replace((String)"]!", (int)(34 + 126)), (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof QTWriterCodecConfigH264)) return bl;
        QTWriterCodecConfigH264 qTWriterCodecConfigH264 = (QTWriterCodecConfigH264)object;
        if (!Arrays.equals(this.a, qTWriterCodecConfigH264.a)) return bl;
        if (!Arrays.equals(this.b, qTWriterCodecConfigH264.b)) return bl;
        return super.equals(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int parse(byte[] byArray) {
        int n = super.getSize() + 20;
        String string = BufferUtils.byteArrayToString((byte[])byArray, (int)n, (int)4);
        if (string.equals(JSON.replace((String)"gqkJ", (int)(1164 / 167)))) {
            n = super.parse(byArray);
            if (n <= 0) return n;
            int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n);
            byte[] byArray2 = new byte[n2 - 8];
            System.arraycopy(byArray, n += 8, byArray2, 0, n2 - 8);
            this.setH264CodecConfig(byArray2);
            return n += n2 - 8;
        }
        if (!string.equals(Base64.subSequence((int)(23 - 43), (String)"$;-\f"))) {
            return 0;
        }
        n = super.parse(byArray);
        if (n <= 0) return n;
        int n3 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n);
        byte[] byArray3 = new byte[n3 - 8];
        System.arraycopy(byArray, n += 8, byArray3, 0, n3 - 8);
        this.setH265CodecConfig(byArray3);
        return n += n3 - 8;
    }
}

