/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CallingFormat;
import com.amazon.s3.GetResponse;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.LocationResponse;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class AWSAuthConnection {
    public static final String LOCATION_DEFAULT = null;
    public static final String LOCATION_EU = "EU";
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;

    public AWSAuthConnection(String string, String string2) {
        this(string, string2, true);
    }

    public AWSAuthConnection(String string, String string2, boolean bl) {
        this(string, string2, bl, "s3.amazonaws.com");
    }

    public AWSAuthConnection(String string, String string2, boolean bl, String string3) {
        this(string, string2, bl, string3, bl ? 443 : 80);
    }

    public AWSAuthConnection(String string, String string2, boolean bl, String string3, int n) {
        this(string, string2, bl, string3, n, CallingFormat.getSubdomainCallingFormat());
    }

    public AWSAuthConnection(String string, String string2, boolean bl, String string3, CallingFormat callingFormat) {
        this(string, string2, bl, string3, bl ? 443 : 80, callingFormat);
    }

    public AWSAuthConnection(String string, String string2, boolean bl, String string3, int n, CallingFormat callingFormat) {
        this.awsAccessKeyId = string;
        this.awsSecretAccessKey = string2;
        this.isSecure = bl;
        this.server = string3;
        this.port = n;
        this.callingFormat = callingFormat;
    }

    public Response createBucket(String string, Map map) throws MalformedURLException, IOException {
        return this.createBucket(string, null, map);
    }

    public Response createBucket(String string, String string2, Map map) throws MalformedURLException, IOException {
        String string3;
        if (string2 == null) {
            string3 = null;
        } else if (LOCATION_EU.equals(string2)) {
            if (!this.callingFormat.supportsLocatedBuckets()) {
                throw new IllegalArgumentException("Creating location-constrained bucket with unsupported calling-format");
            }
            string3 = "<CreateBucketConstraint><LocationConstraint>" + string2 + "</LocationConstraint></CreateBucketConstraint>";
        } else {
            throw new IllegalArgumentException("Invalid Location: " + string2);
        }
        if (!Utils.validateBucketName(string, this.callingFormat, string2 != null)) {
            throw new IllegalArgumentException("Invalid Bucket Name: " + string);
        }
        HttpURLConnection httpURLConnection = this.makeRequest("PUT", string, "", null, map);
        if (string3 != null) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.getOutputStream().write(string3.getBytes("UTF-8"));
        }
        return new Response(httpURLConnection);
    }

    public boolean checkBucketExists(String string) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = this.makeRequest("HEAD", string, "", null, null);
        int n = httpURLConnection.getResponseCode();
        return n >= 200 && n < 300;
    }

    public ListBucketResponse listBucket(String string, String string2, String string3, Integer n, Map map) throws MalformedURLException, IOException {
        return this.listBucket(string, string2, string3, n, null, map);
    }

    public ListBucketResponse listBucket(String string, String string2, String string3, Integer n, String string4, Map map) throws MalformedURLException, IOException {
        Map map2 = Utils.paramsForListOptions(string2, string3, n, string4);
        return new ListBucketResponse(this.makeRequest("GET", string, "", map2, map));
    }

    public Response deleteBucket(String string, Map map) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", string, "", null, map));
    }

    public Response put(String string, String string2, S3Object s3Object, Map map) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = this.makeRequest("PUT", string, Utils.urlencode(string2), null, map, s3Object);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.getOutputStream().write(s3Object.data == null ? new byte[]{} : s3Object.data);
        return new Response(httpURLConnection);
    }

    public Response copy(String string, String string2, String string3, String string4, Map hashMap) throws MalformedURLException, IOException {
        S3Object s3Object = new S3Object(new byte[0], new HashMap());
        hashMap = hashMap == null ? new HashMap<String, List<String>>() : new HashMap(hashMap);
        hashMap.put("x-amz-copy-source", Arrays.asList(string + "/" + string2));
        hashMap.put("x-amz-metadata-directive", Arrays.asList("COPY"));
        return this.verifyCopy(this.put(string3, string4, s3Object, hashMap));
    }

    public Response copy(String string, String string2, String string3, String string4, Map map, Map hashMap) throws MalformedURLException, IOException {
        S3Object s3Object = new S3Object(new byte[0], map);
        hashMap = hashMap == null ? new HashMap<String, List<String>>() : new HashMap(hashMap);
        hashMap.put("x-amz-copy-source", Arrays.asList(string + "/" + string2));
        hashMap.put("x-amz-metadata-directive", Arrays.asList("REPLACE"));
        return this.verifyCopy(this.put(string3, string4, s3Object, hashMap));
    }

    private Response verifyCopy(Response response) throws IOException {
        if (response.connection.getResponseCode() < 400) {
            byte[] byArray = GetResponse.slurpInputStream(response.connection.getInputStream());
            String string = new String(byArray);
            if (string.indexOf("<Error") != -1) {
                throw new IOException(string.substring(string.indexOf("<Error")));
            }
            if (string.indexOf("</CopyObjectResult>") == -1) {
                throw new IOException("Unexpected response: " + string);
            }
        }
        return response;
    }

    public GetResponse get(String string, String string2, Map map) throws MalformedURLException, IOException {
        return new GetResponse(this.makeRequest("GET", string, Utils.urlencode(string2), null, map));
    }

    public Response delete(String string, String string2, Map map) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", string, Utils.urlencode(string2), null, map));
    }

    public GetResponse getBucketRequestPayment(String string, Map map) throws MalformedURLException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("requestPayment", null);
        return new GetResponse(this.makeRequest("GET", string, "", hashMap, map));
    }

    public Response putBucketRequestPayment(String string, String string2, Map map) throws MalformedURLException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("requestPayment", null);
        S3Object s3Object = new S3Object(string2.getBytes(), null);
        HttpURLConnection httpURLConnection = this.makeRequest("PUT", string, "", hashMap, map, s3Object);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.getOutputStream().write(s3Object.data == null ? new byte[]{} : s3Object.data);
        return new Response(httpURLConnection);
    }

    public GetResponse getBucketLogging(String string, Map map) throws MalformedURLException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("logging", null);
        return new GetResponse(this.makeRequest("GET", string, "", hashMap, map));
    }

    public Response putBucketLogging(String string, String string2, Map map) throws MalformedURLException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("logging", null);
        S3Object s3Object = new S3Object(string2.getBytes(), null);
        HttpURLConnection httpURLConnection = this.makeRequest("PUT", string, "", hashMap, map, s3Object);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.getOutputStream().write(s3Object.data == null ? new byte[]{} : s3Object.data);
        return new Response(httpURLConnection);
    }

    public GetResponse getBucketACL(String string, Map map) throws MalformedURLException, IOException {
        return this.getACL(string, "", map);
    }

    public GetResponse getACL(String string, String string2, Map map) throws MalformedURLException, IOException {
        if (string2 == null) {
            string2 = "";
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("acl", null);
        return new GetResponse(this.makeRequest("GET", string, Utils.urlencode(string2), hashMap, map));
    }

    public Response putBucketACL(String string, String string2, Map map) throws MalformedURLException, IOException {
        return this.putACL(string, "", string2, map);
    }

    public Response putACL(String string, String string2, String string3, Map map) throws MalformedURLException, IOException {
        S3Object s3Object = new S3Object(string3.getBytes(), null);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("acl", null);
        HttpURLConnection httpURLConnection = this.makeRequest("PUT", string, Utils.urlencode(string2), hashMap, map, s3Object);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.getOutputStream().write(s3Object.data == null ? new byte[]{} : s3Object.data);
        return new Response(httpURLConnection);
    }

    public LocationResponse getBucketLocation(String string) throws MalformedURLException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("location", null);
        return new LocationResponse(this.makeRequest("GET", string, "", hashMap, null));
    }

    public ListAllMyBucketsResponse listAllMyBuckets(Map map) throws MalformedURLException, IOException {
        return new ListAllMyBucketsResponse(this.makeRequest("GET", "", "", null, map));
    }

    private HttpURLConnection makeRequest(String string, String string2, String string3, Map map, Map map2) throws MalformedURLException, IOException {
        return this.makeRequest(string, string2, string3, map, map2, null);
    }

    private HttpURLConnection makeRequest(String string, String string2, String string3, Map map, Map map2, S3Object s3Object) throws MalformedURLException, IOException {
        CallingFormat callingFormat = Utils.getCallingFormatForBucket(this.callingFormat, string2);
        if (this.isSecure && callingFormat != CallingFormat.getPathCallingFormat() && string2.indexOf(".") != -1) {
            System.err.println("You are making an SSL connection, however, the bucket contains periods and the wildcard certificate will not match by default.  Please consider using HTTP.");
        }
        URL uRL = callingFormat.getURL(this.isSecure, this.server, this.port, string2, string3, map);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod(string);
        if (!httpURLConnection.getInstanceFollowRedirects() && callingFormat.supportsLocatedBuckets()) {
            throw new RuntimeException("HTTP redirect support required.");
        }
        this.addHeaders(httpURLConnection, map2);
        if (s3Object != null) {
            this.addMetadataHeaders(httpURLConnection, s3Object.metadata);
        }
        this.addAuthHeader(httpURLConnection, string, string2, string3, map);
        return httpURLConnection;
    }

    private void addHeaders(HttpURLConnection httpURLConnection, Map map) {
        this.addHeaders(httpURLConnection, map, "");
    }

    private void addMetadataHeaders(HttpURLConnection httpURLConnection, Map map) {
        this.addHeaders(httpURLConnection, map, "x-amz-meta-");
    }

    private void addHeaders(HttpURLConnection httpURLConnection, Map map, String string) {
        if (map != null) {
            for (String string2 : map.keySet()) {
                for (String string3 : (List)map.get(string2)) {
                    httpURLConnection.addRequestProperty(string + string2, string3);
                }
            }
        }
    }

    private void addAuthHeader(HttpURLConnection httpURLConnection, String string, String string2, String string3, Map map) {
        if (httpURLConnection.getRequestProperty("Date") == null) {
            httpURLConnection.setRequestProperty("Date", AWSAuthConnection.httpDate());
        }
        if (httpURLConnection.getRequestProperty("Content-Type") == null) {
            httpURLConnection.setRequestProperty("Content-Type", "");
        }
        String string4 = Utils.makeCanonicalString(string, string2, string3, map, httpURLConnection.getRequestProperties());
        String string5 = Utils.encode(this.awsSecretAccessKey, string4, false);
        httpURLConnection.setRequestProperty("Authorization", "AWS " + this.awsAccessKeyId + ":" + string5);
    }

    public static String httpDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date()) + "GMT";
    }
}

