/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GetResponse
extends Response {
    public S3Object object;

    public GetResponse(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection);
        if (httpURLConnection.getResponseCode() < 400) {
            Map map = this.extractMetadata(httpURLConnection);
            byte[] byArray = GetResponse.slurpInputStream(httpURLConnection.getInputStream());
            this.object = new S3Object(byArray, map);
        }
    }

    private Map extractMetadata(HttpURLConnection httpURLConnection) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
        for (String string : map.keySet()) {
            if (string == null || !string.startsWith("x-amz-meta-")) continue;
            treeMap.put(string.substring("x-amz-meta-".length()), map.get(string));
        }
        return treeMap;
    }

    static byte[] slurpInputStream(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

