/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Bucket;
import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SimpleTimeZone;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ListAllMyBucketsResponse
extends Response {
    public List entries;

    public ListAllMyBucketsResponse(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection);
        if (httpURLConnection.getResponseCode() < 400) {
            try {
                XMLReader xMLReader = Utils.createXMLReader();
                ListAllMyBucketsHandler listAllMyBucketsHandler = new ListAllMyBucketsHandler();
                xMLReader.setContentHandler(listAllMyBucketsHandler);
                xMLReader.setErrorHandler(listAllMyBucketsHandler);
                xMLReader.parse(new InputSource(httpURLConnection.getInputStream()));
                this.entries = listAllMyBucketsHandler.getEntries();
            }
            catch (SAXException sAXException) {
                throw new RuntimeException("Unexpected error parsing ListAllMyBuckets xml", sAXException);
            }
        }
    }

    static class ListAllMyBucketsHandler
    extends DefaultHandler {
        private List entries = new ArrayList();
        private Bucket currBucket = null;
        private StringBuffer currText = null;
        private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public ListAllMyBucketsHandler() {
            this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
            this.currText = new StringBuffer();
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string2.equals("Bucket")) {
                this.currBucket = new Bucket();
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string2.equals("Bucket")) {
                this.entries.add(this.currBucket);
            } else if (string2.equals("Name")) {
                this.currBucket.name = this.currText.toString();
            } else if (string2.equals("CreationDate")) {
                try {
                    this.currBucket.creationDate = this.iso8601Parser.parse(this.currText.toString());
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Unexpected date format in list bucket output", parseException);
                }
            }
            this.currText = new StringBuffer();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.currText.append(cArray, n, n2);
        }

        public List getEntries() {
            return this.entries;
        }
    }
}

