/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LocationResponse
extends Response {
    String location;

    public LocationResponse(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection);
        if (httpURLConnection.getResponseCode() < 400) {
            try {
                XMLReader xMLReader = Utils.createXMLReader();
                LocationResponseHandler locationResponseHandler = new LocationResponseHandler();
                xMLReader.setContentHandler(locationResponseHandler);
                xMLReader.setErrorHandler(locationResponseHandler);
                xMLReader.parse(new InputSource(httpURLConnection.getInputStream()));
                this.location = locationResponseHandler.location;
            }
            catch (SAXException sAXException) {
                throw new RuntimeException("Unexpected error parsing ListAllMyBuckets xml", sAXException);
            }
        } else {
            this.location = "<error>";
        }
    }

    public String getLocation() {
        return this.location;
    }

    static class LocationResponseHandler
    extends DefaultHandler {
        String location = null;
        private StringBuffer currText = null;

        LocationResponseHandler() {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string2.equals("LocationConstraint")) {
                this.currText = new StringBuffer();
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string2.equals("LocationConstraint")) {
                this.location = this.currText.toString();
                this.currText = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.currText != null) {
                this.currText.append(cArray, n, n2);
            }
        }
    }
}

