/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.pushpublish.model;

import com.wowza.util.Base64;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.JSON;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.pushpublish.model.IPushPublish;
import com.wowza.wms.pushpublish.model.IPushPublishSession;
import com.wowza.wms.pushpublish.model.PushPublishSessionBase;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.PushPublishUtils;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.modeler.Registry;
import org.w3c.dom.Element;

public abstract class PushPublishBase
implements IPushPublish {
    public static final Class<PushPublishBase> CLASS = PushPublishBase.class;
    public static final String CLASSNAME = "PushPublishBase";
    protected int pushPublishType = 0;
    protected IOPerformanceCounter sendingPerfomance = new IOPerformanceCounter();
    protected boolean pushPublishStreamDebug = false;
    protected int reconnectWaitTime = 0;
    protected int mapFileIndex;
    protected WMSProperties properties = new WMSProperties();
    private boolean a = false;
    protected String userName = null;
    protected String password = null;
    protected IApplicationInstance appInstance = null;
    protected String srcStreamName = null;
    protected IMediaStream srcStream = null;
    protected String dstStreamName = null;
    protected String hostname = null;
    protected InetAddress inetAddr;
    protected int port = 1935;
    protected String mImplementation = null;
    protected String mType;
    protected boolean sendOriginalTimecodes = true;
    protected long originalTimecodeThreshold = 0L;

    public PushPublishBase() {
        this.properties.put((Object)JSON.replace((String)"|/,l4+2<&f>'8b=;<8!'18<%?v\t/(4\r+=,(1+\u0012 44!&$", (int)(45 * 27)), (Object)PushPublishBase.getPushPublishVersionStr());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(IApplicationInstance iApplicationInstance, String string, IMediaStream iMediaStream, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, boolean bl) {
        this.setAppInstance(iApplicationInstance);
        HashMap<String, String> hashMap3 = new HashMap<String, String>(hashMap);
        this.setSendOriginalTimecodes(false);
        this.setOriginalTimecodeThreshold(0L);
        this.load(hashMap3);
        if (bl) {
            this.pushPublishStreamDebug = true;
        }
        PushPublishUtils.removeMapString(hashMap3, (String)JSON.replace((String)"}!2'\u0000($54", (int)(55 * 57)));
        PushPublishUtils.removeMapString(hashMap3, (String)JSON.replace((String)"'*6<208", (int)(95 + 120)));
        if (this.pushPublishStreamDebug) {
            for (String string2 : hashMap3.keySet()) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"[y~f_es~zg}Tvk|9Rrtj%Uoimkrh'X{emeak/[tk)", (int)(19 * 41)) + string2);
            }
        }
        hashMap3 = new HashMap<String, String>(hashMap2);
        this.load(hashMap3);
        PushPublishUtils.removeMapString(hashMap3, (String)JSON.replace((String)"aevcDdhyx", (int)(-19 - -54)));
        PushPublishUtils.removeMapString(hashMap3, (String)Base64.subSequence((int)(31 - -39), (String)"65'/#')"));
        if (this.pushPublishStreamDebug) {
            for (String string2 : hashMap3.keySet()) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Caf~Gm{vrou\\~sd!Jjlr=]gaecz`/]pb3_po-", (int)(39 * 53)) + string2);
            }
        }
        this.setSrcStreamName(string);
        this.srcStream = iMediaStream;
        try {
            String string3 = Base64.subSequence((int)(61 + 76), (String)"^e|vl]{bts~}{qRv~suy'hOurjSqgjn{aoy\u007f0^zcyBfvy\u007fdp5:m]mn\"") + iApplicationInstance.getApplication().getName() + Base64.subSequence((int)(3 * 55), (String)")&qIyzBb~zn~rw.") + iApplicationInstance.getName() + Base64.subSequence((int)(669 / 124), (String)")pT|{oja0") + string + JSON.replace((String)".mehc:AFZn~ka}}p|pq", (int)(72 + 90));
            Registry.getRegistry(null, null).registerComponent((Object)this.sendingPerfomance, string3, this.sendingPerfomance.getClass().getName());
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(115 + 23), (String)"Z~\u007fe^zr}{`|Wwd}:_c\u007fxnkinl#MJVbzoeyal`lu1{}}a") + exception.getMessage());
            if (!this.pushPublishStreamDebug) return;
        }
        exception.printStackTrace();
    }

    public String getImplementation() {
        return this.mImplementation;
    }

    public void setImplementation(String string) {
        if (string != null) {
            this.mImplementation = string;
            return;
        }
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    protected String getConfigDataOrDefault(Element element, String string, String string2) {
        String string3 = XMLUtils.getNodeValueByTagName((Element)element, (String)string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getConfigDataOrDefault(Element element, String string, int n) {
        String string2 = XMLUtils.getNodeValueByTagName((Element)element, (String)string);
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.pushPublishStreamDebug) return n;
        }
        numberFormatException.printStackTrace();
        return n;
    }

    protected boolean getConfigDataOrDefault(Element element, String string, boolean bl) {
        String string2 = XMLUtils.getNodeValueByTagName((Element)element, (String)string);
        if (string2 == null) {
            return bl;
        }
        boolean bl2 = Boolean.parseBoolean(string2);
        return bl2;
    }

    public boolean isAdaptiveStreaming() {
        return this.a;
    }

    public void setAdaptiveStreaming(boolean bl) {
        this.a = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void a(String string) {
        if (string == null) {
            return;
        }
        this.a = Boolean.parseBoolean(string);
        if (!this.a) return;
        this.setSendOriginalTimecodes(true);
        this.setOriginalTimecodeThreshold(0x100000L);
    }

    public boolean isSendOriginalTimecodes() {
        return this.sendOriginalTimecodes;
    }

    public void setSendOriginalTimecodes(boolean bl) {
        this.sendOriginalTimecodes = bl;
    }

    private void b(String string) {
        if (string != null) {
            this.sendOriginalTimecodes = Boolean.parseBoolean(string);
            return;
        }
    }

    public long getOriginalTimecodeThreshold() {
        return this.originalTimecodeThreshold;
    }

    public void setOriginalTimecodeThreshold(long l) {
        this.originalTimecodeThreshold = l;
    }

    public void setOriginalTimecodeThreshold(String string) {
        if (string != null) {
            this.originalTimecodeThreshold = PushPublishBase.getNumberFromString(string);
            return;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        if (string != null) {
            this.userName = string;
            return;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        if (string != null) {
            this.password = string;
            return;
        }
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    @Override
    public String getSrcStreamName() {
        return this.srcStreamName;
    }

    @Override
    public void setSrcStreamName(String string) {
        if (string != null) {
            this.srcStreamName = string;
            return;
        }
    }

    @Override
    public String getDstStreamName() {
        return this.dstStreamName;
    }

    @Override
    public void setDstStreamName(String string) {
        if (string != null) {
            this.dstStreamName = string;
            return;
        }
    }

    @Override
    public void setStreamName(String string) {
        if (string != null) {
            this.srcStreamName = string;
            return;
        }
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHost(String string) {
        if (string != null) {
            this.hostname = string;
            return;
        }
    }

    @Override
    public void setHostname(String string) {
        if (string != null) {
            this.hostname = string;
            return;
        }
    }

    @Override
    public void setDebugLog(boolean bl) {
        this.pushPublishStreamDebug = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void c(String string) {
        if (string == null) {
            return;
        }
        this.pushPublishStreamDebug = Boolean.parseBoolean(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int n) {
        this.port = n;
    }

    @Override
    public void setPort(String string) {
        if (string != null) {
            this.port = PushPublishBase.getNumberFromString(string);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getPushPublishVersionStr() {
        String string = "";
        if (string.length() > 0) {
            string = string + Base64.subSequence((int)(-40 - -6), (String)"e\u007f");
        }
        if ((string = string + System.getProperty(JSON.replace((String)"kv(iido", (int)(1016 / 209))) + JSON.replace((String)"*'", (int)(268 / 42)) + System.getProperty(Base64.subSequence((int)(23 * 33), (String)"8+w,>..70n")) + Base64.subSequence((int)(576 / 116), (String)"(%") + System.getProperty(Base64.subSequence((int)(-34 - -58), (String)"wj4zn~v"))).length() > 0) {
            string = string + JSON.replace((String)" <", (int)(12 - -47));
        }
        string = string + System.getProperty(JSON.replace((String)"uawc-rh(iido", (int)(3 * 53))) + JSON.replace((String)"?4", (int)(49 * 3)) + System.getProperty(Base64.subSequence((int)(114 + 114), (String)".$0&f?'e:( +?#")) + JSON.replace((String)"s`", (int)(15 * 49)) + System.getProperty(Base64.subSequence((int)(27 * 9), (String)"95#7y.<((520")) + Base64.subSequence((int)(-42 - -29), (String)"\u007ft") + System.getProperty(Base64.subSequence((int)(231 / 39), (String)"ogqi'|f\"{k}cx}}")) + Base64.subSequence((int)(1172 / 175), (String)"*'") + System.getProperty(Base64.subSequence((int)(109 + 101), (String)"!&:{7%;1t?=)?q-.&&("));
        if (System.getProperty(JSON.replace((String)"urgq*igio|kli", (int)(87 + -55))) != null && System.getProperty(JSON.replace((String)"vw`t)kf\u007fex\u007fw", (int)(148 / 43))) != null) {
            if (string.length() > 0) {
                string = string + Base64.subSequence((int)(21 + 27), (String)"+1");
            }
            string = string + System.getProperty(Base64.subSequence((int)(953 / 198), (String)"qvcu&ekekxohu")).toLowerCase() + "-" + System.getProperty(JSON.replace((String)"fgpd9{vouhog", (int)(59 * 9))).toLowerCase();
        }
        if (string.length() <= 0) return Base64.subSequence((int)(7 * 23), (String)"Vmt~dUszlkfeciJ~v{}q:") + ReleaseInfo.getVersion() + Base64.subSequence((int)(809 / 254), (String)".fpokl") + ReleaseInfo.getBuildNumber() + string;
        string = Base64.subSequence((int)(-65 - 3), (String)"<5") + string + ")";
        return Base64.subSequence((int)(7 * 23), (String)"Vmt~dUszlkfeciJ~v{}q:") + ReleaseInfo.getVersion() + Base64.subSequence((int)(809 / 254), (String)".fpokl") + ReleaseInfo.getBuildNumber() + string;
    }

    public void load(HashMap<String, String> hashMap) {
        this.c(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"EgaqbJho", (int)(-48 - 47))));
        this.setHost(PushPublishUtils.removeMapString(hashMap, (String)Base64.subSequence((int)(5 * 63), (String)"Ssnj")));
        this.a(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"Flhz\u007fe{k\\dcwry|xp", (int)(-26 - 63))));
        this.setImplementation(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"\r(6+-$/%8,:&??", (int)(122 + 74))));
        this.setOriginalTimecodeThreshold(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"\u0013/78iocoPlkbkfnnXe|jcy}\u007fp", (int)(109 + 15))));
        this.setPassword(PushPublishUtils.removeMapString(hashMap, (String)Base64.subSequence((int)(27 * 3), (String)"\u00013 '\"9%<")));
        this.setPort(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"Skwr", (int)(87 + 76))));
        this.b(PushPublishUtils.removeMapString(hashMap, (String)Base64.subSequence((int)(762 / 129), (String)"VcilFxbkd`n|E{~qvys}j")));
        this.setDstStreamName(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"Mk2$#.\n$+\"", (int)(14 + 48))));
        this.d(PushPublishUtils.removeMapString(hashMap, (String)Base64.subSequence((int)(-28 - 21), (String)"\u001b)!7")));
        this.setUserName(PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"Vw`tIido", (int)(626 / 177))));
        String string = PushPublishUtils.removeMapString(hashMap, (String)JSON.replace((String)"idvAaeoBbikw", (int)(824 / 176)));
        this.setMapFileIndex(string);
    }

    private final void d(String string) {
        if (string != null) {
            this.mType = string;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int getNumberFromString(String string) {
        if (string == null) return 0;
        if (string.length() < 1) return 0;
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public int getMapFileIndex() {
        return this.mapFileIndex;
    }

    @Override
    public void setMapFileIndex(String string) {
        if (string != null) {
            this.mapFileIndex = Integer.parseInt(string);
            return;
        }
    }

    @Override
    public int getReconnectWaitTime() {
        return this.reconnectWaitTime;
    }

    @Override
    public void setReconnectWaitTime(int n) {
        this.reconnectWaitTime = n;
    }

    public double getBandwidth() {
        return this.sendingPerfomance.getFileOutBytesRate();
    }

    @Override
    public int getPushPublishType() {
        return this.pushPublishType;
    }

    @Override
    public IPushPublishSession createPushPublishSession() {
        PushPublishSessionBase pushPublishSessionBase = new PushPublishSessionBase();
        pushPublishSessionBase.setPushPublishImpl(this);
        return pushPublishSessionBase;
    }

    @Override
    public IMediaStream getSrcStream() {
        return this.srcStream;
    }

    @Override
    public void setSrcStream(IMediaStream iMediaStream) {
        this.srcStream = iMediaStream;
    }

    @Override
    public String getContextStr() {
        return "";
    }
}

