/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.pushpublish.protocol.rtmp;

import com.wowza.util.Base64;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.JSON;
import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.INetConnectionCallResult;
import com.wowza.wms.netconnection.INetConnectionCallback;
import com.wowza.wms.netconnection.INetConnectionIdle;
import com.wowza.wms.netconnection.INetConnectionPingResult;
import com.wowza.wms.netconnection.INetConnectionPublisher;
import com.wowza.wms.netconnection.NetConnection;
import com.wowza.wms.pushpublish.model.IPushPublishSession;
import com.wowza.wms.pushpublish.model.PushPublishBase;
import com.wowza.wms.pushpublish.protocol.rtmp.IPushPublishRTMPAuthProvider;
import com.wowza.wms.pushpublish.protocol.rtmp.IPushPublishRTMPNotify;
import com.wowza.wms.pushpublish.protocol.rtmp.PushPublishRTMPNetConnectionSession;
import com.wowza.wms.pushpublish.protocol.rtmp.PushPublishSessionRTMP;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.security.encryption.TEA;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamCallback;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IoSession;

public class PushPublishRTMP
extends PushPublishBase {
    public static final Class<PushPublishRTMP> CLASS = PushPublishRTMP.class;
    public static final String CLASSNAME = "PushPublishRTMP";
    public static final String CURRENTFMLEVERSION = "FMLE/3.0 (compatible; FMSc/1.0)";
    public static final String CURRENTFLASHVERSION = "WIN 10,0,12,36";
    protected boolean rtmpDebugLog = false;
    protected long debugLogLastPacketCount = -1L;
    protected boolean debugPackets = false;
    protected Map<INetConnection, PushPublishRTMPNetConnectionSession> netconnectToSessionHolder = new HashMap<INetConnection, PushPublishRTMPNetConnectionSession>();
    protected Map<IoSession, PushPublishRTMPNetConnectionSession> ioSessionToSessionHolder = new HashMap<IoSession, PushPublishRTMPNetConnectionSession>();
    protected List<PushPublishRTMPNetConnectionSession> sessionOrder = new ArrayList<PushPublishRTMPNetConnectionSession>();
    protected List<IPushPublishRTMPNotify> listeners = new ArrayList<IPushPublishRTMPNotify>();
    protected String dstStreamName = null;
    protected String dstApplicationName = JSON.replace((String)"RjjvpbcK", (int)(35 * 15));
    protected String dstAppInstanceName = Base64.subSequence((int)(1157 / 222), (String)"Zbbn`dxxR");
    protected Object lock = new Object();
    protected String howToPublish = null;
    protected boolean sendFCPublish = false;
    protected boolean sendFCAnnounce = false;
    protected boolean sendReleaseStream = true;
    protected boolean sendStreamCloseCommands = false;
    protected boolean sendOnMetadata = true;
    protected boolean onMetadataToSetDataFrame = true;
    protected boolean sendOriginalTimecodes = true;
    protected int timecodesOutOfOrderThreshold = 30;
    protected boolean tryConnect = true;
    protected boolean isReconnectorRunning = false;
    protected String connectionQueryStr = "";
    protected String connectionFlashVersion = Base64.subSequence((int)(-46 - -18), (String)"\u0002\b\n\u0002gzd{le- =!3'=7:2cy\u001c\u0016\u000f>qn.1+");
    protected String connectionSwfURL = JSON.replace((String)"RiprhZycAgyuCwcqtbrj", (int)(1371 / 229));
    protected String connectionPageURL = "";
    protected String secureTokenSharedSecret = "";
    protected String akamaiUserName = null;
    protected String akamaiPassword = null;
    protected String akamaiOriginIp = null;
    protected Integer akamaiOriginPort = null;
    protected long validationFrequency = 25000L;
    protected int connectionTimeout = 4000;
    protected long connectLastAttempt = -1L;
    protected long connectLastSuccess = -1L;
    protected boolean doSendOnMetaData = true;
    protected boolean removeDefaultAppInstance = false;
    protected boolean resetOnTimecodeOutOfOrder = true;
    protected long sendStreamCloseCommandsSendTime = -1L;
    protected int streamCloseWaitTime = 5000;
    protected long lastIdleReadTime = -1L;
    protected long lastIdleWriteTime = -1L;
    protected long totalPacketsSent = 0L;
    protected long lastVideoTC = -1L;
    protected long lastAudioTC = -1L;
    protected long lastDataTC = -1L;
    protected long packetsSentAudio = 0L;
    protected long packetsSentVideo = 0L;
    protected long packetsSentData = 0L;
    protected boolean waitOnMetadataAvailable = true;
    protected boolean waitOnMetadataVideo = true;
    protected boolean waitOnMetadataVideoDatarate = false;
    protected boolean waitOnMetadataAudio = true;
    protected boolean waitOnMetadataAudioDatarate = false;
    protected long waitOnMetadataTimeout = 6000L;
    protected boolean waitOnMetadataReady = false;
    protected long waitOnMetadataStartime = -1L;
    protected long srcStreamBufferSize = 0L;
    protected String bindAddress = null;
    protected IPushPublishRTMPAuthProvider rtmpAuthProvider = null;
    protected Map<String, AMFData> connectMetaData = new HashMap<String, AMFData>();
    public long offlineTime;
    public long onlineTime = -1L;
    public int outprint = 0;
    public float[] bytesAvg = new float[12];
    protected boolean isSSL = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PushPublishRTMP() throws LicensingException {
        this.pushPublishType = 1;
        this.onlineTime = -1L;
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(Base64.subSequence((int)(96 + 100), (String)"7x") + RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)131))) >= 0) return;
            if (string2.indexOf("s" + (String)MediaStreamBase.sinfo.get(Base64.subSequence((int)(-89 + 112), (String)"dti")) + "=" + RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)131))) >= 0) return;
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public INetConnection getNetConnection() {
        Object object = this.lock;
        synchronized (object) {
            PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = this.getLastSession();
            if (pushPublishRTMPNetConnectionSession == null) return null;
            return pushPublishRTMPNetConnectionSession.netConnection;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public String getHowToPublish() {
        return this.howToPublish;
    }

    public void setHowToPublish(String string) {
        this.howToPublish = string;
    }

    public boolean isSendFCPublish() {
        return this.sendFCPublish;
    }

    public void setSendFCPublish(boolean bl) {
        this.sendFCPublish = bl;
    }

    public boolean isSendReleaseStream() {
        return this.sendReleaseStream;
    }

    public void setSendReleaseStream(boolean bl) {
        this.sendReleaseStream = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSessionListDebug() {
        String string = "{";
        Object object = this.lock;
        synchronized (object) {
            Iterator<PushPublishRTMPNetConnectionSession> iterator = this.sessionOrder.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = iterator.next();
                string = string + "[" + n + Base64.subSequence((int)(-4 + 111), (String)"\u0016vm") + pushPublishRTMPNetConnectionSession.session.hashCode() + " ";
                ++n;
            }
            return string + "}";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCurrentSession(IoSession ioSession) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = this.getLastSession();
            if (pushPublishRTMPNetConnectionSession == null) return bl;
            if (pushPublishRTMPNetConnectionSession.session != ioSession) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PushPublishRTMPNetConnectionSession getLastSession() {
        PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.sessionOrder.size() <= 0) return pushPublishRTMPNetConnectionSession;
            List<PushPublishRTMPNetConnectionSession> list = this.sessionOrder;
            return list.get(list.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSession(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        Object object = this.lock;
        synchronized (object) {
            this.sessionOrder.add(pushPublishRTMPNetConnectionSession);
            this.netconnectToSessionHolder.put(pushPublishRTMPNetConnectionSession.netConnection, pushPublishRTMPNetConnectionSession);
            this.ioSessionToSessionHolder.put(pushPublishRTMPNetConnectionSession.session, pushPublishRTMPNetConnectionSession);
            if (!this.rtmpDebugLog) return;
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(12 + 2), (String)"^zcyBfvy\u007fdpKNVL3\u007f{dRgpwliiS") + this.getContextStr() + JSON.replace((String)"\u0004`{", (int)(21 * 53)) + this.getSessionListDebug());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeSession(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        Object object = this.lock;
        synchronized (object) {
            this.sessionOrder.remove(pushPublishRTMPNetConnectionSession);
            this.netconnectToSessionHolder.remove(pushPublishRTMPNetConnectionSession.netConnection);
            this.ioSessionToSessionHolder.remove(pushPublishRTMPNetConnectionSession.session);
            if (!this.rtmpDebugLog) return;
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(27 * 25), (String)"SqvnW}kfb\u007fe\\[]A<aqxya}J\u007fhotqq\u001b") + this.getContextStr() + JSON.replace((String)"W1,", (int)(65 + 105)) + this.getSessionListDebug());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PushPublishRTMPNetConnectionSession getSessionHolderBySession(IoSession ioSession) {
        PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = null;
        Object object = this.lock;
        synchronized (object) {
            return this.ioSessionToSessionHolder.get(ioSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PushPublishRTMPNetConnectionSession getSessionHolderByNetConnection(INetConnection iNetConnection) {
        PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = null;
        Object object = this.lock;
        synchronized (object) {
            return this.netconnectToSessionHolder.get(iNetConnection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sessionOpened(IoSession ioSession) {
        if (!this.pushPublishStreamDebug) {
            return;
        }
        WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"D`e\u007fHlxwunvM\u0014\f\u0012m7 54!&$\u0004<( *4\n", (int)(5 + 47)) + this.getContextStr() + JSON.replace((String)"Bza", (int)(11 * 29)));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void a(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        INetConnection iNetConnection = pushPublishRTMPNetConnectionSession.netConnection;
        Iterator<IMediaStream> iterator = pushPublishRTMPNetConnectionSession.streamsToPublish.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                pushPublishRTMPNetConnectionSession.streamsToPublish.clear();
                return;
            }
            IMediaStream iMediaStream = iterator.next();
            iMediaStream.stopPublishing();
            if (iNetConnection == null) continue;
            iNetConnection.removePublishStreams(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void b(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        block11: {
            block10: {
                Object object = this.lock;
                // MONITORENTER : object
                if (pushPublishRTMPNetConnectionSession == null) break block11;
                try {
                    this.a(pushPublishRTMPNetConnectionSession);
                    if (pushPublishRTMPNetConnectionSession.netConnection != null) {
                        pushPublishRTMPNetConnectionSession.netConnection.close();
                    }
                    break block10;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(CLASS).error(JSON.replace((String)"\u00162;!\u001a>.!'<8\u0003\u0006\u001e\u0004{5;7*?\u000b).6\u000f5#\u0011&76/(&\u0012", (int)(72 + -2)) + this.getContextStr() + Base64.subSequence((int)(47 * 31), (String)"LI\"I/6"), (Throwable)exception);
                    if (!this.pushPublishStreamDebug) break block10;
                }
                exception.printStackTrace();
            }
            try {
                this.removeSession(pushPublishRTMPNetConnectionSession);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error(JSON.replace((String)"Ust`Y\u007fi`d}gBE_C:vzxk|JnouNjbRgpwliiS", (int)(21 * 49)) + this.getContextStr() + Base64.subSequence((int)(11 * 21), (String)"\u001a\u0013{\u0017ql"), (Throwable)exception);
            }
            try {
                this.notifyPushPublisherSessionDestroy(pushPublishRTMPNetConnectionSession);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error(JSON.replace((String)"EcdpIoyptmw\u0012\u0015\u000f\u0013j&*(;,\u001a>?%\u001e:2\u00027 '<99\u0003", (int)(7 + 46)) + this.getContextStr() + Base64.subSequence((int)(74 + 90), (String)"Y^5Z2)"), (Throwable)exception);
            }
        }
        // MONITOREXIT : object
        if (!this.pushPublishStreamDebug) return;
        WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Ust`Y\u007fi`d}gBE_C:vzxk|JnouNjbRgpwliiS", (int)(951 / 164)) + this.getContextStr() + Base64.subSequence((int)(743 / 144), (String)"X<'Keexii"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sessionClosed(IoSession ioSession) {
        if (this.pushPublishStreamDebug) {
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\u000f52*\u00131'*.;!\u0018\u001f\u0001\u001d`<5\"!:;;\u0015;7*??\u0007", (int)(37 * 51)) + this.getContextStr() + "]");
        }
        boolean bl = this.isCurrentSession(ioSession);
        PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = this.getSessionHolderBySession(ioSession);
        this.b(pushPublishRTMPNetConnectionSession);
        synchronized (this.lock) {
            if (!bl) return;
            if (!this.tryConnect) return;
            this.bumpReconnectWaitTime();
            if (this.pushPublishStreamDebug) {
                WMSLoggerFactory.getLogger(CLASS).warn(JSON.replace((String)"\u001b9>&\u001f%3>:'=\u0004\u0003\u0015\tt(9.-6ooAokvccS", (int)(33 * 11)) + this.getContextStr() + JSON.replace((String)"T0+^YC_0bw`g|yy8zvtoxz?5/';4 %3--&2bm\u001c*$#+::2v>6y", (int)(39 * 47)) + this.reconnectWaitTime + Base64.subSequence((int)(37 * 43), (String)"7uj\u007fx"));
            }
            this.tryToConnect();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tryToConnect() {
        Object object = this.lock;
        synchronized (object) {
            IVHost iVHost = this.appInstance.getVHost();
            if (this.isReconnectorRunning) return;
            if (!this.tryConnect) return;
            if (iVHost.isShuttingDown()) return;
            this.isReconnectorRunning = true;
            iVHost.getThreadPool().execute((Runnable)new Reconnector());
            return;
        }
    }

    @Override
    public void resetConnection() {
        this.resetConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetConnection(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = this.getLastSession();
            if (this.pushPublishStreamDebug) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"TpuoX|hge~f]D\\B=fperlZuurx}kinlX", (int)(789 / 184)) + this.getContextStr() + JSON.replace((String)"\u0007a|", (int)(-3 - 35)) + pushPublishRTMPNetConnectionSession);
            }
            if (pushPublishRTMPNetConnectionSession != null) {
                this.b(pushPublishRTMPNetConnectionSession);
            }
            if (!this.tryConnect) return;
            if (bl) {
                this.connectLastAttempt = -1L;
            }
            this.tryToConnect();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getContextStr() {
        if (!this.removeDefaultAppInstance) return Base64.subSequence((int)(1598 / 231), (String)"tsey0$#") + this.hostname + ":" + this.port + "/" + this.dstApplicationName + "/" + this.dstAppInstanceName + "/" + this.dstStreamName;
        if (!this.dstAppInstanceName.equals(Base64.subSequence((int)(175 / 40), (String)"[acaagy\u007fS"))) return Base64.subSequence((int)(1598 / 231), (String)"tsey0$#") + this.hostname + ":" + this.port + "/" + this.dstApplicationName + "/" + this.dstAppInstanceName + "/" + this.dstStreamName;
        return JSON.replace((String)"tsey0$#", (int)(775 / 129)) + this.hostname + ":" + this.port + "/" + this.dstApplicationName + "/" + this.dstStreamName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String resolveHostName() {
        String string;
        block6: {
            string = null;
            try {
                this.inetAddr = InetAddress.getByName(this.hostname);
                if (this.inetAddr == null) return string;
                string = this.hostname;
                if (!this.pushPublishStreamDebug) return string;
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\u00162;!\u001a>.!'<8\u0003\u0006\u001e\u0004{$2+66-9\u00151,tOcna^", (int)(80 + 22)) + this.getContextStr() + Base64.subSequence((int)(328 / 64), (String)"X<'ay*jhi|jcb2|r54") + this.hostname + Base64.subSequence((int)(59 + 87), (String)"03}f65") + this.inetAddr.getHostAddress() + "\"");
                return string;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error(Base64.subSequence((int)(1135 / 174), (String)"Vr{aZ~nag|xCF^D;drkvvmyUqltOcna^") + this.getContextStr() + Base64.subSequence((int)(51 * 29), (String)"\u001ari"), (Throwable)exception);
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                if (!this.pushPublishStreamDebug) break block6;
            }
            WMSLoggerFactory.getLogger(CLASS).error(Base64.subSequence((int)(3 - -27), (String)"NjsiRvfiot`[^F\\#|jc~~eq]ydlW{vyF") + this.getContextStr() + Base64.subSequence((int)(48 + 8), (String)"E#:"), (Throwable)unknownHostException);
        }
        if (this.inetAddr == null) return string;
        try {
            if (this.inetAddr.isReachable(5000)) {
                string = this.inetAddr.getHostAddress();
                if (!this.pushPublishStreamDebug) return string;
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\r+,(\u00117!(,5/\u001a\u001d\u0007\u001bb?+<?=$6\u001c:%#\u001687>\u0007", (int)(31 + 62)) + this.getContextStr() + JSON.replace((String)"Z2)_xeci/x~ag4|f7y}~iynm?\"", (int)(15 * 9)) + string + Base64.subSequence((int)(975 / 229), (String)"&%unfjo+ey)|0cwrw}wut|"));
                return string;
            }
            if (!this.pushPublishStreamDebug) return string;
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(53 * 55), (String)"\u001316.\u0017=+&\"?%\u001c\u001b\u001d\u0001|!1&9;.<\u00124/)\u0010>mdY") + this.getContextStr() + Base64.subSequence((int)(-57 - 38), (String)"\\8#Ljus(`y+bbz/btsp|tt{}"));
            return string;
        }
        catch (Exception exception) {
            if (!this.pushPublishStreamDebug) return string;
        }
        WMSLoggerFactory.getLogger(CLASS).error(Base64.subSequence((int)(17 + 83), (String)"\u001405/\u0018<('%>&\u001d\u0004\u001c\u0002}&0%84/?\u00133.*\u0011algX") + this.getContextStr() + JSON.replace((String)"Y?&", (int)(304 / 73)), (Throwable)exception);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IoSession internalConnect(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        if (this.pushPublishStreamDebug) {
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\u0004 %?\b,875.6\rTLR-mkrbzgkgOb`aurf)4", (int)(63 - -53)) + this.getContextStr() + (this.bindAddress != null ? Base64.subSequence((int)(-31 - -29), (String)"~=iofB`atb{z0") + this.bindAddress : ""));
        }
        IoSession ioSession = null;
        try {
            NetConnection netConnection = (NetConnection)pushPublishRTMPNetConnectionSession.getNetConnection();
            Object object = this.lock;
            synchronized (object) {
                netConnection.setSSL(this.isSSL);
                String string = this.resolveHostName();
                if (string != null) {
                    if (this.pushPublishStreamDebug) {
                        WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"[y~f_es~zg}DCUI4rri{mn`n@kkhbk}Q", (int)(-46 - -57)) + this.getContextStr() + JSON.replace((String)"\fhs7:89=:.22:~+/a*,71fe", (int)(43 + 38)) + string + "\"");
                    }
                    netConnection.connect(string, this.port, this.isSSL, null, this.connectionTimeout, (INetConnectionCallResult)new HandshakeResult(pushPublishRTMPNetConnectionSession), this.bindAddress);
                    return netConnection.getSession();
                }
                WMSLoggerFactory.getLogger(CLASS).warn(Base64.subSequence((int)(528 / 110), (String)"TpuoX|hge~f]D\\B=}{brjw{w_rpqebvX") + this.getContextStr() + JSON.replace((String)"Y?&dg|fob*z/s~|}qvb7opns<uqlt!", (int)(707 / 176)) + this.hostname);
                return ioSession;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(Base64.subSequence((int)(-19 + 72), (String)"EcdpIoyptmw\u0012\u0015\u000f\u0013j,(3-;$* \u000e!!>41'\u000f") + this.getContextStr() + JSON.replace((String)"T0+", (int)(13 * 13)), (Throwable)exception);
            return ioSession;
        }
    }

    public String getConnectionQueryStr() {
        return this.connectionQueryStr;
    }

    public void setConnectionQueryStr(String string) {
        this.connectionQueryStr = string;
    }

    @Override
    public void connect() {
        WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(54 + 1), (String)"GmjrKi\u007frv3)\u0010\u0017\t\u0015h$''$./9\u0015") + this.getContextStr() + "]");
        this.tryToConnect();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void callConnect(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, String string) {
        AMFDataObj aMFDataObj = new AMFDataObj();
        String string2 = this.dstApplicationName + "/" + this.dstAppInstanceName;
        if (this.removeDefaultAppInstance && Base64.subSequence((int)(611 / 152), (String)"[acaagy\u007fS").equals(this.dstAppInstanceName)) {
            string2 = this.dstApplicationName;
        }
        if (string == null) {
            string = "";
        }
        String string3 = "";
        if (this.connectionQueryStr.length() > 0) {
            if (string3.length() > 0) {
                string3 = string3 + "&";
            }
            string3 = string3 + this.connectionQueryStr;
        }
        if (string.length() > 0) {
            if (string3.length() > 0) {
                string3 = string3 + "&";
            }
            string3 = string3 + string;
        }
        if (this.rtmpAuthProvider != null) {
            string3 = this.rtmpAuthProvider.addAuthQueryString(string3);
        }
        if (string3.length() > 0) {
            string3 = "?" + string3;
        }
        aMFDataObj.put(JSON.replace((String)",>?", (int)(55 * 27)), (AMFData)new AMFDataItem(string2 + string3));
        aMFDataObj.put(Base64.subSequence((int)(-1 - -48), (String)"i|pa{Bpd"), (AMFData)new AMFDataItem(this.connectionFlashVersion));
        aMFDataObj.put(JSON.replace((String)"|gwGax", (int)(31 * 17)), (AMFData)new AMFDataItem(this.connectionSwfURL));
        aMFDataObj.put(JSON.replace((String)",:\u000f)0", (int)(52 - -36)), (AMFData)new AMFDataItem(JSON.replace((String)"qphv='&", (int)(701 / 196)) + this.hostname + ":" + this.port + "/" + string2 + string3));
        aMFDataObj.put(JSON.replace((String)"j}ok", (int)(92 + 48)), (AMFData)new AMFDataItem(false));
        aMFDataObj.put(JSON.replace((String)"grl`eHciklc", (int)(1246 / 201)), (AMFData)new AMFDataItem(3191.0));
        aMFDataObj.put(JSON.replace((String)"rlbbgJeoin}", (int)(40 + -36)), (AMFData)new AMFDataItem(252.0));
        aMFDataObj.put(JSON.replace((String)"vfol_y`", (int)(1609 / 233)), (AMFData)new AMFDataItem(this.connectionPageURL));
        aMFDataObj.put(JSON.replace((String)"xicjLxd|xG|lr", (int)(41 * 51)), (AMFData)new AMFDataItem(4096.0));
        for (String string4 : this.connectMetaData.keySet()) {
            aMFDataObj.put(string4, this.connectMetaData.get(string4));
        }
        if (this.rtmpDebugLog) {
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"OurjSqgjn{aX_A] lq}~P{{xr{mA", (int)(57 * 23)) + this.getContextStr() + JSON.replace((String)"\rkr", (int)(-33 - 15)) + string2 + string3 + "\n" + aMFDataObj.toString());
        }
        if (this.akamaiUserName == null) {
            pushPublishRTMPNetConnectionSession.getNetConnection().callConnect((INetConnectionCallResult)new ConnectResult(pushPublishRTMPNetConnectionSession), aMFDataObj, new Object[0]);
            return;
        }
        pushPublishRTMPNetConnectionSession.getNetConnection().callConnect((INetConnectionCallResult)new ConnectResult(pushPublishRTMPNetConnectionSession), aMFDataObj, new Object[]{this.getAkamaiSessionKey(null), this.dstApplicationName, this.akamaiOriginIp, this.akamaiOriginPort == null ? null : Integer.valueOf(this.akamaiOriginPort)});
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAkamaiSessionKey(String string) {
        String string2 = "";
        string2 = this.akamaiOriginIp != null ? JSON.replace((String)"sy{v~~n'", (int)(61 + 89)) + this.akamaiOriginIp + ":" + this.akamaiUserName : JSON.replace((String)"cikfnn~7?!\"?!= /", (int)(628 / 90)) + this.akamaiUserName;
        if (string == null) return string2;
        return string2 + ":" + string;
    }

    public String getConnectionFlashVerion() {
        return this.connectionFlashVersion;
    }

    public String getConnectionFlashVersion() {
        return this.connectionFlashVersion;
    }

    public void setConnectionFlashVersion(String string) {
        this.connectionFlashVersion = string;
    }

    public void setConnectionFlashVerion(String string) {
        this.connectionFlashVersion = string;
    }

    public String getConnectionSwfURL() {
        return this.connectionSwfURL;
    }

    public void setConnectionSwfURL(String string) {
        this.connectionSwfURL = string;
    }

    public String getConnectionPageURL() {
        return this.connectionPageURL;
    }

    public void setConnectionPageURL(String string) {
        this.connectionPageURL = string;
    }

    public String getSecureTokenSharedSecret() {
        return this.secureTokenSharedSecret;
    }

    public void setSecureTokenSharedSecret(String string) {
        this.secureTokenSharedSecret = string;
    }

    public String getAkamaiUserName() {
        return this.akamaiUserName;
    }

    public void setAkamaiUserName(String string) {
        this.akamaiUserName = string;
    }

    public String getAkamaiPassword() {
        return this.akamaiPassword;
    }

    public void setAkamaiPassword(String string) {
        this.akamaiPassword = string;
    }

    public String getAkamaiOriginIp() {
        return this.akamaiOriginIp;
    }

    public void setAkamaiOriginIp(String string) {
        this.akamaiOriginIp = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAkamaiOriginPort() {
        if (this.akamaiOriginPort == null) {
            return -1;
        }
        int n = this.akamaiOriginPort;
        return n;
    }

    public void setAkamaiOriginPort(int n) {
        this.akamaiOriginPort = new Integer(n);
    }

    public boolean isSendFCAnnounce() {
        return this.sendFCAnnounce;
    }

    public void setSendFCAnnounce(boolean bl) {
        this.sendFCAnnounce = bl;
    }

    public long getValidationFrequency() {
        return this.validationFrequency;
    }

    public void setValidationFrequency(long l) {
        this.validationFrequency = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(IPushPublishRTMPNotify iPushPublishRTMPNotify) {
        List<IPushPublishRTMPNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.add(iPushPublishRTMPNotify);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeListener(IPushPublishRTMPNotify iPushPublishRTMPNotify) {
        List<IPushPublishRTMPNotify> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(iPushPublishRTMPNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IPushPublishRTMPNotify> getLocalListeners() {
        ArrayList<IPushPublishRTMPNotify> arrayList = new ArrayList<IPushPublishRTMPNotify>();
        List<IPushPublishRTMPNotify> list = this.listeners;
        synchronized (list) {
            arrayList.addAll(this.listeners);
            return arrayList;
        }
    }

    protected void notifyConnectStart(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onConnectStart(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifyConnectSuccess(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onConnectSuccess(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifyConnectFailure(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onConnectFailure(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifyHandshakeResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onHandshakeResult(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyAkamaiSetChallenge(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onAkamaiSetChallenge(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyAkamaiSetOriginConnectionInfo(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onAkamaiSetOriginConnectionInfo(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyAkamaiClientLogin(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onAkamaiClientLogin(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyFCPublish(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onFCPublish(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyFCAnnounce(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onFCAnnounce(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyConnect(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onConnect(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyStreamCreate(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onStreamCreate(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyStreamOnPlayStatus(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onStreamOnPlayStatus(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyStreamOnStatus(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, RequestFunction requestFunction, AMFDataList aMFDataList) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onStreamOnStatus(pushPublishRTMPNetConnectionSession, requestFunction, aMFDataList);
        }
        return;
    }

    protected void notifyPublishHandlerPlay(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, OutputStream outputStream, long[] lArray) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onPublishHandlerPlay(pushPublishRTMPNetConnectionSession, outputStream, lArray);
        }
        return;
    }

    protected void notifySessionIdle(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onSessionIdle(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifySessionOpened(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onSessionOpened(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifySessionClosed(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onSessionClosed(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifyValidateSession(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onValidateSession(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifyValidateSessionResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, boolean bl) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onValidateSessionResult(pushPublishRTMPNetConnectionSession, bl);
        }
        return;
    }

    protected void notifyPushPublisherSessionCreate(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onPushPublisherSessionCreate(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    protected void notifyPushPublisherSessionDestroy(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        List<IPushPublishRTMPNotify> list = this.getLocalListeners();
        Iterator<IPushPublishRTMPNotify> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPushPublishRTMPNotify iPushPublishRTMPNotify = iterator.next();
            iPushPublishRTMPNotify.onPushPublisherSessionDestroy(pushPublishRTMPNetConnectionSession);
        }
        return;
    }

    public long getConnectLastAttempt() {
        return this.connectLastAttempt;
    }

    public void setConnectLastAttempt(long l) {
        this.connectLastAttempt = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void bumpReconnectWaitTime() {
        this.reconnectWaitTime = this.reconnectWaitTime > 0 ? (int)((double)this.reconnectWaitTime * 1.5) : 3000;
        if (this.reconnectWaitTime < 60000) return;
        this.reconnectWaitTime = 60000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getReconnectDelay(long l) {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.connectLastAttempt < 0L) return n;
            if (this.reconnectWaitTime <= 0) return n;
            long l2 = l - this.connectLastAttempt;
            if (l2 <= 0L) return n;
            if (l2 >= (long)this.reconnectWaitTime) return n;
            return (int)((long)this.reconnectWaitTime - l2);
        }
    }

    public long getConnectLastSuccess() {
        return this.connectLastSuccess;
    }

    public void setConnectLastSuccess(long l) {
        this.connectLastSuccess = l;
    }

    @Override
    public boolean isSendOriginalTimecodes() {
        return this.sendOriginalTimecodes;
    }

    @Override
    public void setSendOriginalTimecodes(boolean bl) {
        this.sendOriginalTimecodes = bl;
    }

    @Override
    public long getOriginalTimecodeThreshold() {
        return this.originalTimecodeThreshold;
    }

    @Override
    public void setOriginalTimecodeThreshold(long l) {
        this.originalTimecodeThreshold = l;
    }

    public boolean isDebugLog() {
        return this.rtmpDebugLog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDebugLog(boolean bl) {
        this.rtmpDebugLog = bl;
        if (!this.pushPublishStreamDebug) {
            return;
        }
        this.rtmpDebugLog = true;
    }

    @Override
    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    @Override
    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    @Override
    public String getSrcStreamName() {
        return this.srcStreamName;
    }

    @Override
    public void setSrcStreamName(String string) {
        this.srcStreamName = string;
    }

    @Override
    public String getDstStreamName() {
        return this.dstStreamName;
    }

    @Override
    public void setDstStreamName(String string) {
        this.dstStreamName = string;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int n) {
        this.port = n;
    }

    public String getDstApplicationName() {
        return this.dstApplicationName;
    }

    public void setDstApplicationName(String string) {
        this.dstApplicationName = string;
    }

    public String getDstAppInstanceName() {
        return this.dstAppInstanceName;
    }

    public void setDstAppInstanceName(String string) {
        this.dstAppInstanceName = string;
    }

    public IPushPublishRTMPAuthProvider getRTMPAuthProvider() {
        return this.rtmpAuthProvider;
    }

    public void setRTMPAuthProvider(IPushPublishRTMPAuthProvider iPushPublishRTMPAuthProvider) {
        this.rtmpAuthProvider = iPushPublishRTMPAuthProvider;
    }

    public boolean isSendOnMetadata() {
        return this.sendOnMetadata;
    }

    public void setSendOnMetadata(boolean bl) {
        this.sendOnMetadata = bl;
    }

    public boolean isRemoveDefaultAppInstance() {
        return this.removeDefaultAppInstance;
    }

    public void setRemoveDefaultAppInstance(boolean bl) {
        this.removeDefaultAppInstance = bl;
    }

    public boolean isOnMetadataToSetDataFrame() {
        return this.onMetadataToSetDataFrame;
    }

    public void setOnMetadataToSetDataFrame(boolean bl) {
        this.onMetadataToSetDataFrame = bl;
    }

    public boolean isSendStreamCloseCommands() {
        return this.sendStreamCloseCommands;
    }

    public void setSendStreamCloseCommands(boolean bl) {
        this.sendStreamCloseCommands = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AMFDataList convertDataEvenToAMFData(AMFPacket aMFPacket) {
        AMFDataList aMFDataList = null;
        try {
            byte[] byArray;
            if (aMFPacket.getType() != 18) {
                if (aMFPacket.getType() != 15) return aMFDataList;
            }
            if ((byArray = aMFPacket.getData()) == null) {
                return aMFDataList;
            }
            if (aMFPacket.getSize() <= 1) {
                return aMFDataList;
            }
            int n = 0;
            if (byArray[0] != 0) return new AMFDataList(byArray, n, byArray.length - n);
            ++n;
            return new AMFDataList(byArray, n, byArray.length - n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(35 + 76), (String)"\u001f%\":\u0003!7:>+1\b\u000f\u0011\rp<ootfvqBf|hO}icZ`Q\\TWuawL") + this.getContextStr() + Base64.subSequence((int)(55 * 11), (String)"\u0000d\u007f"), (Throwable)exception);
            return aMFDataList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AMFPacket convertOnMetadataToSetDataFrame(AMFPacket aMFPacket) {
        AMFDataList aMFDataList;
        AMFPacket aMFPacket2;
        block9: {
            aMFPacket2 = aMFPacket;
            try {
                if (aMFPacket.getType() == 18 || aMFPacket.getType() == 15) break block9;
                return aMFPacket2;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"SqvnW}kfb\u007fe\\[]A<p{{`rjmUuQxj~d`vbPjUb|Mk\u007fmK|n}tI", (int)(671 / 199)) + this.getContextStr() + JSON.replace((String)"\fhs", (int)(20 - 35)), (Throwable)exception);
                return aMFPacket2;
            }
        }
        byte[] byArray = aMFPacket.getData();
        if (byArray == null) {
            return aMFPacket2;
        }
        if (aMFPacket.getSize() <= 1) {
            return aMFPacket2;
        }
        int n = 0;
        if (byArray[0] == 0) {
            ++n;
        }
        if ((aMFDataList = new AMFDataList(byArray, n, byArray.length - n)).size() <= 1) {
            return aMFPacket2;
        }
        if (aMFDataList.get(0).getType() != 2) {
            return aMFPacket2;
        }
        String string = aMFDataList.getString(0);
        if (!string.equalsIgnoreCase(JSON.replace((String)"==\u00190\"6\u001c8.:", (int)(66 + 16)))) {
            return aMFPacket2;
        }
        aMFDataList.add(0, (AMFData)new AMFDataItem(Base64.subSequence((int)(37 - -10), (String)"OctfWuawQjxw~")));
        byte[] byArray2 = aMFDataList.serialize();
        if (byArray2 == null) return aMFPacket2;
        aMFPacket2 = new AMFPacket(18, 0, byArray2.length);
        aMFPacket2.addData(byArray2, 0, byArray2.length);
        return aMFPacket2;
    }

    public int getStreamCloseWaitTime() {
        return this.streamCloseWaitTime;
    }

    public void setStreamCloseWaitTime(int n) {
        this.streamCloseWaitTime = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() {
        if (!this.sendStreamCloseCommands) {
            this.a();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.sendStreamCloseCommandsSendTime = System.currentTimeMillis();
        }
        this.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a() {
        Object object = this.lock;
        synchronized (object) {
            PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = this.getLastSession();
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Ust`Y\u007fi`d}gBE_C:q\u007fd{vtuy~jD", (int)(49 * 53)) + this.getContextStr() + JSON.replace((String)"\blw", (int)(56 - -29)) + pushPublishRTMPNetConnectionSession);
            this.tryConnect = false;
            if (pushPublishRTMPNetConnectionSession == null) return;
            this.b(pushPublishRTMPNetConnectionSession);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void b() {
        IMediaStream iMediaStream;
        INetConnection iNetConnection = this.getNetConnection();
        if (iNetConnection == null) {
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"KinvOucnjwmTSEY$xicjL|~avGadrytYtqp\u007fq$2\u0019", (int)(25 + 2)) + this.getContextStr() + Base64.subSequence((int)(3 - 50), (String)"\fhs:0\"4774>?)70.a,,0e (='.gl';<$q6:'6996<9/539\u007fsdqpmjh"));
            this.a();
            return;
        }
        if (this.rtmpDebugLog) {
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"W}zb[yobfcy@GYE8d}w~Hho{~mBnlw`Ehedkeh~U", (int)(-63 - 58)) + this.getContextStr() + "]");
        }
        try {
            if (this.sendFCPublish) {
                iNetConnection.call(JSON.replace((String)"EGPhw}kfb\u007fe", (int)(540 / 178)), (INetConnectionCallResult)new FCUnpublishResult(), new Object[]{this.dstStreamName});
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(782 / 221), (String)"SqvnW}kfb\u007fe\\[]A<`q{rTtvi~OilzalAlihgilz0Ntnk\u007fdx}}O") + this.getContextStr() + JSON.replace((String)"\blw", (int)(51 + 34)), (Throwable)exception);
            return;
        }
        int n = 0;
        PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = this.getSessionHolderByNetConnection(iNetConnection);
        if (pushPublishRTMPNetConnectionSession != null && (iMediaStream = pushPublishRTMPNetConnectionSession.publishStream) != null) {
            n = iMediaStream.getSrc();
            iNetConnection.call(Base64.subSequence((int)(37 * 31), (String)"802-:Supfeh"), iMediaStream, null, new Object[0]);
        }
        iNetConnection.call(Base64.subSequence((int)(560 / 173), (String)"gaicsmZ~yilc"), null, new Object[]{new AMFDataItem(n)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFlashVerionFMLE(String string) {
        boolean bl = false;
        if (string == null) return bl;
        if (string.startsWith(Base64.subSequence((int)(63 + 116), (String)"UYYS8"))) return true;
        if (!string.startsWith(Base64.subSequence((int)(82 + 20), (String)"\u0000\n\rf"))) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isFlashVersionFMLE(String string) {
        boolean bl = false;
        if (string == null) return bl;
        if (string.startsWith(JSON.replace((String)"\b\u0002\u001c\u0014}", (int)(92 + 18)))) return true;
        if (!string.startsWith(Base64.subSequence((int)(19 * 21), (String)"I]T="))) return false;
        return true;
    }

    public boolean isDebugPackets() {
        return this.debugPackets;
    }

    public void setDebugPackets(boolean bl) {
        this.debugPackets = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTotalPacketsSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalPacketsSent;
        }
    }

    public boolean isResetOnTimecodeOutOfOrder() {
        return this.resetOnTimecodeOutOfOrder;
    }

    public void setResetOnTimecodeOutOfOrder(boolean bl) {
        this.resetOnTimecodeOutOfOrder = bl;
    }

    public int getTimecodesOutOfOrderThreshold() {
        return this.timecodesOutOfOrderThreshold;
    }

    public void setTimecodesOutOfOrderThreshold(int n) {
        this.timecodesOutOfOrderThreshold = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLastVideoTC() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastVideoTC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLastAudioTC() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastAudioTC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLastDataTC() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastDataTC;
        }
    }

    private final void c() {
        this.waitOnMetadataStartime = -1L;
        this.waitOnMetadataReady = false;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean a(IMediaStream var1_1, AMFPacket var2_2) {
        block70: {
            block64: {
                block50: {
                    block66: {
                        block68: {
                            block40: {
                                block53: {
                                    block71: {
                                        block55: {
                                            block63: {
                                                block60: {
                                                    block58: {
                                                        block54: {
                                                            block59: {
                                                                block62: {
                                                                    block48: {
                                                                        block47: {
                                                                            block67: {
                                                                                block45: {
                                                                                    block44: {
                                                                                        block61: {
                                                                                            block51: {
                                                                                                block46: {
                                                                                                    block57: {
                                                                                                        block43: {
                                                                                                            block56: {
                                                                                                                block42: {
                                                                                                                    block69: {
                                                                                                                        block52: {
                                                                                                                            block41: {
                                                                                                                                block39: {
                                                                                                                                    block65: {
                                                                                                                                        block49: {
                                                                                                                                            var3_3 = true;
                                                                                                                                            var4_4 = false;
                                                                                                                                            var5_5 = false;
                                                                                                                                            var6_6 = false;
                                                                                                                                            var7_7 = false;
                                                                                                                                            var8_8 = 0;
                                                                                                                                            var9_9 = 0L;
                                                                                                                                            if (this.sendOnMetadata) break block65;
                                                                                                                                            break block58;
lbl10:
                                                                                                                                            // 1 sources

                                                                                                                                            while (true) {
                                                                                                                                                if (!var4_4) break block39;
                                                                                                                                                break block40;
                                                                                                                                                break;
                                                                                                                                            }
lbl13:
                                                                                                                                            // 1 sources

                                                                                                                                            while (true) {
                                                                                                                                                if (var23_20 == 8) break block41;
                                                                                                                                                ** GOTO lbl38
                                                                                                                                                break;
                                                                                                                                            }
lbl16:
                                                                                                                                            // 2 sources

                                                                                                                                            while (true) {
                                                                                                                                                if (!var24_21.containsKey(Base64.subSequence((int)(884 / 246), (String)"bqaohlh~j~lzj"))) ** GOTO lbl38
                                                                                                                                                break block42;
                                                                                                                                                break;
                                                                                                                                            }
lbl19:
                                                                                                                                            // 1 sources

                                                                                                                                            while (true) {
                                                                                                                                                var22_19 = var21_18.getString(0);
                                                                                                                                                if (var22_19.equalsIgnoreCase(Base64.subSequence((int)(47 - -12), (String)"trP{k!\u0005#7%"))) break block43;
                                                                                                                                                ** GOTO lbl38
lbl23:
                                                                                                                                                // 1 sources

                                                                                                                                                while (true) {
                                                                                                                                                    var7_7 = true;
                                                                                                                                                    ** GOTO lbl38
                                                                                                                                                    break;
                                                                                                                                                }
lbl26:
                                                                                                                                                // 1 sources

                                                                                                                                                while (var18_15.getType() != 15) {
                                                                                                                                                    ** GOTO lbl38
                                                                                                                                                }
                                                                                                                                                break block44;
lbl29:
                                                                                                                                                // 2 sources

                                                                                                                                                while (true) {
                                                                                                                                                    if (!var24_21.containsKey(Base64.subSequence((int)(97 + 50), (String)"raq\u007fx{v~~\u007ftz"))) ** GOTO lbl16
                                                                                                                                                    break block45;
                                                                                                                                                    break;
                                                                                                                                                }
lbl32:
                                                                                                                                                // 1 sources

                                                                                                                                                while (var18_15.getSize() <= 0) {
                                                                                                                                                    ** GOTO lbl38
                                                                                                                                                }
                                                                                                                                                break block46;
                                                                                                                                                break;
                                                                                                                                            }
lbl35:
                                                                                                                                            // 2 sources

                                                                                                                                            while (true) {
                                                                                                                                                var21_18 = new AMFDataList(var19_16, var20_17, var19_16.length - var20_17);
                                                                                                                                                if (var21_18.size() > 1) break block47;
lbl38:
                                                                                                                                                // 17 sources

                                                                                                                                                while (true) {
                                                                                                                                                    if (!var17_14.hasNext()) break block48;
                                                                                                                                                    break block49;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                break;
                                                                                                                                            }
lbl41:
                                                                                                                                            // 1 sources

                                                                                                                                            while (!this.waitOnMetadataVideo) {
                                                                                                                                                break block50;
                                                                                                                                            }
                                                                                                                                            break block66;
lbl44:
                                                                                                                                            // 2 sources

                                                                                                                                            while (true) {
                                                                                                                                                if (!var24_21.containsKey(Base64.subSequence((int)(542 / 113), (String)"epbngmk\u007fm\u007fo{u"))) ** GOTO lbl38
                                                                                                                                                ** continue;
                                                                                                                                                break;
                                                                                                                                            }
lbl47:
                                                                                                                                            // 2 sources

                                                                                                                                            while (var24_21.containsKey(Base64.subSequence((int)(46 - 50), (String)"*4::oecwewgsm"))) {
                                                                                                                                                break block51;
                                                                                                                                            }
                                                                                                                                            break block67;
lbl50:
                                                                                                                                            // 2 sources

                                                                                                                                            while (var21_18.size() <= 1) {
                                                                                                                                                ** GOTO lbl38
                                                                                                                                            }
                                                                                                                                            break block68;
lbl53:
                                                                                                                                            // 1 sources

                                                                                                                                            while (var18_15.getType() != 18) {
                                                                                                                                                ** GOTO lbl26
                                                                                                                                            }
                                                                                                                                            break block44;
                                                                                                                                        }
                                                                                                                                        var18_15 = (AMFPacket)var17_14.next();
                                                                                                                                        if (var18_15 != null) ** GOTO lbl32
                                                                                                                                        ** GOTO lbl38
                                                                                                                                    }
                                                                                                                                    if (this.waitOnMetadataAvailable) break block69;
                                                                                                                                    break block58;
                                                                                                                                }
lbl64:
                                                                                                                                // 5 sources

                                                                                                                                while (true) {
                                                                                                                                    if (!this.waitOnMetadataReady) break block52;
                                                                                                                                    break block53;
                                                                                                                                    break;
                                                                                                                                }
lbl67:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    this.waitOnMetadataReady = true;
                                                                                                                                    ** GOTO lbl64
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                            }
lbl71:
                                                                                                                            // 2 sources

                                                                                                                            while (true) {
                                                                                                                                ++var8_8;
                                                                                                                                if (var23_20 != 3) break block54;
                                                                                                                                break block55;
                                                                                                                                break;
                                                                                                                            }
lbl75:
                                                                                                                            // 1 sources

                                                                                                                            while (true) {
                                                                                                                                if (!var5_5) ** GOTO lbl64
                                                                                                                                break block56;
                                                                                                                                break;
                                                                                                                            }
lbl78:
                                                                                                                            // 1 sources

                                                                                                                            while ((var24_21 = (AMFDataMixedArray)var21_18.get(1)).containsKey(JSON.replace((String)"?#/)\"- 441:0", (int)(120 + 81)))) {
                                                                                                                                break block57;
                                                                                                                            }
                                                                                                                            ** GOTO lbl47
                                                                                                                        }
lbl82:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            if (!this.rtmpDebugLog) break block58;
                                                                                                                            break block59;
                                                                                                                            break;
                                                                                                                        }
lbl85:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            if (!var7_7) ** GOTO lbl64
                                                                                                                            ** GOTO lbl67
                                                                                                                            break;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (!this.waitOnMetadataReady) ** GOTO lbl41
                                                                                                                    break block58;
lbl91:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        this.waitOnMetadataStartime = var11_10;
                                                                                                                        break block60;
                                                                                                                        while (true) {
                                                                                                                            var14_12 = var2_2.getAbsTimecode();
                                                                                                                            var16_13 = new ArrayList<E>();
                                                                                                                            var13_11.onStreamStart(var16_13, var14_12);
                                                                                                                            var17_14 = var16_13.iterator();
                                                                                                                            ** GOTO lbl38
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        break;
                                                                                                                    }
lbl100:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        this.waitOnMetadataReady = true;
                                                                                                                        break block58;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                var7_7 = true;
                                                                                                                ** GOTO lbl38
                                                                                                            }
lbl107:
                                                                                                            // 2 sources

                                                                                                            while (true) {
                                                                                                                if (!this.waitOnMetadataVideoDatarate) break block61;
                                                                                                                break block62;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        ** while ((var23_20 = var21_18.get((int)1).getType()) == 3)
lbl112:
                                                                                                        // 1 sources

                                                                                                        ** while (true)
                                                                                                    }
                                                                                                    var4_4 = true;
                                                                                                    ** GOTO lbl47
                                                                                                    while (true) {
                                                                                                        if ((var13_11 = var1_1.getMetaDataProvider()) != null) ** continue;
                                                                                                        break block58;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var19_16 = var18_15.getData();
                                                                                                if (var19_16 != null) ** GOTO lbl53
                                                                                                ** GOTO lbl38
lbl123:
                                                                                                // 1 sources

                                                                                                while (true) {
                                                                                                    ++var20_17;
                                                                                                    ** GOTO lbl35
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            var6_6 = true;
                                                                                            break block67;
                                                                                        }
lbl130:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            if (this.waitOnMetadataAudioDatarate) ** break;
                                                                                            ** continue;
                                                                                            ** continue;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    if (var18_15.getSize() > 1) break block70;
                                                                                    ** GOTO lbl38
lbl137:
                                                                                    // 1 sources

                                                                                    while (true) {
                                                                                        var21_18.remove(0);
                                                                                        ** GOTO lbl50
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                var5_5 = true;
                                                                                ** while (true)
                                                                            }
                                                                            if (!var24_21.containsKey(JSON.replace((String)"4#3169488=6$", (int)(31 * 11)))) ** GOTO lbl44
                                                                            break block71;
lbl147:
                                                                            // 1 sources

                                                                            while ((var22_19 = var21_18.getString(0)).equals(Base64.subSequence((int)(45 * 51), (String)"\u0017+<.\u001f=)?\u0019r`of"))) {
                                                                                ** continue;
lbl149:
                                                                                // 1 sources

                                                                                ** GOTO lbl137
                                                                            }
                                                                            ** GOTO lbl50
                                                                        }
                                                                        if (var21_18.get(0).getType() == 2) ** GOTO lbl147
                                                                        ** GOTO lbl38
                                                                    }
                                                                    if (this.waitOnMetadataVideo) {
                                                                        ** continue;
                                                                    }
                                                                    break block40;
                                                                }
                                                                if (var6_6) ** break;
                                                                ** while (true)
                                                                ** while (true)
                                                            }
                                                            WMSLoggerFactory.getLogger(PushPublishRTMP.CLASS).info(JSON.replace((String)"\u0005#$0\t/904-7RUOS_", (int)(35 * 7)) + this.getContextStr() + Base64.subSequence((int)(630 / 92), (String)"[)azEeAhzntpfrFpwsa#:xshpk:") + var8_8 + JSON.replace((String)"2g}xs-", (int)(-9 - -27)) + var9_9 + Base64.subSequence((int)(-15 - 53), (String)"<kw{%.x") + this.waitOnMetadataVideo + "/" + var4_4 + JSON.replace((String)";jtzz/\u0013#7!\u007f", (int)(45 * 7)) + this.waitOnMetadataVideoDatarate + "/" + var6_6 + JSON.replace((String)"g)<.\"#w", (int)(43 * 53)) + this.waitOnMetadataAudio + "/" + var5_5 + Base64.subSequence((int)(1171 / 227), (String)"%grl`eYmyk5") + this.waitOnMetadataAudioDatarate + "/" + var7_7 + JSON.replace((String)"w*<;?%g", (int)(101 + 18)) + this.waitOnMetadataReady + "/" + var3_3);
                                                            break block58;
lbl165:
                                                            // 1 sources

                                                            while (true) {
                                                                var6_6 = true;
                                                                ** GOTO lbl29
                                                                break;
                                                            }
                                                        }
                                                        if (var23_20 != 8) ** GOTO lbl38
                                                        ** GOTO lbl78
lbl171:
                                                        // 1 sources

                                                        while (true) {
                                                            var4_4 = true;
                                                            break block63;
                                                            break;
                                                        }
                                                    }
lbl175:
                                                    // 2 sources

                                                    return var3_3;
                                                }
                                                while (true) {
                                                    if ((var9_9 = var11_10 - this.waitOnMetadataStartime) <= this.waitOnMetadataTimeout) ** continue;
                                                    break block64;
                                                    break;
                                                }
                                            }
lbl182:
                                            // 2 sources

                                            while (true) {
                                                if (var24_21.containsKey(Base64.subSequence((int)(32 + -5), (String)"muy{pd`vbvdrb"))) ** break;
                                                ** continue;
                                                ** continue;
                                                break;
                                            }
                                        }
                                        ** while (!(var24_21 = (AMFDataObj)var21_18.get((int)1)).containsKey((String)Base64.subSequence((int)(64 + 12), (String)":$**?2=716?3")))
lbl188:
                                        // 1 sources

                                        ** while (true)
                                    }
                                    var5_5 = true;
                                    ** while (true)
                                }
                                var3_3 = true;
                                ** while (true)
                            }
                            ** while (!this.waitOnMetadataAudio)
lbl197:
                            // 1 sources

                            ** while (true)
lbl198:
                            // 1 sources

                            while (true) {
                                WMSLoggerFactory.getLogger(PushPublishRTMP.CLASS).info(Base64.subSequence((int)(59 * 51), (String)"\u001170,\u00153%$ 9#\u001e\u0019\u0003\u001f\u000b") + this.getContextStr() + JSON.replace((String)"\u0002.hqLjHcsimk\u007fm_knth(3@|{rwln!<", (int)(47 * 49)) + var9_9 + ">" + this.waitOnMetadataTimeout);
                                ** GOTO lbl100
                                break;
                            }
                        }
                        ** while (var21_18.get((int)0).getType() == 2)
lbl203:
                        // 1 sources

                        ** while (true)
                    }
lbl205:
                    // 2 sources

                    while (true) {
                        var3_3 = false;
                        var11_10 = System.currentTimeMillis();
                        if (this.waitOnMetadataStartime >= 0L) ** continue;
                        ** continue;
                        break;
                    }
                }
                ** while (this.waitOnMetadataAudio)
lbl212:
                // 1 sources

                ** while (true)
            }
            if (this.rtmpDebugLog) ** break;
            ** while (true)
            ** while (true)
        }
        var20_17 = 0;
        if (var19_16[0] == 0) ** break;
        ** while (true)
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWaitOnMetadataAvailable() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitOnMetadataAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWaitOnMetadataAvailable(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.waitOnMetadataAvailable = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWaitOnMetadataVideo() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitOnMetadataVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWaitOnMetadataVideo(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.waitOnMetadataVideo = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWaitOnMetadataAudio() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitOnMetadataAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWaitOnMetadataAudio(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.waitOnMetadataAudio = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getWaitOnMetadataTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitOnMetadataTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWaitOnMetadataTimeout(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.waitOnMetadataTimeout = l;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWaitOnMetadataVideoDatarate() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitOnMetadataVideoDatarate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWaitOnMetadataVideoDatarate(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.waitOnMetadataVideoDatarate = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWaitOnMetadataAudioDatarate() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitOnMetadataAudioDatarate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWaitOnMetadataAudioDatarate(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.waitOnMetadataAudioDatarate = bl;
            return;
        }
    }

    public long getSrcStreamBufferSize() {
        return this.srcStreamBufferSize;
    }

    public void setSrcStreamBufferSize(long l) {
        this.srcStreamBufferSize = l;
    }

    public void addConnectMetaData(String string, AMFData aMFData) {
        this.connectMetaData.put(string, aMFData);
    }

    @Override
    public IPushPublishSession createPushPublishSession() {
        PushPublishSessionRTMP pushPublishSessionRTMP = new PushPublishSessionRTMP();
        pushPublishSessionRTMP.setPushPublishImpl(this);
        return pushPublishSessionRTMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPacketsSentAudio() {
        Object object = this.lock;
        synchronized (object) {
            return this.packetsSentAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPacketsSentVideo() {
        Object object = this.lock;
        synchronized (object) {
            return this.packetsSentVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPacketsSentData() {
        Object object = this.lock;
        synchronized (object) {
            return this.packetsSentData;
        }
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean bl) {
        this.isSSL = bl;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String string) {
        this.bindAddress = string;
    }

    static /* synthetic */ IMediaStream g(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.srcStream;
    }

    static /* synthetic */ String h(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.srcStreamName;
    }

    static /* synthetic */ IApplicationInstance i(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.appInstance;
    }

    static /* synthetic */ boolean a(PushPublishRTMP pushPublishRTMP, IMediaStream iMediaStream, AMFPacket aMFPacket) {
        return pushPublishRTMP.a(iMediaStream, aMFPacket);
    }

    static /* synthetic */ long j(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.originalTimecodeThreshold;
    }

    static /* synthetic */ long k(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.originalTimecodeThreshold;
    }

    static /* synthetic */ boolean l(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.pushPublishStreamDebug;
    }

    static /* synthetic */ long m(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.originalTimecodeThreshold;
    }

    static /* synthetic */ String n(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.srcStreamName;
    }

    static /* synthetic */ IApplicationInstance o(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.appInstance;
    }

    static /* synthetic */ IOPerformanceCounter p(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.sendingPerfomance;
    }

    static /* synthetic */ void x(PushPublishRTMP pushPublishRTMP) {
        pushPublishRTMP.c();
    }

    static /* synthetic */ IApplicationInstance y(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.appInstance;
    }

    static /* synthetic */ IApplicationInstance z(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.appInstance;
    }

    static /* synthetic */ void a(PushPublishRTMP pushPublishRTMP, PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
        pushPublishRTMP.b(pushPublishRTMPNetConnectionSession);
    }

    static /* synthetic */ int _(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.reconnectWaitTime;
    }

    static /* synthetic */ IApplicationInstance aa(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.appInstance;
    }

    static /* synthetic */ boolean ab(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.pushPublishStreamDebug;
    }

    static /* synthetic */ int ac(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.reconnectWaitTime;
    }

    static /* synthetic */ IApplicationInstance ad(PushPublishRTMP pushPublishRTMP) {
        return pushPublishRTMP.appInstance;
    }

    class Reconnector
    implements Runnable {
        Reconnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block18: {
                    block19: {
                        break block19;
lbl3:
                        // 1 sources

                        throw var6_4;
                    }
                    var1_1 = PushPublishRTMP.this.lock;
                    synchronized (var1_1) {
                        ** break block20
                    }
lbl9:
                    // 2 sources

                    while (true) {
                        continue;
                        {
                            while (true) {
                                var3_7 = new NetConnection(PushPublishRTMP.y(PushPublishRTMP.this), PushPublishRTMP.z(PushPublishRTMP.this).getVHost().getNextNetConnectionId());
                                var4_8 = new PushPublishRTMPNetConnectionSession((INetConnection)var3_7, null);
                                var3_7.setIdleHandler((INetConnectionIdle)new IdleHandler(var4_8));
                                var3_7.setPublishHandler((INetConnectionPublisher)new PublishHandler(var4_8));
                                PushPublishRTMP.this.notifyPushPublisherSessionCreate(var4_8);
                                PushPublishRTMP.this.notifyConnectStart(var4_8);
                                PushPublishRTMP.this.connectLastAttempt = System.currentTimeMillis();
                                var5_9 = PushPublishRTMP.this.internalConnect(var4_8);
                                if (var5_9 == null) break block17;
                                var4_8.setSession(var5_9);
                                PushPublishRTMP.this.addSession(var4_8);
                                PushPublishRTMP.this.isReconnectorRunning = false;
                                PushPublishRTMP.this.notifyConnectSuccess(var4_8);
                                break;
                            }
                        }
                        break;
                    }
lbl27:
                    // 1 sources

                    while (true) {
                        Thread.sleep(var1_2);
                        ** GOTO lbl9
                        break;
                    }
lbl30:
                    // 1 sources

                    throw var2_6;
                    var2_5 = PushPublishRTMP.this.lock;
                    synchronized (var2_5) {
                        block24: {
                            block23: {
                                block22: {
                                    block17: {
                                        ** break block21
                                    }
                                    PushPublishRTMP.a(PushPublishRTMP.this, var4_8);
                                    PushPublishRTMP.this.bumpReconnectWaitTime();
                                    if (PushPublishRTMP._(PushPublishRTMP.this) != 60000) break block22;
                                    break block23;
lbl41:
                                    // 3 sources

                                    while (true) {
                                        break block18;
                                        break;
                                    }
                                }
                                if (!PushPublishRTMP.ab(PushPublishRTMP.this)) ** GOTO lbl41
                                break block24;
                            }
                            WMSLoggerFactory.getLogger(PushPublishRTMP.CLASS).warn(Base64.subSequence((int)(-63 - 58), (String)"W}zb[yobfcy@GYE8E}zuurx}kosY") + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"M+2GFZCUT\\:XSSPZCUKMC$''Zl~yud`h0x|3\"%6d}zuuxn0?!12y", (int)(21 + 123)) + PushPublishRTMP.aa(PushPublishRTMP.this).getContextStr());
                            ** GOTO lbl41
                        }
                        WMSLoggerFactory.getLogger(PushPublishRTMP.CLASS).warn(Base64.subSequence((int)(-37 - 5), (String)"\u0006\"+1\n.>17,(\u0013\u0016\u000e\u0014k\u0014\"+&$%).: \"\n") + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(57 - -8), (String)"\u001cxc\u0016\u0011\u000b\u0017h\u001a/8?$!!p73:802w,6z8330:#5lcd\u0017#3:0#%+m'!p") + PushPublishRTMP.ac(PushPublishRTMP.this) + Base64.subSequence((int)(57 * 15), (String)"w5*?8"));
                        ** continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        PushPublishRTMP.this.doSendOnMetaData = true;
                        PushPublishRTMP.this.totalPacketsSent = 0L;
                        PushPublishRTMP.this.debugLogLastPacketCount = -1L;
                        PushPublishRTMP.this.lastVideoTC = -1L;
                        PushPublishRTMP.this.lastAudioTC = -1L;
                        PushPublishRTMP.this.lastDataTC = -1L;
                        PushPublishRTMP.this.packetsSentAudio = 0L;
                        PushPublishRTMP.this.packetsSentVideo = 0L;
                        PushPublishRTMP.this.packetsSentData = 0L;
                        PushPublishRTMP.this.onlineTime = -1L;
                        PushPublishRTMP.x(PushPublishRTMP.this);
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (PushPublishRTMP.this.tryConnect) ** continue;
                        PushPublishRTMP.this.isReconnectorRunning = false;
                    }
                    {
                        catch (Throwable var2_6) {
                            // MONITOREXIT @DISABLED, blocks:[0, 5, 7] lbl69 : MonitorExitStatement: MONITOREXIT : var1_1
                            ** continue;
                        }
                    }
                }
                if ((var1_2 = PushPublishRTMP.this.getReconnectDelay(System.currentTimeMillis())) > 0) ** break;
                ** continue;
                ** continue;
                {
                    catch (Throwable var6_4) {
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 8] lbl75 : MonitorExitStatement: MONITOREXIT : var2_5
                        ** continue;
                    }
                }
lbl81:
                // 3 sources

                return;
            }
            catch (Exception var1_3) {
                WMSLoggerFactory.getLogger(PushPublishRTMP.CLASS).error(Base64.subSequence((int)(-21 - 35), (String)"\u0018<9#\u001c8,#9\":\u0001\u0000\u0018\u0006y\n<9423;<4.0yd$67r") + PushPublishRTMP.ad(PushPublishRTMP.this).getContextStr(), (Throwable)var1_3);
                ** continue;
            }
        }
    }

    class HandshakeResult
    implements INetConnectionCallResult {
        PushPublishRTMPNetConnectionSession a = null;

        public HandshakeResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyHandshakeResult(this.a, requestFunction, aMFDataList);
            if (PushPublishRTMP.this.akamaiUserName != null) {
                iNetConnection.registerCallback(Base64.subSequence((int)(28 + 59), (String)"$=-\u00193=12:.&'"), (INetConnectionCallback)new SetChallengeResult(this.a));
                iNetConnection.registerCallback(Base64.subSequence((int)(7 * 53), (String)" 1!\u0019%1>35\u001f201ebvjkkOinf"), (INetConnectionCallback)new SetOriginConnectionInfoResult(this.a));
            }
            PushPublishRTMP.this.callConnect(this.a, null);
        }
    }

    class SetChallengeResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public SetChallengeResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyAkamaiSetChallenge(this.a, requestFunction, aMFDataList);
            String string = aMFDataList.getString(3);
            String string2 = aMFDataList.getString(4);
            String string3 = PushPublishRTMP.this.getAkamaiSessionKey(string);
            String string4 = MD5DigestUtils.generateHash((String)(string3 + ":" + string2 + ":" + PushPublishRTMP.this.akamaiPassword));
            String string5 = MD5DigestUtils.generateHash((String)(string2 + ":" + PushPublishRTMP.this.akamaiPassword + string4));
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"MklhQwahluoZ]G[/^k{Sys\u007fxpxp}K\u007fhiqj1//\u0001\"()$&+\"\u0011", (int)(13 - -16)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(9 * 33), (String)"T0+\u007fh}|y~|Zp/6") + string + Base64.subSequence((int)(602 / 145), (String)"$fnfdeoekh4") + string2);
            }
            iNetConnection.registerCallback(JSON.replace((String)"86\u001a6293*\u0013/&+-", (int)(46 - -41)), (INetConnectionCallback)new ClientLoginResult(this.a));
            iNetConnection.call(Base64.subSequence((int)(-64 - 46), (String)"Q\u007f}pxcTv}rr"), null, new Object[]{string3, string5});
        }
    }

    class SetOriginConnectionInfoResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public SetOriginConnectionInfoResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyAkamaiSetOriginConnectionInfo(this.a, requestFunction, aMFDataList);
            PushPublishRTMP.this.akamaiOriginIp = aMFDataList.getString(3);
            PushPublishRTMP.this.akamaiOriginPort = new Integer(aMFDataList.getInt(4));
            if (!PushPublishRTMP.this.rtmpDebugLog) {
                return;
            }
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"NjsiRvfiot`[^F\\.]jd^`zs|xTwwt~\u007fiwp.\b,%+\u0017#4=%>e##\r.<=027>\r", (int)(45 + -15)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(-51 - 38), (String)"Z2)k`m`of_c{t}{_g\"9") + PushPublishRTMP.this.akamaiOriginIp + Base64.subSequence((int)(63 * 59), (String)"%glidkbC\u007fghy\u007fB|fa,") + PushPublishRTMP.this.akamaiOriginPort);
        }
    }

    class ClientLoginResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public ClientLoginResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            block8: {
                block9: {
                    block10: {
                        block7: {
                            PushPublishRTMP.this.notifyAkamaiClientLogin(this.a, requestFunction, aMFDataList);
                            AMFDataObj aMFDataObj = ClientLoginResult.getParamObj((AMFDataList)aMFDataList, (int)3);
                            if (aMFDataObj == null) return;
                            String string = aMFDataObj.getString(JSON.replace((String)"0;13", (int)(-26 - -13)));
                            if (PushPublishRTMP.this.rtmpDebugLog) {
                                WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(53 * 45), (String)"\u0001' <\u0005#540)3\u000e\t\u0013\u000fc\u0002.*!+2\u000b'.#%\u001e(=:<%|<:\u00167;4;;87\u0006") + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"\u001ari8.?8\";jq", (int)(-39 - 18)) + string);
                            }
                            if (!string.equals(JSON.replace((String)"\r&/\"18|\u0010;;82;-t\b)>=:sr", (int)(-27 - -7)))) return;
                            if (PushPublishRTMP.this.sendFCAnnounce) {
                                if (PushPublishRTMP.this.sendReleaseStream) {
                                    if (PushPublishRTMP.this.rtmpDebugLog) {
                                        WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\u001d;<8\u0001'18<%?\n\r\u0017\u000b\u007f\u001e26%/6\u000f+\"/)\u001a,9> 9` >\u00123?87743\u0002", (int)(53 * 57)) + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"[=(jkg`-|j|ts`qFbe}xw!<", (int)(947 / 157)) + PushPublishRTMP.this.dstStreamName);
                                    }
                                    iNetConnection.call(Base64.subSequence((int)(70 + 60), (String)"pfh`gtmZ~yilc"), null, new Object[]{PushPublishRTMP.this.dstStreamName});
                                }
                                if (PushPublishRTMP.this.rtmpDebugLog) {
                                    WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(1252 / 217), (String)"Ust`Y\u007fi`d}gBE_C7Vz~}wnWszwqRdqvhq(hfJkg`ool{J") + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(81 + -31), (String)"O)4vw{t9\\X]spp5/!&~e") + PushPublishRTMP.this.dstStreamName);
                                }
                                iNetConnection.registerCallback(Base64.subSequence((int)(198 / 62), (String)"ljCEFfge~bnk"), (INetConnectionCallback)new AkamaiFCAnnounceResult(this.a));
                                iNetConnection.call(JSON.replace((String)"CEFfge~bnk", (int)(488 / 86)), null, new Object[]{PushPublishRTMP.this.dstStreamName});
                            }
                            if (!PushPublishRTMP.this.sendFCPublish) break block7;
                            if (!PushPublishRTMP.this.sendReleaseStream) break block8;
                            if (!PushPublishRTMP.this.rtmpDebugLog) break block9;
                            break block10;
                        }
                        if (PushPublishRTMP.this.sendReleaseStream) {
                            iNetConnection.call(Base64.subSequence((int)(1333 / 246), (String)"wckmhyn_y|jq|"), null, new Object[]{PushPublishRTMP.this.dstStreamName});
                        }
                        iNetConnection.call(JSON.replace((String)":(>=);\ftsgbi", (int)(82 + 39)), (INetConnectionCallResult)new StreamCreateResult(this.a), new Object[0]);
                        return;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(681 / 172), (String)"SqvnW}kfb\u007fe\\[]A1Px|sylUu|usLzstnw*jhDiefimneT") + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"D ;\u007f|rs`3'/!$5\"\u001b=8.- to", (int)(25 * 33)) + PushPublishRTMP.this.dstStreamName);
                }
                iNetConnection.call(JSON.replace((String)";/'),=*\u0003% 658", (int)(29 * 29)), null, new Object[]{PushPublishRTMP.this.dstStreamName});
            }
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(653 / 113), (String)"Ust`Y\u007fi`d}gBE_C7Vz~}wnWszwqRdqvhq(hfJkg`ool{J") + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"\u0003e bcoh%@DX|hge~f50", (int)(26 + 100)) + PushPublishRTMP.this.dstStreamName);
            }
            iNetConnection.registerCallback(Base64.subSequence((int)(521 / 84), (String)"iiNJZ~nag|x"), (INetConnectionCallback)new AkamaiFCPublishResult(this.a));
            iNetConnection.call(Base64.subSequence((int)(51 * 31), (String)"KM_es~zg}"), null, new Object[]{PushPublishRTMP.this.dstStreamName});
        }
    }

    class AkamaiFCPublishResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public AkamaiFCPublishResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyFCPublish(this.a, requestFunction, aMFDataList);
            AMFDataObj aMFDataObj = AkamaiFCPublishResult.getParamObj((AMFDataList)aMFDataList, (int)3);
            if (aMFDataObj == null) return;
            String string = aMFDataObj.getString(JSON.replace((String)"l\u007fuw", (int)(71 + -24)));
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(380 / 80), (String)"TpuoX|hge~f]D\\B0RVFbzushtO{lumv-kkEfdehjofU") + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(762 / 216), (String)"^>%tb{|f\u007f6-") + string);
            }
            if (!string.equals(JSON.replace((String)"AueAgfpwz6Ioyptmwn\u00126\"61", (int)(13 * 43)))) return;
            iNetConnection.call(JSON.replace((String)"lbtsgqFbe}xw", (int)(72 + -57)), (INetConnectionCallResult)new StreamCreateResult(this.a), new Object[0]);
        }
    }

    class FCUnpublishResult
    extends ModuleBase
    implements INetConnectionCallResult {
        FCUnpublishResult() {
        }

        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
        }
    }

    class FCPublishResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public FCPublishResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyFCPublish(this.a, requestFunction, aMFDataList);
            AMFDataObj aMFDataObj = FCPublishResult.getParamObj((AMFDataList)aMFDataList, (int)3);
            if (aMFDataObj == null) return;
            String string = aMFDataObj.getString(JSON.replace((String)".!+5", (int)(55 - -54)));
            if (!PushPublishRTMP.this.rtmpDebugLog) return;
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"MklhQwahluoZ]G[/KM_es~zg}Drklvo2rp\\!-.!%&-\u001c", (int)(-9 - -38)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(56 - -2), (String)"G!<o{l5-6yd") + string);
        }
    }

    class AkamaiFCAnnounceResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public AkamaiFCAnnounceResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyFCAnnounce(this.a, requestFunction, aMFDataList);
            AMFDataObj aMFDataObj = AkamaiFCAnnounceResult.getParamObj((AMFDataList)aMFDataList, (int)3);
            if (aMFDataObj == null) return;
            String string = aMFDataObj.getString(Base64.subSequence((int)(40 - 62), (String)")$(("));
            if (!PushPublishRTMP.this.rtmpDebugLog) return;
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Vr{aZ~nag|xCF^D6PTYwttis}z\u0012$16(1h(&\n+' //,;\n", (int)(50 + -12)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(-62 - 5), (String)"@$?2$16(1|g") + string);
        }
    }

    class FCAnnounceResult
    extends ModuleBase
    implements INetConnectionCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public FCAnnounceResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onCallback(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyFCAnnounce(this.a, requestFunction, aMFDataList);
            AMFDataObj aMFDataObj = FCAnnounceResult.getParamObj((AMFDataList)aMFDataList, (int)3);
            if (aMFDataObj == null) return;
            String string = aMFDataObj.getString(JSON.replace((String)"m`tt", (int)(121 + 21)));
            if (!PushPublishRTMP.this.rtmpDebugLog) return;
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Ust`Y\u007fi`d}gBE_C7SUVvwunr~{Merwop+iiKhfgnlmdK", (int)(475 / 90)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(639 / 113), (String)"X<'zly~`y4/") + string);
        }
    }

    class ConnectResult
    extends ModuleBase
    implements INetConnectionCallResult {
        PushPublishRTMPNetConnectionSession a = null;

        public ConnectResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyConnect(this.a, requestFunction, aMFDataList);
            AMFDataObj aMFDataObj = ConnectResult.getParamObj((AMFDataList)aMFDataList, (int)3);
            if (aMFDataObj == null) return;
            String string = aMFDataObj.getString(Base64.subSequence((int)(599 / 178), (String)"`kac"));
            String string2 = aMFDataObj.getString(JSON.replace((String)"bb{jxb|yg`~", (int)(233 / 36)));
            AMFDataObj aMFDataObj2 = aMFDataObj.getObject(JSON.replace((String)"l~\u007f|xqr`|yy", (int)(107 + 34)));
            String string3 = aMFDataObj2 == null ? "" : aMFDataObj2.getString(Base64.subSequence((int)(41 * 15), (String)"*;."));
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"TpuoX|hge~f]D\\B0Wzxy}znIynkst/mmV`urd}Q", (int)(813 / 193)) + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"\u0018|g:,9> 9to", (int)(52 - -17)) + string + Base64.subSequence((int)(191 / 45), (String)"$actk{c{xdaa*") + string2 + Base64.subSequence((int)(55 + -4), (String)"3Ypedy~\u007f!") + string3);
            }
            if (PushPublishRTMP.this.rtmpAuthProvider != null) {
                PushPublishRTMP.this.rtmpAuthProvider.handleConnectResponse(requestFunction, aMFDataList);
            }
            if (!string.equals(JSON.replace((String)"MaqEhfgohxdaa>R}}zpuc6Jox\u007fxml", (int)(269 / 73)))) return;
            int n = aMFDataObj.getInt(Base64.subSequence((int)(49 * 17), (String)"\".*!+2.,"));
            iNetConnection.setClientId(n);
            String string4 = JSON.replace((String)"fstmk\u007fOsv{q", (int)(4 + 49));
            String string5 = aMFDataObj.getString(string4);
            if (string5 != null) {
                String string6 = null;
                try {
                    string6 = TEA.decrypt((String)string5, (String)PushPublishRTMP.this.secureTokenSharedSecret);
                }
                catch (Exception exception) {}
                if (string6 == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn(JSON.replace((String)"Ust`Y\u007fi`d}gBE_C7Vyyv|yoNxmjlu,ljWct}e~1,^klecwG{~sy8zrzpq{q'$b1!&#.>,.el\u0019\u000b\u000e~570&,&#x?;208:q`\u0002*&'.f3'i(.l>;=5q!67 $>, z+=>5>gd\"jw%oi{}kg`hj!", (int)(445 / 76)));
                } else {
                    if (PushPublishRTMP.this.pushPublishStreamDebug) {
                        WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"SqvnW}kfb\u007fe\\[]A1P{{xr{mH~ohrkn.,\u0011!63+<\u0012", (int)(45 * 15)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(481 / 118), (String)"Y?&tmj\u007fyiYadu\u007f@vgeyyk| ;") + string6);
                    }
                    iNetConnection.call(Base64.subSequence((int)(1423 / 223), (String)"ubk|xnXbej~Cw`dzxd}"), null, new Object[]{new AMFDataItem(string6)});
                }
            }
            if (PushPublishRTMP.this.akamaiUserName != null) {
                return;
            }
            if (PushPublishRTMP.this.sendReleaseStream) {
                iNetConnection.call(JSON.replace((String)"v`jbizoXx\u007fkn}", (int)(328 / 82)), null, new Object[]{PushPublishRTMP.this.dstStreamName});
            }
            if (PushPublishRTMP.this.sendFCPublish) {
                iNetConnection.registerCallback(JSON.replace((String)"kk@DX|hge~f", (int)(-16 - -20)), (INetConnectionCallback)new FCPublishResult(this.a));
                iNetConnection.call(Base64.subSequence((int)(36 - 35), (String)"GASqgjn{a"), null, new Object[]{PushPublishRTMP.this.dstStreamName});
            }
            if (PushPublishRTMP.this.sendFCAnnounce) {
                iNetConnection.registerCallback(Base64.subSequence((int)(-53 - -31), (String)"%%\n\u000e\u000f!>>'=70"), (INetConnectionCallback)new FCAnnounceResult(this.a));
                iNetConnection.call(Base64.subSequence((int)(494 / 114), (String)"BFGiff\u007feoh"), null, new Object[]{PushPublishRTMP.this.dstStreamName});
            }
            iNetConnection.call(JSON.replace((String)"o\u007fkndtAgfpwz", (int)(56 + 116)), (INetConnectionCallResult)new StreamCreateResult(this.a), new Object[0]);
        }
    }

    class PublishResult
    extends ModuleBase
    implements INetConnectionCallResult {
        PushPublishRTMPNetConnectionSession a = null;

        public PublishResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            if (!PushPublishRTMP.this.pushPublishStreamDebug) {
                return;
            }
            PublishResult.getLogger().info(JSON.replace((String)"Vrjecxd_k|e}f){{Drklvo&\u0017", (int)(886 / 144)) + aMFDataList.toString());
        }
    }

    class StreamCreateResult
    extends ModuleBase
    implements INetConnectionCallResult {
        PushPublishRTMPNetConnectionSession a = null;

        public StreamCreateResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyStreamCreate(this.a, requestFunction, aMFDataList);
            int n = aMFDataList.getInt(3);
            MediaStreamMap mediaStreamMap = iNetConnection.getStreams();
            IMediaStream iMediaStream = mediaStreamMap.getStream(iNetConnection, n, true);
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(16 - 25), (String)"\u0007-*2\u000b)?26siPWIU%T|{ojaN|jqewAqfc{l7uuNxmjluY") + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(45 * 43), (String)"R*1bfvy\u007fdpJniy|s% ") + iMediaStream);
            }
            if (iMediaStream == null) return;
            PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = null;
            synchronized (PushPublishRTMP.this.lock) {
                pushPublishRTMPNetConnectionSession = PushPublishRTMP.this.getSessionHolderByNetConnection(iNetConnection);
                if (pushPublishRTMPNetConnectionSession != null) {
                    pushPublishRTMPNetConnectionSession.publishStream = iMediaStream;
                }
                // ** MonitorExit[var8_9] (shouldn't be in output)
                iMediaStream.setNetConnection(iNetConnection);
                iMediaStream.registerOnStatus((IMediaStreamCallback)new StreamOnStatus(this.a));
                iMediaStream.registerOnPlayStatus((IMediaStreamCallback)new StreamOnPlayStatus(this.a));
                if (PushPublishRTMP.this.howToPublish != null) {
                    iNetConnection.call(JSON.replace((String)"!'18<%?", (int)(33 * 49)), iMediaStream, null, new Object[]{PushPublishRTMP.this.dstStreamName, PushPublishRTMP.this.howToPublish});
                    return;
                }
                iNetConnection.call(Base64.subSequence((int)(-6 - 58), (String)"04 /-6."), iMediaStream, null, new Object[]{PushPublishRTMP.this.dstStreamName});
                return;
            }
        }
    }

    class StreamOnPlayStatus
    extends ModuleBase
    implements IMediaStreamCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public StreamOnPlayStatus(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyStreamOnPlayStatus(this.a, requestFunction, aMFDataList);
            AMFDataObj aMFDataObj = aMFDataList.getObject(1);
            String string = aMFDataObj.getString(Base64.subSequence((int)(719 / 182), (String)"`kac"));
            if (!PushPublishRTMP.this.rtmpDebugLog) {
                return;
            }
            WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(7 - -59), (String)"\u001267-\u00162*%#8$\u001f\u001a\u0002\u0000r\u0001'&07:\u00177\n7=$\r+!570j*(\u0004)%&)-.%\u0014") + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"\u001d{b", (int)(-35 - -3)) + string);
        }
    }

    class StreamOnStatus
    extends ModuleBase
    implements IMediaStreamCallback {
        PushPublishRTMPNetConnectionSession a = null;

        public StreamOnStatus(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
            PushPublishRTMP.this.notifyStreamOnStatus(this.a, requestFunction, aMFDataList);
            int n = aMFDataList.size();
            if (3 >= n) return;
            AMFDataObj aMFDataObj = aMFDataList.getObject(3);
            String string = aMFDataObj.getString(Base64.subSequence((int)(45 * 15), (String)"`kac"));
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\u0018<9#\u001c8,#9\":\u0001\u0000\u0018\u0006t\u000b-(>=0\u00111\u00135#716h(&\n+' //,;\n", (int)(36 - -36)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(444 / 134), (String)"^>%") + string);
            }
            if (string.equalsIgnoreCase(Base64.subSequence((int)(1103 / 208), (String)"Kcs[}xnm` _es~zg}8Dlxho"))) {
                Object object = PushPublishRTMP.this.lock;
                // MONITORENTER : object
                this.a.netConnection.addPublishStreams(this.a.publishStream);
                this.a.streamsToPublish.add(this.a.publishStream);
                // MONITOREXIT : object
                PushPublishRTMP.this.reconnectWaitTime = 0;
                PushPublishRTMP.this.setConnectLastSuccess(System.currentTimeMillis());
                return;
            }
            if (!string.equalsIgnoreCase(Base64.subSequence((int)(62 - -50), (String)"\u001e4&\u0000 '365w\u000f5,(<3irj-Wpedmzy"))) return;
            boolean bl = false;
            // MONITORENTER : PushPublishRTMP.this.lock
            if (PushPublishRTMP.this.sendStreamCloseCommandsSendTime >= 0L) {
                bl = true;
            }
            // MONITOREXIT : var8_8
            if (!bl) return;
            PushPublishRTMP.this.a();
        }
    }

    class PublishHandler
    implements INetConnectionPublisher {
        PushPublishRTMPNetConnectionSession a = null;
        protected long timecodeOffset = -1L;
        protected boolean waitForKeyFrame = true;
        protected long lastSeq = -1L;
        protected boolean isFirstVideoSend = true;
        protected boolean isFirstAudioSend = true;
        protected byte[] workBuffer = null;
        protected int chunkSize = 0;
        protected boolean sendDataStart = true;
        protected int totalPacketsZeroTimecode = 0;

        public PublishHandler(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.a = pushPublishRTMPNetConnectionSession;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void checkWorkBuffer(int n) {
            boolean bl = false;
            if (this.workBuffer == null) {
                bl = true;
            } else if (this.workBuffer.length < n) {
                bl = true;
            }
            if (bl) {
                this.workBuffer = new byte[n];
            }
            this.chunkSize = n;
        }

        protected int sendPacket(OutputStream outputStream, long l, AMFPacket aMFPacket, AMFObj aMFObj, IMediaStream iMediaStream) {
            int n = 0;
            return n += StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])this.workBuffer, (int)this.chunkSize);
        }

        /*
         * Unable to fully structure code
         */
        protected long getPlayPacketDuration(List<AMFPacket> var1_1) {
            block18: {
                block19: {
                    block16: {
                        block17: {
                            var2_2 = 0;
                            var3_3 = 0;
                            var4_4 = -1L;
                            var6_5 = -1L;
                            var8_6 = var1_1.size();
                            var9_7 = 0;
                            break block19;
lbl8:
                            // 3 sources

                            while (true) {
                                var2_2 = (int)((long)var2_2 + var14_11);
                                ** GOTO lbl34
                                break;
                            }
lbl11:
                            // 1 sources

                            return Math.max(var2_2, var3_3);
lbl13:
                            // 1 sources

                            while (true) {
                                var14_11 = 1000L;
                                break block16;
                                break;
                            }
                            while (true) {
                                if (var14_11 <= 1000L) ** GOTO lbl8
                                break block17;
                                break;
                            }
lbl19:
                            // 2 sources

                            while (true) {
                                var6_5 = var12_10;
                                ** GOTO lbl-1000
                                break;
                            }
lbl22:
                            // 1 sources

                            while (true) {
                                continue;
lbl24:
                                // 1 sources

                                while (true) {
                                    var14_11 = 0L;
                                    ** GOTO lbl8
                                    break;
                                }
lbl27:
                                // 1 sources

                                while (true) {
                                    if ((var14_11 = var12_10 - var4_4) >= 0L) ** continue;
                                    ** continue;
                                    break;
                                }
lbl30:
                                // 1 sources

                                while (var14_11 > 1000L) {
                                    ** continue;
lbl32:
                                    // 1 sources

                                    ** GOTO lbl13
                                }
                                break block16;
lbl34:
                                // 2 sources

                                while (true) {
                                    var4_4 = var12_10;
                                    ** GOTO lbl47
                                    break;
                                }
                                break;
                            }
                        }
                        var14_11 = 1000L;
                        ** while (true)
                        var10_8 = var1_1.get(var9_7);
                        var11_9 = var10_8.getType();
                        var12_10 = var10_8.getAbsTimecode();
                        switch (var11_9) {
                            case 8: {
                                if (var4_4 < 0L) ** continue;
                                ** continue;
                            }
lbl47:
                            // 2 sources

                            default: lbl-1000:
                            // 2 sources

                            {
                                ++var9_7;
                                break block19;
                            }
lbl50:
                            // 1 sources

                            while ((var14_11 = var12_10 - var6_5) < 0L) {
                                break block18;
                            }
                            ** GOTO lbl30
                            case 9: {
                                if (var6_5 < 0L) ** GOTO lbl19
                                break;
                            }
                        }
                        ** GOTO lbl50
                    }
lbl58:
                    // 2 sources

                    while (true) {
                        var3_3 = (int)((long)var3_3 + var14_11);
                        ** continue;
                        break;
                    }
                }
                ** while (var9_7 >= var8_6)
lbl63:
                // 1 sources

                ** while (true)
            }
            var14_11 = 0L;
            ** while (true)
        }

        /*
         * Exception decompiling
         */
        protected int sendPackets(INetConnection var1_1, OutputStream var2_2, IMediaStream var3_3, long[] var4_4) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [3 : 731->759)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ResponseFunction getDataStart(IMediaStream iMediaStream, long l) {
            ResponseFunction responseFunction = null;
            try {
                AMFDataObj aMFDataObj = null;
                AMFObj aMFObj = iMediaStream.getRespAMFDataObj();
                if (aMFObj == null) {
                    aMFObj = new AMFObj(3);
                }
                responseFunction = new ResponseFunction(iMediaStream.getClient(), aMFObj);
                responseFunction.createSeekMessage(Base64.subSequence((int)(53 * 45), (String)"><\u0000 4\"\"+"));
                responseFunction.setSrc(iMediaStream.getSrc());
                responseFunction.setType(18);
                responseFunction.setTimecode(l);
                aMFDataObj = new AMFDataObj();
                aMFDataObj.put(Base64.subSequence((int)(-9 - 45), (String)")$(("), (AMFData)new AMFDataItem(Base64.subSequence((int)(63 * 9), (String)"Y}mIonx\u007frn\u0005#7%k\u00153);>")));
                responseFunction.addBody((AMFData)aMFDataObj);
                return responseFunction;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).error(Base64.subSequence((int)(37 * 59), (String)"W}zb[yobfcy@GYE8d}w~K}~uztrYpakbCi}kXxl|{M+2rde,") + PushPublishRTMP.this.appInstance.getContextStr(), (Throwable)exception);
                return responseFunction;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public int play(INetConnection iNetConnection, OutputStream outputStream, long[] lArray) {
            int n = 0;
            boolean bl = true;
            ArrayList<IMediaStream> arrayList = PushPublishRTMP.this.lock;
            // MONITORENTER : arrayList
            if (PushPublishRTMP.this.sendStreamCloseCommandsSendTime > 0L) {
                bl = false;
            }
            // MONITOREXIT : arrayList
            if (!bl) {
                return n;
            }
            PushPublishRTMP.this.notifyPublishHandlerPlay(this.a, outputStream, lArray);
            arrayList = new ArrayList<IMediaStream>();
            Object object = PushPublishRTMP.this.lock;
            // MONITORENTER : object
            PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession = PushPublishRTMP.this.getSessionHolderByNetConnection(iNetConnection);
            if (pushPublishRTMPNetConnectionSession == null || pushPublishRTMPNetConnectionSession.streamsToPublish.isEmpty()) {
                if (PushPublishRTMP.this.pushPublishStreamDebug) {
                    WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"\u001f%\":\u0003!7:>+1\b\u000f\u0011\r``3$,'\u0014$%,-=9\u0010", (int)(92 + -13)) + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"\nby\r:5)71'a--d\u0016#4; %%`m/? k", (int)(61 * 35)) + PushPublishRTMP.this.appInstance.getContextStr());
                }
            } else {
                arrayList.addAll(pushPublishRTMPNetConnectionSession.streamsToPublish);
            }
            // MONITOREXIT : object
            long l = System.currentTimeMillis();
            Iterator iterator = arrayList.iterator();
            if (arrayList.size() == 0) {
                PushPublishRTMP.this.offlineTime = l;
                if (PushPublishRTMP.this.onlineTime < 0L) {
                    PushPublishRTMP.this.onlineTime = l;
                }
            } else {
                while (true) {
                    if (!iterator.hasNext()) {
                        PushPublishRTMP.this.onlineTime = l;
                        return n;
                    }
                    IMediaStream iMediaStream = (IMediaStream)iterator.next();
                    n += this.sendPackets(iNetConnection, outputStream, iMediaStream, lArray);
                }
            }
            if (PushPublishRTMP.this.offlineTime - PushPublishRTMP.this.onlineTime <= 10000L) return 0;
            if (PushPublishRTMP.this.pushPublishStreamDebug) {
                WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(95 + -55), (String)"X|yc\\xlcybzA@XF)'j\u007fuxM\u007f|+$60\u001f") + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(41 * 55), (String)"\u0012jq\u001c<t&\"%=87(p}?/0{") + PushPublishRTMP.this.appInstance.getContextStr() + Base64.subSequence((int)(511 / 162), (String)"/$Wctm}~bbj"));
            }
            PushPublishRTMP.this.resetConnection();
            PushPublishRTMP.this.onlineTime = l;
            return 0;
        }
    }

    class IdleHandler
    implements INetConnectionIdle {
        protected PushPublishRTMPNetConnectionSession pushPublisherSession = null;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IdleHandler(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession) {
            this.pushPublisherSession = pushPublishRTMPNetConnectionSession;
            if (!PushPublishRTMP.this.rtmpDebugLog) {
                return;
            }
            WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"TpuoX|hge~f]D\\B0]qzrPxt\u007fpxl1csgbp`]", (int)(285 / 69)) + PushPublishRTMP.this.getContextStr() + "]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onIdle(INetConnection iNetConnection, IoSession ioSession) {
            long l;
            block13: {
                long l2;
                long l3;
                block14: {
                    block12: {
                        long l4;
                        long l5;
                        block11: {
                            l5 = System.currentTimeMillis();
                            l4 = iNetConnection.getLastValidateTime();
                            boolean bl = true;
                            boolean bl2 = false;
                            Object object = PushPublishRTMP.this.lock;
                            synchronized (object) {
                                if (PushPublishRTMP.this.sendStreamCloseCommandsSendTime >= 0L) {
                                    bl = false;
                                    if (l5 - PushPublishRTMP.this.sendStreamCloseCommandsSendTime > (long)PushPublishRTMP.this.streamCloseWaitTime) {
                                        bl2 = true;
                                    }
                                }
                            }
                            if (bl2) {
                                if (PushPublishRTMP.this.pushPublishStreamDebug) {
                                    WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"SqvnW}kfb\u007fe\\[]A1Zpys_yw~wyo0pnHfoa^", (int)(598 / 198)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(41 * 41), (String)"L(3[cse8}sh\u007frpqebv#sdos(}cfi#.L|~av4AUG8zuurx}k).,m"));
                                }
                                PushPublishRTMP.this.a();
                            }
                            if (!bl) return;
                            PushPublishRTMP.this.notifySessionIdle(this.pushPublisherSession);
                            l3 = -1L;
                            l2 = -1L;
                            IoSession ioSession2 = ((NetConnection)iNetConnection).getSession();
                            if (ioSession2 != null) {
                                l3 = ioSession2.getLastReadTime();
                                l2 = ioSession2.getLastWriteTime();
                            }
                            if (l4 != 0L) break block11;
                            iNetConnection.setLastValidateTime(l5);
                            if (l3 > 0L) {
                                PushPublishRTMP.this.lastIdleReadTime = l3;
                            }
                            break block12;
                        }
                        if (iNetConnection.isValidatingConnection()) return;
                        if (PushPublishRTMP.this.validationFrequency <= 0L) return;
                        if (l5 - l4 <= PushPublishRTMP.this.validationFrequency) return;
                        l = System.currentTimeMillis();
                        if (l3 <= 0L || l3 <= PushPublishRTMP.this.lastIdleReadTime || l2 <= 0L) break block13;
                        break block14;
                    }
                    if (l2 <= 0L) return;
                    PushPublishRTMP.this.lastIdleWriteTime = l2;
                    return;
                }
                if (l2 > PushPublishRTMP.this.lastIdleWriteTime) {
                    PushPublishRTMP.this.lastIdleReadTime = l3;
                    PushPublishRTMP.this.lastIdleWriteTime = l2;
                    iNetConnection.setLastValidateTime(l);
                    if (!PushPublishRTMP.this.rtmpDebugLog) return;
                    WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Vr{aZ~nag|xCF^D6_st|Rzryrzr/mmMajbS", (int)(1512 / 240)) + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"];\"Qadb'ign+{\u007fg{u1]X", (int)(85 + -53)));
                    return;
                }
            }
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"Y\u007fxd]{m|xa{FA[G;P~wyU\u007fq$-'1j*(\u000e,%/\u0010", (int)(29 + 12)) + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(-40 - 60), (String)"A'>iamkgeqc"));
            }
            iNetConnection.setValidatingConnection(true);
            iNetConnection.setLastValidateTime(l);
            iNetConnection.ping((INetConnectionPingResult)new PingResult(this.pushPublisherSession, l));
            PushPublishRTMP.this.notifyValidateSession(this.pushPublisherSession);
        }

        public void onSessionOpened(INetConnection iNetConnection, IoSession ioSession) {
            PushPublishRTMP.this.notifySessionOpened(this.pushPublisherSession);
            PushPublishRTMP.this.sessionOpened(ioSession);
        }

        public void onSessionClosed(INetConnection iNetConnection, IoSession ioSession) {
            PushPublishRTMP.this.notifySessionClosed(this.pushPublisherSession);
            PushPublishRTMP.this.sessionClosed(ioSession);
        }
    }

    class PingResult
    implements INetConnectionPingResult {
        protected long startValidateTime = 0L;
        protected long startSessionBytesWritten = 0L;
        protected long startWriteId = -1L;
        protected PushPublishRTMPNetConnectionSession pushPublisherSession = null;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PingResult(PushPublishRTMPNetConnectionSession pushPublishRTMPNetConnectionSession, long l) {
            this.pushPublisherSession = pushPublishRTMPNetConnectionSession;
            this.startValidateTime = l;
            IoSession ioSession = ((NetConnection)pushPublishRTMPNetConnectionSession.getNetConnection()).getSession();
            if (ioSession == null) {
                return;
            }
            this.startSessionBytesWritten = ioSession.getWrittenBytes();
            this.startWriteId = ioSession.getFirstWriteRequestId();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onResult(INetConnection iNetConnection, long l, int n, boolean bl) {
            IoSession ioSession = ((NetConnection)iNetConnection).getSession();
            long l2 = 0L;
            long l3 = -1L;
            long l4 = ((NetConnection)iNetConnection).getLastPingWriteId();
            if (ioSession != null) {
                l2 = ioSession.getWrittenBytes();
                l3 = ioSession.getFirstWriteRequestId();
            }
            if (PushPublishRTMP.this.pushPublishStreamDebug) {
                WMSLoggerFactory.getLogger(CLASS).info(Base64.subSequence((int)(951 / 215), (String)"TpuoX|hge~f]D\\B0D|xpJ|inpi0pnSgpqir\\") + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"^>%", (int)(867 / 218)) + bl);
            }
            if (!(bl || l4 != -1L && l4 == l3)) {
                if (this.startSessionBytesWritten > 0L && l2 > 0L && this.startSessionBytesWritten != l2) {
                    if (PushPublishRTMP.this.pushPublishStreamDebug) {
                        WMSLoggerFactory.getLogger(CLASS).debug(JSON.replace((String)"im}idbckldx}}Btz~|xnrss>D", (int)(62 - 23)) + iNetConnection.getClientId() + JSON.replace((String)"\u001ah+3?)\u001a<&$%7=\u0017=79?<>a|", (int)(-65 - -40)) + this.startSessionBytesWritten + ":" + l2);
                    }
                    bl = true;
                }
                if (this.startValidateTime != iNetConnection.getLastValidateTime()) {
                    if (PushPublishRTMP.this.pushPublishStreamDebug) {
                        WMSLoggerFactory.getLogger(CLASS).debug(Base64.subSequence((int)(81 + 120), (String)"'/?/\" !52&:;;\u0000640>:(411`\u001a") + iNetConnection.getClientId() + Base64.subSequence((int)(44 + 30), (String)"\u0017k:,\"&40&:;;\u0002>5<\u00193=39:${b") + this.startValidateTime + ":" + iNetConnection.getLastValidateTime());
                    }
                    bl = true;
                }
            }
            PushPublishRTMP.this.notifyValidateSessionResult(this.pushPublisherSession, bl);
            ((NetConnection)iNetConnection).setLastPingWriteId(l3);
            if (!bl) {
                WMSLoggerFactory.getLogger(CLASS).warn(Base64.subSequence((int)(31 + 15), (String)"^zcyBfvy\u007fdpKNVL>Nv.&\u0010&70*3\u0013") + PushPublishRTMP.this.getContextStr() + Base64.subSequence((int)(114 + 26), (String)"Q7.\u007fy\u007fu3`|{rwln!<o{leu\"`kkhbk}cdb") + JSON.replace((String)"'iyz1", (int)(-61 - 60)) + PushPublishRTMP.this.appInstance.getContextStr());
                PushPublishRTMP.this.resetConnection();
                return;
            }
            if (PushPublishRTMP.this.rtmpDebugLog) {
                WMSLoggerFactory.getLogger(CLASS).info(JSON.replace((String)"SqvnW}kfb\u007fe\\[]A1C}{qE}jowhF", (int)(804 / 252)) + PushPublishRTMP.this.getContextStr() + JSON.replace((String)"[=(ycek-AD", (int)(1143 / 185)));
            }
            iNetConnection.setValidatingConnection(false);
            iNetConnection.setLastValidateTime(System.currentTimeMillis());
        }
    }
}

