/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.machine.monitoring;

import com.sun.management.OperatingSystemMXBean;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.bootstrap.BootstrapOperatingSystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.restserver.WMSRestLogger;
import com.wowza.wms.server.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="CurrentMachineStatistics")
@WMSDescription(text="Machine Level Current Statistics", get="Retrieves current statictics for the machine")
@WMSConfig(restLocation="/v2/machine/monitoring/current", restVerbs="GET", xmlFilename="")
public class CurrentMachineStatistics
extends ConfigBase {
    private static final Pattern a = Pattern.compile(Severity.valueOf(26 - -28, ">L(4#F74Blk,+-"));
    private static final Pattern b = Pattern.compile(Utils.substring("6D0,;^/,</S9'2Q&'", 19 - -11));
    private static final Pattern c = Pattern.compile(Utils.substring(",^6*1T!\"P~%kqh", 1142 / 244));
    @JsonProperty(value="serverUptime")
    @XStreamAlias(value="ServerUptime")
    private long d;
    @JsonProperty(value="cpuIdle")
    @XStreamAlias(value="CpuIdle")
    protected Integer cpuIdle;
    @JsonProperty(value="cpuUser")
    @XStreamAlias(value="CpuUser")
    protected Integer cpuUser;
    @JsonProperty(value="cpuSystem")
    @XStreamAlias(value="CpuSystem")
    protected Integer cpuSystem;
    @JsonProperty(value="memoryFree")
    @XStreamAlias(value="MemoryFree")
    protected Long memoryFree;
    @JsonProperty(value="memoryUsed")
    @XStreamAlias(value="MemoryUsed")
    protected Long memoryUsed;
    @JsonProperty(value="heapFree")
    @XStreamAlias(value="HeapFree")
    protected Long heapFree;
    @JsonProperty(value="heapUsed")
    @XStreamAlias(value="HeapUsed")
    protected Long heapUsed;
    @JsonProperty(value="diskFree")
    @XStreamAlias(value="DiskFree")
    protected Long diskFree;
    @JsonProperty(value="diskUsed")
    @XStreamAlias(value="DiskUsed")
    protected Long diskUsed;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Long connectionCount;
    private static final Pattern e = Pattern.compile(Utils.substring("fdIe<070$51Blki\u0019si|\u001blai?8)?=p|\r!x8:73x8,>.<9:3~xcl\u001evjq\u0014a\u0017b\u0016~bi\f\tcyl\u000b~tf\u0006(wu\u0005o-8_(X+]7%0WP< 7R9=-Og>>L(4#F7A0D0,;^_5+>U ", 105 + 74));
    private static final Logger f = WMSRestLogger.getLogger();
    private static int g = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    private static long h = 0L;
    private static long i = 0L;

    public CurrentMachineStatistics() {
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.substring("Fgiff~+\u007flxj0p|3uef{qz{ourp?sucwmvrnk", -45 - -50));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        if (RestProperties.getBoolean(Utils.substring(";/88\u001e:.$8!'=6%\u0013=;/<\u00193?=ldf", 21 * 5))) {
            f.info((Object)Severity.valueOf(634 / 136, "V`rrzgcek-mzbcw}`5{v{qsuy=mkaukpplet"));
        }
        MBeanServer mBeanServer = null;
        try {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception exception) {}
        long l = BootstrapOperatingSystemUtils.getTotalPhysicalMemorySize((MBeanServer)mBeanServer, (long)0L);
        long l2 = BootstrapOperatingSystemUtils.getFreePhysicalMemorySize((MBeanServer)mBeanServer, (long)0L);
        int n = BootstrapOperatingSystemUtils.getAvailableProcessors((MBeanServer)mBeanServer, (long)1L);
        this.cpuSystem = 0;
        this.cpuUser = (int)(this.getCpuUsage(mBeanServer) * 100.0 / (double)n);
        this.cpuIdle = 100 - this.cpuSystem - this.cpuUser;
        this.memoryFree = l2;
        this.memoryUsed = l - this.memoryFree;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.heapUsed = memoryMXBean.getHeapMemoryUsage().getUsed();
        this.heapFree = memoryMXBean.getHeapMemoryUsage().getMax() - this.heapUsed;
        long l3 = 0L;
        long l4 = 0L;
        Server server = File.listRoots();
        int n2 = ((File[])server).length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.diskFree = l4;
                this.diskUsed = l3 - l4;
                server = Server.getInstance();
                this.connectionCount = server.getConnectionCounter().getCurrent();
                this.d = (long)server.getTimeRunningSeconds();
                if (!RestProperties.getBoolean(Severity.valueOf(60 - -34, ",:35\u00117%1/4< )8\b(,:7\u0014<26933"))) return true;
                f.info((Object)(Utils.substring("Fsuzld\u007f,`olxx|v4fbvlpiou~m% ", 59 * 63) + this.toString()));
                return true;
            }
            File file = server[n3];
            l3 += file.getTotalSpace();
            l4 += file.getFreeSpace();
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getSystemUptime() throws Exception {
        long l = 0L;
        try {
            String string;
            String string2;
            String string3;
            block7: {
                Matcher matcher;
                block8: {
                    String string4;
                    block6: {
                        Process process;
                        BufferedReader bufferedReader;
                        String string5;
                        String string6 = System.getProperty(Utils.substring(">!}:4;2", -34 - -19)).toLowerCase();
                        if (string6.contains(Severity.valueOf(1397 / 242, "roi"))) break block6;
                        if (!(string6.contains(Utils.substring("+&+", 122 + 76)) || string6.contains(Utils.substring("mm}", 368 / 112)) || string6.contains(Utils.substring("%95", 49 * 59)))) {
                            if (!string6.contains(Utils.substring("*%5", 35 * 25))) return l;
                        }
                        if ((string5 = (bufferedReader = new BufferedReader(new InputStreamReader((process = Runtime.getRuntime().exec(Severity.valueOf(636 / 99, "sw|`gn"))).getInputStream()))).readLine()) == null) return l;
                        Matcher matcher2 = e.matcher(string5);
                        if (!matcher2.find()) return l;
                        String string7 = matcher2.group(1);
                        string3 = null;
                        string2 = null;
                        string = null;
                        if (string7.contains(Utils.substring("nju", 42 - 32)) && (matcher = c.matcher(string7)).find()) {
                            string3 = matcher.group(1);
                        }
                        if (string7.contains(":") && (matcher = b.matcher(string7)).find()) {
                            string2 = matcher.group(1);
                            string = matcher.group(2);
                        }
                        if (!string7.contains(Severity.valueOf(51 * 25, "653")) || !(matcher = a.matcher(string7)).find()) break block7;
                        break block8;
                    }
                    Process process = Runtime.getRuntime().exec(Utils.substring("eiy.|dpf`4fda", -28 - 57));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    do {
                        if ((string4 = bufferedReader.readLine()) == null) return l;
                    } while (!string4.startsWith(Severity.valueOf(78 + -9, "\u00162&< 9?%.=o#8<01u")));
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
                    Date date = dateFormat.parse(string4.substring(Utils.substring("\u00188,:&#%;0'u%>6:?", 3 * 25).length()));
                    return System.currentTimeMillis() - date.getTime();
                }
                string = matcher.group(1);
            }
            int n = string3 != null ? Integer.parseInt(string3) : 0;
            int n2 = string2 != null ? Integer.parseInt(string2) : 0;
            int n3 = string != null ? Integer.parseInt(string) : 0;
            return n3 * 60000 + n2 * 60000 * 60 + n * 60000 * 60 * 24;
        }
        catch (Exception exception) {
            return l;
        }
    }

    public static CurrentMachineStatistics getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        HashMap hashMap = new HashMap();
        return (CurrentMachineStatistics)CurrentMachineStatistics.getObjectFromREST(CurrentMachineStatistics.getUrl(CurrentMachineStatistics.class), CurrentMachineStatistics.class, wMSClientSecurity);
    }

    public synchronized double getCpuUsage(MBeanServer mBeanServer) {
        if (h != 0L) {
            long l = System.nanoTime();
            long l2 = 0L;
            l2 = BootstrapOperatingSystemUtils.getProcessCpuTime((MBeanServer)mBeanServer, (long)0L);
            double d = (double)(l2 - i) / (double)(l - h);
            h = l;
            i = l2;
            return d;
        }
        this.a();
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void a() {
        h = System.nanoTime();
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (!(operatingSystemMXBean instanceof OperatingSystemMXBean)) {
            return;
        }
        i = ((OperatingSystemMXBean)operatingSystemMXBean).getProcessCpuTime();
    }

    public Integer getCpuIdle() {
        return this.cpuIdle;
    }

    public Integer getCpuUser() {
        return this.cpuUser;
    }

    public Integer getCpuSystem() {
        return this.cpuSystem;
    }

    public Long getMemoryFree() {
        return this.memoryFree;
    }

    public Long getMemoryUsed() {
        return this.memoryUsed;
    }

    public Long getDiskFree() {
        return this.diskFree;
    }

    public Long getDiskUsed() {
        return this.diskUsed;
    }

    public void setCpuIdle(Integer n) {
        this.cpuIdle = n;
    }

    public void setCpuUser(Integer n) {
        this.cpuUser = n;
    }

    public void setCpuSystem(Integer n) {
        this.cpuSystem = n;
    }

    public void setMemoryFree(Long l) {
        this.memoryFree = l;
    }

    public void setMemoryUsed(Long l) {
        this.memoryUsed = l;
    }

    public void setDiskFree(Long l) {
        this.diskFree = l;
    }

    public void setDiskUsed(Long l) {
        this.diskUsed = l;
    }

    public Long getConnectionCount() {
        return this.connectionCount;
    }

    public void setConnectionCount(Long l) {
        this.connectionCount = l;
    }

    public Long getHeapFree() {
        return this.heapFree;
    }

    public Long getHeapUsed() {
        return this.heapUsed;
    }

    public void setHeapFree(Long l) {
        this.heapFree = l;
    }

    public void setHeapUsed(Long l) {
        this.heapUsed = l;
    }

    public long getServerUptime() {
        return this.d;
    }

    public void setServerUptime(long l) {
        this.d = l;
    }

    public String toString() {
        return Severity.valueOf(45 * 3, "D}{xnbyCnsy{}qFbvlpiou~m?[rgqr`tRx}cfi0") + this.d + Severity.valueOf(49 + 55, "di);9\u0004*#5l") + this.cpuIdle + Utils.substring(")&dx|_xi\u007f3", 79 + 86) + this.cpuUser + Utils.substring("/$hcjg{sM~hk2", 7 * 5) + this.memoryFree + Severity.valueOf(6 - -52, "6;qxsp28\u00170!!{") + this.memoryUsed + Severity.valueOf(33 - 60, "if/-(:\r>(+r") + this.heapFree + Severity.valueOf(37 * 35, "#0ywrd@er|$") + this.heapUsed + Utils.substring("*'l`y`J\u007fkj-", 482 / 75) + this.diskFree + Severity.valueOf(72 + 67, "',ig|{Davp(") + this.diskUsed + Severity.valueOf(63 * 55, "%*hcc`jse{|zVybvm'") + this.connectionCount + "]";
    }
}

