/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.machine.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.server.monitoring.HistoricServerStatistics;
import com.wowza.wms.rest.server.monitoring.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryMachine;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricMachineStatistics")
@WMSDescription(text="Machine Level Historic Statistics", get="Retrieves historic statictics for the machine")
@WMSConfig(restLocation="/v2/machine/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricMachineStatistics
extends HistoricalStatistics<StatsEntryMachine> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricMachineStatistics.class);

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(41 * 49, "\u001a;522*\u007f3 4&d$(g)9:'%./;9><s'!7#1*.2?"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricMachineStatistics getObjectFromREST(DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Severity.valueOf(15 * 19, "o{ltRvbplusajyOio{hU\u007fsqxpr"))) {
            a.info(String.format(Utils.substring("Lz43+&2,( h$+($$ *p\"&2 &v1*67{y.~+/ag0", 30 + 32), dateTime, dateTime2));
        }
        String string = HistoricMachineStatistics.getUrl(HistoricMachineStatistics.class);
        try {
            String string2 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Utils.substring("\u001c\u001e\rau", 36 - -37));
            String string3 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Severity.valueOf(-3 - -42, "R\\O'3"));
            string = string + String.format(Severity.valueOf(13 * 41, "*3d%<i=9n#:s"), Severity.valueOf(66 + 60, "-+asv"), string2, Severity.valueOf(-43 - -40, "80;"), string3);
            return (HistoricMachineStatistics)HistoricMachineStatistics.getObjectFromREST(string, HistoricMachineStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Severity.valueOf(383 / 67, "Phfjeo+xb.j~r}wq5bx8LN]1%"), (Throwable)unsupportedEncodingException);
            return new HistoricMachineStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryMachine> getDatabase() {
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Utils.substring("Usi}yFmcohuc2zzfbvvz\u007f;rrj?awcjhddkm", 1521 / 248));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Severity.valueOf(19 * 11, "\u0002&2 &\u00126,88:/8\u0013>. %&6e/);=+%/(n!?%r2\"4?;9;6>"));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.machineGetDatabase();
        if (iStatsDatabase != null) {
            iStatsDatabase.open();
            return iStatsDatabase;
        }
        a.warn(Utils.substring("Lestfv%bf|hhj\u007fh.a\u007fe2rbt\u007f{y{v~", 9 + 22));
        return null;
    }
}

