/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientResource;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.server.listeners.ServerListenersConfig;
import com.wowza.wms.server.Server;
import com.wowza.wms.server.ServerTuningHandler;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Server")
@WMSDescription(text="Server Configuration", get="Retrieves the Server configuration", put="Updates the Server configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}", restVerbs="GET,PUT", xmlFilename="Server.xml")
public class ServerConfig
extends ConfigBase {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/Server/Name/text()")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Server/Description/text()")
    protected String description;
    @JsonProperty(value="defaultStreamPrefix")
    @XStreamAlias(value="DefaultStreamPrefix")
    @WMSXMLVariable(xpath="/Root/Server/Streams/DefaultStreamPrefix/text()")
    protected String defaultStreamPrefix;
    @NotNull
    @JsonProperty(value="ipAddress")
    @XStreamAlias(value="IPAddress")
    @WMSXMLVariable(xpath="/Root/Server/CommandInterface/HostPort/IpAddress/text()")
    protected String ipAddress;
    @JsonProperty(value="port")
    @XStreamAlias(value="Port")
    @WMSXMLVariable(xpath="/Root/Server/CommandInterface/HostPort/Port/text()")
    protected int port;
    @JsonProperty(value="handlerThreadPool")
    @XStreamAlias(value="HandlerThreadPool")
    @WMSXMLVariable(xpath="/Root/Server/HandlerThreadPool/PoolSize/text()")
    protected String handlerThreadPool;
    @JsonProperty(value="handlerThreadPoolAutoValue")
    @XStreamAlias(value="HandlerThreadPoolAutoValue")
    protected String handlerThreadPoolAutoValue;
    @JsonProperty(value="transportThreadPool")
    @XStreamAlias(value="TransportThreadPool")
    @WMSXMLVariable(xpath="/Root/Server/TransportThreadPool/PoolSize/text()")
    protected String transportThreadPool;
    @JsonProperty(value="transportThreadPoolAutoValue")
    @XStreamAlias(value="HandlerThreadPoolAutoValue")
    protected String transportThreadPoolAutoValue;
    @JsonProperty(value="rtpDataPortSharing")
    @XStreamAlias(value="RTPDataPortSharing")
    @WMSXMLVariable(xpath="/Root/Server/RTP/DatagramPortSharing/text()")
    protected boolean rtpDataPortSharing;
    @JsonProperty(value="rtpDataPortSharingPort")
    @XStreamAlias(value="RTPDataPortSharingPort")
    @WMSXMLVariable(xpath="/Root/Server/RTP/DatagramStartingPort/text()")
    protected int rtpDataPortSharingPort;
    @JsonProperty(value="serverListeners")
    @XStreamAlias(value="ServerListeners")
    protected ServerListenersConfig serverListeners = new ServerListenersConfig();

    public ServerConfig() {
        this.initUrl();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDefaultStreamPrefix() {
        return this.defaultStreamPrefix;
    }

    public void setDefaultStreamPrefix(String string) {
        this.defaultStreamPrefix = string;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public String getHandlerThreadPool() {
        return this.handlerThreadPool;
    }

    public void setHandlerThreadPool(String string) {
        this.handlerThreadPool = string;
    }

    public String getHandlerThreadPoolAutoValue() {
        return this.handlerThreadPoolAutoValue;
    }

    public void setHandlerThreadPoolAutoValue(String string) {
        this.handlerThreadPoolAutoValue = string;
    }

    public String getTransportThreadPool() {
        return this.transportThreadPool;
    }

    public void setTransportThreadPool(String string) {
        this.transportThreadPool = string;
    }

    public String getTransportThreadPoolAutoValue() {
        return this.transportThreadPoolAutoValue;
    }

    public void setTransportThreadPoolAutoValue(String string) {
        this.transportThreadPoolAutoValue = string;
    }

    public boolean isRtpDataPortSharing() {
        return this.rtpDataPortSharing;
    }

    public void setRtpDataPortSharing(boolean bl) {
        this.rtpDataPortSharing = bl;
    }

    public int getRtpDataPortSharingPort() {
        return this.rtpDataPortSharingPort;
    }

    public void setRtpDataPortSharingPort(int n) {
        this.rtpDataPortSharingPort = n;
    }

    public ServerListenersConfig getServerListeners() {
        return this.serverListeners;
    }

    public void setServerListeners(ServerListenersConfig serverListenersConfig) {
        this.serverListeners = serverListenersConfig;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        try {
            Class.forName(Utils.substring("hc` x\u007ffhr:b{d6j\u007fijxl1SdpuawRrf`dlDl`k|t`", 50 - 39));
            ServerTuningHandler serverTuningHandler = Server.getInstance().getTuningHandler();
            this.handlerThreadPoolAutoValue = serverTuningHandler.getSuggestedServerHandlerThreadCount() + "";
            this.transportThreadPoolAutoValue = serverTuningHandler.getSuggestedServerTransportThreadCount() + "";
            return super.loadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.loadObject();
        }
    }

    public static ServerConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (ServerConfig)ServerConfig.getObjectFromREST(ServerConfig.getUrl(ServerConfig.class), ServerConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ServerConfig getObjectFromRESTQuietly(WMSClientSecurity wMSClientSecurity) {
        WMSClientResource wMSClientResource;
        Class<ServerConfig> clazz;
        ServerConfig serverConfig;
        int n;
        String string;
        block6: {
            string = ServerConfig.getUrl(ServerConfig.class);
            n = 0;
            serverConfig = null;
            clazz = ServerConfig.class;
            wMSClientResource = null;
            if (!string.toLowerCase().startsWith(Severity.valueOf(7 * 41, "wtur")) && wMSClientSecurity != null && wMSClientSecurity.getServerURL() != null) {
                string = wMSClientSecurity.getServerURL() + string;
            }
            try {
                wMSClientResource = string.contains(Severity.valueOf(82 + 26, "!(*&1l")) ? new WMSClientResource(string, wMSClientSecurity) : (string.contains("?") ? new WMSClientResource(string + Utils.substring("#kbl`k6", 1122 / 209) + ConfigBase.defaultMediaType, wMSClientSecurity) : new WMSClientResource(string + Severity.valueOf(108 + -11, "~/& ,'z") + ConfigBase.defaultMediaType, wMSClientSecurity));
                Representation representation = wMSClientResource.get();
                serverConfig = (ServerConfig)ServerConfig.getObject(representation, clazz);
                break block6;
            }
            catch (Exception exception) {}
            if (wMSClientResource != null && wMSClientResource.getStatus() != null) {
                n = wMSClientResource.getStatus().getCode();
            }
            if (exception.getClass() == ResourceException.class) {
                throw (ResourceException)((Object)exception);
            }
            ConfigBase.logDebug(clazz.getName() + Severity.valueOf(3 + 76, "a74&\u001c6?34,\u001f(41\u000f\u001b\f\u0014aj") + string + Utils.substring("*)", 141 / 38) + n);
        }
        if (serverConfig != null) return serverConfig;
        if (wMSClientResource != null && wMSClientResource.getStatus() != null) {
            n = wMSClientResource.getStatus().getCode();
        }
        ConfigBase.logDebug(clazz.getName() + Severity.valueOf(1670 / 248, "(`m}Eifhm{Vc}~FPEC81") + string + Utils.substring(",+", 15 * 11) + n + Severity.valueOf(-39 - -33, "z2/},:ttpmmka'i)d~`a.`r{wp`"));
        return serverConfig;
    }
}

