/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.server.mediacache.MediaCacheSourceConfig;
import com.wowza.wms.rest.server.mediacache.MediaCacheStoreConfig;
import com.wowza.wms.server.Server;
import com.wowza.wms.server.ServerTuningHandler;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCache")
@WMSDescription(text="Server MediaCache", get="Retrieves the server MediaCache configuration", put="Updates the server MediaCache configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache", restVerbs="GET,PUT", xmlFilename="MediaCache.xml")
public class MediaCacheConfig
extends ConfigBase {
    @JsonProperty(value="writerThreadPoolSize")
    @XStreamAlias(value="WriterThreadPoolSize")
    @WMSXMLVariable(xpath="/Root/MediaCache/WriterThreadPool/PoolSize/text()")
    protected String writerThreadPoolSize;
    @JsonProperty(value="writerThreadPoolSizeAutoValue")
    @XStreamAlias(value="WriterThreadPoolSize")
    protected String writerThreadPoolSizeAutoValue;
    @JsonProperty(value="readAheadThreadPoolSize")
    @XStreamAlias(value="ReadAheadThreadPoolSize")
    @WMSXMLVariable(xpath="/Root/MediaCache/ReadAheadThreadPool/PoolSize/text()")
    protected String readAheadThreadPoolSize;
    @JsonProperty(value="readAheadThreadPoolSizeAutoValue")
    @XStreamAlias(value="ReadAheadThreadPoolSize")
    protected String readAheadThreadPoolSizeAutoValue;
    @JsonProperty(value="maxPendingWriteRequestSize")
    @XStreamAlias(value="MaxPendingWriteRequestSize")
    @WMSXMLVariable(xpath="/Root/MediaCache/MaxPendingWriteRequestSize/text()")
    protected String maxPendingWriteRequestSize;
    @JsonProperty(value="maxPendingWriteRequestSizeAutoValue")
    @XStreamAlias(value="MaxPendingWriteRequestSizeAutoValue")
    protected String maxPendingWriteRequestSizeAutoValue;
    @JsonProperty(value="maxPendingReadAheadRequestSize")
    @XStreamAlias(value="MaxPendingReadAheadRequestSize")
    @WMSXMLVariable(xpath="/Root/MediaCache/MaxPendingReadAheadRequestSize/text()")
    protected String maxPendingReadAheadRequestSize;
    @JsonProperty(value="maxPendingReadAheadRequestSizeAutoValue")
    @XStreamAlias(value="MaxPendingReadAheadRequestSizeAutoValue")
    protected String maxPendingReadAheadRequestSizeAutoValue;
    @JsonProperty(value="stores")
    @XStreamAlias(value="Stores")
    @WMSXMLList(xpath="/Root/MediaCacheStores", keyxpath="/MediaCacheStore/Name", keyName="storeName")
    protected List<MediaCacheStoreConfig> mediaCacheStores;
    @JsonProperty(value="sources")
    @XStreamAlias(value="Sources")
    @WMSXMLList(xpath="/Root/MediaCacheSources", keyxpath="/MediaCacheSource/Name", keyName="sourceName")
    protected List<MediaCacheSourceConfig> mediaCacheSources;

    public MediaCacheConfig() {
        this.initUrl();
    }

    public String getWriterThreadPoolSize() {
        return this.writerThreadPoolSize;
    }

    public void setWriterThreadPoolSize(String string) {
        this.writerThreadPoolSize = string;
    }

    public String getReadAheadThreadPoolSize() {
        return this.readAheadThreadPoolSize;
    }

    public void setReadAheadThreadPoolSize(String string) {
        this.readAheadThreadPoolSize = string;
    }

    public List<MediaCacheSourceConfig> getMediaCacheSources() {
        return this.mediaCacheSources;
    }

    public void setMediaCacheSources(List<MediaCacheSourceConfig> list) {
        this.mediaCacheSources = list;
    }

    public List<MediaCacheStoreConfig> getMediaCacheStores() {
        return this.mediaCacheStores;
    }

    public void setMediaCacheStores(List<MediaCacheStoreConfig> list) {
        this.mediaCacheStores = list;
    }

    public String getMaxPendingWriteRequestSize() {
        return this.maxPendingWriteRequestSize;
    }

    public void setMaxPendingWriteRequestSize(String string) {
        this.maxPendingWriteRequestSize = string;
    }

    public String getMaxPendingReadAheadRequestSize() {
        return this.maxPendingReadAheadRequestSize;
    }

    public void setMaxPendingReadAheadRequestSize(String string) {
        this.maxPendingReadAheadRequestSize = string;
    }

    public String getWriterThreadPoolSizeAutoValue() {
        return this.writerThreadPoolSizeAutoValue;
    }

    public String getReadAheadThreadPoolSizeAutoValue() {
        return this.readAheadThreadPoolSizeAutoValue;
    }

    public String getMaxPendingWriteRequestSizeAutoValue() {
        return this.maxPendingWriteRequestSizeAutoValue;
    }

    public String getMaxPendingReadAheadRequestSizeAutoValue() {
        return this.maxPendingReadAheadRequestSizeAutoValue;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        try {
            Class.forName(Utils.substring("474t,3*$>n6/0j6#5>,8e\u001f(<95#\u0006&:<80\u001084?08,", 16 + 71));
            ServerTuningHandler serverTuningHandler = Server.getInstance().getTuningHandler();
            this.writerThreadPoolSizeAutoValue = serverTuningHandler.getSuggestedMediaCacheThreadsWriterCount() + "";
            this.readAheadThreadPoolSizeAutoValue = serverTuningHandler.getSuggestedMediaCacheThreadsWriterCount() + "";
            this.maxPendingWriteRequestSizeAutoValue = serverTuningHandler.getSuggestedMediaCacheMaxPendingWriterRequestSize() + "";
            this.maxPendingReadAheadRequestSizeAutoValue = serverTuningHandler.getSuggestedMediaCacheMaxPendingReadAheadRequestSize() + "";
            return super.loadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.loadObject();
        }
    }

    public static MediaCacheConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheConfig)MediaCacheConfig.getObjectFromREST(MediaCacheConfig.getUrl(MediaCacheConfig.class), MediaCacheConfig.class, wMSClientSecurity);
    }
}

