/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.server.mediacache.MediaCacheConfig;
import com.wowza.wms.server.Server;
import java.io.File;
import java.util.Iterator;
import javax.validation.ConstraintValidatorContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheSource")
@WMSDescription(text="Server MediaCache Source", get="Retrieves the specified MediaCache Source configuration", put="Updates the specified MediaCache Source configuration", post="Adds the specified MediaCache Source configuration", delete="Deletes the specified MediaCache Source configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/sources/{sourceName}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="MediaCache.xml")
public class MediaCacheSourceConfig
extends ConfigBase
implements Comparable<MediaCacheSourceConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="name")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/Name/text()")
    protected String name;
    @JsonProperty(value="type")
    @XStreamAlias(value="Type")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/Type/text()")
    protected String type;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/Description/text()")
    protected String description;
    @JsonProperty(value="basePath")
    @XStreamAlias(value="BasePath")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/BasePath/text()")
    protected String basePath;
    @JsonProperty(value="prefix")
    @XStreamAlias(value="Prefix")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/Prefix/text()")
    protected String prefix;
    @JsonProperty(value="minTimeToLive")
    @XStreamAlias(value="MinTimeToLive")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/MinTimeToLive/text()")
    protected long minTimeToLive;
    @JsonProperty(value="maxTimeToLive")
    @XStreamAlias(value="MaxTimeToLive")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/MaxTimeToLive/text()")
    protected long maxTimeToLive;
    @JsonProperty(value="isAmazonS3")
    @XStreamAlias(value="IsAmazonS3")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="isAmazonS3", defaultValue="false")
    protected boolean isAmazonS3;
    @JsonProperty(value="s3BucketNameInDomain")
    @XStreamAlias(value="S3BucketNameInDomain")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="s3BucketNameInDomain", defaultValue="false")
    protected boolean s3BucketNameInDomain;
    @JsonProperty(value="awsAccessKeyId")
    @XStreamAlias(value="AWSAccessKeyId")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="awsAccessKeyId", defaultValue="")
    protected String awsAccessKeyId;
    @JsonProperty(value="awsSecretAccessKey")
    @XStreamAlias(value="AWSSecretAccessKey")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="awsSecretAccessKey", defaultValue="")
    protected String awsSecretAccessKey;
    @JsonProperty(value="isPassThru")
    @XStreamAlias(value="IsPassThru")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/IsPassThru/text()")
    protected boolean isPassThru;
    @JsonProperty(value="baseClass")
    @XStreamAlias(value="BaseClass")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/BaseClass/text()")
    protected String baseClass;
    @JsonProperty(value="readerClass")
    @XStreamAlias(value="ReaderClass")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/ReaderClass/text()")
    protected String readerClass;

    public MediaCacheSourceConfig() {
        this.addFieldForKeyMap(Utils.substring("0+04$-\u0007+&)", 86 + -19), "name");
    }

    public MediaCacheSourceConfig(String string) {
        this.name = string;
        this.addToStringKeyMap(Utils.substring("wjsuklDjah", 542 / 125), string);
        this.initUrl();
        this.addFieldForKeyMap(Severity.valueOf(1422 / 252, "virzjoEm`k"), "name");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String string) {
        this.baseClass = string;
    }

    public String getReaderClass() {
        return this.readerClass;
    }

    public void setReaderClass(String string) {
        this.readerClass = string;
    }

    public long getMaxTimeToLive() {
        return this.maxTimeToLive;
    }

    public void setMaxTimeToLive(long l) {
        this.maxTimeToLive = l;
    }

    public long getMinTimeToLive() {
        return this.minTimeToLive;
    }

    public void setMinTimeToLive(long l) {
        this.minTimeToLive = l;
    }

    public boolean isPassThru() {
        return this.isPassThru;
    }

    public void setPassThru(boolean bl) {
        this.isPassThru = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isAmazonS3() {
        return this.isAmazonS3;
    }

    public void setAmazonS3(boolean bl) {
        this.isAmazonS3 = bl;
    }

    public boolean isS3BucketNameInDomain() {
        return this.s3BucketNameInDomain;
    }

    public void setS3BucketNameInDomain(boolean bl) {
        this.s3BucketNameInDomain = bl;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String string) {
        this.awsAccessKeyId = string;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String string) {
        this.awsSecretAccessKey = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(565 / 147, "pkptdmGkfi"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        Iterator<MediaCacheSourceConfig> iterator;
        boolean bl = super.isValid(constraintValidatorContext);
        try {
            Class.forName(Utils.substring("/\"#a'>%)5{!:+w)>.+;-n\u0012'12 4", 44 - -32));
            Server server = Server.getInstance();
            MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
            if (!mediaCacheConfig.loadObject()) return bl;
            if (mediaCacheConfig.getMediaCacheSources() == null) return bl;
            iterator = mediaCacheConfig.getMediaCacheSources().iterator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
        while (iterator.hasNext()) {
            MediaCacheSourceConfig mediaCacheSourceConfig = iterator.next();
            if (mediaCacheSourceConfig.name.equals(this.name) || !mediaCacheSourceConfig.prefix.equals(this.prefix)) continue;
            this.addErrorMessage(constraintValidatorContext, Severity.valueOf(25 * 23, "o2$$*<"), "{mediacache.source.prefix.unique}");
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists() {
        Object object;
        boolean bl = false;
        try {
            String string = this.getFilename();
            object = new File(string);
            bl = ((File)object).exists();
        }
        catch (Exception exception) {}
        if (bl) {
            bl = false;
            MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
            if (mediaCacheConfig.loadObject()) {
                object = mediaCacheConfig.getMediaCacheSources().iterator();
                boolean bl2 = true;
                block2: while (true) {
                    if (!bl2 || (bl2 = false) || !true) {
                        bl = true;
                    }
                    while (object.hasNext()) {
                        MediaCacheSourceConfig mediaCacheSourceConfig = (MediaCacheSourceConfig)object.next();
                        if (!mediaCacheSourceConfig.name.equals(this.name)) continue;
                        continue block2;
                    }
                    break;
                }
            }
        }
        return bl;
    }

    public static MediaCacheSourceConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheSourceConfig)MediaCacheSourceConfig.getObjectFromREST(MediaCacheSourceConfig.getUrl(Utils.substring("hshl|%\u000f#.!", 41 - -18), string, MediaCacheSourceConfig.class), MediaCacheSourceConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(MediaCacheSourceConfig mediaCacheSourceConfig) {
        return this.name.compareTo(mediaCacheSourceConfig.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateXML(Document document) {
        boolean bl = super.updateXML(document);
        if (!bl) return bl;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        Element element = document.getDocumentElement();
        try {
            XPathExpression xPathExpression = xPath.compile(this.resolveVariables(Severity.valueOf(910 / 171, "*Thg}%FiignSpq{qFybjz\u007fh3P{{i`AbgmcTg|xhiV@n}t/4") + this.name + Severity.valueOf(49 * 5, "r\u000bx\u001a8)>\u001f1?,s")));
            Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            if (node != null) return bl;
            MediaCacheSourceConfig mediaCacheSourceConfig = this;
            Node node2 = mediaCacheSourceConfig.a(mediaCacheSourceConfig.type);
            if (node2 != null) {
                xPathExpression = xPath.compile(this.resolveVariables(Utils.substring("z\u000487-u\u0016997>\u0003 !+!\u0016)2:*/8c\u0000++90\u001127=3\u00047,(89\u0006\u0010>md?$", 17 * 5) + this.name + Utils.substring("$Y", 27 * 25)));
                Node node3 = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (node3 == null) return bl;
                Node node4 = node3.getParentNode();
                node4.removeChild(node3);
                node2 = document.adoptNode(node2.cloneNode(true));
                Element element2 = document.createElement(Severity.valueOf(19 * 31, "\u0003/\"5"));
                element2.appendChild(document.createTextNode(this.name));
                node2.insertBefore(element2, node2.getFirstChild());
                node4.appendChild(node2);
                this.updateXML(document);
                return bl;
            }
            ConfigBase.log.warn((Object)(Utils.substring("YI^Z/QA[)4XssqxYz\u007fu{L/40 !\u0011#*8%+?)c6\"<kr\u0010; :3x75/|;71$a#c0 +7$(>.l+!=p%+#1o", 37 * 15) + this.type));
            return bl;
        }
        catch (XPathExpressionException xPathExpressionException) {
            ConfigBase.log.warn((Object)(Utils.substring("Vugkfna-{\u007ftpfzzr6Z}}sz_|}we!aljco`2)", 562 / 86) + this.getQuery()), (Throwable)xPathExpressionException);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Node a(String string) {
        Node node = null;
        String string2 = ConfigBase.wowzaBasePath + Severity.valueOf(882 / 130, "ehfo%") + Utils.substring("I`bniJkhdh]`ecqv@p{gtxn~o3frl", 981 / 235);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            File file = new File(string2);
            boolean bl = false;
            if (!bl && file.exists()) {
                try {
                    document = documentBuilder.parse(string2);
                    bl = true;
                }
                catch (Exception exception) {}
                if (bl) {
                    ConfigBase.log.info((Object)Utils.substring("\u0005\u001d\n\u000e{\u001d\r\u0017e Mm`ei&_EE*dzh|}yuw)4XssqxYz\u007fu{Lotp`aQcjxek\u007fi~ w}}", 14 + 105));
                }
            }
            if (!bl) {
                try {
                    document = MediaCacheSourceConfig.getDocumentFromResouce(Utils.substring("Kbl`kHmnfjC~gawpBruivzhxm1xln", 465 / 75));
                    bl = true;
                }
                catch (Exception exception) {}
            }
            if (!bl) {
                ConfigBase.log.warn((Object)Utils.substring("\u0017\u0003\u0014\u001ci\u000b\u001b\u0005wn\u000255;2\u001745?=\n5..>;\u000b%,2/%1#4f1''l)!*#q<< u3/1*.u|}\u0010:w!Jlwqvhz}*fmt.a\u007fe2ua{ucqvt;loqoesnz*", 27 * 31));
                return node;
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            Element element = document.getDocumentElement();
            XPathExpression xPathExpression = xPath.compile(this.resolveVariables(Severity.valueOf(28 + 43, "h\u001a&%?c\u0000++90\u001127=3\u00047,(89.q\u0012%%+\"\u0007$%/-\u001a%>>.+\u0014\u0004(\"6ir") + string + Utils.substring("e\u001e", 43 - -55)));
            node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            XPathExpression xPathExpression2 = xPath.compile(this.resolveVariables(Severity.valueOf(17 - -62, "`\u0002>='{\u00183318\u0019:?5;\f/40 !6i\n--#*\u000f,-'5\u0002=&&63\f\f *>az") + string + Severity.valueOf(1391 / 234, "\"[(Fhgn")));
            Node node2 = (Node)xPathExpression2.evaluate(element, XPathConstants.NODE);
            if (node2 == null) return node;
            node2.getParentNode().removeChild(node2);
            return node;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ConfigBase.log.warn((Object)(Severity.valueOf(37 + 28, "\u0011#17 4g+&$-%*;=1%;<:u&%7;6>1g~") + this.getQuery()), (Throwable)parserConfigurationException);
            return node;
        }
        catch (XPathExpressionException xPathExpressionException) {
            ConfigBase.log.warn((Object)(Severity.valueOf(288 / 75, "Svjdkmd*liyzf~v2^qq\u007fv[xysy=zzf`wop?&") + this.getQuery()), (Throwable)xPathExpressionException);
            return node;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse;
        block3: {
            block2: {
                block1: {
                    wMSResponse = new WMSResponse();
                    if (ConfigBase.inTradeShowMode) break block1;
                    if (!this.removeNode(Severity.valueOf(8 + -1, "(Zfe\u007f#@kkypQrw}sDwlhxyn1ReekbGdeomZe~~nkT^p\u007fv)2mdwlhxyS\u007fr%<e\u001e"))) break block2;
                    break block3;
                }
                ConfigBase.log.warn((Object)(Severity.valueOf(783 / 197, "QAVR'IYC1,Ikcue{}s5[r|p{;_|}we!Qlqweb(!") + this.getStringVariable(Utils.substring("kgjm", 1262 / 249)) + Utils.substring("2&=Wq upb``&t`f}+abjj>12]{a6s}u\u007fousy?\u0013.71' h", -57 - 44)));
                wMSResponse.success = true;
                wMSResponse.message = Severity.valueOf(102 + 22, "\u001882:tdf");
                return wMSResponse;
            }
            wMSResponse.message = Severity.valueOf(40 - -23, "\\/4.'d+)3h-/')9+o?3867!");
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }
}

