/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBaseAdv;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLAdvSetting;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import java.util.ArrayList;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheSourceAdv")
@WMSDescription(text="Server MediaCache Source, advanced settings", get="Retrieves the specified advanced MediaCache Source configuration", put="Updates the specified advanced MediaCache Source configuration", post="Adds the specified advanced MediaCache Source configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/sources/{sourceName}/adv", restVerbs="GET,PUT,POST", xmlFilename="MediaCache.xml")
public class MediaCacheSourceConfigAdv
extends ConfigBaseAdv {
    @XStreamOmitField
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/Name/text()")
    protected String sourceName;
    @XStreamOmitField
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/Type/text()")
    protected String type;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheSource", name="defaultBlockSize")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/DefaultBlockSize/text()")
    protected String defaultBlockSize;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheSource", name="readAhead")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/ReadAhead/text()")
    protected boolean readAhead;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheSource", name="readAheadThreshold")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']/ReadAheadThreshold/text()")
    protected int readAheadThreshold;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="FileSource", name="fileReadRetries")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="fileReadRetries")
    protected int fileReadRetries;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="httpReadTimeout")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="httpReadTimeout")
    protected int httpReadTimeout;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="maxPoolSize")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="maxPoolSize")
    protected int maxPoolSize;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="httpConnectionTimeout")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="httpConnectionTimeout")
    protected int httpConnectionTimeout;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="httpReadRetries")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="httpReadRetries")
    protected int httpReadRetries;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="httpSendBufferSize")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="httpSendBufferSize")
    protected int httpSendBufferSize;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="httpReceiveBufferSize")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="httpReceiveBufferSize")
    protected int httpReceiveBufferSize;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="closeConnectOnBadContentLength")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="closeConnectOnBadContentLength")
    protected boolean closeConnectOnBadContentLength;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="proxyHost")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="proxyHost")
    protected String proxyHost;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="proxyPort")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="proxyPort")
    protected int proxyPort;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="HTTPSource", name="requestFullURL")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{sourceName}']", name="requestFullURL")
    protected boolean requestFullURL;

    public MediaCacheSourceConfigAdv() {
    }

    public MediaCacheSourceConfigAdv(String string) {
        this.sourceName = string;
        String string2 = Utils.substring(".1*rbgMehc", 78 + 47);
        this.addFieldForKeyMap(string2, string2);
        this.addToStringKeyMap(Utils.substring("c~gawpXvu|", 90 + 86), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(-39 - -46, "tg|xhiCobu"));
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String string) {
        this.sourceName = string;
    }

    @Override
    protected void subConstructor(boolean bl) {
        super.subConstructor(bl);
        this.pathsForUndocumentedProperties = new ArrayList<String>();
        this.pathsForUndocumentedProperties.add(Utils.substring("0Rnmw+HccahIjoek\\\u007fd`pqf9Z}}sz_|}w%\u0012-66&#\u001c\u0006('.qj5<?$ 01\u001b7:=$}\u0006", 72 + 87));
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected ConfigBaseAdv getDefaultConfigBaseAdv() {
        ConfigBaseAdv configBaseAdv = super.getDefaultConfigBaseAdv();
        if (this.sourceName.equals(Severity.valueOf(4 - 2, "fuvjtno`d"))) {
            return new MediaCacheSourceConfigAdv(Severity.valueOf(37 * 35, "kfc}a}r\u007fy"));
        }
        if (this.type.equals(Utils.substring("LQRW", 365 / 85))) {
            return new MediaCacheSourceConfigAdv(Utils.substring("@``f}e~CXY^", 587 / 124));
        }
        if (this.type.equals(Utils.substring("\u0001!%/", 37 + 34))) {
            return new MediaCacheSourceConfigAdv(Severity.valueOf(1473 / 237, "Bbnh\u007fgxKgcu"));
        }
        if (!this.type.equals(Severity.valueOf(-60 - -2, "\u0007*)3%%\u001f~"))) return configBaseAdv;
        return new MediaCacheSourceConfigAdv(Utils.substring("\u0019;9atnwEhg}ggY8", -32 - -29));
    }

    @Override
    protected String getDefalutXMLFilename() {
        if (!this.sourceName.equals(Severity.valueOf(-34 - -64, "zirnpjclh"))) {
            return Severity.valueOf(7 - -18, "T\u007f\u007fu|]~cigPkptdm]of|ao{ub<kyy");
        }
        return super.getDefalutXMLFilename();
    }

    public static MediaCacheSourceConfigAdv getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        String string2 = MediaCacheSourceConfigAdv.getUrl(Utils.substring("ze~~nkAq|w", 14 + 27), string, MediaCacheSourceConfigAdv.class);
        return (MediaCacheSourceConfigAdv)MediaCacheSourceConfigAdv.getObjectFromREST(string2, MediaCacheSourceConfigAdv.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MediaCacheSourceConfigAdv getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        String string3 = MediaCacheSourceConfigAdv.getUrl(Severity.valueOf(76 + 7, " ; $4=\u0017;69"), string, MediaCacheSourceConfigAdv.class);
        if (string2 == null) return (MediaCacheSourceConfigAdv)MediaCacheSourceConfigAdv.getObjectFromREST(string3, MediaCacheSourceConfigAdv.class, wMSClientSecurity);
        if (string2.isEmpty()) return (MediaCacheSourceConfigAdv)MediaCacheSourceConfigAdv.getObjectFromREST(string3, MediaCacheSourceConfigAdv.class, wMSClientSecurity);
        string3 = string3 + "?" + string2;
        return (MediaCacheSourceConfigAdv)MediaCacheSourceConfigAdv.getObjectFromREST(string3, MediaCacheSourceConfigAdv.class, wMSClientSecurity);
    }
}

