/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.server.mediacache.MediaCacheConfig;
import com.wowza.wms.rest.server.mediacache.MediaCacheSourceConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheSources")
@WMSDescription(text="MediaCache Sources", get="Retrieves the list of MediaCache Sources", post="Adds the specified MediaCache Source to the list")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/sources", restVerbs="GET,POST", xmlFilename="MediaCache.xml")
public class MediaCacheSourcesConfig
extends ConfigBase {
    @JsonProperty(value="sources")
    @XStreamImplicit(itemFieldName="Sources")
    private List<ShortObject> a = new ArrayList<ShortObject>();

    public List<ShortObject> getSources() {
        return this.a;
    }

    public void setSources(List<ShortObject> list) {
        this.a = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean loadObject() {
        MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
        mediaCacheConfig.loadObject();
        this.a.clear();
        Iterator<MediaCacheSourceConfig> iterator = mediaCacheConfig.mediaCacheSources.iterator();
        while (iterator.hasNext()) {
            MediaCacheSourceConfig mediaCacheSourceConfig = iterator.next();
            this.a.add(new ShortObject(mediaCacheSourceConfig.name, this.restURI + "/" + mediaCacheSourceConfig.name));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        MediaCacheSourceConfig mediaCacheSourceConfig = new MediaCacheSourceConfig();
        Representation representation2 = mediaCacheSourceConfig.post(representation, this.getRequest());
        this.setStatus(mediaCacheSourceConfig.getStatus());
        if (mediaCacheSourceConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(mediaCacheSourceConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static MediaCacheSourcesConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheSourcesConfig)MediaCacheSourcesConfig.getObjectFromREST(MediaCacheSourcesConfig.getUrl(MediaCacheSourcesConfig.class), MediaCacheSourcesConfig.class, wMSClientSecurity);
    }
}

