/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.server.mediacache.MediaCacheConfig;
import com.wowza.wms.server.Server;
import java.io.File;
import java.util.Iterator;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheStore")
@WMSDescription(text="Server MediaCache Store", get="Retrieves the specified MediaCache Store configuration", put="Updates the specified MediaCache Store configuration", post="Adds the specified MediaCache Store configuration", delete="Deletes the specified MediaCache Store configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/stores/{storeName}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="MediaCache.xml")
public class MediaCacheStoreConfig
extends ConfigBase
implements Comparable<MediaCacheStoreConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="name")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/Name/text()")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/Description/text()")
    protected String description;
    @JsonProperty(value="path")
    @XStreamAlias(value="Path")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/Path/text()")
    protected String path;
    @JsonProperty(value="maxSize")
    @XStreamAlias(value="MaxSize")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/MaxSize/text()")
    protected String maxSize;
    @JsonProperty(value="writeRate")
    @XStreamAlias(value="WriteRate")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/WriteRate/text()")
    protected String writeRate;
    @JsonProperty(value="writeRateMaxBucketSize")
    @XStreamAlias(value="WriteRateMaxBucketSize")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/WriteRateMaxBucketSize/text()")
    protected String writeRateMaxBucketSize;

    public MediaCacheStoreConfig() {
        this.addFieldForKeyMap(Severity.valueOf(20 + 19, "t|fxnBlcj"), "name");
    }

    public MediaCacheStoreConfig(String string) {
        this.name = string;
        this.addToStringKeyMap(Utils.substring("ppjtbFhgn", 49 * 19), string);
        this.initUrl();
        this.addFieldForKeyMap(Utils.substring("<$> 6\u001a4;2", -39 - 10), "name");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getWriteRate() {
        return this.writeRate;
    }

    public void setWriteRate(String string) {
        this.writeRate = string;
    }

    public String getWriteRateMaxBucketSize() {
        return this.writeRateMaxBucketSize;
    }

    public void setWriteRateMaxBucketSize(String string) {
        this.writeRateMaxBucketSize = string;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String string) {
        this.maxSize = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(17 - -43, "oiqm%\u000f#.!"));
        this.addFieldForKeyMap(Utils.substring(")/3/;\u0011alg", 126 + -4), "name");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        Iterator<MediaCacheStoreConfig> iterator;
        boolean bl = super.isValid(constraintValidatorContext);
        try {
            Class.forName(Severity.valueOf(19 + 71, "941s)07;#m3(5i;,8=)?`\u001c5#$6&"));
            Server server = Server.getInstance();
            MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
            if (!mediaCacheConfig.loadObject()) return bl;
            if (mediaCacheConfig.getMediaCacheStores() == null) return bl;
            iterator = mediaCacheConfig.getMediaCacheStores().iterator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
        while (iterator.hasNext()) {
            MediaCacheStoreConfig mediaCacheStoreConfig = iterator.next();
            if (mediaCacheStoreConfig.name.equals(this.name) || !mediaCacheStoreConfig.path.equals(this.path)) continue;
            this.addErrorMessage(constraintValidatorContext, Utils.substring("9+?$", -28 - 27), "{mediacache.store.path.unique}");
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists() {
        Object object;
        boolean bl = false;
        try {
            object = this.getFilename();
            File file = new File((String)object);
            bl = file.exists();
        }
        catch (Exception exception) {}
        if (bl) {
            bl = false;
            object = new MediaCacheConfig();
            if (((MediaCacheConfig)((Object)object)).loadObject()) {
                for (MediaCacheStoreConfig mediaCacheStoreConfig : ((MediaCacheConfig)((Object)object)).getMediaCacheStores()) {
                    if (!mediaCacheStoreConfig.name.equals(this.name)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static MediaCacheStoreConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheStoreConfig)MediaCacheStoreConfig.getObjectFromREST(MediaCacheStoreConfig.getUrl(Utils.substring("|d~`vZt{r", -28 - -43), string, MediaCacheStoreConfig.class), MediaCacheStoreConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(MediaCacheStoreConfig mediaCacheStoreConfig) {
        return this.name.compareTo(mediaCacheStoreConfig.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse;
        block3: {
            block1: {
                block2: {
                    wMSResponse = new WMSResponse();
                    if (ConfigBase.inTradeShowMode) break block1;
                    if (!this.removeNode(Severity.valueOf(57 - 45, "#_a`d>_vp|wTyzr~Oiqmer-NaaofKhici^z`btI]uxs*?bioso{Q!,'>c\u0018"))) break block2;
                    break block3;
                }
                wMSResponse.message = Utils.substring("\u0012=&81v97-z?91;+%a-!. %3", -12 - 35);
                return wMSResponse;
            }
            ConfigBase.log.warn((Object)(Utils.substring("\b\u001e\u000f\t~\u001e\u0010\bxc\u0000 *\"< $,l\u0000++90r\u001056>2x\n.4.8~w", 100 + 118) + this.getStringVariable(Utils.substring("mehc", 898 / 229)) + Severity.valueOf(77 + 91, "!3*Bb-z}quw3g}y`8tu\u007fy3>?\u000e.6c  *\"< $,l\u001e: \"4|")));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(758 / 148, "Ackm}oo");
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }
}

