/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBaseAdv;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLAdvSetting;
import com.wowza.wms.rest.WMSXMLVariable;
import java.util.ArrayList;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheStoreAdv")
@WMSDescription(text="Server MediaCache Store, advanced settings", get="Retrieves the specified advanced MediaCache Store configuration", put="Updates the specified advanced MediaCache Store configuration", post="Adds the specified advanced MediaCache Store configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/stores/{storeName}/adv", restVerbs="GET,PUT,POST", xmlFilename="MediaCache.xml")
public class MediaCacheStoreConfigAdv
extends ConfigBaseAdv {
    @XStreamOmitField
    protected String storeName;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheStore", name="level1FolderCount")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/Level1FolderCount/text()")
    protected int level1FolderCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheStore", name="level2FolderCount")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/Level2FolderCount/text()")
    protected int level2FolderCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheStore", name="fileCount")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/FileCount/text()")
    protected int fileCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MediaCacheStore", name="writeRateFillFrequency")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{storeName}']/WriteRateFillFrequency/text()")
    protected long writeRateFillFrequency;

    public MediaCacheStoreConfigAdv() {
    }

    public MediaCacheStoreConfigAdv(String string) {
        this.storeName = string;
        String string2 = Severity.valueOf(86 + 1, "$,6(>\u0012<3:");
        this.addFieldForKeyMap(string2, string2);
        this.addToStringKeyMap(Severity.valueOf(26 + 65, "((2,:\u000e /&"), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("wqiumGkfi", 168 / 41));
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String string) {
        this.storeName = string;
    }

    public int getLevel1FolderCount() {
        return this.level1FolderCount;
    }

    public void setLevel1FolderCount(int n) {
        this.level1FolderCount = n;
    }

    public int getLevel2FolderCount() {
        return this.level2FolderCount;
    }

    public void setLevel2FolderCount(int n) {
        this.level2FolderCount = n;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int n) {
        this.fileCount = n;
    }

    public long getWriteRateFillFrequency() {
        return this.writeRateFillFrequency;
    }

    public void setWriteRateFillFrequency(long l) {
        this.writeRateFillFrequency = l;
    }

    @Override
    protected void subConstructor(boolean bl) {
        super.subConstructor(bl);
        this.pathsForUndocumentedProperties = new ArrayList<String>();
        this.pathsForUndocumentedProperties.add(Severity.valueOf(539 / 104, "*Thg}%FiignSpq{qFbxj|i4QxzvaBc`l`Usg{oPBlcj-6i``zdrVxw~a:C"));
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    protected ConfigBaseAdv getDefaultConfigBaseAdv() {
        return new MediaCacheStoreConfigAdv(Severity.valueOf(9 + 61, "\"\".(?'8"));
    }

    public static MediaCacheStoreConfigAdv getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        String string2 = MediaCacheStoreConfigAdv.getUrl(Utils.substring("<$> 6\u001a4;2", 65 + 46), string, MediaCacheStoreConfigAdv.class);
        return (MediaCacheStoreConfigAdv)MediaCacheStoreConfigAdv.getObjectFromREST(string2, MediaCacheStoreConfigAdv.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MediaCacheStoreConfigAdv getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        String string3 = MediaCacheStoreConfigAdv.getUrl(Utils.substring("wqiumGkfi", 78 + 54), string, MediaCacheStoreConfigAdv.class);
        if (string2 == null) return (MediaCacheStoreConfigAdv)MediaCacheStoreConfigAdv.getObjectFromREST(string3, MediaCacheStoreConfigAdv.class, wMSClientSecurity);
        if (string2.isEmpty()) return (MediaCacheStoreConfigAdv)MediaCacheStoreConfigAdv.getObjectFromREST(string3, MediaCacheStoreConfigAdv.class, wMSClientSecurity);
        string3 = string3 + "?" + string2;
        return (MediaCacheStoreConfigAdv)MediaCacheStoreConfigAdv.getObjectFromREST(string3, MediaCacheStoreConfigAdv.class, wMSClientSecurity);
    }
}

