/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.server.mediacache.MediaCacheConfig;
import com.wowza.wms.rest.server.mediacache.MediaCacheStoreConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheStores")
@WMSDescription(text="Server MediaCache Stores", get="Retrieves the list of MediaCache Stores", post="Adds the specified MediaCache Store to the list")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/stores", restVerbs="GET,POST", xmlFilename="MediaCache.xml")
public class MediaCacheStoresConfig
extends ConfigBase {
    @JsonProperty(value="stores")
    @XStreamImplicit(itemFieldName="Stores")
    private List<ShortObject> a = new ArrayList<ShortObject>();

    public List<ShortObject> getStores() {
        return this.a;
    }

    public void setStores(List<ShortObject> list) {
        this.a = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean loadObject() {
        MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
        mediaCacheConfig.loadObject();
        this.a.clear();
        Iterator<MediaCacheStoreConfig> iterator = mediaCacheConfig.mediaCacheStores.iterator();
        while (iterator.hasNext()) {
            MediaCacheStoreConfig mediaCacheStoreConfig = iterator.next();
            this.a.add(new ShortObject(mediaCacheStoreConfig.getName(), this.restURI + "/" + mediaCacheStoreConfig.getName()));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        MediaCacheStoreConfig mediaCacheStoreConfig = new MediaCacheStoreConfig();
        Representation representation2 = mediaCacheStoreConfig.post(representation, this.getRequest());
        this.setStatus(mediaCacheStoreConfig.getStatus());
        if (mediaCacheStoreConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(mediaCacheStoreConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static MediaCacheStoresConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheStoresConfig)MediaCacheStoresConfig.getObjectFromREST(MediaCacheStoresConfig.getUrl(MediaCacheStoresConfig.class), MediaCacheStoresConfig.class, wMSClientSecurity);
    }
}

