/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacasters;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSPathVariable;
import com.wowza.wms.rest.WMSXMLVariable;
import java.util.HashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCaster")
@WMSDescription(text="Server MediaCaster", get="Retrieves the specified MediaCaster configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacasters/{mediacastername}", restVerbs="GET", xmlFilename="MediaCasters.xml")
public class MediaCasterConfig
extends ConfigBase
implements Comparable<MediaCasterConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/MediaCasters/MediaCaster[Name='{mediacastername}']/Name/text()")
    @WMSPathVariable(name="mediacastername")
    public String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/MediaCasters/MediaCaster[Name='{mediacastername}']/Description/text()")
    public String description;
    @JsonProperty(value="streamType")
    @XStreamAlias(value="StreamType")
    @WMSXMLVariable(xpath="/Root/MediaCasters/MediaCaster[Name='{mediacastername}']/StreamType/text()")
    public String streamType;
    @JsonProperty(value="baseClass")
    @XStreamAlias(value="BaseClass")
    @WMSXMLVariable(xpath="/Root/MediaCasters/MediaCaster[Name='{mediacastername}']/BaseClass/text()")
    public String baseClass;
    @JsonProperty(value="connectionTimeout")
    @XStreamAlias(value="ConnectionTimeout")
    @WMSXMLVariable(xpath="/Root/MediaCasters/MediaCaster[Name='{mediacastername}']/ConnectionTimeout/text()")
    public String connectionTimeout;
    @JsonProperty(value="keepAliveTime")
    @XStreamAlias(value="KeepAliveTime")
    @WMSXMLVariable(xpath="/Root/MediaCasters/MediaCaster[Name='{mediacastername}']/KeepAliveTime/text()")
    public String keepAliveTime;

    public MediaCasterConfig() {
        this.addFieldForKeyMap(Utils.substring(" ++9012'!3%687>", -24 - -5), "name");
        this.useLocalResourceIfAvailable = true;
    }

    public MediaCasterConfig(String string) {
        this.addFieldForKeyMap(Utils.substring("hccahij\u007fyk}~p\u007fv", 45 * 57), "name");
        this.name = string;
        this.addToStringKeyMap(Severity.valueOf(50 + 97, "~qq\u007fv{xioyop~md"), string);
        this.initUrl();
        this.useLocalResourceIfAvailable = true;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(531 / 173, "naaofkhy\u007fi\u007f`n}t"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String string) {
        this.baseClass = string;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String string) {
        this.connectionTimeout = string;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String string) {
        this.keepAliveTime = string;
    }

    @Override
    public int compareTo(MediaCasterConfig mediaCasterConfig) {
        return this.name.compareToIgnoreCase(mediaCasterConfig.name);
    }

    public static MediaCasterConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(29 * 47, ">11?6;8)/9/0>-$"), string);
        return (MediaCasterConfig)MediaCasterConfig.getObjectFromREST(MediaCasterConfig.getUrl(hashMap, MediaCasterConfig.class), MediaCasterConfig.class, wMSClientSecurity);
    }
}

