/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.server.monitoring.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryServer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricServerStatistics")
@WMSDescription(text="Server Monitoring Historic Statistics", get="Retrieves the server historical statictics")
@WMSConfig(restLocation="/v2/servers/{serverName}/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricServerStatistics
extends HistoricalStatistics<StatsEntryServer> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricServerStatistics.class);

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.substring("Effge\u007f,~oyu1s}4tfgtpyzhtqq rvbplusaj", 854 / 124));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricServerStatistics getObjectFromREST(DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Severity.valueOf(50 + 36, "$2+-\t/=)7,4(!0\u0000 $2/\f$*.!++"))) {
            a.info(String.format(Utils.substring("Zl~yehxf~v2`qg`rj9io}im?fsmn$ u'|f*.\u007f", 65 + 71), dateTime, dateTime2));
        }
        String string = HistoricServerStatistics.getUrl(HistoricServerStatistics.class);
        try {
            String string2 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Utils.substring("MM\\6$", -20 - -44));
            String string3 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Severity.valueOf(158 / 41, "VPC+?"));
            string = string + String.format(Severity.valueOf(-52 - 26, "-6g(3d><i&9n"), Severity.valueOf(677 / 112, "usi{~"), string2, Utils.substring(".\")", 39 * 61), string3);
            return (HistoricServerStatistics)HistoricServerStatistics.getObjectFromREST(string, HistoricServerStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Utils.substring("\u0012&((')m: p4<0;13w,6z\u000e\b\u001bsg", 35 * 13), (Throwable)unsupportedEncodingException);
            return new HistoricServerStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryServer> getDatabase() {
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Severity.valueOf(786 / 200, "PpdrtEhdjkh|/y\u007fagu{ur8wuo<|h~imcah`"));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Utils.substring("Usi}yOmyomqbw^u{wp}k:rrnj~nbg#jjr'i\u007fkb`llcu", 1445 / 211));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.serverGetDatabase();
        if (iStatsDatabase != null) {
            iStatsDatabase.open();
            return iStatsDatabase;
        }
        a.warn(Severity.valueOf(43 * 45, "\\ucdvf5rvlxxzox>qou\"brdokikfn"));
        return null;
    }
}

