/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.entry.StatsEntry;
import com.wowza.wms.stats.utils.StatsUtilsDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class HistoricalStatistics<T extends StatsEntry>
extends ApplicationConfigBase {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricalStatistics.class);
    public static final String DATE_RANGE_START_PARAM = "start";
    public static final String DATE_RANGE_END_PARAM = "end";
    public static DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)Severity.valueOf(21 * 55, "z}|\u007f*ED'oh*Z(XY(~yO"));
    public static final Duration ONE_HOUR = new Duration(3600000L);
    public static final Duration FOUR_HOURS = new Duration(14400000L);
    public static final Duration ONE_WEEK = new Duration(604800000L);
    public static final String REST_LOG_STATS_ENABLED = "restStatisticsDebugEnabled";
    @JsonIgnore
    private DateTime b = new DateTime();
    @JsonIgnore
    private DateTime c = this.b.minusDays(1);
    @JsonProperty(value="entries")
    @XStreamAlias(value="Entries")
    private Map<String, List<T>> d = new HashMap<String, List<T>>();

    public HistoricalStatistics() {
        super("", "");
    }

    public HistoricalStatistics(String string) {
        super(string, "");
    }

    public HistoricalStatistics(String string, String string2) {
        super(string, string2);
    }

    public abstract IStatsDatabase<T> getDatabase();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        try {
            Map<String, List<T>> map;
            block10: {
                block12: {
                    IStatsDatabase<T> iStatsDatabase;
                    block11: {
                        block9: {
                            this.vhostName = this.getStringVariable(Severity.valueOf(29 - -61, ",33.*\u0011!,'"));
                            this.appName = this.getStringVariable(Severity.valueOf(96 + 31, ">pqLbi`"));
                            iStatsDatabase = this.getDatabase();
                            this.a();
                            if (RestProperties.getBoolean(Utils.substring("tb{}Y\u007fmyg|dxq`Pptb\u007f\\tz~q{{", 1216 / 191))) {
                                a.info(String.format(Utils.substring("Hjgcagm+\u007fyo{c1ta{x62k9nt<8m?fnp#rmit|)/x,l~\u007f04a", 887 / 185), this.getStartTime(), this.getEndTime(), this.vhostName, this.appName));
                            }
                            this.d.put(Severity.valueOf(25 - -2, "z\u007fik~l"), new ArrayList());
                            this.d.put(Utils.substring("tsu", 47 * 55), new ArrayList());
                            this.d.put(Severity.valueOf(17 - -15, "m`z"), new ArrayList());
                            this.d.put(Utils.substring("3%1'70=", -50 - -4), new ArrayList());
                            DateTime dateTime = StatsUtilsDateTime.getNow();
                            HistoricalStatistics historicalStatistics = this;
                            if (historicalStatistics.rangeContainsSecondsData(historicalStatistics.getStartTime(), this.getEndTime())) {
                                if (RestProperties.getBoolean(Utils.substring("wct|Z~jxd}{yraWqwcp]w{ypxz", 812 / 157))) {
                                    a.info(Severity.valueOf(921 / 249, "Qekab(jeexlgac1`vuy6cqt\u007f;x|j~"));
                                }
                                HistoricalStatistics historicalStatistics2 = this;
                                map = historicalStatistics2.getEntriesForLevel(historicalStatistics2.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 0);
                                this.d.get(Utils.substring("fk}\u007fj`", 25 * 63)).addAll((Collection)map.get(Utils.substring("des}hf", 432 / 84)));
                                if (RestProperties.getBoolean(Severity.valueOf(78 + -55, "e}jnHh|jvsuk`wAce}nOemobjt"))) {
                                    a.info(String.format(Severity.valueOf(70 + -4, "\u0003'  \"gm-j.\"9<&5\"r2 u$295z/50;\u007f,$4&("), map.get(Severity.valueOf(2 - 56, "+(88/#")).size()));
                                }
                            }
                            HistoricalStatistics historicalStatistics3 = this;
                            if (!historicalStatistics3.rangeContainsMinutesData(historicalStatistics3.getStartTime(), this.getEndTime())) break block9;
                            HistoricalStatistics historicalStatistics4 = this;
                            map = historicalStatistics4.getEntriesForLevel(historicalStatistics4.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 1);
                            this.d.get(Severity.valueOf(652 / 100, "knf")).addAll((Collection)map.get(Utils.substring(">=;", 58 + 57)));
                            this.d.get(Severity.valueOf(9 * 17, "t{c")).addAll((Collection)map.get(Utils.substring("3>8", 121 + 101)));
                            this.d.get(Utils.substring("\"2 4&/,", 30 + 69)).addAll((Collection)map.get(Severity.valueOf(45 * 15, "br`tfol")));
                            if (RestProperties.getBoolean(Severity.valueOf(27 * 13, "-%26\u00100$2.;=#(?\t+-%6\u0017=57:2<"))) {
                                a.info(String.format(Utils.substring("Flmoo,(j/u\u007ffa}pe7ym:vuskke!nfr`j", 39 * 33), map.get(Severity.valueOf(60 - -33, "<(:2 %&")).size()));
                            }
                            break block10;
                        }
                        HistoricalStatistics historicalStatistics = this;
                        if (!historicalStatistics.rangeContainsHoursData(historicalStatistics.getStartTime(), this.getEndTime())) break block11;
                        HistoricalStatistics historicalStatistics5 = this;
                        map = historicalStatistics5.getEntriesForLevel(historicalStatistics5.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 2);
                        this.d.get(Utils.substring("knf", 1468 / 233)).addAll((Collection)map.get(Utils.substring(":17", 7 + 80)));
                        this.d.get(Utils.substring("dks", 55 + 114)).addAll((Collection)map.get(Utils.substring("ne}", 567 / 165)));
                        this.d.get(Severity.valueOf(30 - 33, "<(:r`ef")).addAll((Collection)map.get(Utils.substring("gqm{kli", 678 / 98)));
                        if (!RestProperties.getBoolean(Severity.valueOf(253 / 65, "qavrT|h~b\u007fyglcUwqarSyy{v~x"))) break block10;
                        break block12;
                    }
                    HistoricalStatistics historicalStatistics = this;
                    if (historicalStatistics.rangeContainsDaysData(historicalStatistics.getStartTime(), this.getEndTime())) {
                        HistoricalStatistics historicalStatistics6 = this;
                        map = historicalStatistics6.getEntriesForLevel(historicalStatistics6.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 3);
                        this.d.get(Utils.substring("8?9", 11 * 31)).addAll((Collection)map.get(Severity.valueOf(945 / 143, "knf")));
                        this.d.get(Severity.valueOf(747 / 148, "hg\u007f")).addAll((Collection)map.get(Utils.substring("jiq", -18 - -57)));
                        this.d.get(Utils.substring("8,>.<9:", -37 - 2)).addAll((Collection)map.get(Utils.substring("k}i\u007fohu", 47 + 123)));
                        if (RestProperties.getBoolean(Utils.substring("0&71\u00153)=#88$-<\u001440&3\u001086:5??", -36 - -6))) {
                            a.info(String.format(Severity.valueOf(33 * 49, "\u00106711vr<y?5(/7:3a#7d!'>h%/=)!"), map.get(Utils.substring("gqm{kli", 104 + 30)).size()));
                        }
                    }
                    break block10;
                }
                a.info(String.format(Utils.substring("Pvwqq62|9\u007fuhowzs!cw$mirz)fnzhb", 96 + 49), map.get(Utils.substring("h|n~lij", 68 + -27)).size()));
            }
            map = new Comparator<T>(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public int compare(T t, T t2) {
                    if (t == null) {
                        return 1;
                    }
                    if (t2 != null) return t.getDateTime().compareTo((ReadableInstant)t2.getDateTime());
                    return -1;
                }
            };
            Collections.sort(this.d.get(Severity.valueOf(40 + 22, "sv.")), map);
            Collections.sort(this.d.get(Severity.valueOf(47 * 59, "87/")), map);
            Collections.sort(this.d.get(Utils.substring("<(:r`ef", 19 * 47)), map);
            return true;
        }
        catch (Exception exception) {
            a.error(Utils.substring("\u0013%*6({;80:2 6**\"f4<(>\"?9',#", 111 + -25), (Throwable)exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void a() {
        Map<String, String> map = this.getQueryParamMap();
        if (RestProperties.getBoolean(Utils.substring("qavrT|h~b\u007fyglcUwqarSyy{v~x", 130 / 33))) {
            a.info(String.format(Severity.valueOf(43 * 9, "Bpqcjx}cek-z`0asagp6sym\u007fh<8m?aof#!v"), map.get(Utils.substring("vrfz}", 1094 / 202)), map.get(Severity.valueOf(19 * 31, "( +"))));
        }
        if (map.containsKey(Severity.valueOf(23 * 53, "00$43"))) {
            this.c = StatsUtilsDateTime.getNormalizedToSeconds((DateTime)DATE_FORMATTER.parseDateTime(map.get(Utils.substring("\u007fyo}d", 3 + 41))));
        }
        if (map.containsKey(Severity.valueOf(43 * 25, "vzq"))) {
            this.b = StatsUtilsDateTime.getNormalizedToSeconds((DateTime)DATE_FORMATTER.parseDateTime(map.get(Utils.substring("~ry", 9 * 35))));
        }
        if (!this.c.isAfter((ReadableInstant)this.b)) return;
        this.b = this.c.plusDays(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsSecondsData(DateTime dateTime, DateTime dateTime2) {
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (!dateTime.isAfter((ReadableInstant)dateTime2)) {
            DateTime dateTime3;
            DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
            DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusHours(12);
            Duration duration = new Duration((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
            if (!dateTime.isAfter((ReadableInstant)dateTime5)) return false;
            if (duration.isShorterThan((ReadableDuration)ONE_HOUR)) return true;
            if (!duration.equals((Object)ONE_HOUR)) return false;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsMinutesData(DateTime dateTime, DateTime dateTime2) {
        DateTime dateTime3;
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (dateTime.isAfter((ReadableInstant)dateTime2)) {
            return false;
        }
        DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
        DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusDays(3);
        Duration duration = new Duration((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
        if (!dateTime.isAfter((ReadableInstant)dateTime5)) return false;
        if (duration.isShorterThan((ReadableDuration)FOUR_HOURS)) return true;
        if (!duration.equals((Object)FOUR_HOURS)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsHoursData(DateTime dateTime, DateTime dateTime2) {
        DateTime dateTime3;
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (dateTime.isAfter((ReadableInstant)dateTime2)) {
            return false;
        }
        DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
        DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusDays(30);
        Duration duration = new Duration((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
        if (!dateTime.isAfter((ReadableInstant)dateTime5)) return false;
        if (duration.isShorterThan((ReadableDuration)ONE_WEEK)) return true;
        if (!duration.equals((Object)ONE_WEEK)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsDaysData(DateTime dateTime, DateTime dateTime2) {
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (!dateTime.isAfter((ReadableInstant)dateTime2)) {
            DateTime dateTime3;
            DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
            DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusDays(365);
            if (dateTime.isAfter((ReadableInstant)dateTime5)) return true;
            if (!dateTime2.isAfter((ReadableInstant)dateTime5)) return false;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, List<T>> getEntriesForLevel(DateTime dateTime, DateTime dateTime2, IStatsDatabase<T> iStatsDatabase, int n) {
        HashMap<String, List<T>> hashMap = new HashMap<String, List<T>>();
        if (iStatsDatabase == null) return hashMap;
        if (dateTime2 == null) return hashMap;
        if (!dateTime2.isBefore((ReadableInstant)dateTime)) {
            if (n == 0) {
                hashMap.put(Severity.valueOf(41 * 11, "\"'13&$"), iStatsDatabase.read(n, 0, dateTime, dateTime2));
                return hashMap;
            }
            hashMap.put(Utils.substring("vus", 49 * 11), iStatsDatabase.read(n, 0, dateTime, dateTime2));
            hashMap.put(Severity.valueOf(22 - 41, " /7"), iStatsDatabase.read(n, 1, dateTime, dateTime2));
            hashMap.put(Utils.substring("9/?)=:;", 52 - 60), iStatsDatabase.read(n, 2, dateTime, dateTime2));
            return hashMap;
        }
        return hashMap;
    }

    public Map<String, List<T>> getEntries() {
        return this.d;
    }

    public void setEntries(Map<String, List<T>> map) {
        this.d = map;
    }

    public DateTime getEndTime() {
        return this.b;
    }

    public DateTime getStartTime() {
        return this.c;
    }

    public void setEndTime(DateTime dateTime) {
        this.b = dateTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.c = dateTime;
    }
}

