/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.database.StatsDatabaseManager;
import java.lang.reflect.Method;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Monitoring")
@WMSDescription(text="Server Monitoring", get="Retrieves the server monitoring configuration", put="Updates the server monitoring configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/monitoring", restVerbs="GET,PUT", xmlFilename="Server.xml")
public class MonitoringConfig
extends ConfigBase {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(MonitoringConfig.class);
    @JsonProperty(value="enable")
    @XStreamAlias(value="Enable")
    @WMSXMLVariable(xpath="/Root/Server/Stats/Enable/text()")
    protected boolean enable = true;
    @JsonProperty(value="debugEnable")
    @XStreamAlias(value="DebugEnable")
    @WMSXMLProperty(root="/Root/Server/Stats", name="statsManagerDebugEnable")
    protected boolean statsManagerDebugEnable = false;
    @JsonProperty(value="databaseDebugEnable")
    @XStreamAlias(value="DatabaseDebugEnable")
    @WMSXMLProperty(root="/Root/Server/Stats", name="statsDatabaseManagerDebugEnable")
    protected boolean statsDatabaseManagerDebugEnable = false;

    public MonitoringConfig() {
        this.initUrl();
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean bl) {
        this.enable = bl;
    }

    public boolean isStatsManagerDebugEnabled() {
        return this.statsManagerDebugEnable;
    }

    public void setStatsManagerDebugEnabled(boolean bl) {
        this.statsManagerDebugEnable = bl;
    }

    public boolean isStatsDatabaseManagerDebugEnabled() {
        return this.statsDatabaseManagerDebugEnable;
    }

    public void setStatsDatabaseManagerDebugEnabled(boolean bl) {
        this.statsDatabaseManagerDebugEnable = bl;
    }

    public static MonitoringConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (MonitoringConfig)MonitoringConfig.getObjectFromREST(MonitoringConfig.getUrl(MonitoringConfig.class), MonitoringConfig.class, wMSClientSecurity);
    }

    @Override
    public boolean exists() {
        boolean bl = super.exists();
        if (!MonitoringConfig.usesCentralConfig()) {
            return bl;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean loadObjectFromFile(String string) {
        boolean bl = false;
        Document document = null;
        if (!MonitoringConfig.usesCentralConfig()) {
            return super.loadObjectFromFile(string);
        }
        try {
            document = MonitoringConfig.getDocumentFromCentralConfig(this.getXMLFilename());
        }
        catch (Exception exception) {
            this.logException(Severity.valueOf(-32 - -42, "fdmiAmztqgRgyz^pv~"), exception);
        }
        catch (SAXParseException sAXParseException) {
            MonitoringConfig.logError(Utils.substring("Fvjjsu{=FR\fa$*( n", 104 + -50) + string + Utils.substring("lf", -1 + 102) + sAXParseException);
        }
        if (document == null) return bl;
        return this.loadXMLDocument(document, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        WMSResponse wMSResponse = super.saveObject();
        try {
            IStatsDatabaseManager iStatsDatabaseManager;
            Class.forName(Utils.substring("$'$d<#:4.~&? z&\"6,*t\b(<*,M`lbc`t", 15 * 41));
            IStatsManager iStatsManager = StatsManager.getInstance();
            iStatsManager.setDebugLogging(this.statsManagerDebugEnable);
            if (this.enable) {
                iStatsDatabaseManager = Class.forName(Severity.valueOf(1189 / 184, "ehe'}d{wo!g|a=gpda}k4Hyohzr"));
                try {
                    Method method = iStatsDatabaseManager.getMethod(Severity.valueOf(-42 - -46, "c`rNfz~jbnk"), null);
                    Object object = method.invoke(null, (Object[])null);
                    Method method2 = object.getClass().getMethod(Severity.valueOf(-38 - 13, ">:.\"%\u0001'5!%"), null);
                    method2.invoke(object, (Object[])null);
                }
                catch (Exception exception) {
                    a.warn(Severity.valueOf(110 + -15, "\u000f2. /!(f4<(8?%#)o#%3'=&\">;*z-5<~\rERV#euo"), (Throwable)exception);
                }
            } else {
                iStatsManager.stopManager();
            }
            Class.forName(Utils.substring("ehe'}d{wo!g|a=gawck7Io}im[\u0002\f#-%\"#5", 90 + 76));
            iStatsDatabaseManager = StatsDatabaseManager.getInstance();
            iStatsDatabaseManager.setDebugLogging(this.statsDatabaseManagerDebugEnable);
            return wMSResponse;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return wMSResponse;
        }
    }
}

