/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.publishers;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.server.publishers.PublishersConfig;
import com.wowza.wms.rest.user.UsersConfig;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Publisher")
@WMSDescription(text="Server Publisher", get="Retrieves the specified Publisher configuration", put="Updates the specified Publisher configuration", post="Adds the specified Publisher configuration", delete="Deletes the specified Publisher configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/publishers/{publisher}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="")
public class PublisherConfig
extends ConfigBase
implements Comparable<PublisherConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    protected String description;
    @JsonProperty(value="password")
    @XStreamAlias(value="Password")
    protected String password;
    @XStreamOmitField
    protected String privatePassword;

    public PublisherConfig() {
        this.addFieldForKeyMap(Utils.substring("62*%#8$(<", 44 + 26), "name");
    }

    public PublisherConfig(String string) {
        this.addFieldForKeyMap(Utils.substring("tpdkazbn~", 665 / 163), "name");
        this.name = string;
        this.addToStringKeyMap(Utils.substring("qwahluom{", 4 - -29), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(-4 - 58, "26&)/4 ,8"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        if (!bl) return bl;
        this.fillStringKeyMap();
        this.name = this.getStringVariable(Severity.valueOf(25 * 39, "?%3>:'=3%"));
        PublisherConfig publisherConfig = PublishersConfig.getPublisher(this.name);
        if (publisherConfig == null) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exists() {
        PublisherConfig publisherConfig = PublishersConfig.getPublisher(this.name);
        if (publisherConfig == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse saveObject() {
        WMSResponse wMSResponse;
        block2: {
            block1: {
                wMSResponse = new WMSResponse();
                if (ConfigBase.inTradeShowMode) break block1;
                break block2;
            }
            ConfigBase.log.warn((Object)Utils.substring("\u0016\u0000\u0015\u0013h\b\u001a\u0002vm\u001d.&8<4t\u0005#540)39/-e Hl#pwgcm)yccz.b\u007fuw=45Xxl9ytqpwkthld$fnffnox\"", 31 + 69));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(43 + 25, "\u0017$0\",");
            return wMSResponse;
        }
        if (UsersConfig.isMemberOf(this.restletUser.getName(), Severity.valueOf(55 * 27, ",*\"9?"))) return PublishersConfig.updatePublisher(this);
        wMSResponse.message = Utils.substring("Hh|)k~xea}ykww", 950 / 147);
        return wMSResponse;
    }

    @Override
    public WMSResponse saveNewObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (!ConfigBase.inTradeShowMode) {
            this.privatePassword = this.password;
            return PublishersConfig.addPublisher(this);
        }
        ConfigBase.log.warn((Object)(Utils.substring("]UBF3UE_-8X~\u007fusy?\u00104 /-6.\":ijc", 53 + 122) + this.name + Utils.substring("-?&Nf)~ymik/cy}d4xys}7:;Rrj?aefjjb&aaeo%", 28 + 104)));
        wMSResponse.success = true;
        wMSResponse.message = Severity.valueOf(5 * 9, "Ljkuu");
        return wMSResponse;
    }

    @Override
    public WMSResponse deleteObject() {
        return PublishersConfig.removePublisher(this.name);
    }

    public static PublisherConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (PublisherConfig)PublisherConfig.getObjectFromREST(PublisherConfig.getUrl(Utils.substring("mk}lhqkaw", 7 * 59), string, PublisherConfig.class), PublisherConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(PublisherConfig publisherConfig) {
        return this.name.compareTo(publisherConfig.getName());
    }
}

