/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.user;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.authentication.file.AuthenticationPasswordFile;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.user.UserConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;

@JsonAutoDetect(value={JsonMethod.NONE})
@WMSDescription(text="Server Users", get="Retrieves the list of server Users", post="Adds a new server User to the list")
@WMSConfig(restLocation="/v2/servers/{serverName}/users", restVerbs="GET,POST", xmlFilename="")
@XStreamAlias(value="Users")
public class UsersConfig
extends ConfigBase {
    @JsonProperty(value="users")
    @XStreamImplicit(itemFieldName="User")
    public List<UserConfig> users = new ArrayList<UserConfig>();
    @XStreamOmitField
    public static List<UserConfig> staticUsers = null;
    @XStreamOmitField
    protected static long staticVersion;

    public List<UserConfig> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserConfig> list) {
        this.users = list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        UsersConfig.loadAdminPassword();
        this.users.clear();
        if (this.restletUser == null) {
            if (staticUsers == null) return true;
            this.users.addAll(staticUsers);
            return true;
        }
        UserConfig userConfig = UsersConfig.getUser(this.restletUser.getName());
        if (!userConfig.isMemberOf(Severity.valueOf(247 / 54, "eaknf"))) {
            this.users.add(userConfig);
            return true;
        }
        this.users.addAll(staticUsers);
        return true;
    }

    public static String getUserPasswordFile() {
        return ConfigBase.wowzaBasePath + Severity.valueOf(46 + 67, "2==2z73504u,<-,wnpg");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean loadAdminPassword() {
        AuthenticationPasswordFile authenticationPasswordFile;
        boolean bl = true;
        String string = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles != null && (authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string))) != null) {
            staticUsers = new ArrayList<UserConfig>();
            Map map = authenticationPasswordFile.getPasswordVals();
            Map map2 = authenticationPasswordFile.getGroupVals();
            for (String string2 : map.keySet()) {
                UserConfig userConfig = new UserConfig();
                userConfig.setName(string2);
                userConfig.setPrivatePassword((String)map.get(string2));
                userConfig.groups.addAll((Collection)map2.get(string2));
                staticUsers.add(userConfig);
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static UserConfig getUser(String string) {
        UserConfig userConfig;
        UserConfig userConfig2 = null;
        UsersConfig.loadAdminPassword();
        Iterator<UserConfig> iterator = staticUsers.iterator();
        do {
            if (!iterator.hasNext()) return userConfig2;
        } while (!(userConfig = iterator.next()).getName().equals(string));
        return userConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMemberOf(String string, String string2) {
        boolean bl = false;
        UserConfig userConfig = UsersConfig.getUser(string);
        if (userConfig == null) return bl;
        return userConfig.isMemberOf(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WMSResponse updateUser(UserConfig userConfig) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)Severity.valueOf(222 / 66, "QAVR'IYC1,^oyy\u007fu3LXZ70x~vus0oarqtkwb.2)Ce,y|ntt2`|za7uv~~2=>Q/5b +(+.<=#%+m-'1?56'{"));
            wMSResponse.success = true;
            wMSResponse.message = Utils.substring("\u00049/??", 3 - 44);
            return wMSResponse;
        }
        String string = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles == null) return wMSResponse;
        AuthenticationPasswordFile authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string));
        if (authenticationPasswordFile == null) return wMSResponse;
        if (!authenticationPasswordFile.updateUser(userConfig.getName(), userConfig.getPassword(), userConfig.getGroups())) {
            wMSResponse.message = Utils.substring("Eeljbl)~d,x~kqew3afse", 769 / 229);
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WMSResponse removeUser(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)Utils.substring("TB[]*J\\D4/Cpdzzr6OUU:3}ysvn/rbwvqhzm#1,D`/dcswq5e\u007fwn:vsy{1`a\f,0e%(%$#?8$ (p2:2:23$v", 1448 / 211));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(1405 / 232, "Uf~ln");
            return wMSResponse;
        }
        String string2 = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles == null) return wMSResponse;
        AuthenticationPasswordFile authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string2));
        if (authenticationPasswordFile == null) return wMSResponse;
        if (authenticationPasswordFile.deleteUser(string)) {
            wMSResponse.success = true;
            return wMSResponse;
        }
        wMSResponse.message = Severity.valueOf(36 + 41, "\u000b/&<46s :v3=5?/9}+,%3");
        return wMSResponse;
    }

    public static WMSResponse addUser(UserConfig userConfig) {
        WMSResponse wMSResponse = new WMSResponse();
        if (!ConfigBase.inTradeShowMode) {
            return UsersConfig.addUser2(userConfig);
        }
        ConfigBase.log.warn((Object)Utils.substring("[OXX-O_Y+2@uc\u007fy\u007f9BVP=6~dlkm*ugt{~eyh$4/Y\u007f2gftrr8jrtk=sp$$lcd\u000b)3h*%&!$:;9?5s7=79?<)u", 5 * 53));
        wMSResponse.success = true;
        wMSResponse.message = Severity.valueOf(3 - -34, "Vgqmm");
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static WMSResponse addUser2(UserConfig userConfig) {
        WMSResponse wMSResponse = new WMSResponse();
        String string = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles == null) return wMSResponse;
        AuthenticationPasswordFile authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string));
        if (authenticationPasswordFile == null) return wMSResponse;
        if (authenticationPasswordFile.addUser(userConfig.getName(), userConfig.getPrivatePassword(), userConfig.getGroups())) {
            wMSResponse.success = true;
            return wMSResponse;
        }
        wMSResponse.message = Utils.substring("]}trz$a6,d$\"#h<9.>", 8 + 51);
        return wMSResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        UserConfig userConfig = new UserConfig();
        Representation representation2 = userConfig.post(representation, this.getRequest());
        this.setStatus(userConfig.getStatus());
        if (userConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(userConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static UsersConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (UsersConfig)UsersConfig.getObjectFromREST(UsersConfig.getUrl(UsersConfig.class), UsersConfig.class, wMSClientSecurity);
    }
}

