/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSPathVariable;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.HostPortConfigAdv;
import com.wowza.wms.rest.vhosts.HostPortsConfig;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TuneHostPorts")
@WMSDescription(text="VHost Host Ports for Tuning", get="Retrieves the host port configuration used for server tuning for the specified vhost", put="Updates the host port configuration used for server tuning for the specified vhost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/tunehostports", restVerbs="GET,PUT", xmlFilename="VHost.xml")
public class HostportsTuneConfig
extends ConfigBase {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSPathVariable(name="vhostName", description="The vhost name")
    protected String name;
    @JsonProperty(value="hostports")
    @XStreamAlias(value="HostPorts")
    List<HostPortConfigAdv> a = new ArrayList<HostPortConfigAdv>();

    public HostportsTuneConfig() {
    }

    public HostportsTuneConfig(String string) {
        this.name = string;
        this.addToStringKeyMap(Utils.substring(">!%88\u0003/\"5", -17 - 7), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(626 / 93, "pogz~Em`k"));
    }

    public List<HostPortConfigAdv> getHostPortAdv() {
        return this.a;
    }

    public void setHostPortAdv(List<HostPortConfigAdv> list) {
        this.a = list;
    }

    @Override
    public boolean loadObject() {
        String string = this.getStringVariable(Severity.valueOf(732 / 218, "uljusFhgn"));
        HostPortsConfig hostPortsConfig = new HostPortsConfig(string);
        Iterator<String> iterator = hostPortsConfig.getHostports().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            HostPortConfigAdv hostPortConfigAdv = new HostPortConfigAdv(string, string2);
            hostPortConfigAdv.loadObject();
            this.a.add(hostPortConfigAdv);
        }
        return super.loadObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        HostPortConfigAdv hostPortConfigAdv;
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)Severity.valueOf(35 + 17, "FPEC8XJR&=M~6(,$d\u001d\u000b\u000bha\u0002$?9> \"%!\u0007!;3~by\u00135|),>$$b0,*1g%&..bmn\u0001?%r0;8;>,-35;}=7aoefw+"));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(59 * 55, "^oyuu");
            return wMSResponse;
        }
        Iterator<HostPortConfigAdv> iterator = this.a.iterator();
        do {
            if (!iterator.hasNext()) return wMSResponse;
            hostPortConfigAdv = iterator.next();
            hostPortConfigAdv.setVhostName(this.getStringVariable(Utils.substring("uljusFhgn", 41 + -6)));
            hostPortConfigAdv.stringKeyMap.put(Severity.valueOf(39 * 21, "e|zecVxw~"), hostPortConfigAdv.getVhostName());
            hostPortConfigAdv.stringKeyMap.put(Utils.substring("uiu|gkfi", 1003 / 170), hostPortConfigAdv.getName());
        } while ((wMSResponse = hostPortConfigAdv.saveObject()).isSuccess());
        return wMSResponse;
    }

    @Override
    public String getFilename() {
        String string = this.getStringVariable(Utils.substring(";& #%\u001c290", 53 * 57));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Utils.substring("s>11&n", 1 + 91) + this.getXMLFilename();
    }

    public static HostportsTuneConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (HostportsTuneConfig)HostportsTuneConfig.getObjectFromREST(HostportsTuneConfig.getUrl(Severity.valueOf(860 / 186, "rmit|Gkfi"), string, HostportsTuneConfig.class), HostportsTuneConfig.class, wMSClientSecurity);
    }
}

