/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSPathVariable;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="SSL")
@WMSDescription(text="VHost SSL", get="Retrieves the SSL configuration for the specified vhost and port", put="Updates the SSL configuration for the specified vhost and port")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/hostports/{portname}/ssl", restVerbs="GET,PUT", xmlFilename="VHost.xml")
public class SSLConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @XStreamOmitField
    @WMSPathVariable(name="portname", description="The port name")
    public String name;
    @JsonProperty(value="sslEnable")
    @XStreamAlias(value="SSLEnable")
    protected boolean sslEnable = false;
    @JsonProperty(value="sslKeyStorePath")
    @XStreamAlias(value="SSLKeyStorePath")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/KeyStorePath/text()")
    protected String sslKeyStorePath;
    @JsonProperty(value="sslKeyStorePassword")
    @XStreamAlias(value="SSLKeyStorePassword")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/KeyStorePassword/text()")
    protected String sslKeyStorePassword;
    @JsonProperty(value="sslKeyStoreType")
    @XStreamAlias(value="SSLKeyStoreType")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/KeyStoreType/text()")
    protected String sslKeyStoreType;
    @JsonProperty(value="sslProtocol")
    @XStreamAlias(value="SSLProtocol")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/SSLProtocol/text()")
    protected String sslProtocol;
    @JsonProperty(value="sslAlgorithm")
    @XStreamAlias(value="SSLAlgorithm")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/Algorithm/text()")
    protected String sslAlgorithm;
    @JsonProperty(value="sslCipherSuites")
    @XStreamAlias(value="SSLCipherSuites")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/CipherSuites/text()")
    protected List<String> ssl;
    @JsonProperty(value="sslProtocols")
    @XStreamAlias(value="SSLProtocols")
    @WMSXMLVariable(xpath="/Root/VHost/HostPortList/HostPort[Name='{portname}']/SSLConfig/Protocols/text()")
    protected List<String> sslProtocols;

    public SSLConfig() {
    }

    public SSLConfig(String string, String string2) {
        this.vhostName = string;
        this.name = string2;
        this.addToStringKeyMap(Severity.valueOf(5 * 3, "\u007f\u007fcf}uxs"), string2);
        this.addToStringKeyMap(Severity.valueOf(27 + -13, "xg\u007fbf]uxs"), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(24 - -37, "mqm4/#.!"));
        this.addToStringKeyMapFromRequest(Utils.substring("rmit|Gkfi", 158 / 33));
    }

    public boolean isSslEnable() {
        return this.sslEnable;
    }

    public void setSslEnable(boolean bl) {
        this.sslEnable = bl;
    }

    public String getSslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    public void setSslKeyStorePath(String string) {
        this.sslKeyStorePath = string;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public void setSslKeyStorePassword(String string) {
        this.sslKeyStorePassword = string;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public void setSslKeyStoreType(String string) {
        this.sslKeyStoreType = string;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String string) {
        this.sslProtocol = string;
    }

    public String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public void setSslAlgorithm(String string) {
        this.sslAlgorithm = string;
    }

    public List<String> getSsl() {
        return this.ssl;
    }

    public void setSsl(List<String> list) {
        this.ssl = list;
    }

    public List<String> getSslProtocols() {
        return this.sslProtocols;
    }

    public void setSslProtocols(List<String> list) {
        this.sslProtocols = list;
    }

    @Override
    public String getFilename() {
        String string = this.getStringVariable(Severity.valueOf(41 * 55, "98>!'\u001a4;2"));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Utils.substring("m ++ h", 30 + 36) + this.getXMLFilename();
    }

    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        this.restURI = null;
        return bl;
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        WMSResponse wMSResponse = super.saveObject();
        if (wMSResponse.isSuccess()) {
            // empty if block
        }
        return wMSResponse;
    }
}

